/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.internal.ads.zzasg;
import com.google.android.gms.internal.ads.zzatd;
import com.google.android.gms.internal.ads.zzfqr;
import com.google.android.gms.internal.ads.zzfqt;
import com.google.android.gms.internal.ads.zzfqz;
import com.google.android.gms.internal.ads.zzfre;
import com.google.android.gms.internal.ads.zzfrf;
import com.google.android.gms.internal.ads.zzfrg;
import com.google.android.gms.internal.ads.zzfrh;
import com.google.android.gms.internal.ads.zzfri;
import com.google.android.gms.internal.ads.zzfrj;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public final class zzfrk {
    private final Context zza;
    private final Executor zzb;
    private final zzfqr zzc;
    private final zzfqt zzd;
    private final zzfrj zze;
    private final zzfrj zzf;
    private Task zzg;
    private Task zzh;

    public final zzatd zza() {
        zzfrj zzfrj2 = this.zze;
        return zzfrk.zzg(this.zzg, zzfrj2.zza());
    }

    public final zzatd zzb() {
        zzfrj zzfrj2 = this.zzf;
        return zzfrk.zzg(this.zzh, zzfrj2.zza());
    }

    private static zzatd zzg(@NonNull Task task, @NonNull zzatd zzatd2) {
        if (!task.isSuccessful()) {
            return zzatd2;
        }
        return (zzatd)task.getResult();
    }

    final /* synthetic */ zzatd zzc() throws Exception {
        zzasg zzasg2 = zzatd.zza();
        AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)((zzfrk)object).zza);
        Object object = info.getId();
        if (object != null && ((String)object).matches("^[a-fA-F0-9]{8}-([a-fA-F0-9]{4}-){3}[a-fA-F0-9]{12}$")) {
            object = UUID.fromString((String)object);
            byte[] byArray = new byte[16];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.putLong(((UUID)object).getMostSignificantBits());
            byteBuffer.putLong(((UUID)object).getLeastSignificantBits());
            object = Base64.encodeToString((byte[])byArray, (int)11);
        }
        if (object != null) {
            zzasg2.zzs((String)object);
            zzasg2.zzr(info.isLimitAdTrackingEnabled());
            zzasg2.zzab(6);
        }
        return (zzatd)zzasg2.zzal();
    }

    final /* synthetic */ zzatd zzd() throws Exception {
        zzfrk zzfrk2 = zzfrk2.zza;
        PackageInfo packageInfo = zzfrk2.getPackageManager().getPackageInfo(zzfrk2.getPackageName(), 0);
        zzfrk zzfrk3 = zzfrk2;
        return zzfqz.zza((Context)zzfrk3, zzfrk3.getPackageName(), Integer.toString(packageInfo.versionCode));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static zzfrk zze(@NonNull Context context, @NonNull Executor executor, @NonNull zzfqr zzfqr2, @NonNull zzfqt zzfqt2) {
        zzfrk zzfrk2 = new zzfrk(context, executor, zzfqr2, zzfqt2, new zzfrh(), new zzfri());
        if (zzfrk2.zzd.zzd()) {
            zzfrk zzfrk3 = zzfrk2;
            zzfrk3.zzg = zzfrk3.zzh(new zzfre(zzfrk3));
        } else {
            zzfrk2.zzg = Tasks.forResult((Object)zzfrk2.zze.zza());
        }
        zzfrk zzfrk4 = zzfrk2;
        zzfrk4.zzh = zzfrk4.zzh(new zzfrf(zzfrk4));
        return zzfrk2;
    }

    private final Task zzh(@NonNull Callable object) {
        Task task = Tasks.call((Executor)this.zzb, (Callable)object);
        object = new zzfrg(this);
        return task.addOnFailureListener(this.zzb, (OnFailureListener)object);
    }

    @VisibleForTesting
    zzfrk(Context context, Executor executor, zzfqr zzfqr2, zzfqt zzfqt2, zzfrh zzfrh2, zzfri zzfri2) {
        this.zza = context;
        this.zzb = executor;
        this.zzc = zzfqr2;
        this.zzd = zzfqt2;
        this.zze = zzfrh2;
        this.zzf = zzfri2;
    }

    final /* synthetic */ void zzf(Exception exception) {
        if (exception instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        this.zzc.zzc(2025, -1L, exception);
    }
}

