/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzgfs;
import com.google.android.gms.internal.ads.zzggb;
import com.google.android.gms.internal.ads.zzgii;
import com.google.android.gms.internal.ads.zzgmv;
import com.google.android.gms.internal.ads.zzgpm;
import com.google.android.gms.internal.ads.zzgwl;
import com.google.android.gms.internal.ads.zzgwm;
import com.google.android.gms.internal.ads.zzgxo;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class zzgwn
implements zzgfs {
    private static final ThreadLocal zza = new zzgwl();
    private static final ThreadLocal zzb = new zzgwm();
    private final byte[] zzc;
    private final byte[] zzd;
    private final byte[] zze;
    private final SecretKeySpec zzf;
    private final int zzg;

    public static zzgfs zzb(zzgii zzgii2) throws GeneralSecurityException {
        if (!zzgmv.zza(1)) {
            throw new GeneralSecurityException("Can not use AES-EAX in FIPS-mode.");
        }
        zzgii2.zza();
        return new zzgwn(zzgii2.zzc().zzd(zzggb.zza()), zzgii2.zza().zzb(), zzgii2.zzb().zzc());
    }

    private zzgwn(byte[] byArray, int n, byte[] byArray2) throws GeneralSecurityException {
        if (!zzgmv.zza(1)) {
            throw new GeneralSecurityException("Can not use AES-EAX in FIPS-mode.");
        }
        if (n != 12 && n != 16) {
            throw new IllegalArgumentException("IV size should be either 12 or 16 bytes");
        }
        this.zzg = n;
        zzgxo.zza(byArray.length);
        String string2 = "AES";
        this.zzf = new SecretKeySpec(byArray, string2);
        Cipher cipher = (Cipher)zza.get();
        cipher.init(1, this.zzf);
        this.zzc = zzgwn.zzc(cipher.doFinal(new byte[16]));
        this.zzd = zzgwn.zzc(this.zzc);
        this.zze = byArray2;
    }

    @Override
    public final byte[] zza(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        byte[] byArray3 = this.zze;
        if (byArray3.length == 0) {
            return this.zze(byArray, byArray2);
        }
        if (!zzgpm.zzb(byArray3, byArray)) {
            throw new GeneralSecurityException("Decryption failed (OutputPrefix mismatch).");
        }
        zzgwn zzgwn2 = this;
        int n = byArray.length;
        return zzgwn2.zze(Arrays.copyOfRange(byArray, zzgwn2.zze.length, n), byArray2);
    }

    private static byte[] zzc(byte[] byArray) {
        byte[] byArray2 = new byte[16];
        int n = 0;
        while (n < 15) {
            byte by = byArray[n];
            byArray2[n++] = (byte)((by + by ^ (byArray[n] & 0xFF) >>> 7) & 0xFF);
        }
        byte by = byArray[15];
        byArray2[15] = (byte)(by + by ^ byArray[0] >> 7 & 0x87);
        return byArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final byte[] zzd(Cipher cipher, int n, byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        Object object;
        byte[] byArray2 = new byte[16];
        byArray2[15] = (byte)n;
        if (n3 == 0) {
            return cipher.doFinal(zzgwn.zzf(byArray2, ((zzgwn)object).zzc));
        }
        byte[] byArray3 = cipher.doFinal(byArray2);
        int n4 = 0;
        while (n3 - n4 > 16) {
            for (int i = 0; i < 16; ++i) {
                int n5 = n2 + n4;
                int n6 = i;
                byArray3[n6] = (byte)(byArray3[n6] ^ byArray[n5 + i]);
            }
            byArray3 = cipher.doFinal(byArray3);
            n4 += 16;
        }
        if ((byArray = Arrays.copyOfRange(byArray, n2 + n4, n2 + n3)).length == 16) {
            object = zzgwn.zzf(byArray, ((zzgwn)object).zzc);
            return cipher.doFinal(zzgwn.zzf(byArray3, (byte[])object));
        }
        byte[] byArray4 = Arrays.copyOf(((zzgwn)object).zzd, 16);
        for (int i = 0; i < (n3 = byArray.length); ++i) {
            int n7 = i;
            byArray4[n7] = (byte)(byArray4[i] ^ byArray[n7]);
        }
        int n8 = n3;
        byArray4[n8] = (byte)(byArray4[n8] ^ 0x80);
        object = byArray4;
        return cipher.doFinal(zzgwn.zzf(byArray3, (byte[])object));
    }

    private final byte[] zze(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        int n = byArray.length;
        int n2 = n - this.zzg + -16;
        if (n2 < 0) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        Object object = (Cipher)zza.get();
        ((Cipher)object).init(1, this.zzf);
        byte[] byArray3 = this.zzd((Cipher)object, 0, byArray, 0, this.zzg);
        if (byArray2 == null) {
            byArray2 = new byte[]{};
        }
        byte[] byArray4 = this.zzd((Cipher)object, 1, byArray2, 0, byArray2.length);
        object = this.zzd((Cipher)object, 2, byArray, this.zzg, n2);
        int n3 = n + -16;
        int n4 = 0;
        for (n = 0; n < 16; ++n) {
            n4 |= byArray[n3 + n] ^ byArray4[n] ^ byArray3[n] ^ object[n];
            n4 = (byte)n4;
        }
        if (n4 != 0) {
            throw new AEADBadTagException("tag mismatch");
        }
        Cipher cipher = (Cipher)zzb.get();
        cipher.init(1, (Key)this.zzf, new IvParameterSpec(byArray3));
        return cipher.doFinal(byArray, this.zzg, n2);
    }

    private static byte[] zzf(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        byte[] byArray3 = new byte[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            byArray3[n2] = (byte)(byArray[i] ^ byArray2[n2]);
        }
        return byArray3;
    }
}

