/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.VisibleForTesting;
import androidx.browser.customtabs.CustomTabsCallback;
import androidx.browser.customtabs.CustomTabsClient;
import androidx.browser.customtabs.CustomTabsSession;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdFormat;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.internal.client.zzbd;
import com.google.android.gms.ads.internal.util.client.zzo;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.ads.nonagon.signalgeneration.zzaa;
import com.google.android.gms.ads.nonagon.signalgeneration.zzf;
import com.google.android.gms.ads.query.QueryInfo;
import com.google.android.gms.ads.query.QueryInfoGenerationCallback;
import com.google.android.gms.internal.ads.zzbbz;
import com.google.android.gms.internal.ads.zzbci;
import com.google.android.gms.internal.ads.zzbdk;
import com.google.android.gms.internal.ads.zzbdl;
import com.google.android.gms.internal.ads.zzbdm;
import com.google.android.gms.internal.ads.zzben;
import com.google.android.gms.internal.ads.zzdrj;
import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzbdn {
    private final ScheduledExecutorService zza;
    private final com.google.android.gms.ads.nonagon.signalgeneration.zzo zzb;
    private final zzf zzc;
    private final zzdrj zzd;
    private Runnable zze;
    private zzbdk zzf;
    private CustomTabsSession zzg;
    private String zzh;
    private long zzi = 0L;
    private long zzj;
    private JSONArray zzk;
    private Context zzl;

    static /* bridge */ /* synthetic */ CustomTabsSession zza(zzbdn zzbdn2) {
        return zzbdn2.zzg;
    }

    @Nullable
    public final CustomTabsSession zzb() {
        return this.zzg;
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    final JSONObject zzc(String string2, String string3) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("paw_id", (Object)string2);
        jSONObject.put("error", (Object)string3);
        long l = (Boolean)zzben.zze.zze() != false ? (Long)zzben.zzh.zze() : 0L;
        jSONObject.put("sdk_ttl_ms", l);
        ((zzbdn)((Object)zzf2)).zzk(jSONObject);
        if (((Boolean)zzben.zzc.zze()).booleanValue()) {
            zzf zzf2 = ((zzbdn)((Object)zzf2)).zzc;
            jSONObject.put("as", (Object)zzf2.zza());
        }
        return jSONObject;
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    final JSONObject zzd(String string2, String string3) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("paw_id", (Object)string2);
        jSONObject.put("signal", (Object)string3);
        long l = (Boolean)zzben.zze.zze() != false ? (Long)zzben.zzh.zze() : 0L;
        jSONObject.put("sdk_ttl_ms", l);
        ((zzbdn)((Object)zzf2)).zzk(jSONObject);
        if (((Boolean)zzben.zzc.zze()).booleanValue()) {
            zzf zzf2 = ((zzbdn)((Object)zzf2)).zzc;
            jSONObject.put("as", (Object)zzf2.zza());
        }
        return jSONObject;
    }

    public static /* synthetic */ void zze(zzbdn zzbdn2) {
        zzbdn2.zzj();
    }

    @VisibleForTesting
    public zzbdn(ScheduledExecutorService scheduledExecutorService, com.google.android.gms.ads.nonagon.signalgeneration.zzo zzo2, zzf zzf2, zzdrj zzdrj2) {
        this.zza = scheduledExecutorService;
        this.zzb = zzo2;
        this.zzc = zzf2;
        this.zzd = zzdrj2;
    }

    final void zzf() {
        zzbbz zzbbz2 = zzbci.zzjU;
        this.zzi = zzv.zzC().elapsedRealtime() + (long)((Integer)zzbd.zzc().zzb(zzbbz2)).intValue();
        if (this.zze == null) {
            this.zze = new zzbdl(this);
        }
        this.zzj();
    }

    public final void zzg(@Nonnull Context object, @Nonnull CustomTabsClient customTabsClient, @Nonnull String string2, @Nullable CustomTabsCallback customTabsCallback) {
        if (object == null) {
            throw new IllegalArgumentException("App Context parameter is null");
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Origin parameter is empty or null");
        }
        if (customTabsClient != null) {
            pairArray.zzl = object;
            pairArray.zzh = string2;
            object = pairArray.zzd;
            pairArray.zzf = new zzbdk((zzbdn)pairArray, customTabsCallback, (zzdrj)object);
            pairArray.zzg = customTabsClient.newSession((CustomTabsCallback)pairArray.zzf);
            if (pairArray.zzg == null) {
                zzo.zzg((String)"CustomTabsClient failed to create new session.");
            }
        } else {
            throw new IllegalArgumentException("CustomTabsClient parameter is null");
        }
        Pair[] pairArray = new Pair[]{new Pair((Object)"pe", (Object)"pact_init")};
        zzaa.zzd((zzdrj)object, null, "pact_action", pairArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzj() {
        block5: {
            ScheduledExecutorService scheduledExecutorService;
            block6: {
                zzbdk zzbdk2 = zzbdn2.zzf;
                if (zzbdk2 == null) {
                    zzo.zzg((String)"PACT callback is not present, please initialize the PawCustomTabsImpl.");
                    return;
                }
                if (zzbdk2.zza().booleanValue()) {
                    return;
                }
                if (zzbdn2.zzh == null || zzbdn2.zzg == null || (scheduledExecutorService = zzbdn2.zza) == null) break block5;
                if (zzbdn2.zzi != 0L && zzv.zzC().elapsedRealtime() <= zzbdn2.zzi) break block6;
                zzbbz zzbbz2 = zzbci.zzjV;
                if (!((Boolean)zzbd.zzc().zzb(zzbbz2)).booleanValue()) break block5;
            }
            zzbdn2.zzg.requestPostMessageChannel(Uri.parse((String)zzbdn2.zzh));
            zzbdn zzbdn2 = zzbci.zzjW;
            scheduledExecutorService.schedule(zzbdn2.zze, (long)((Long)zzbd.zzc().zzb((zzbbz)zzbdn2)), TimeUnit.MILLISECONDS);
            return;
        }
        com.google.android.gms.ads.internal.util.zze.zza("PACT max retry connection duration timed out");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void zzh(String string2) {
        try {
            CustomTabsSession customTabsSession = this.zzg;
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("gsppack", true);
            jSONObject.put("fpt", (Object)new Date(this.zzj).toString());
            this.zzk(jSONObject);
            boolean bl = (Boolean)zzben.zzc.zze();
            if (bl) {
                jSONObject.put("as", (Object)this.zzc.zza());
            }
            customTabsSession.postMessage(jSONObject.toString(), null);
            zzbdm zzbdm2 = new zzbdm(this, string2);
            boolean bl2 = (Boolean)zzben.zze.zze();
            if (bl2) {
                this.zzb.zzg(this.zzg, zzbdm2);
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putString("query_info_type", "requester_type_6");
            QueryInfo.generate((Context)this.zzl, (AdFormat)AdFormat.BANNER, (AdRequest)((AdRequest.Builder)new AdRequest.Builder().addNetworkExtrasBundle(AdMobAdapter.class, bundle)).build(), (QueryInfoGenerationCallback)zzbdm2);
            return;
        }
        catch (JSONException jSONException) {
            zzo.zzh((String)"Error creating JSON: ", (Throwable)jSONException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzk(JSONObject jSONObject) {
        try {
            JSONArray jSONArray = this.zzk;
            if (jSONArray == null) {
                zzbbz zzbbz2 = zzbci.zzjY;
                Object object = zzbd.zzc().zzb(zzbbz2);
                this.zzk = jSONArray = new JSONArray((String)object);
            }
            jSONObject.put("eids", (Object)this.zzk);
            return;
        }
        catch (JSONException jSONException) {
            zzo.zzh((String)"Error fetching the PACT active eids JSON: ", (Throwable)jSONException);
            return;
        }
    }

    public final void zzi(long l) {
        this.zzj = l;
    }
}

