/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.ads.impl.R;
import com.google.android.gms.ads.internal.client.zzbd;
import com.google.android.gms.ads.internal.util.client.zzo;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.util.zzs;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzbbz;
import com.google.android.gms.internal.ads.zzbci;
import com.google.android.gms.internal.ads.zzbcx;
import com.google.android.gms.internal.ads.zzbzk;
import com.google.android.gms.internal.ads.zzcak;
import com.google.android.gms.internal.ads.zzcal;
import com.google.android.gms.internal.ads.zzcam;
import com.google.android.gms.internal.ads.zzcan;
import com.google.android.gms.internal.ads.zzcao;
import com.google.android.gms.internal.ads.zzcap;
import com.google.android.gms.internal.ads.zzcaq;
import com.google.android.gms.internal.ads.zzcar;
import com.google.android.gms.internal.ads.zzcas;
import com.google.android.gms.internal.ads.zzcat;
import com.google.android.gms.internal.ads.zzcay;
import com.google.android.gms.internal.ads.zzcbf;
import com.google.android.gms.internal.ads.zzcbg;
import com.google.android.gms.internal.ads.zzcbh;
import com.google.android.gms.internal.ads.zzcbi;
import com.google.android.gms.internal.ads.zzcby;
import com.google.android.gms.internal.ads.zzcea;
import com.google.android.gms.internal.ads.zzdre;
import com.google.android.gms.internal.ads.zzgcd;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class zzcau
extends FrameLayout
implements zzcal {
    private final zzcbg zzb;
    private final FrameLayout zzc;
    private final View zzd;
    private final zzbcx zze;
    @VisibleForTesting
    final zzcbi zza;
    private final long zzf;
    @Nullable
    private final zzcam zzg;
    private boolean zzh;
    private boolean zzi;
    private boolean zzj;
    private boolean zzk;
    private long zzl;
    private long zzm;
    private String zzn;
    private String[] zzo;
    private Bitmap zzp;
    private final ImageView zzq;
    private boolean zzr;

    @Nullable
    public final Integer zzl() {
        zzcam zzcam2 = ((zzcau)((Object)zzcam2)).zzg;
        if (zzcam2 != null) {
            return zzcam2.zzw();
        }
        return null;
    }

    public static /* synthetic */ void zzm(zzcau zzcau2) {
        zzcau2.zzK("firstFrameRendered", new String[0]);
    }

    public static /* synthetic */ void zzn(zzcau zzcau2, boolean bl) {
        String string2 = "hasWindowFocus";
        String[] stringArray = new String[]{string2, String.valueOf(bl)};
        zzcau2.zzK("windowFocusChanged", stringArray);
    }

    static /* bridge */ /* synthetic */ void zzo(zzcau zzcau2, String string2, String[] stringArray) {
        zzcau2.zzK(string2, stringArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public zzcau(Context context, zzcbg object, int n, boolean bl, zzbcx zzbcx2, zzcbf zzcbf2, @Nullable zzdre zzdre2) {
        super(context);
        boolean bl2;
        this.zzb = object;
        this.zze = zzbcx2;
        this.zzc = new FrameLayout(context);
        zzcau zzcau2 = this;
        zzcau2.addView((View)zzcau2.zzc, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        Preconditions.checkNotNull((Object)object.zzj());
        zzcan cfr_ignored_0 = object.zzj().zza;
        zzcbh zzcbh2 = new zzcbh(context, object.zzm(), object.zzs(), zzbcx2, object.zzk());
        if (n == 3) {
            object = new zzcea(context, zzcbh2);
        } else if (n == 2) {
            Object object2 = object;
            object = new zzcby(context, zzcbh2, (zzcbg)object2, bl, zzcay.zza((zzcbg)object2), zzcbf2, zzdre2);
        } else {
            Object object3 = object;
            object = new zzcak(context, (zzcbg)object3, bl, zzcay.zza((zzcbg)object3), zzcbf2, new zzcbh(context, object.zzm(), object.zzs(), zzbcx2, object.zzk()), zzdre2);
        }
        this.zzg = object;
        this.zzd = new View(context);
        this.zzd.setBackgroundColor(0);
        object = this.zzg;
        if (object != null) {
            this.zzc.addView((View)object, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            object = zzbci.zzV;
            if (((Boolean)zzbd.zzc().zzb((zzbbz)object)).booleanValue()) {
                this.zzc.addView(this.zzd, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.zzc.bringChildToFront(this.zzd);
            }
            object = zzbci.zzS;
            if (((Boolean)zzbd.zzc().zzb((zzbbz)object)).booleanValue()) {
                this.zzp();
            }
        }
        this.zzq = new ImageView(context);
        context = zzbci.zzX;
        this.zzf = (Long)zzbd.zzc().zzb((zzbbz)context);
        context = zzbci.zzU;
        this.zzk = bl2 = ((Boolean)zzbd.zzc().zzb((zzbbz)context)).booleanValue();
        object = this.zze;
        if (object != null) {
            String string2 = true != bl2 ? "0" : "1";
            ((zzbcx)object).zzd("spinner_used", string2);
        }
        this.zza = new zzcbi(this);
        zzcam zzcam2 = this.zzg;
        if (zzcam2 != null) {
            zzcam2.zzr(this);
        }
        if (this.zzg == null) {
            this.zzb("AdVideoUnderlay Error", "Allocating player failed.");
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final void zzp() {
        void var1_5;
        Object object = this.zzg;
        if (object == null) {
            return;
        }
        Context context = object.getContext();
        TextView textView = new TextView(context);
        Resources resources = zzv.zzp().zze();
        if (resources == null) {
            String string2 = "AdMob - ";
        } else {
            String string3 = resources.getString(R.string.watermark_label_prefix);
        }
        object = ((zzcam)object).zzj();
        textView.setText((CharSequence)String.valueOf(var1_5).concat((String)object));
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        FrameLayout frameLayout = this.zzc;
        frameLayout.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        frameLayout.bringChildToFront((View)textView);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzJ() {
        zzcbg zzcbg2 = this.zzb;
        if (zzcbg2.zzi() == null || !this.zzi || this.zzj) {
            return;
        }
        zzcbg2.zzi().getWindow().clearFlags(128);
        this.zzi = false;
    }

    public final void zzq() {
        this.zza.zza();
        zzcam zzcam2 = this.zzg;
        if (zzcam2 != null) {
            zzcam2.zzt();
        }
        this.zzJ();
    }

    public final void finalize() throws Throwable {
        block3: {
            zzcam zzcam2;
            try {
                this.zza.zza();
                zzcam2 = this.zzg;
                if (zzcam2 == null) break block3;
            }
            catch (Throwable throwable) {
                super.finalize();
                throw throwable;
            }
            zzgcd zzgcd2 = zzbzk.zzf;
            Objects.requireNonNull(zzcam2);
            zzgcd2.execute(new zzcao(zzcam2));
        }
        super.finalize();
    }

    public final void zzr(Integer n) {
        zzcam zzcam2 = this.zzg;
        if (zzcam2 == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzn)) {
            zzcam2.zzC(this.zzn, this.zzo, n);
            return;
        }
        this.zzK("no_src", new String[0]);
    }

    public final void zzs() {
        zzcam zzcam2 = ((zzcau)((Object)zzcam2)).zzg;
        if (zzcam2 == null) {
            return;
        }
        zzcam2.zzb.zzd(true);
        zzcam2.zzn();
    }

    /*
     * Enabled aggressive block sorting
     */
    final void zzt() {
        long l;
        String[] stringArray = this.zzg;
        if (stringArray == null || this.zzl == (l = (long)stringArray.zza()) || l <= 0L) {
            return;
        }
        float f = l;
        zzbbz zzbbz2 = zzbci.zzcc;
        f /= 1000.0f;
        if (((Boolean)zzbd.zzc().zzb(zzbbz2)).booleanValue()) {
            String string2 = "time";
            String[] stringArray2 = new String[]{string2, String.valueOf(f), "totalBytes", String.valueOf(stringArray.zzh()), "qoeCachedBytes", String.valueOf(stringArray.zzf()), "qoeLoadedBytes", String.valueOf(stringArray.zzg()), "droppedFrames", String.valueOf(stringArray.zzb()), "reportTime", String.valueOf(zzv.zzC().currentTimeMillis())};
            this.zzK("timeupdate", stringArray2);
        } else {
            stringArray = new String[]{"time", String.valueOf(f)};
            this.zzK("timeupdate", stringArray);
        }
        this.zzl = l;
    }

    @Override
    public final void zza() {
        zzbbz zzbbz2 = zzbci.zzce;
        if (((Boolean)zzbd.zzc().zzb(zzbbz2)).booleanValue()) {
            this.zza.zza();
        }
        this.zzK("ended", new String[0]);
        this.zzJ();
    }

    @Override
    public final void zzb(String string2, @Nullable String string3) {
        String string4 = "what";
        String[] stringArray = new String[]{string4, string2, "extra", string3};
        this.zzK("error", stringArray);
    }

    @Override
    public final void zzc(String string2, @Nullable String string3) {
        string2 = "what";
        String[] stringArray = new String[]{string2, "ExoPlayerAdapter exception", "extra", string3};
        this.zzK("exception", stringArray);
    }

    @Override
    public final void zzd() {
        this.zzK("pause", new String[0]);
        this.zzJ();
        this.zzh = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void zze() {
        zzcbg zzcbg2;
        zzbbz zzbbz2 = zzbci.zzce;
        if (((Boolean)zzbd.zzc().zzb(zzbbz2)).booleanValue()) {
            this.zza.zzb();
        }
        if ((zzcbg2 = this.zzb).zzi() != null && !this.zzi) {
            boolean bl = (zzcbg2.zzi().getWindow().getAttributes().flags & 0x80) != 0;
            this.zzj = bl;
            if (!bl) {
                zzcbg2.zzi().getWindow().addFlags(128);
                this.zzi = true;
            }
        }
        this.zzh = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void zzf() {
        Object object = this.zzg;
        if (object == null || this.zzm != 0L) {
            return;
        }
        float f = ((zzcam)object).zzc();
        int n = ((zzcam)object).zze();
        int n2 = ((zzcam)object).zzd();
        object = "duration";
        String[] stringArray = new String[]{object, String.valueOf(f / 1000.0f), "videoWidth", String.valueOf(n), "videoHeight", String.valueOf(n2)};
        this.zzK("canplaythrough", stringArray);
    }

    @Override
    public final void zzg() {
        this.zzd.setVisibility(4);
        zzs.zza.post((Runnable)new zzcap(this));
    }

    @Override
    public final void zzh() {
        this.zza.zzb();
        zzs.zza.post((Runnable)new zzcar(this));
    }

    @Override
    public final void zzi() {
        if (this.zzr && this.zzp != null && !this.zzL()) {
            ImageView imageView = this.zzq;
            imageView.setImageBitmap(this.zzp);
            imageView.invalidate();
            FrameLayout frameLayout = this.zzc;
            frameLayout.addView((View)imageView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            frameLayout.bringChildToFront((View)imageView);
        }
        this.zza.zza();
        this.zzm = this.zzl;
        zzs.zza.post((Runnable)new zzcas(this));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void zzj(int n, int n2) {
        block3: {
            block2: {
                if (!this.zzk) break block2;
                zzbbz zzbbz2 = zzbci.zzW;
                n = Math.max(n / (Integer)zzbd.zzc().zzb(zzbbz2), 1);
                zzbbz2 = zzbci.zzW;
                n2 = Math.max(n2 / (Integer)zzbd.zzc().zzb(zzbbz2), 1);
                zzbbz2 = this.zzp;
                if (zzbbz2 == null || zzbbz2.getWidth() != n || this.zzp.getHeight() != n2) break block3;
            }
            return;
        }
        this.zzp = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.zzr = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void zzk() {
        long l;
        block7: {
            block6: {
                zzcam zzcam2;
                if (((zzcau)((Object)zzbcx2)).zzh && ((zzcau)((Object)zzbcx2)).zzL()) {
                    ((zzcau)((Object)zzbcx2)).zzc.removeView((View)((zzcau)((Object)zzbcx2)).zzq);
                }
                if ((zzcam2 = ((zzcau)((Object)zzbcx2)).zzg) == null || ((zzcau)((Object)zzbcx2)).zzp == null) break block6;
                long l2 = zzv.zzC().elapsedRealtime();
                if (zzcam2.getBitmap(((zzcau)((Object)zzbcx2)).zzp) != null) {
                    ((zzcau)((Object)zzbcx2)).zzr = true;
                }
                l = zzv.zzC().elapsedRealtime() - l2;
                if (com.google.android.gms.ads.internal.util.zze.zzc()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Spinner frame grab took ");
                    stringBuilder.append(l);
                    stringBuilder.append("ms");
                    com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
                }
                if (l <= ((zzcau)((Object)zzbcx2)).zzf) break block6;
                com.google.android.gms.ads.internal.util.client.zzo.zzj((String)"Spinner frame grab crossed jank threshold! Suspending spinner.");
                ((zzcau)((Object)zzbcx2)).zzk = false;
                ((zzcau)((Object)zzbcx2)).zzp = null;
                zzbcx zzbcx2 = ((zzcau)((Object)zzbcx2)).zze;
                if (zzbcx2 != null) break block7;
            }
            return;
        }
        zzbcx2.zzd("spinner_jank", Long.toString(l));
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (bl) {
            this.zza.zzb();
        } else {
            this.zza.zza();
            this.zzm = this.zzl;
        }
        zzs.zza.post((Runnable)new zzcaq(this, bl));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void onWindowVisibilityChanged(int n) {
        super.onWindowVisibilityChanged(n);
        if (n == 0) {
            this.zza.zzb();
            n = 1;
        } else {
            this.zza.zza();
            this.zzm = this.zzl;
            n = 0;
        }
        zzs.zza.post((Runnable)new zzcat(this, n != 0));
    }

    public final void zzu() {
        zzcam zzcam2 = ((zzcau)((Object)zzcam2)).zzg;
        if (zzcam2 == null) {
            return;
        }
        zzcam2.zzo();
    }

    public final void zzv() {
        zzcam zzcam2 = ((zzcau)((Object)zzcam2)).zzg;
        if (zzcam2 == null) {
            return;
        }
        zzcam2.zzp();
    }

    public final void zzw(int n) {
        zzcam zzcam2 = ((zzcau)((Object)zzcam2)).zzg;
        if (zzcam2 == null) {
            return;
        }
        zzcam2.zzq(n);
    }

    public final void zzx(MotionEvent motionEvent) {
        zzcam zzcam2 = ((zzcau)((Object)zzcam2)).zzg;
        if (zzcam2 == null) {
            return;
        }
        zzcam2.dispatchTouchEvent(motionEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzK(String string2, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Integer n = this.zzl();
        if (n != null) {
            hashMap.put("playerId", n.toString());
        }
        hashMap.put("event", string2);
        int n2 = stringArray.length;
        string2 = null;
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                this.zzb.zzd("onVideoEvent", hashMap);
                return;
            }
            String string3 = stringArray[n3];
            if (string2 == null) {
                string2 = string3;
            } else {
                hashMap.put(string2, string3);
                string2 = null;
            }
            ++n3;
        }
    }

    public final void zzy(int n) {
        zzcam zzcam2 = ((zzcau)((Object)zzcam2)).zzg;
        if (zzcam2 == null) {
            return;
        }
        zzcam2.zzx(n);
    }

    public final void zzz(int n) {
        zzcam zzcam2 = ((zzcau)((Object)zzcam2)).zzg;
        if (zzcam2 == null) {
            return;
        }
        zzcam2.zzy(n);
    }

    public final void zzA(int n) {
        zzcam zzcam2 = ((zzcau)((Object)zzcam2)).zzg;
        if (zzcam2 == null) {
            return;
        }
        zzcam2.zzz(n);
    }

    public final void zzB(int n) {
        zzcam zzcam2 = ((zzcau)((Object)zzcam2)).zzg;
        if (zzcam2 == null) {
            return;
        }
        zzcam2.zzA(n);
    }

    public final void zzC(int n) {
        zzbbz zzbbz2 = zzbci.zzV;
        if (((Boolean)zzbd.zzc().zzb(zzbbz2)).booleanValue()) {
            this.zzc.setBackgroundColor(n);
            this.zzd.setBackgroundColor(n);
            return;
        }
    }

    public final void zzD(int n) {
        zzcam zzcam2 = ((zzcau)((Object)zzcam2)).zzg;
        if (zzcam2 == null) {
            return;
        }
        zzcam2.zzB(n);
    }

    public final void zzE(String string2, String[] stringArray) {
        this.zzn = string2;
        this.zzo = stringArray;
    }

    public final void zzF(int n, int n2, int n3, int n4) {
        if (com.google.android.gms.ads.internal.util.zze.zzc()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Set video bounds to x:");
            stringBuilder.append(n);
            stringBuilder.append(";y:");
            stringBuilder.append(n2);
            stringBuilder.append(";w:");
            stringBuilder.append(n3);
            stringBuilder.append(";h:");
            stringBuilder.append(n4);
            com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        }
        if (n3 == 0 || n4 == 0) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, n4);
        layoutParams.setMargins(n, n2, 0, 0);
        this.zzc.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public final void zzG(float f) {
        zzcam zzcam2 = ((zzcau)((Object)zzcam2)).zzg;
        if (zzcam2 == null) {
            return;
        }
        zzcam2.zzb.zze(f);
        zzcam2.zzn();
    }

    public final void zzH(float f, float f2) {
        zzcam zzcam2 = ((zzcau)((Object)zzcam2)).zzg;
        if (zzcam2 != null) {
            zzcam2.zzu(f, f2);
            return;
        }
    }

    public final void zzI() {
        zzcam zzcam2 = ((zzcau)((Object)zzcam2)).zzg;
        if (zzcam2 == null) {
            return;
        }
        zzcam2.zzb.zzd(false);
        zzcam2.zzn();
    }

    private final boolean zzL() {
        return this.zzq.getParent() != null;
    }
}

