/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Message;
import android.view.View;
import android.view.WindowManager;
import android.webkit.ConsoleMessage;
import android.webkit.GeolocationPermissions;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.client.zzbd;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.util.client.zzo;
import com.google.android.gms.ads.internal.util.zzs;
import com.google.android.gms.ads.internal.zzb;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.internal.ads.zzbbz;
import com.google.android.gms.internal.ads.zzbci;
import com.google.android.gms.internal.ads.zzced;
import com.google.android.gms.internal.ads.zzcee;
import com.google.android.gms.internal.ads.zzcef;
import com.google.android.gms.internal.ads.zzceg;
import com.google.android.gms.internal.ads.zzceh;
import com.google.android.gms.internal.ads.zzcei;
import com.google.android.gms.internal.ads.zzcej;
import com.google.android.gms.internal.ads.zzcel;

public final class zzcek
extends WebChromeClient {
    private final zzcel zza;

    public zzcek(zzcel zzcel2) {
        this.zza = zzcel2;
    }

    public final void onCloseWindow(WebView webView) {
        if (!(webView instanceof zzcel)) {
            zzo.zzj((String)"Tried to close a WebView that wasn't an AdWebView.");
            return;
        }
        zzm zzm2 = ((zzcel)webView).zzL();
        if (zzm2 == null) {
            zzo.zzj((String)"Tried to close an AdWebView not associated with an overlay.");
            return;
        }
        zzm2.zzb();
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void onExceededDatabaseQuota(String string2, String string3, long l, long l2, long l3, WebStorage.QuotaUpdater quotaUpdater) {
        long l4;
        long l5 = 0x500000L - l3;
        if (l5 <= 0L) {
            quotaUpdater.updateQuota(l);
            return;
        }
        if (l == 0L) {
            long l6 = l2 <= l5 ? (l2 <= 0x100000L ? l2 : 0L) : 0L;
            l4 = l6;
        } else if (l2 == 0L) {
            l4 = Math.min(l + Math.min(131072L, l5), 0x100000L);
        } else {
            if (l2 <= Math.min(0x100000L - l, l5)) {
                l += l2;
            }
            l4 = l;
        }
        quotaUpdater.updateQuota(l4);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void onGeolocationPermissionsShowPrompt(String string2, GeolocationPermissions.Callback callback) {
        if (callback != null) {
            boolean bl;
            zzcel zzcel2 = ((zzcek)((Object)zzcel2)).zza;
            zzv.zzq();
            if (!zzs.zzB(zzcel2.getContext(), "android.permission.ACCESS_FINE_LOCATION")) {
                zzv.zzq();
                bl = zzs.zzB(zzcel2.getContext(), "android.permission.ACCESS_COARSE_LOCATION");
            } else {
                bl = true;
            }
            zzbbz zzbbz2 = zzbci.zznj;
            if (((Boolean)zzbd.zzc().zzb(zzbbz2)).booleanValue()) {
                callback.invoke(string2, false, true);
            } else {
                callback.invoke(string2, bl, true);
            }
            zzbbz zzbbz3 = zzbci.zznk;
            if (((Boolean)zzbd.zzc().zzb(zzbbz3)).booleanValue()) {
                zzo.zze((String)"AdWebChromeClient.onGeolocationPermissionsShowPrompt()");
                return;
            }
        }
    }

    public final void onHideCustomView() {
        zzm zzm2 = ((zzcek)((Object)zzm2)).zza.zzL();
        if (zzm2 == null) {
            zzo.zzj((String)"Could not get ad overlay when hiding custom view.");
            return;
        }
        zzm2.zzg();
    }

    public final void onShowCustomView(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.onShowCustomView(view, -1, customViewCallback);
    }

    @Deprecated
    public final void onShowCustomView(View view, int n, WebChromeClient.CustomViewCallback customViewCallback) {
        zzm zzm2 = ((zzcek)((Object)zzm2)).zza.zzL();
        if (zzm2 == null) {
            zzo.zzj((String)"Could not get ad overlay when showing custom view.");
            customViewCallback.onCustomViewHidden();
            return;
        }
        zzm2.zzC(view, customViewCallback);
        zzm2.zzA(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        String string2 = consoleMessage.message();
        String string3 = consoleMessage.sourceId();
        int n = consoleMessage.lineNumber();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("JS: ");
        stringBuilder.append(string2);
        stringBuilder.append(" (");
        stringBuilder.append(string3);
        stringBuilder.append(":");
        stringBuilder.append(n);
        stringBuilder.append(")");
        string2 = stringBuilder.toString();
        if (string2.contains("Application Cache")) {
            return super.onConsoleMessage(consoleMessage);
        }
        switch (zzcej.zza[consoleMessage.messageLevel().ordinal()]) {
            default: {
                zzo.zzi((String)string2);
                return super.onConsoleMessage(consoleMessage);
            }
            case 5: {
                zzo.zze((String)string2);
                return super.onConsoleMessage(consoleMessage);
            }
            case 3: 
            case 4: {
                zzo.zzi((String)string2);
                return super.onConsoleMessage(consoleMessage);
            }
            case 2: {
                zzo.zzj((String)string2);
                return super.onConsoleMessage(consoleMessage);
            }
            case 1: 
        }
        zzo.zzg((String)string2);
        return super.onConsoleMessage(consoleMessage);
    }

    public final boolean onCreateWindow(WebView webView, boolean bl, boolean bl2, Message message) {
        WebView.WebViewTransport webViewTransport = (WebView.WebViewTransport)message.obj;
        WebView webView2 = new WebView(webView.getContext());
        zzcel zzcel2 = ((zzcek)((Object)zzcel2)).zza;
        if (zzcel2.zzH() != null) {
            webView2.setWebViewClient(zzcel2.zzH());
        }
        webViewTransport.setWebView(webView2);
        message.sendToTarget();
        return true;
    }

    public final boolean onJsAlert(WebView webView, String string2, String string3, JsResult jsResult) {
        return this.zza(zzcek.zzb(webView), "alert", string2, string3, null, jsResult, null, false);
    }

    public final boolean onJsBeforeUnload(WebView webView, String string2, String string3, JsResult jsResult) {
        return this.zza(zzcek.zzb(webView), "onBeforeUnload", string2, string3, null, jsResult, null, false);
    }

    public final boolean onJsConfirm(WebView webView, String string2, String string3, JsResult jsResult) {
        return this.zza(zzcek.zzb(webView), "confirm", string2, string3, null, jsResult, null, false);
    }

    public final boolean onJsPrompt(WebView webView, String string2, String string3, String string4, JsPromptResult jsPromptResult) {
        return this.zza(zzcek.zzb(webView), "prompt", string2, string3, string4, null, jsPromptResult, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean zza(Context context, String string2, String string3, String string4, String string5, JsResult jsResult, JsPromptResult jsPromptResult, boolean bl) {
        block12: {
            Object object;
            block11: {
                try {
                    object = ((zzcek)((Object)object)).zza;
                    if (object == null) break block11;
                }
                catch (WindowManager.BadTokenException badTokenException) {
                    zzo.zzk((String)"Fail to display Dialog.", (Throwable)badTokenException);
                    return true;
                }
                Object object2 = object.zzN();
                if (object2 == null) break block11;
                object2 = object.zzN().zzd();
                if (object2 == null) break block11;
                object = object.zzN().zzd();
                if (object == null) break block11;
                boolean bl2 = ((zzb)object).zzc();
                if (bl2) break block11;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("window.");
                stringBuilder.append(string2);
                stringBuilder.append("('");
                stringBuilder.append(string4);
                stringBuilder.append("')");
                ((zzb)object).zzb(stringBuilder.toString());
                return false;
            }
            zzv.zzq();
            object = zzs.zzL(context);
            object.setTitle((CharSequence)string3);
            if (!bl) break block12;
            LinearLayout linearLayout = new LinearLayout(context);
            linearLayout.setOrientation(1);
            TextView textView = new TextView(context);
            textView.setText((CharSequence)string4);
            string2 = new EditText(context);
            string2.setText((CharSequence)string5);
            linearLayout.addView((View)textView);
            linearLayout.addView((View)string2);
            object.setView((View)linearLayout).setPositiveButton(17039370, (DialogInterface.OnClickListener)new zzcei(jsPromptResult, (EditText)string2)).setNegativeButton(0x1040000, (DialogInterface.OnClickListener)new zzceh(jsPromptResult)).setOnCancelListener((DialogInterface.OnCancelListener)new zzceg(jsPromptResult)).create().show();
            return true;
        }
        object.setMessage((CharSequence)string4).setPositiveButton(17039370, (DialogInterface.OnClickListener)new zzcef(jsResult)).setNegativeButton(0x1040000, (DialogInterface.OnClickListener)new zzcee(jsResult)).setOnCancelListener((DialogInterface.OnCancelListener)new zzced(jsResult)).create().show();
        return true;
    }

    private static final Context zzb(WebView object) {
        if (!(object instanceof zzcel)) {
            return object.getContext();
        }
        Activity activity = (object = (zzcel)object).zzi();
        if (activity != null) {
            return activity;
        }
        return object.getContext();
    }
}

