/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.RemoteException;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.client.zzea;
import com.google.android.gms.ads.internal.util.client.zzo;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbff;
import com.google.android.gms.internal.ads.zzbfq;
import com.google.android.gms.internal.ads.zzblv;
import com.google.android.gms.internal.ads.zzblz;
import com.google.android.gms.internal.ads.zzbzx;
import com.google.android.gms.internal.ads.zzcqg;
import com.google.android.gms.internal.ads.zzdhl;
import com.google.android.gms.internal.ads.zzdhq;
import com.google.android.gms.internal.ads.zzdlt;
import java.util.Collections;

public final class zzdlu
extends zzblv
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener,
zzbff {
    private View zza;
    private zzea zzb;
    private zzdhl zzc;
    private boolean zzd;
    private boolean zze;

    @Nullable
    public final zzea zzb() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzd) {
            zzo.zzg((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        return this.zzb;
    }

    @Nullable
    public final zzbfq zzc() {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (((zzdlu)((Object)zzdhl2)).zzd) {
            zzo.zzg((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        zzdhl zzdhl2 = ((zzdlu)((Object)zzdhl2)).zzc;
        if (zzdhl2 != null && zzdhl2.zzc() != null) {
            return zzdhl2.zzc().zza();
        }
        return null;
    }

    public zzdlu(zzdhl zzdhl2, zzdhq zzdhq2) {
        this.zza = zzdhq2.zzf();
        this.zzb = zzdhq2.zzj();
        this.zzc = zzdhl2;
        this.zzd = false;
        this.zze = false;
        if (zzdhq2.zzs() != null) {
            zzdhq2.zzs().zzap(this);
            return;
        }
    }

    public final void zzd() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        this.zzh();
        zzdhl zzdhl2 = this.zzc;
        if (zzdhl2 != null) {
            ((zzcqg)zzdhl2).zzb();
        }
        this.zzc = null;
        this.zza = null;
        this.zzb = null;
        this.zzd = true;
    }

    private final void zzg() {
        View view;
        zzdhl zzdhl2 = this.zzc;
        if (zzdhl2 != null && (view = this.zza) != null) {
            zzdhl2.zzB(view, Collections.emptyMap(), Collections.emptyMap(), zzdhl.zzY(this.zza));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzh() {
        View view = this.zza;
        if (view == null || !((view = view.getParent()) instanceof ViewGroup)) {
            return;
        }
        ((ViewGroup)view).removeView(this.zza);
    }

    public final void onGlobalLayout() {
        this.zzg();
    }

    public final void onScrollChanged() {
        this.zzg();
    }

    public final void zze(IObjectWrapper iObjectWrapper) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        this.zzf(iObjectWrapper, (zzblz)new zzdlt(this));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzf(IObjectWrapper iObjectWrapper, zzblz zzblz2) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (((zzdlu)((Object)string2)).zzd) {
            zzo.zzg((String)"Instream ad can not be shown after destroy().");
            zzdlu.zzi(zzblz2, 2);
            return;
        }
        View view = ((zzdlu)((Object)string2)).zza;
        if (view == null || ((zzdlu)((Object)string2)).zzb == null) {
            String string2 = view == null ? "can not get video view." : "can not get video controller.";
            zzo.zzg((String)"Instream internal error: ".concat(string2));
            zzdlu.zzi(zzblz2, 0);
            return;
        }
        if (((zzdlu)((Object)string2)).zze) {
            zzo.zzg((String)"Instream ad should not be used again.");
            zzdlu.zzi(zzblz2, 1);
            return;
        }
        ((zzdlu)((Object)string2)).zze = true;
        super.zzh();
        ((ViewGroup)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)).addView(((zzdlu)((Object)string2)).zza, new ViewGroup.LayoutParams(-1, -1));
        zzv.zzy();
        zzbzx.zza(((zzdlu)((Object)string2)).zza, (ViewTreeObserver.OnGlobalLayoutListener)string2);
        zzv.zzy();
        zzbzx.zzb(((zzdlu)((Object)string2)).zza, (ViewTreeObserver.OnScrollChangedListener)string2);
        super.zzg();
        try {
            zzblz2.zzf();
            return;
        }
        catch (RemoteException remoteException) {
            zzo.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    private static final void zzi(zzblz zzblz2, int n) {
        try {
            zzblz2.zze(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzo.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }
}

