/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.RemoteException;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import com.google.android.gms.ads.impl.R;
import com.google.android.gms.ads.internal.client.zzbd;
import com.google.android.gms.ads.internal.offline.buffering.zza;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.util.client.zzo;
import com.google.android.gms.ads.internal.util.client.zzu;
import com.google.android.gms.ads.internal.util.zzbr;
import com.google.android.gms.ads.internal.util.zzs;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbbz;
import com.google.android.gms.internal.ads.zzbci;
import com.google.android.gms.internal.ads.zzbsq;
import com.google.android.gms.internal.ads.zzdhq;
import com.google.android.gms.internal.ads.zzdrd;
import com.google.android.gms.internal.ads.zzdre;
import com.google.android.gms.internal.ads.zzeah;
import com.google.android.gms.internal.ads.zzeal;
import com.google.android.gms.internal.ads.zzeam;
import com.google.android.gms.internal.ads.zzeat;
import com.google.android.gms.internal.ads.zzeav;
import com.google.android.gms.internal.ads.zzeaw;
import com.google.android.gms.internal.ads.zzeax;
import com.google.android.gms.internal.ads.zzeay;
import com.google.android.gms.internal.ads.zzeaz;
import com.google.android.gms.internal.ads.zzeba;
import com.google.android.gms.internal.ads.zzebb;
import com.google.android.gms.internal.ads.zzebc;
import com.google.android.gms.internal.ads.zzebd;
import com.google.android.gms.internal.ads.zzebg;
import com.google.android.gms.internal.ads.zzfqt;
import com.google.android.gms.internal.ads.zzfwz;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.xmlpull.v1.XmlPullParser;

public final class zzebe
extends zzbsq {
    @VisibleForTesting
    final Map zza = new HashMap();
    private final Context zzb;
    private final zzdre zzc;
    private final zzu zzd;
    private final zzeat zze;
    private String zzf;
    private String zzg;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final AlertDialog zzs(Activity activity, @Nullable zzm zzm2) {
        zzv.zzq();
        zzm2 = zzs.zzL((Context)activity).setOnCancelListener((DialogInterface.OnCancelListener)new zzeaw(zzm2));
        XmlResourceParser xmlResourceParser = zzebe.zzt(R.layout.offline_ads_dialog);
        if (xmlResourceParser == null) {
            zzm2.setMessage(zzebe.zzv(R.string.offline_dialog_text, "Thanks for your interest.\nWe will share more once you're back online."));
            return zzm2.create();
        }
        try {
            activity = activity.getLayoutInflater().inflate((XmlPullParser)xmlResourceParser, null);
        }
        catch (Resources.NotFoundException notFoundException) {
            zzm2.setMessage(zzebe.zzv(R.string.offline_dialog_text, "Thanks for your interest.\nWe will share more once you're back online."));
            return zzm2.create();
        }
        zzm2.setView((View)activity);
        String string2 = ((zzebe)((Object)this)).zzu();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            TextView textView = (TextView)activity.findViewById(R.id.offline_dialog_advertiser_name);
            textView.setVisibility(0);
            textView.setText((CharSequence)string2);
        }
        if ((this = (this = (zzeal)((zzebe)((Object)this)).zza.get(((zzebe)((Object)this)).zzf)) == null ? null : ((zzeal)this).zza()) != null) {
            ((ImageView)activity.findViewById(R.id.offline_dialog_image)).setImageDrawable((Drawable)this);
        }
        AlertDialog alertDialog = zzm2.create();
        alertDialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        return alertDialog;
    }

    @Nullable
    private static XmlResourceParser zzt(int n) {
        Resources resources = zzv.zzp().zze();
        if (resources == null) {
            return null;
        }
        try {
            XmlResourceParser xmlResourceParser = resources.getLayout(n);
            return xmlResourceParser;
        }
        catch (Resources.NotFoundException notFoundException) {
            return null;
        }
    }

    @Nullable
    private final String zzu() {
        zzeal zzeal2 = (zzeal)((zzebe)((Object)zzeal2)).zza.get(((zzebe)((Object)zzeal2)).zzf);
        if (zzeal2 == null) {
            return "";
        }
        return zzeal2.zzb();
    }

    private static String zzv(int n, String string2) {
        Resources resources = zzv.zzp().zze();
        if (resources == null) {
            return string2;
        }
        try {
            String string3 = resources.getString(n);
            return string3;
        }
        catch (Resources.NotFoundException notFoundException) {
            return string2;
        }
    }

    public static /* synthetic */ void zzc(zzebe zzebe2, zzm zzm2, DialogInterface object, int n) {
        zzebe2.zze.zzc(zzebe2.zzf);
        object = new HashMap();
        object.put("dialog_action", "dismiss");
        zzebe zzebe3 = zzebe2;
        zzebe3.zzw(zzebe3.zzf, "rtsdc", (Map)object);
        if (zzm2 != null) {
            zzm2.zzb();
            return;
        }
    }

    public static /* synthetic */ void zzd(zzebe zzebe2, zzm zzm2, DialogInterface object) {
        zzebe2.zze.zzc(zzebe2.zzf);
        object = new HashMap();
        object.put("dialog_action", "dismiss");
        zzebe zzebe3 = zzebe2;
        zzebe3.zzw(zzebe3.zzf, "rtsdc", (Map)object);
        if (zzm2 != null) {
            zzm2.zzb();
            return;
        }
    }

    public static /* synthetic */ void zzk(zzebe zzebe2, Activity activity, zzm zzm2, DialogInterface object, int n) {
        object = new HashMap();
        object.put("dialog_action", "confirm");
        zzebe zzebe3 = zzebe2;
        zzebe3.zzw(zzebe3.zzf, "rtsdc", (Map)object);
        Activity activity2 = activity;
        activity2.startActivity(zzv.zzr().zzf(activity2));
        zzebe2.zzx();
        if (zzm2 != null) {
            zzm2.zzb();
            return;
        }
    }

    public static /* synthetic */ void zzl(zzebe zzebe2, zzm zzm2, DialogInterface object, int n) {
        zzebe2.zze.zzc(zzebe2.zzf);
        object = new HashMap();
        object.put("dialog_action", "dismiss");
        zzebe zzebe3 = zzebe2;
        zzebe3.zzw(zzebe3.zzf, "dialog_click", (Map)object);
        if (zzm2 != null) {
            zzm2.zzb();
            return;
        }
    }

    public static /* synthetic */ void zzm(zzebe zzebe2, Activity activity, zzm zzm2, DialogInterface object, int n) {
        object = new HashMap();
        object.put("dialog_action", "confirm");
        zzebe zzebe3 = zzebe2;
        zzebe3.zzw(zzebe3.zzf, "dialog_click", (Map)object);
        zzebe2.zzy(activity, zzm2);
    }

    public static /* synthetic */ void zzn(zzebe zzebe2, zzm zzm2, DialogInterface object) {
        zzebe2.zze.zzc(zzebe2.zzf);
        object = new HashMap();
        object.put("dialog_action", "dismiss");
        zzebe zzebe3 = zzebe2;
        zzebe3.zzw(zzebe3.zzf, "dialog_click", (Map)object);
        if (zzm2 != null) {
            zzm2.zzb();
            return;
        }
    }

    @VisibleForTesting
    public zzebe(Context context, zzeat zzeat2, zzu zzu2, zzdre zzdre2) {
        this.zzb = context;
        this.zzc = zzdre2;
        this.zzd = zzu2;
        this.zze = zzeat2;
    }

    private final void zzw(String string2, String string3, Map map) {
        zzebe.zzp(this.zzb, this.zzc, this.zze, string2, string3, map);
    }

    public static void zzo(Context context, zzdre zzdre2, zzeat zzeat2, String string2, String string3) {
        zzebe.zzp(context, zzdre2, zzeat2, string2, string3, new HashMap());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static void zzp(Context object, zzdre object2, zzeat zzeat2, String string2, String object3, Map map) {
        object = true != zzv.zzp().zzA((Context)object) ? "offline" : "online";
        if (object2 != null) {
            void var5_7;
            object2 = ((zzdre)object2).zza();
            ((zzdrd)object2).zzb("gqi", string2);
            ((zzdrd)object2).zzb("action", (String)object3);
            ((zzdrd)object2).zzb("device_connectivity", (String)object);
            object = String.valueOf(zzv.zzC().currentTimeMillis());
            ((zzdrd)object2).zzb("event_timestamp", (String)object);
            for (Map.Entry entry : var5_7.entrySet()) {
                ((zzdrd)object2).zzb((String)entry.getKey(), (String)entry.getValue());
            }
            object = ((zzdrd)object2).zze();
        } else {
            object = "";
        }
        zzeat2.zzd(new zzeav(zzv.zzC().currentTimeMillis(), string2, (String)object, 2));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zze(Intent intent) {
        String string2;
        String string3;
        block9: {
            HashMap<String, String> hashMap;
            int n;
            string3 = intent.getStringExtra("offline_notification_action");
            if (string3 != null && (string3.equals("offline_notification_clicked") || string3.equals("offline_notification_dismissed"))) {
                string2 = intent.getStringExtra("gws_query_id");
                String string4 = intent.getStringExtra("uri");
                Context context = this.zzb;
                n = zzv.zzp().zzA(context);
                hashMap = new HashMap<String, String>();
                if (string3.equals("offline_notification_clicked")) {
                    hashMap.put("offline_notification_action", "offline_notification_clicked");
                    n = 1 != n ? 2 : 1;
                    string3 = String.valueOf(Build.VERSION.SDK_INT);
                    hashMap.put("obvs", string3);
                    string3 = String.valueOf(string4.startsWith("http"));
                    hashMap.put("olaih", string3);
                    string3 = context.getPackageManager().getLaunchIntentForPackage(string4);
                    if (string3 == null) {
                        Intent intent2 = new Intent("android.intent.action.VIEW");
                        intent2.setData(Uri.parse((String)string4));
                        string3 = intent2;
                    }
                    string3.addFlags(0x10000000);
                    context.startActivity((Intent)string3);
                    hashMap.put("olaa", "olas");
                } else {
                    hashMap.put("offline_notification_action", "offline_notification_dismissed");
                    n = 2;
                }
            } else {
                return;
                catch (ActivityNotFoundException activityNotFoundException) {
                    hashMap.put("olaa", "olaf");
                }
            }
            this.zzw(string2, "offline_notification_action", hashMap);
            try {
                string3 = this.zze.getWritableDatabase();
                if (n != 1) break block9;
                this.zze.zzg((SQLiteDatabase)string3, this.zzd, string2);
                return;
            }
            catch (SQLiteException sQLiteException) {
                zzo.zzg((String)"Failed to get writable offline buffering database: ".concat(((Object)((Object)sQLiteException)).toString()));
                return;
            }
        }
        zzeat.zzi((SQLiteDatabase)string3, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzf(String[] activity, int[] nArray, IObjectWrapper object) {
        int n = 0;
        while (true) {
            if (n >= ((Activity)activity).length) {
                return;
            }
            if (activity[n].equals("android.permission.POST_NOTIFICATIONS")) break;
            ++n;
        }
        zzebg zzebg2 = (zzebg)ObjectWrapper.unwrap((IObjectWrapper)object);
        activity = zzebg2.zza();
        object = zzebg2.zzb();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (nArray[n] == 0) {
            hashMap.put("dialog_action", "confirm");
            this.zzx();
            this.zzz(activity, (zzm)object);
        } else {
            hashMap.put("dialog_action", "dismiss");
            if (object != null) {
                ((zzm)object).zzb();
            }
        }
        zzebe zzebe2 = this;
        zzebe2.zzw(zzebe2.zzf, "asnpdc", hashMap);
    }

    public final void zzg(IObjectWrapper iObjectWrapper) {
        zzebe zzebe2 = this;
        zzebg zzebg2 = (zzebg)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        iObjectWrapper = zzebg2.zza();
        zzm zzm2 = zzebg2.zzb();
        zzebe2.zzf = zzebg2.zzc();
        zzebe2.zzg = zzebg2.zzd();
        zzbbz zzbbz2 = zzbci.zziA;
        if (!((Boolean)zzbd.zzc().zzb(zzbbz2)).booleanValue()) {
            zzebe zzebe3 = this;
            zzebe3.zzw(zzebe3.zzf, "dialog_impression", zzfwz.zzd());
            zzv.zzq();
            AlertDialog.Builder builder = zzs.zzL((Context)iObjectWrapper);
            builder.setTitle((CharSequence)zzebe.zzv(R.string.offline_opt_in_title, "Open ad when you're back online.")).setMessage((CharSequence)zzebe.zzv(R.string.offline_opt_in_message, "We'll send you a notification with a link to the advertiser site.")).setPositiveButton((CharSequence)zzebe.zzv(R.string.offline_opt_in_confirm, "OK"), (DialogInterface.OnClickListener)new zzeba(this, (Activity)iObjectWrapper, zzm2)).setNegativeButton((CharSequence)zzebe.zzv(R.string.offline_opt_in_decline, "No thanks"), (DialogInterface.OnClickListener)new zzebb(this, zzm2)).setOnCancelListener((DialogInterface.OnCancelListener)new zzebc(this, zzm2));
            builder.create().show();
            return;
        }
        this.zzy((Activity)iObjectWrapper, zzm2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzx() {
        boolean bl;
        block5: {
            zzv.zzq();
            Context context = this.zzb;
            zzbr zzbr2 = zzs.zzA(context);
            IObjectWrapper iObjectWrapper = ObjectWrapper.wrap((Object)context);
            String string2 = this.zzg;
            String string3 = this.zzf;
            Object object = this.zza;
            object = (zzeal)object.get(string3);
            object = object == null ? "" : ((zzeal)object).zzc();
            zza zza2 = new zza(string2, string3, (String)object);
            bl = zzbr2.zzg(iObjectWrapper, zza2);
            if (bl) return;
            bl = zzbr2.zzf(ObjectWrapper.wrap((Object)context), this.zzg, this.zzf);
            break block5;
            catch (RemoteException remoteException) {
                RemoteException remoteException2;
                boolean bl2;
                block6: {
                    bl2 = false;
                    break block6;
                    catch (RemoteException remoteException3) {
                        remoteException2 = remoteException3;
                        bl2 = bl;
                    }
                }
                zzo.zzh((String)"Failed to schedule offline notification poster.", (Throwable)remoteException2);
                bl = bl2;
            }
        }
        if (bl) return;
        this.zze.zzc(this.zzf);
        zzebe zzebe2 = this;
        zzebe2.zzw(zzebe2.zzf, "offline_notification_worker_not_scheduled", zzfwz.zzd());
    }

    private final void zzy(Activity activity, @Nullable zzm object) {
        zzv.zzq();
        if (!NotificationManagerCompat.from((Context)activity).areNotificationsEnabled()) {
            if (Build.VERSION.SDK_INT < 33) {
                zzv.zzq();
                AlertDialog.Builder builder = zzs.zzL((Context)activity);
                builder.setTitle((CharSequence)zzebe.zzv(R.string.notifications_permission_title, "Allow app to send you notifications?")).setPositiveButton((CharSequence)zzebe.zzv(R.string.notifications_permission_confirm, "Allow"), (DialogInterface.OnClickListener)new zzeax(this, activity, (zzm)object)).setNegativeButton((CharSequence)zzebe.zzv(R.string.notifications_permission_decline, "Don't allow"), (DialogInterface.OnClickListener)new zzeay(this, (zzm)object)).setOnCancelListener((DialogInterface.OnCancelListener)new zzeaz(this, (zzm)object));
                builder.create().show();
                zzebe zzebe2 = this;
                zzebe2.zzw(zzebe2.zzf, "rtsdi", zzfwz.zzd());
                return;
            }
            object = "android.permission.POST_NOTIFICATIONS";
            activity.requestPermissions(new String[]{object}, 12345);
            zzebe zzebe3 = this;
            zzebe3.zzw(zzebe3.zzf, "asnpdi", zzfwz.zzd());
            return;
        }
        this.zzx();
        this.zzz(activity, (zzm)object);
    }

    public final void zzh() {
        zzeam zzeam2 = new zzeam(this.zzd);
        this.zze.zze(zzeam2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzq(String string2, zzdhq zzdhq2) {
        String string3;
        String string4;
        block10: {
            string4 = zzdhq2.zzx();
            string3 = zzdhq2.zzB();
            if (TextUtils.isEmpty((CharSequence)string4)) {
                string4 = string3 != null ? string3 : "";
            }
            if ((string3 = zzdhq2.zzm()) == null) {
                string3 = "";
            } else {
                try {
                    string3 = string3.zze().toString();
                }
                catch (RemoteException remoteException) {
                    string3 = "";
                }
            }
            if ((zzdhq2 = zzdhq2.zzn()) == null) {
                zzdhq2 = null;
            } else {
                try {
                    zzdhq2 = zzdhq2.zzf();
                    if (zzdhq2 != null) {
                        zzdhq2 = (Drawable)ObjectWrapper.unwrap((IObjectWrapper)zzdhq2);
                        break block10;
                    }
                    zzdhq2 = null;
                }
                catch (RemoteException remoteException) {
                    zzdhq2 = null;
                }
            }
        }
        zzeah zzeah2 = new zzeah(string4, string3, (Drawable)zzdhq2);
        this.zza.put(string2, zzeah2);
    }

    public final void zzi(IObjectWrapper iObjectWrapper, String string2, String string3) {
        String string4 = "";
        this.zzj(iObjectWrapper, new zza(string2, string3, string4));
    }

    private final void zzz(Activity activity, @Nullable zzm zzm2) {
        activity = this.zzs(activity, zzm2);
        activity.show();
        Timer timer = new Timer();
        timer.schedule((TimerTask)new zzebd(this, (AlertDialog)activity, timer, zzm2), 3000L);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzj(IObjectWrapper object, zza object2) {
        void var1_10;
        void var1_7;
        NotificationCompat.Builder builder;
        String string2;
        HashMap<String, String> hashMap;
        Context context;
        block13: {
            context = (Context)ObjectWrapper.unwrap((IObjectWrapper)object);
            String string3 = "offline_notification_channel";
            String string4 = "AdMob Offline Notifications";
            String string5 = ((zza)hashMap).zza;
            string2 = ((zza)hashMap).zzb;
            hashMap = ((zza)hashMap).zzc;
            String string6 = this.zzu();
            zzv.zzr().zzh(context, string3, string4);
            PendingIntent pendingIntent = zzebe.zzr(context, "offline_notification_clicked", string2, string5);
            string4 = zzebe.zzr(context, "offline_notification_dismissed", string2, string5);
            string5 = "offline_notification_channel";
            builder = new NotificationCompat.Builder(context, string5);
            if (!TextUtils.isEmpty((CharSequence)string6)) {
                builder.setContentTitle((CharSequence)String.format(zzebe.zzv(R.string.offline_notification_title_with_advertiser, "You are back online! Continue learning about %s"), string6));
            } else {
                builder.setContentTitle((CharSequence)zzebe.zzv(R.string.offline_notification_title, "You are back online! Let's pick up where we left off"));
            }
            zzbbz zzbbz2 = zzbci.zziB;
            builder.setAutoCancel(true).setDeleteIntent((PendingIntent)string4).setContentIntent(pendingIntent).setSmallIcon(context.getApplicationInfo().icon).setPriority(((Integer)zzbd.zzc().zzb(zzbbz2)).intValue());
            zzbbz zzbbz3 = zzbci.zziD;
            if (((Boolean)zzbd.zzc().zzb(zzbbz3)).booleanValue()) {
                if (!((String)((Object)hashMap)).isEmpty()) {
                    Bitmap bitmap = BitmapFactory.decodeStream((InputStream)new URL((String)((Object)hashMap)).openConnection().getInputStream());
                } else {
                    Object var1_11 = null;
                }
            } else {
                Object var1_12 = null;
            }
            break block13;
            catch (IOException iOException) {
                Object var1_13 = null;
            }
        }
        if (var1_7 != null) {
            try {
                builder.setLargeIcon((Bitmap)var1_7).setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture((Bitmap)var1_7).bigLargeIcon((Bitmap)null));
            }
            catch (Resources.NotFoundException notFoundException) {}
        }
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        hashMap = new HashMap<String, String>();
        try {
            notificationManager.notify(string2, 54321, builder.build());
            String string7 = "offline_notification_impression";
        }
        catch (IllegalArgumentException illegalArgumentException) {
            hashMap.put("notification_not_shown_reason", illegalArgumentException.getMessage());
            String string8 = "offline_notification_failed";
        }
        this.zzw(string2, (String)var1_10, hashMap);
    }

    @VisibleForTesting
    public static final PendingIntent zzr(Context context, String string2, String string3, String string4) {
        Intent intent = new Intent();
        intent.setAction(string2);
        intent.putExtra("offline_notification_action", string2);
        intent.putExtra("gws_query_id", string3);
        intent.putExtra("uri", string4);
        if (Build.VERSION.SDK_INT >= 29 && string2.equals("offline_notification_clicked")) {
            intent.setClassName(context, "com.google.android.gms.ads.NotificationHandlerActivity");
            return zzfqt.zza(context, 0, intent, 0xC000000);
        }
        intent.setClassName(context, "com.google.android.gms.ads.AdService");
        return zzfqt.zzb(context, 0, intent, 0x44000000, 0);
    }
}

