/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.SuppressLint;
import android.app.UiModeManager;
import android.content.Context;
import android.graphics.Point;
import android.hardware.display.DisplayManager;
import android.media.AudioFormat;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.ads.zzdc;
import com.google.android.gms.internal.ads.zzdx;
import com.google.android.gms.internal.ads.zzdy;
import com.google.android.gms.internal.ads.zzek;
import com.google.android.gms.internal.ads.zzes;
import com.google.android.gms.internal.ads.zzftc;
import com.google.android.gms.internal.ads.zzfzp;
import com.google.android.gms.internal.ads.zzfzu;
import com.google.android.gms.internal.ads.zzx;
import com.google.android.gms.internal.ads.zzz;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public final class zzeu {
    public static final int zza = Build.VERSION.SDK_INT;
    public static final String zzb;
    public static final byte[] zzc;
    private static final Pattern zzd;
    @Nullable
    private static HashMap zze;
    private static final String[] zzf;
    private static final String[] zzg;
    private static final int[] zzh;
    private static final int[] zzi;
    private static final int[] zzj;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int zza(long[] lArray, long l, boolean bl, boolean n) {
        n = Arrays.binarySearch(lArray, l);
        if (n < 0) {
            return ~n;
        }
        while (++n < lArray.length && lArray[n] == l) {
        }
        if (bl) return n + -1;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int zzb(zzdy zzdy2, long l, boolean n, boolean n2) {
        n = 0;
        n2 = zzdy2.zza() + -1;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            if (zzdy2.zzb(n3) < l) {
                n = n3 + 1;
                continue;
            }
            n2 = n3 + -1;
        }
        n = n2 + 1;
        if (n < zzdy2.zza() && zzdy2.zzb(n) == l) {
            return n;
        }
        if (n2 != -1) return n2;
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int zzc(int[] nArray, int n, boolean bl, boolean bl2) {
        int n2;
        int n3 = Arrays.binarySearch(nArray, n);
        if (n3 < 0) {
            n2 = -(n3 + 2);
        } else {
            while (--n3 >= 0 && nArray[n3] == n) {
            }
            n2 = bl ? n3 + 1 : n3;
        }
        if (bl2) {
            return Math.max(0, n2);
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int zzd(long[] lArray, long l, boolean n, boolean bl) {
        int n2;
        n = Arrays.binarySearch(lArray, l);
        if (n < 0) {
            n2 = -(n + 2);
        } else {
            while (--n >= 0 && lArray[n] == l) {
            }
            n2 = n + 1;
        }
        if (bl) {
            return Math.max(0, n2);
        }
        return n2;
    }

    public static int zze(byte[] byArray, int n, int n2, int n3) {
        n = 65535;
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = byArray[n3] & 0xFF;
            n = zzeu.zzR(n4 >> 4, n);
            n = zzeu.zzR(n4 & 0xF, n);
        }
        return n;
    }

    private static int zzR(int n, int n2) {
        n = zzi[n2 >> 12 ^ n];
        return (char)((char)(n2 << 4) ^ n);
    }

    public static int zzf(byte[] byArray, int n, int n2, int n3) {
        while (n < n2) {
            int n4 = n3 << 8;
            n3 >>>= 24;
            n3 = n4 ^ zzh[n3 ^ byArray[n] & 0xFF];
            ++n;
        }
        return n3;
    }

    public static int zzg(byte[] byArray, int n, int n2, int n3) {
        int n4 = n;
        n = 0;
        for (n3 = v1093408; n3 < n2; ++n3) {
            n = zzj[n ^ byArray[n3] & 0xFF];
        }
        return n;
    }

    public static int zzh(int n) {
        switch (n) {
            default: {
                return Integer.MAX_VALUE;
            }
            case 30: {
                return 34;
            }
            case 22: {
                return 31;
            }
            case 20: {
                return 30;
            }
            case 14: {
                return 25;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return 28;
            }
            case 7: 
            case 8: {
                return 23;
            }
            case 4: 
            case 5: 
            case 6: {
                return 21;
            }
            case 2: 
            case 3: 
        }
        return 3;
    }

    /*
     * Unable to fully structure code
     */
    @SuppressLint(value={"InlinedApi"})
    public static int zzi(int var0) {
        switch (var0) {
            case 24: {
                var0 = 0x3FFFFFC;
                var1_1 = 0;
lbl5:
                // 2 sources

                while (true) {
                    if (zzeu.zza >= 32) {
                        return var0;
                    }
                    return var1_1;
                }
            }
            case 10: {
                var0 = 737532;
                var1_1 = 6396;
                ** continue;
            }
            default: {
                return 0;
            }
            case 12: {
                return 743676;
            }
            case 8: {
                return 6396;
            }
            case 7: {
                return 1276;
            }
            case 6: {
                return 252;
            }
            case 5: {
                return 220;
            }
            case 4: {
                return 204;
            }
            case 3: {
                return 28;
            }
            case 2: {
                return 12;
            }
            case 1: 
        }
        return 4;
    }

    public static int zzj(ByteBuffer byteBuffer, int n) {
        n = byteBuffer.getInt(n);
        if (byteBuffer.order() == ByteOrder.BIG_ENDIAN) {
            return n;
        }
        return Integer.reverseBytes(n);
    }

    public static int zzk(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException();
            }
            case 21: 
            case 0x50000000: {
                return 3;
            }
            case 4: 
            case 22: 
            case 0x60000000: {
                return 4;
            }
            case 3: {
                return 1;
            }
            case 2: 
            case 0x10000000: 
        }
        return 2;
    }

    public static int zzl(int n) {
        switch (n) {
            default: {
                return 6006;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return 6002;
            }
            case 10: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                return 6004;
            }
            case 8: 
            case 15: {
                return 6003;
            }
            case 2: 
            case 4: 
            case 7: 
            case 16: 
            case 18: 
        }
        return 6005;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static int zzm(@Nullable String var0) {
        block9: {
            block7: {
                block8: {
                    if (var0 == null) {
                        return 0;
                    }
                    var1_2 = ((String[])(var0 = var0.split("_", -1))).length;
                    if (var1_2 < 2) {
                        return 0;
                    }
                    var2_3 = var0[var1_2 + -1];
                    if (var1_2 < 3) break block7;
                    if (!"neg".equals(var0 = var0[var1_2 + -2])) break block8;
                    var0_1 = true;
lbl10:
                    // 3 sources

                    while (var2_3 != null) {
                        block6: {
                            var1_2 = Integer.parseInt(var2_3);
                            if (!var0_1) break block6;
                            return -var1_2;
                        }
                        return var1_2;
                    }
                    break block9;
                }
                var0_1 = false;
                ** GOTO lbl10
            }
            var0_1 = false;
            ** GOTO lbl10
        }
        try {
            throw null;
        }
        catch (NumberFormatException v0) {
            return 0;
        }
    }

    public static int zzn(int n) {
        switch (n) {
            default: {
                return 0;
            }
            case 32: {
                return 22;
            }
            case 24: {
                return 21;
            }
            case 16: {
                return 2;
            }
            case 8: 
        }
        return 3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int zzo(Uri object) {
        block16: {
            int n;
            block17: {
                String string2 = object.getScheme();
                if (string2 != null && zzftc.zzc((CharSequence)"rtsp", (CharSequence)string2)) {
                    return 3;
                }
                string2 = object.getLastPathSegment();
                if (string2 == null) {
                    return 4;
                }
                int n2 = string2.lastIndexOf(46);
                if (n2 < 0) break block16;
                string2 = zzftc.zza((String)string2.substring(n2 + 1));
                switch (string2.hashCode()) {
                    case 3299913: {
                        if (!string2.equals("m3u8")) break;
                        n = 1;
                        break block17;
                    }
                    case 3242057: {
                        if (!string2.equals("isml")) break;
                        n = 3;
                        break block17;
                    }
                    case 108321: {
                        if (!string2.equals("mpd")) break;
                        n = 0;
                        break block17;
                    }
                    case 104579: {
                        if (!string2.equals("ism")) break;
                        n = 2;
                        break block17;
                    }
                }
                n = -1;
            }
            switch (n) {
                default: {
                    n = 4;
                    break;
                }
                case 2: 
                case 3: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 0: {
                    return 0;
                }
            }
            if (n != 4) {
                return n;
            }
        }
        Pattern pattern = zzd;
        if ((object = object.getPath()) == null) throw null;
        if (!((Matcher)(object = pattern.matcher((CharSequence)object))).matches()) {
            return 4;
        }
        if ((object = ((Matcher)object).group(2)) == null) return 1;
        if (((String)object).contains("format=mpd-time-csf")) {
            return 0;
        }
        if (!((String)object).contains("format=m3u8-aapl")) return 1;
        return 2;
    }

    public static long zzp(long l, int n) {
        RoundingMode roundingMode = RoundingMode.UP;
        return zzeu.zzu(l, n, 1000000L, roundingMode);
    }

    public static long zzq(long l, float f) {
        if (f == 1.0f) {
            return l;
        }
        return Math.round((double)l * (double)f);
    }

    public static long zzr(long l, float f) {
        if (f == 1.0f) {
            return l;
        }
        return Math.round((double)l / (double)f);
    }

    public static long zzs(long l) {
        if (l == -9223372036854775807L || l == Long.MIN_VALUE) {
            return l;
        }
        return l * 1000L;
    }

    public static long zzt(long l, int n) {
        return zzeu.zzu(l, 1000000L, n, RoundingMode.DOWN);
    }

    public static long zzu(long l, long l2, long l3, RoundingMode roundingMode) {
        if (l == 0L || l2 == 0L) {
            return 0L;
        }
        if (l3 < l2 || l3 % l2 != 0L) {
            if (l3 >= l2 || l2 % l3 != 0L) {
                if (l3 < l || l3 % l != 0L) {
                    if (l3 < l && l % l3 == 0L) {
                        return zzfzu.zzd(l2, zzfzu.zzb(l, l3, RoundingMode.UNNECESSARY));
                    }
                    return zzeu.zzS(l, l2, l3, roundingMode);
                }
                return zzfzu.zzb(l2, zzfzu.zzb(l3, l, RoundingMode.UNNECESSARY), roundingMode);
            }
            return zzfzu.zzd(l, zzfzu.zzb(l2, l3, RoundingMode.UNNECESSARY));
        }
        return zzfzu.zzb(l, zzfzu.zzb(l3, l2, RoundingMode.UNNECESSARY), roundingMode);
    }

    private static long zzS(long l, long l2, long l3, RoundingMode roundingMode) {
        long l4 = zzfzu.zzd(l, l2);
        if (l4 == Long.MAX_VALUE || l4 == Long.MIN_VALUE) {
            l4 = zzfzu.zzc(Math.abs(l2), Math.abs(l3));
            long l5 = zzfzu.zzb(l2, l4, RoundingMode.UNNECESSARY);
            l2 = zzfzu.zzb(l3, l4, RoundingMode.UNNECESSARY);
            l3 = zzfzu.zzc(Math.abs(l), Math.abs(l2));
            long l6 = zzfzu.zzb(l, l3, RoundingMode.UNNECESSARY);
            l = zzfzu.zzb(l2, l3, RoundingMode.UNNECESSARY);
            long l7 = zzfzu.zzd(l6, l5);
            if (l7 == Long.MAX_VALUE || l7 == Long.MIN_VALUE) {
                double d = l5;
                double d2 = l;
                if ((d2 = (double)l6 * (d / d2)) > 9.223372036854776E18) {
                    return Long.MAX_VALUE;
                }
                if (d2 < -9.223372036854776E18) {
                    return Long.MIN_VALUE;
                }
                return zzfzp.zzb(d2, roundingMode);
            }
            return zzfzu.zzb(l7, l, roundingMode);
        }
        return zzfzu.zzb(l4, l3, roundingMode);
    }

    public static long zzv(long l) {
        if (l == -9223372036854775807L || l == Long.MIN_VALUE) {
            return l;
        }
        return l / 1000L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Point zzw(Context context) {
        Object object = (DisplayManager)context.getSystemService("display");
        object = object != null ? object.getDisplay(0) : null;
        if (object == null) {
            object = (WindowManager)context.getSystemService("window");
            if (object == null) throw null;
            object = ((WindowManager)object).getDefaultDisplay();
        }
        if (object.getDisplayId() == 0 && zzeu.zzN(context)) {
            String string2 = zza < 28 ? zzeu.zzT("sys.display-size") : zzeu.zzT("vendor.display-size");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                try {
                    String[] stringArray = string2.trim();
                    String string3 = "x";
                    stringArray = stringArray.split(string3, -1);
                    int n = stringArray.length;
                    if (n == 2) {
                        n = Integer.parseInt(stringArray[0]);
                        int n2 = Integer.parseInt(stringArray[1]);
                        if (n > 0 && n2 > 0) {
                            Point point = new Point(n, n2);
                            return point;
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                string2 = String.valueOf(string2);
                String string4 = "Invalid display size: ";
                zzdx.zzc("Util", string4.concat(string2));
            }
            if ("Sony".equals(Build.MANUFACTURER) && Build.MODEL.startsWith("BRAVIA") && context.getPackageManager().hasSystemFeature("com.sony.dtv.hardware.panel.qfhd")) {
                return new Point(3840, 2160);
            }
        }
        Display.Mode mode = object.getMode();
        new Point().x = mode.getPhysicalWidth();
        new Point().y = mode.getPhysicalHeight();
        return new Point();
    }

    public static AudioFormat zzx(int n, int n2, int n3) {
        return new AudioFormat.Builder().setSampleRate(n).setChannelMask(n2).setEncoding(n3).build();
    }

    public static Handler zzy(@Nullable Handler.Callback callback) {
        Looper looper = Looper.myLooper();
        zzdc.zzb(looper);
        callback = looper;
        return new Handler((Looper)callback, null);
    }

    public static Looper zzz() {
        Looper looper = Looper.myLooper();
        if (looper != null) {
            return looper;
        }
        return Looper.getMainLooper();
    }

    public static zzz zzA(int n, int n2, int n3) {
        zzx zzx2 = new zzx();
        zzx2.zzad("audio/raw");
        zzx2.zzB(n2);
        zzx2.zzae(n3);
        zzx2.zzX(n);
        return zzx2.zzaj();
    }

    public static String zzB(byte[] byArray) {
        return new String(byArray, StandardCharsets.UTF_8);
    }

    public static String zzC(byte[] byArray, int n, int n2) {
        return new String(byArray, n, n2, StandardCharsets.UTF_8);
    }

    @Nullable
    private static String zzT(String string2) {
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            string2 = (String)clazz.getMethod("get", String.class).invoke(clazz, string2);
            return string2;
        }
        catch (Exception exception) {
            string2 = "Failed to read system property ".concat(string2);
            zzdx.zzd("Util", string2, exception);
            return null;
        }
    }

    public static String zzD(int n) {
        switch (n) {
            default: {
                return "camera motion";
            }
            case -2: {
                return "none";
            }
            case 5: {
                return "metadata";
            }
            case 4: {
                return "image";
            }
            case 3: {
                return "text";
            }
            case 2: {
                return "video";
            }
            case 1: {
                return "audio";
            }
            case 0: {
                return "default";
            }
            case -1: 
        }
        return "unknown";
    }

    public static String zzE(String string2) {
        block8: {
            String[] stringArray;
            if (string2 == null) {
                return null;
            }
            String[] stringArray2 = string2.replace('_', '-');
            if (!stringArray2.isEmpty() && !stringArray2.equals("und")) {
                string2 = stringArray2;
            }
            string2 = zzftc.zza((String)string2);
            stringArray2 = string2.split("-", 2)[0];
            if (zze == null) {
                zze = zzeu.zzU();
            }
            if ((stringArray = (String[])zze.get(stringArray2)) != null) {
                string2 = stringArray.concat(String.valueOf(string2.substring(stringArray2.length())));
                stringArray2 = stringArray;
            }
            if (!"no".equals(stringArray2) && !"i".equals(stringArray2) && !"zh".equals(stringArray2)) break block8;
            int n = 0;
            while (true) {
                block10: {
                    block9: {
                        stringArray = zzg;
                        int cfr_ignored_0 = stringArray.length;
                        if (n >= 18) break block9;
                        if (!string2.startsWith(stringArray[n])) break block10;
                        string2 = string2.substring(stringArray[n].length());
                        string2 = String.valueOf(stringArray[n + 1]).concat(String.valueOf(string2));
                    }
                    return string2;
                }
                n += 2;
            }
        }
        return string2;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static HashMap zzU() {
        String[] stringArray = Locale.getISOLanguages();
        int n = stringArray.length;
        int cfr_ignored_0 = zzf.length;
        HashMap<String, String> hashMap = new HashMap<String, String>(n + 88);
        int n2 = 0;
        while (true) {
            block7: {
                if (n2 < n) {
                    String string2 = stringArray[n2];
                    String string3 = new Locale(string2).getISO3Language();
                    boolean bl = TextUtils.isEmpty((CharSequence)string3);
                    if (!bl) {
                        hashMap.put(string3, string2);
                    }
                    break block7;
                }
                n2 = 0;
                while (true) {
                    stringArray = zzf;
                    int cfr_ignored_1 = stringArray.length;
                    if (n2 >= 88) {
                        return hashMap;
                    }
                    hashMap.put(stringArray[n2], stringArray[n2 + 1]);
                    n2 += 2;
                }
                catch (MissingResourceException missingResourceException) {}
            }
            ++n2;
        }
    }

    public static ExecutorService zzF(String string2) {
        return Executors.newSingleThreadExecutor(new zzes(string2));
    }

    static {
        String string2 = Build.DEVICE;
        String string3 = Build.MODEL;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(", ");
        stringBuilder.append(string3);
        stringBuilder.append(", ");
        stringBuilder.append(Build.MANUFACTURER);
        stringBuilder.append(", ");
        stringBuilder.append(zza);
        zzb = stringBuilder.toString();
        zzc = new byte[0];
        zzd = Pattern.compile("(?:.*\\.)?isml?(?:/(manifest(.*))?)?", 2);
        string2 = "alb";
        zzf = new String[]{string2, "sq", "arm", "hy", "baq", "eu", "bur", "my", "tib", "bo", "chi", "zh", "cze", "cs", "dut", "nl", "ger", "de", "gre", "el", "fre", "fr", "geo", "ka", "ice", "is", "mac", "mk", "mao", "mi", "may", "ms", "per", "fa", "rum", "ro", "scc", "hbs-srp", "slo", "sk", "wel", "cy", "id", "ms-ind", "iw", "he", "heb", "he", "ji", "yi", "arb", "ar-arb", "in", "ms-ind", "ind", "ms-ind", "nb", "no-nob", "nob", "no-nob", "nn", "no-nno", "nno", "no-nno", "tw", "ak-twi", "twi", "ak-twi", "bs", "hbs-bos", "bos", "hbs-bos", "hr", "hbs-hrv", "hrv", "hbs-hrv", "sr", "hbs-srp", "srp", "hbs-srp", "cmn", "zh-cmn", "hak", "zh-hak", "nan", "zh-nan", "hsn", "zh-hsn"};
        zzg = new String[]{"i-lux", "lb", "i-hak", "zh-hak", "i-navajo", "nv", "no-bok", "no-nob", "no-nyn", "no-nno", "zh-guoyu", "zh-cmn", "zh-hakka", "zh-hak", "zh-min-nan", "zh-nan", "zh-xiang", "zh-hsn"};
        zzh = new int[]{0, 79764919, 159529838, 222504665, 319059676, 398814059, 445009330, 507990021, 638119352, 583659535, 797628118, 726387553, 890018660, 835552979, 1015980042, 944750013, 1276238704, 1221641927, 1167319070, 1095957929, 1595256236, 1540665371, 1452775106, 1381403509, 1780037320, 1859660671, 1671105958, 1733955601, 2031960084, 2111593891, 1889500026, 1952343757, -1742489888, -1662866601, -1851683442, -1788833735, -1960329156, -1880695413, -2103051438, -2040207643, -1104454824, -1159051537, -1213636554, -1284997759, -1389417084, -1444007885, -1532160278, -1603531939, -734892656, -789352409, -575645954, -646886583, -952755380, -1007220997, -827056094, -898286187, -231047128, -151282273, -71779514, -8804623, -515967244, -436212925, -390279782, -327299027, 881225847, 809987520, 1023691545, 969234094, 662832811, 591600412, 771767749, 717299826, 311336399, 374308984, 453813921, 533576470, 25881363, 88864420, 134795389, 214552010, 2023205639, 2086057648, 1897238633, 1976864222, 1804852699, 1867694188, 1645340341, 1724971778, 1587496639, 1516133128, 1461550545, 1406951526, 1302016099, 1230646740, 1142491917, 1087903418, -1398421865, -1469785312, -1524105735, -1578704818, -1079922613, -1151291908, -1239184603, -1293773166, -1968362705, -1905510760, -2094067647, -2014441994, -1716953613, -1654112188, -1876203875, -1796572374, -525066777, -462094256, -382327159, -302564546, -206542021, -143559028, -97365931, -17609246, -960696225, -1031934488, -817968335, -872425850, -709327229, -780559564, -600130067, -654598054, 1762451694, 1842216281, 1619975040, 1682949687, 2047383090, 2127137669, 1938468188, 2001449195, 1325665622, 1271206113, 1183200824, 1111960463, 1543535498, 1489069629, 1434599652, 1363369299, 622672798, 568075817, 748617968, 677256519, 907627842, 853037301, 1067152940, 995781531, 51762726, 131386257, 177728840, 240578815, 269590778, 349224269, 429104020, 491947555, -248556018, -168932423, -122852000, -60002089, -500490030, -420856475, -341238852, -278395381, -685261898, -739858943, -559578920, -630940305, -1004286614, -1058877219, -845023740, -916395085, -1119974018, -1174433591, -1262701040, -1333941337, -1371866206, -1426332139, -1481064244, -1552294533, -1690935098, -1611170447, -1833673816, -1770699233, -2009983462, -1930228819, -2119160460, -2056179517, 1569362073, 1498123566, 1409854455, 1355396672, 1317987909, 1246755826, 1192025387, 1137557660, 2072149281, 2135122070, 1912620623, 1992383480, 1753615357, 1816598090, 1627664531, 1707420964, 295390185, 358241886, 404320391, 483945776, 43990325, 106832002, 186451547, 266083308, 932423249, 861060070, 1041341759, 986742920, 613929101, 542559546, 756411363, 701822548, -978770311, -1050133554, -869589737, -924188512, -693284699, -764654318, -550540341, -605129092, -475935807, -413084042, -366743377, -287118056, -257573603, -194731862, -114850189, -35218492, -1984365303, -1921392450, -2143631769, -2063868976, -1698919467, -1635936670, -1824608069, -1744851700, -1347415887, -1418654458, -1506661409, -1561119128, -1129027987, -1200260134, -1254728445, -1309196108};
        zzi = new int[]{0, 4129, 8258, 12387, 16516, 20645, 24774, 28903, 33032, 37161, 41290, 45419, 49548, 53677, 57806, 61935};
        zzj = new int[]{0, 7, 14, 9, 28, 27, 18, 21, 56, 63, 54, 49, 36, 35, 42, 45, 112, 119, 126, 121, 108, 107, 98, 101, 72, 79, 70, 65, 84, 83, 90, 93, 224, 231, 238, 233, 252, 251, 242, 245, 216, 223, 214, 209, 196, 195, 202, 205, 144, 151, 158, 153, 140, 139, 130, 133, 168, 175, 166, 161, 180, 179, 186, 189, 199, 192, 201, 206, 219, 220, 213, 210, 255, 248, 241, 246, 227, 228, 237, 234, 183, 176, 185, 190, 171, 172, 165, 162, 143, 136, 129, 134, 147, 148, 157, 154, 39, 32, 41, 46, 59, 60, 53, 50, 31, 24, 17, 22, 3, 4, 13, 10, 87, 80, 89, 94, 75, 76, 69, 66, 111, 104, 97, 102, 115, 116, 125, 122, 137, 142, 135, 128, 149, 146, 155, 156, 177, 182, 191, 184, 173, 170, 163, 164, 249, 254, 247, 240, 229, 226, 235, 236, 193, 198, 207, 200, 221, 218, 211, 212, 105, 110, 103, 96, 117, 114, 123, 124, 81, 86, 95, 88, 77, 74, 67, 68, 25, 30, 23, 16, 5, 2, 11, 12, 33, 38, 47, 40, 61, 58, 51, 52, 78, 73, 64, 71, 82, 85, 92, 91, 118, 113, 120, 127, 106, 109, 100, 99, 62, 57, 48, 55, 34, 37, 44, 43, 6, 1, 8, 15, 26, 29, 20, 19, 174, 169, 160, 167, 178, 181, 188, 187, 150, 145, 152, 159, 138, 141, 132, 131, 222, 217, 208, 215, 194, 197, 204, 203, 230, 225, 232, 239, 250, 253, 244, 243};
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void zzG(long[] lArray, long l, long l2) {
        int n;
        RoundingMode roundingMode = RoundingMode.DOWN;
        if (l2 >= 1000000L && l2 % 1000000L == 0L) {
            long l3 = zzfzu.zzb(l2, 1000000L, RoundingMode.UNNECESSARY);
            int n2 = 0;
            while (n2 < lArray.length) {
                int n3 = n2++;
                lArray[n3] = zzfzu.zzb(lArray[n3], l3, roundingMode);
            }
            return;
        }
        if (l2 < 1000000L) {
            if (1000000L % l2 == 0L) {
                long l4 = zzfzu.zzb(1000000L, l2, RoundingMode.UNNECESSARY);
                int n4 = 0;
                while (n4 < lArray.length) {
                    int n5 = n4++;
                    lArray[n5] = zzfzu.zzd(lArray[n5], l4);
                }
                return;
            }
            n = 0;
        } else {
            n = 0;
        }
        while (n < lArray.length) {
            long l5 = lArray[n];
            if (l5 != 0L) {
                lArray[n] = l2 >= l5 && l2 % l5 == 0L ? zzfzu.zzb(1000000L, zzfzu.zzb(l2, l5, RoundingMode.UNNECESSARY), roundingMode) : (l2 < l5 && l5 % l2 == 0L ? zzfzu.zzd(1000000L, zzfzu.zzb(l5, l2, RoundingMode.UNNECESSARY)) : zzeu.zzS(l5, 1000000L, l2, roundingMode));
            }
            ++n;
        }
    }

    public static boolean zzH(SparseArray sparseArray, int n) {
        return sparseArray.indexOfKey(n) >= 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean zzI(zzek zzek2, zzek zzek3, @Nullable Inflater inflater) {
        int n;
        block10: {
            if (zzek2.zza() == 0) {
                return false;
            }
            if (zzek3.zzb() < zzek2.zza()) {
                int n2 = zzek2.zza();
                zzek3.zzF(n2 + n2);
            }
            if (inflater == null) {
                inflater = new Inflater();
            }
            inflater.setInput(zzek2.zzN(), zzek2.zzc(), zzek2.zza());
            n = 0;
            try {
                while (true) {
                    int n3 = n;
                    n += inflater.inflate(zzek3.zzN(), n3, zzek3.zzb() - n3);
                    int n4 = inflater.finished();
                    if (n4 != 0) {
                        zzek3.zzK(n);
                        n = 1;
                        break block10;
                    }
                    n4 = inflater.needsDictionary();
                    if (n4 != 0) break;
                    n4 = inflater.needsInput();
                    if (n4 != 0) {
                        n = 0;
                        break block10;
                    }
                    n4 = zzek3.zzb();
                    if (n != n4) continue;
                    zzek zzek4 = zzek3;
                    int n5 = zzek4.zzb();
                    zzek4.zzF(n5 + n5);
                }
                n = 0;
            }
            catch (Throwable throwable) {
                inflater.reset();
                throw throwable;
            }
            catch (DataFormatException dataFormatException) {
                n = 0;
            }
        }
        inflater.reset();
        return n != 0;
    }

    public static boolean zzJ(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.type.automotive");
    }

    public static boolean zzK(int n) {
        return n == 3 || n == 2 || n == 0x10000000 || n == 21 || n == 0x50000000 || n == 22 || n == 0x60000000 || n == 4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean zzL(Context context) {
        int n = zza;
        if (n < 29) return true;
        if (context.getApplicationInfo().targetSdkVersion < 29) return true;
        if (n == 30) {
            if (zzftc.zzc((CharSequence)Build.MODEL, (CharSequence)"moto g(20)")) return true;
            if (!zzftc.zzc((CharSequence)Build.MODEL, (CharSequence)"rmx3231")) return false;
            return true;
        }
        if (n != 34) return false;
        if (!zzftc.zzc((CharSequence)Build.MODEL, (CharSequence)"sm-x200")) return false;
        return true;
    }

    public static boolean zzM(int n) {
        return n == 10 || n == 13;
    }

    public static boolean zzN(Context context) {
        return (context = (UiModeManager)context.getApplicationContext().getSystemService("uimode")) != null && context.getCurrentModeType() == 4;
    }

    public static boolean zzO(zzek zzek2, zzek zzek3, @Nullable Inflater inflater) {
        return zzek2.zza() > 0 && zzek2.zzf() == 120 && zzeu.zzI(zzek2, zzek3, inflater);
    }

    public static boolean zzP(Handler handler, Runnable runnable) {
        Looper looper = handler.getLooper();
        if (!looper.getThread().isAlive()) {
            return false;
        }
        if (looper == Looper.myLooper()) {
            runnable.run();
            return true;
        }
        return handler.post(runnable);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Object[] zzQ(Object[] objectArray, int n) {
        boolean bl = n <= objectArray.length;
        zzdc.zzd(bl);
        return Arrays.copyOf(objectArray, n);
    }
}

