/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzftw;
import com.google.android.gms.internal.ads.zzfun;
import com.google.android.gms.internal.ads.zzgah;
import com.google.android.gms.internal.ads.zzgbg;
import com.google.android.gms.internal.ads.zzgcl;
import com.google.android.gms.internal.ads.zzgcw;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class zzgag<V>
extends zzgah<V> {
    public Object get() throws InterruptedException, ExecutionException {
        return this.zzu();
    }

    public Object get(long l, TimeUnit timeUnit) throws InterruptedException, TimeoutException, ExecutionException {
        return this.zzv(l, timeUnit);
    }

    static Object zzh(Object object) throws ExecutionException {
        if (object instanceof zza) {
            CancellationException cancellationException = new CancellationException("Task was cancelled.");
            cancellationException.initCause(((zza)object).zzd);
            throw cancellationException;
        }
        if (object instanceof zzc) {
            object = ((zzc)object).zzb;
            throw new ExecutionException((Throwable)object);
        }
        if (object == zze) {
            return null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object zze(ListenableFuture object) {
        void var0_7;
        Object object2;
        block13: {
            boolean bl;
            if (object instanceof zze) {
                void var0_4;
                Object object3 = ((zzgag)object).zzw();
                if (!(object3 instanceof zza)) return Objects.requireNonNull(var0_4);
                zza zza2 = (zza)object3;
                if (!zza2.zzc) return Objects.requireNonNull(var0_4);
                Throwable throwable = zza2.zzd;
                if (throwable != null) {
                    zza zza3 = new zza(false, throwable);
                    return Objects.requireNonNull(var0_4);
                }
                zza zza4 = zza.zzb;
                return Objects.requireNonNull(var0_4);
            }
            if (object instanceof zzgcw) {
                Throwable throwable = ((zzgcw)object).zzi();
                if (throwable != null) return new zzc(throwable);
            }
            if ((zzg ^ true) & (bl = object.isCancelled())) {
                return Objects.requireNonNull(zza.zzb);
            }
            object2 = zzgag.zzf((Future)object);
            if (!bl) break block13;
            try {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("get() did not throw CancellationException, despite reporting isCancelled() == true: ");
                stringBuilder.append(String.valueOf(object));
                return new zza(false, new IllegalArgumentException(stringBuilder.toString()));
            }
            catch (ExecutionException executionException) {
                if (!bl) return new zzc(executionException.getCause());
                String string2 = String.valueOf(String.valueOf(object));
                return new zza(false, new IllegalArgumentException("get() did not throw CancellationException, despite reporting isCancelled() == true: ".concat(string2), executionException));
            }
            catch (CancellationException cancellationException) {
                if (bl) return new zza(false, cancellationException);
                String string3 = String.valueOf(String.valueOf(object));
                return new zzc(new IllegalArgumentException("get() threw CancellationException, despite reporting isCancelled() == false: ".concat(string3), cancellationException));
            }
            catch (Error | Exception throwable) {
                return new zzc(throwable);
            }
        }
        if (object2 == null) {
            Object object4 = zze;
            return var0_7;
        }
        Object object5 = object2;
        return var0_7;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object zzf(Future future) throws ExecutionException {
        boolean bl = false;
        while (true) {
            try {
                Object v = future.get();
                if (!bl) return v;
                Thread.currentThread().interrupt();
                return v;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    throw throwable;
                }
                Thread.currentThread().interrupt();
                throw throwable;
            }
            break;
        }
    }

    protected String zza() {
        if (object instanceof ScheduledFuture) {
            long l = ((ScheduledFuture)object).getDelay(TimeUnit.MILLISECONDS);
            Object object = new StringBuilder();
            ((StringBuilder)object).append("remaining delay=[");
            ((StringBuilder)object).append(l);
            ((StringBuilder)object).append(" ms]");
            return ((StringBuilder)object).toString();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        block15: {
            block13: {
                block14: {
                    block12: {
                        var2_1 = new StringBuilder();
                        if (this.getClass().getName().startsWith("com.google.common.util.concurrent.")) {
                            var2_1.append(this.getClass().getSimpleName());
                        } else {
                            var2_1.append(this.getClass().getName());
                        }
                        var2_1.append('@');
                        var2_1.append(Integer.toHexString(System.identityHashCode(this)));
                        var2_1.append("[status=");
                        if (this.isCancelled()) {
                            var2_1.append("CANCELLED");
lbl17:
                            // 4 sources

                            while (true) {
                                var2_1.append("]");
                                return var2_1.toString();
                            }
                        }
                        if (!this.isDone()) break block12;
                        this.zzE(var2_1);
                        ** GOTO lbl17
                    }
                    var3_2 = var2_1.length();
                    var2_1.append("PENDING");
                    var1_3 /* !! */  = this.zzw();
                    if (!(var1_3 /* !! */  instanceof zzb)) break block13;
                    var2_1.append(", setFuture=[");
                    var1_3 /* !! */  = ((zzb)var1_3 /* !! */ ).zzb;
                    if (var1_3 /* !! */  != this) break block14;
                    var2_1.append("this future");
lbl37:
                    // 2 sources

                    while (true) {
                        var2_1.append("]");
lbl40:
                        // 3 sources

                        while (true) {
                            if (!this.isDone()) ** GOTO lbl17
                            v0 = var2_1;
                            v0.delete(var3_2, v0.length());
                            this.zzE(var2_1);
                            ** continue;
                            break;
                        }
                        break;
                    }
                }
                var2_1.append(var1_3 /* !! */ );
            }
            ** try [egrp 2[TRYBLOCK] [2 : 194->204)] { 
lbl54:
            // 1 sources

            break block15;
lbl55:
            // 1 sources

            catch (Throwable v1) {
                zzgcl.zzb(v1);
                var1_3 /* !! */  = String.valueOf(String.valueOf(v1.getClass()));
                var1_3 /* !! */  = "Exception thrown from implementation: ".concat((String)var1_3 /* !! */ );
            }
lbl59:
            // 2 sources

            while (true) {
                if (var1_3 /* !! */  == null) ** GOTO lbl40
                var2_1.append(", info=[");
                var2_1.append((String)var1_3 /* !! */ );
                var2_1.append("]");
                ** continue;
                break;
            }
            catch (Throwable v2) {
                zzgcl.zzb(v2);
                v3 = var2_1;
                v3.append("Exception thrown from implementation: ");
                v3.append(v2.getClass());
            }
            ** while (true)
        }
        var1_3 /* !! */  = this.zza();
        var1_3 /* !! */  = zzfun.zza((String)var1_3 /* !! */ );
        ** while (true)
    }

    @Override
    protected final Throwable zzi() {
        if (this instanceof zze && (this = ((zzgah)this).zzw()) instanceof zzc) {
            return ((zzc)this).zzb;
        }
        return null;
    }

    protected zzgag() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzE(StringBuilder stringBuilder) {
        try {
            Object object = zzgag.zzf((Future)((Object)this));
            stringBuilder.append("SUCCESS, result=[");
            if (object == null) {
                stringBuilder.append("null");
            } else if (object == this) {
                stringBuilder.append("this future");
            } else {
                stringBuilder.append(object.getClass().getName());
                stringBuilder.append("@");
                stringBuilder.append(Integer.toHexString(System.identityHashCode(object)));
            }
            stringBuilder.append("]");
            return;
        }
        catch (ExecutionException executionException) {
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.append("FAILURE, cause=[");
            stringBuilder2.append(executionException.getCause());
            stringBuilder.append("]");
            return;
        }
        catch (CancellationException cancellationException) {
            stringBuilder.append("CANCELLED");
            return;
        }
        catch (Exception exception) {
            StringBuilder stringBuilder3 = stringBuilder;
            stringBuilder3.append("UNKNOWN, cause=[");
            stringBuilder3.append(exception.getClass());
            stringBuilder.append(" thrown from get()]");
            return;
        }
    }

    public void addListener(Runnable runnable, Executor executor) {
        zzd zzd2;
        zzftw.zzc((Object)runnable, (Object)"Runnable was null.");
        zzftw.zzc((Object)executor, (Object)"Executor was null.");
        if (!this.isDone() && (zzd2 = this.zzr()) != zzd.zza) {
            zzd zzd3 = new zzd(runnable, executor);
            do {
                zzd3.next = zzd2;
                if (!this.zzC(zzd2, zzd3)) continue;
                return;
            } while ((zzd2 = this.zzr()) != zzd.zza);
        }
        zzgag.zzG(runnable, executor);
    }

    protected void zzb() {
    }

    private static void zzF(zzgag zzgag2, boolean bl) {
        zzgag zzgag3 = null;
        block0: while (true) {
            zzgag2.zzB();
            if (bl) {
                zzgag2.zzk();
            }
            zzgag2.zzb();
            zzgag2 = zzgag2.zzq(zzd.zza);
            while (zzgag2 != null) {
                zzd zzd2 = ((zzd)((Object)zzgag2)).next;
                ((zzd)((Object)zzgag2)).next = zzgag3;
                zzgag3 = zzgag2;
                zzgag2 = zzd2;
            }
            while (zzgag3 != null) {
                zzgag2 = ((zzd)((Object)zzgag3)).next;
                Runnable runnable = Objects.requireNonNull(((zzd)((Object)zzgag3)).zzb);
                if (runnable instanceof zzb) {
                    runnable = (zzb)runnable;
                    zzgag3 = ((zzb)runnable).zza;
                    if (zzgag3.zzw() == runnable) {
                        Runnable runnable2 = runnable;
                        if (zzgag.zzD(zzgag3, runnable2, zzgag.zze(((zzb)runnable2).zzb))) {
                            zzgag zzgag4 = zzgag2;
                            bl = false;
                            zzgag2 = zzgag3;
                            zzgag3 = zzgag4;
                            continue block0;
                        }
                        zzgag3 = zzgag2;
                        continue;
                    }
                    zzgag3 = zzgag2;
                    continue;
                }
                zzgag.zzG(runnable, Objects.requireNonNull(((zzd)((Object)zzgag3)).zzc));
                zzgag3 = zzgag2;
            }
            break;
        }
    }

    private static void zzG(Runnable object, Executor executor) {
        try {
            executor.execute((Runnable)object);
            return;
        }
        catch (Exception exception) {
            Logger logger = zzf.zza();
            object = String.valueOf(object);
            String string2 = String.valueOf(executor);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("RuntimeException while executing runnable ");
            stringBuilder.append((String)object);
            stringBuilder.append(" with executor ");
            stringBuilder.append(string2);
            object = stringBuilder.toString();
            logger.logp(Level.SEVERE, "com.google.common.util.concurrent.AbstractFuture", "executeListener", (String)object, exception);
            return;
        }
    }

    protected void zzk() {
    }

    /*
     * Enabled aggressive block sorting
     */
    final void zzl(Future future) {
        boolean bl = future != null;
        if (bl & this.isCancelled()) {
            future.cancel(this.zzo());
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean cancel(boolean bl) {
        zza zza2;
        void var1_9;
        boolean bl2;
        Object object = this.zzw();
        boolean bl3 = object == null;
        if (!(bl3 | (bl2 = object instanceof zzb))) {
            return false;
        }
        if (zzg) {
            zza2 = new zza((boolean)var1_9, new CancellationException("Future.cancel() was called."));
        } else {
            zza2 = var1_9 != false ? zza.zza : zza.zzb;
            zza2 = Objects.requireNonNull(zza2);
        }
        Object object2 = object;
        boolean bl4 = false;
        zzgag zzgag2 = this;
        while (true) {
            void var0_2;
            if (zzgag.zzD(zzgag2, var0_2, zza2)) {
                void var0_5;
                zzgag.zzF(zzgag2, (boolean)var1_9);
                if (!(var0_2 instanceof zzb)) {
                    return true;
                }
                ListenableFuture listenableFuture = ((zzb)var0_2).zzb;
                if (!(listenableFuture instanceof zze)) {
                    listenableFuture.cancel((boolean)var1_9);
                    return true;
                }
                zzgag2 = (zzgag)listenableFuture;
                Object object3 = zzgag2.zzw();
                if (object3 == null) {
                    boolean bl5 = true;
                } else {
                    boolean bl6 = false;
                }
                if ((var0_5 | object3 instanceof zzb) == 0) {
                    return true;
                }
                Object object4 = object3;
                bl4 = true;
                continue;
            }
            Object object5 = zzgag2.zzw();
            if (zzgag.zzm(object5)) break;
        }
        return bl4;
    }

    public boolean isCancelled() {
        return this.zzw() instanceof zza;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDone() {
        boolean bl;
        Object object = this.zzw();
        boolean bl2 = zzgag.zzm(object);
        if (object != null) {
            bl = true;
            return bl & bl2;
        }
        bl = false;
        return bl & bl2;
    }

    static boolean zzm(Object object) {
        return !(object instanceof zzb);
    }

    protected boolean zzc(Object object) {
        if (object == null) {
            object = zze;
        }
        if (zzgag.zzD(this, null, object)) {
            zzgag.zzF(this, false);
            return true;
        }
        return false;
    }

    protected boolean zzd(Throwable throwable) {
        if (throwable != null) {
            zzc zzc2 = new zzc(throwable);
            if (zzgag.zzD(this, null, zzc2)) {
                zzgag.zzF(this, false);
                return true;
            }
        } else {
            throw null;
        }
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean zzn(ListenableFuture listenableFuture) {
        Object object;
        if (listenableFuture == null) throw null;
        zzb zzb2 = ((zzgah)object).zzw();
        if (zzb2 == null) {
            if (listenableFuture.isDone()) {
                if (!zzgag.zzD((zzgah)object, null, zzgag.zze(listenableFuture))) return false;
                zzgag.zzF((zzgag)object, false);
                return true;
            }
            zzb2 = new zzb((zzgag)object, listenableFuture);
            if (zzgag.zzD((zzgah)object, null, zzb2)) {
                listenableFuture.addListener(zzb2, (Executor)zzgbg.zza);
                return true;
            }
            object = ((zzgah)object).zzw();
        } else {
            object = zzb2;
        }
        if (!(object instanceof zza)) return false;
        listenableFuture.cancel(((zza)object).zzc);
        return false;
        catch (Throwable throwable) {
            zzc zzc2;
            try {
                zzc zzc3;
                zzc2 = zzc3 = new zzc(throwable);
            }
            catch (Error | Exception throwable2) {
                zzc2 = zzc.zza;
            }
            zzgag.zzD((zzgah)object, zzb2, zzc2);
            return true;
        }
    }

    protected final boolean zzo() {
        return (this = ((zzgah)this).zzw()) instanceof zza && ((zza)this).zzc;
    }

    private static final class zzb<V>
    implements Runnable {
        final zzgag<V> zza;
        final ListenableFuture<? extends V> zzb;

        zzb(zzgag zzgag2, ListenableFuture listenableFuture) {
            this.zza = zzgag2;
            this.zzb = listenableFuture;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public final void run() {
            ListenableFuture<? extends V> listenableFuture;
            if (this.zza.zzw() != this || !zzgah.zzD(this.zza, this, zzgag.zze(listenableFuture = this.zzb))) {
                return;
            }
            zzgag.zzF((zzgag)this.zza, false);
        }
    }

    private static final class zza {
        static final zza zza;
        static final zza zzb;
        final boolean zzc;
        final Throwable zzd;

        static {
            if (zzgah.zzg) {
                zzb = null;
                zza = null;
            } else {
                zzb = new zza(false, null);
                zza = new zza(true, null);
            }
        }

        zza(boolean bl, Throwable throwable) {
            this.zzc = bl;
            this.zzd = throwable;
        }
    }

    private static final class zzc {
        static final zzc zza = new zzc(new Throwable("Failure occurred while trying to finish a future."){

            @Override
            public final Throwable fillInStackTrace() {
                return this;
            }
        });
        final Throwable zzb;

        zzc(Throwable throwable) {
            if (throwable == null) {
                throw null;
            }
            this.zzb = throwable;
        }
    }

    static interface zze<V>
    extends ListenableFuture<V> {
    }

    static final class zzd {
        static final zzd zza = new zzd();
        final Runnable zzb;
        final Executor zzc;
        zzd next;

        zzd() {
            this.zzb = null;
            this.zzc = null;
        }

        zzd(Runnable runnable, Executor executor) {
            this.zzb = runnable;
            this.zzc = executor;
        }
    }

    static abstract class zzf<V>
    extends zzgag<V>
    implements zze<V> {
        zzf() {
        }
    }
}

