/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzgcy;
import com.google.android.gms.internal.ads.zzgdg;
import com.google.android.gms.internal.ads.zzggl;
import com.google.android.gms.internal.ads.zzgjk;
import com.google.android.gms.internal.ads.zzgko;
import com.google.android.gms.internal.ads.zzgnx;
import com.google.android.gms.internal.ads.zzgvj;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class zzgjl
implements zzgcy {
    private static final byte[] zza = zzgvj.zza("808182838485868788898a8b8c8d8e8f909192939495969798999a9b9c9d9e9f");
    private static final byte[] zzb = zzgvj.zza("070000004041424344454647");
    private static final byte[] zzc = zzgvj.zza("a0784d7a4716f3feb4f64e7f4b39bf04");
    private static final ThreadLocal zzd = new zzgjk();
    private final SecretKey zze;
    private final byte[] zzf;

    public static zzgcy zzb(zzggl zzggl2) throws GeneralSecurityException {
        return new zzgjl(zzggl2.zze().zzd(zzgdg.zza()), zzggl2.zzb().zzd());
    }

    @Nullable
    static Cipher zzc() {
        return (Cipher)zzd.get();
    }

    private zzgjl(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        if (!zzgko.zza(1)) {
            throw new GeneralSecurityException("Can not use ChaCha20Poly1305 in FIPS-mode.");
        }
        if (!zzgjl.zze()) {
            throw new GeneralSecurityException("JCE does not support algorithm: ChaCha20-Poly1305");
        }
        if (byArray.length != 32) {
            throw new InvalidKeyException("The key length in bytes must be 32.");
        }
        String string2 = "ChaCha20";
        this.zze = new SecretKeySpec(byArray, string2);
        this.zzf = byArray2;
    }

    static /* bridge */ /* synthetic */ boolean zzd(Cipher cipher) {
        return zzgjl.zzf(cipher);
    }

    public static boolean zze() {
        return zzd.get() != null;
    }

    private static boolean zzf(Cipher cipher) {
        byte[] byArray;
        byte[] byArray2;
        IvParameterSpec ivParameterSpec;
        block3: {
            try {
                ivParameterSpec = new IvParameterSpec(zzb);
                byArray2 = zza;
                cipher.init(2, (Key)new SecretKeySpec(byArray2, "ChaCha20"), ivParameterSpec);
                byArray = zzc;
                int n = cipher.doFinal(byArray).length;
                if (n == 0) break block3;
                return false;
            }
            catch (GeneralSecurityException generalSecurityException) {
                return false;
            }
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, "ChaCha20");
        cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
        int n = cipher.doFinal(byArray).length;
        return n == 0;
    }

    @Override
    public final byte[] zza(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        if (byArray == null) {
            throw new NullPointerException("ciphertext is null");
        }
        int n = byArray.length;
        Object object = this.zzf;
        int n2 = ((byte[])object).length;
        if (n < n2 + 28) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        if (!zzgnx.zzc(object, byArray)) {
            throw new GeneralSecurityException("Decryption failed (OutputPrefix mismatch).");
        }
        object = new byte[12];
        System.arraycopy(byArray, n2, object, 0, 12);
        IvParameterSpec ivParameterSpec = new IvParameterSpec((byte[])object);
        object = (Cipher)zzd.get();
        object.init(2, (Key)this.zze, ivParameterSpec);
        if (byArray2 != null && byArray2.length != 0) {
            object.updateAAD(byArray2);
        }
        return object.doFinal(byArray, n2 + 12, n - n2 + -12);
    }
}

