/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzgcy;
import com.google.android.gms.internal.ads.zzgdg;
import com.google.android.gms.internal.ads.zzgfh;
import com.google.android.gms.internal.ads.zzgko;
import com.google.android.gms.internal.ads.zzgnx;
import com.google.android.gms.internal.ads.zzguo;
import com.google.android.gms.internal.ads.zzgup;
import com.google.android.gms.internal.ads.zzgvq;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class zzguq
implements zzgcy {
    private static final ThreadLocal zza = new zzguo();
    private static final ThreadLocal zzb = new zzgup();
    private final byte[] zzc;
    private final byte[] zzd;
    private final byte[] zze;
    private final SecretKeySpec zzf;
    private final int zzg;

    public static zzgcy zzb(zzgfh zzgfh2) throws GeneralSecurityException {
        if (!zzgko.zza(1)) {
            throw new GeneralSecurityException("Can not use AES-EAX in FIPS-mode.");
        }
        return new zzguq(zzgfh2.zze().zzd(zzgdg.zza()), zzgfh2.zzd().zzb(), zzgfh2.zzb().zzd());
    }

    private zzguq(byte[] byArray, int n, byte[] byArray2) throws GeneralSecurityException {
        if (!zzgko.zza(1)) {
            throw new GeneralSecurityException("Can not use AES-EAX in FIPS-mode.");
        }
        if (n != 12 && n != 16) {
            throw new IllegalArgumentException("IV size should be either 12 or 16 bytes");
        }
        this.zzg = n;
        zzgvq.zza(byArray.length);
        String string2 = "AES";
        this.zzf = new SecretKeySpec(byArray, string2);
        Cipher cipher = (Cipher)zza.get();
        cipher.init(1, this.zzf);
        this.zzc = zzguq.zzd(cipher.doFinal(new byte[16]));
        this.zzd = zzguq.zzd(this.zzc);
        this.zze = byArray2;
    }

    private static void zzc(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            byArray[n2] = (byte)(byArray[i] ^ byArray2[n2]);
        }
    }

    @Override
    public final byte[] zza(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        int n = byArray.length;
        byte[] byArray3 = this.zze;
        int n2 = byArray3.length;
        int n3 = this.zzg;
        int n4 = n - n2 - n3 + -16;
        if (n4 < 0) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        if (!zzgnx.zzc(byArray3, byArray)) {
            throw new GeneralSecurityException("Decryption failed (OutputPrefix mismatch).");
        }
        Cipher cipher = (Cipher)zza.get();
        SecretKeySpec secretKeySpec = this.zzf;
        cipher.init(1, secretKeySpec);
        byte[] byArray4 = this.zze(cipher, 0, byArray, n2, n3);
        if (byArray2 == null) {
            byArray2 = new byte[]{};
        }
        byte[] byArray5 = this.zze(cipher, 1, byArray2, 0, byArray2.length);
        byte[] byArray6 = this.zze(cipher, 2, byArray, n2 + n3, n4);
        n -= 16;
        int n5 = 0;
        for (int i = 0; i < 16; ++i) {
            n5 |= byArray[n + i] ^ byArray5[i] ^ byArray4[i] ^ byArray6[i];
            n5 = (byte)n5;
        }
        if (n5 != 0) {
            throw new AEADBadTagException("tag mismatch");
        }
        Cipher cipher2 = (Cipher)zzb.get();
        cipher2.init(1, (Key)secretKeySpec, new IvParameterSpec(byArray4));
        return cipher2.doFinal(byArray, byArray3.length + n3, n4);
    }

    private static byte[] zzd(byte[] byArray) {
        byte[] byArray2 = new byte[16];
        int n = 0;
        while (n < 15) {
            byte by = byArray[n];
            byArray2[n++] = (byte)((by + by ^ (byArray[n] & 0xFF) >>> 7) & 0xFF);
        }
        byte by = byArray[15];
        byArray2[15] = (byte)(by + by ^ byArray[0] >> 7 & 0x87);
        return byArray2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final byte[] zze(Cipher cipher, int n, byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        Object object;
        byte[] byArray2 = new byte[16];
        byArray2[15] = (byte)n;
        if (n3 == 0) {
            zzguq.zzc(byArray2, ((zzguq)object).zzc);
            return cipher.doFinal(byArray2);
        }
        byte[] byArray3 = new byte[16];
        cipher.doFinal(byArray2, 0, 16, byArray3);
        int n4 = 0;
        while (n3 - n4 > 16) {
            for (int i = 0; i < 16; ++i) {
                int n5 = n2 + n4;
                int n6 = i;
                byArray3[n6] = (byte)(byArray3[n6] ^ byArray[n5 + i]);
            }
            cipher.doFinal(byArray3, 0, 16, byArray2);
            byte[] byArray4 = byArray3;
            byArray3 = byArray2;
            byArray2 = byArray4;
            n4 += 16;
        }
        if ((byArray = Arrays.copyOfRange(byArray, n2 + n4, n2 + n3)).length == 16) {
            zzguq.zzc(byArray, ((zzguq)object).zzc);
            object = byArray;
        } else {
            byte[] byArray5 = Arrays.copyOf(((zzguq)object).zzd, 16);
            for (int i = 0; i < (n3 = byArray.length); ++i) {
                int n7 = i;
                byArray5[n7] = (byte)(byArray5[i] ^ byArray[n7]);
            }
            int n8 = n3;
            byArray5[n8] = (byte)(byArray5[n8] ^ 0x80);
            object = byArray5;
        }
        zzguq.zzc(byArray3, (byte[])object);
        cipher.doFinal(byArray3, 0, 16, byArray2);
        return byArray2;
    }
}

