/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzgko;
import com.google.android.gms.internal.ads.zzgpt;
import com.google.android.gms.internal.ads.zzgqc;
import com.google.android.gms.internal.ads.zzgus;
import com.google.android.gms.internal.ads.zzgvl;
import com.google.android.gms.internal.ads.zzgvq;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class zzgvm
implements zzgqc {
    private static final ThreadLocal zza = new zzgvl();
    private final SecretKey zzb;
    private final byte[] zzc;
    private final byte[] zzd;

    private static Cipher zzb() throws GeneralSecurityException {
        if (!zzgko.zza(1)) {
            throw new GeneralSecurityException("Can not use AES-CMAC in FIPS-mode.");
        }
        return (Cipher)zza.get();
    }

    public zzgvm(byte[] byArray) throws GeneralSecurityException {
        zzgvq.zza(byArray.length);
        String string2 = "AES";
        this.zzb = new SecretKeySpec(byArray, string2);
        Cipher cipher = zzgvm.zzb();
        cipher.init(1, this.zzb);
        this.zzc = zzgpt.zza(cipher.doFinal(new byte[16]));
        this.zzd = zzgpt.zza(this.zzc);
    }

    private static void zzc(byte[] byArray, byte[] byArray2, int n, byte[] byArray3) {
        for (int i = 0; i < 16; ++i) {
            int n2 = i;
            byArray3[n2] = (byte)(byArray[i] ^ byArray2[n2 + n]);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final byte[] zza(byte[] byArray, int n) throws GeneralSecurityException {
        Object object;
        if (n > 16) {
            throw new InvalidAlgorithmParameterException("outputLength too large, max is 16 bytes");
        }
        SecretKey secretKey = ((zzgvm)object).zzb;
        Cipher cipher = zzgvm.zzb();
        cipher.init(1, secretKey);
        int n2 = byArray.length;
        int n3 = n2 == 0 ? 1 : (n2 + -1 >> 4) + 1;
        int n4 = n3 + -1;
        int n5 = n4 * 16;
        if (n3 * 16 == n2) {
            object = zzgus.zzc(byArray, n5, ((zzgvm)object).zzc, 0, 16);
        } else {
            byte[] byArray2 = Arrays.copyOfRange(byArray, n5, n2);
            if ((n2 = byArray2.length) >= 16) {
                throw new IllegalArgumentException("x must be smaller than a block.");
            }
            byArray2 = Arrays.copyOf(byArray2, 16);
            byArray2[n2] = -128;
            object = ((zzgvm)object).zzd;
            if (byArray2.length != 16) {
                throw new IllegalArgumentException("The lengths of x and y should match.");
            }
            object = zzgus.zzc(byArray2, 0, (byte[])object, 0, 16);
        }
        byte[] byArray3 = new byte[16];
        byte[] byArray4 = new byte[16];
        for (int i = 0; i < n4; ++i) {
            zzgvm.zzc(byArray3, byArray, i * 16, byArray4);
            if (cipher.doFinal(byArray4, 0, 16, byArray3) == 16) continue;
            throw new IllegalStateException("Cipher didn't write full block");
        }
        zzgvm.zzc(byArray3, (byte[])object, 0, byArray4);
        if (cipher.doFinal(byArray4, 0, 16, byArray3) != 16) {
            throw new IllegalStateException("Cipher didn't write full block");
        }
        if (n == 16) {
            return byArray3;
        }
        return Arrays.copyOf(byArray3, n);
    }
}

