/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.ads.zzfx;
import com.google.android.gms.internal.ads.zzgf;
import com.google.android.gms.internal.ads.zzgj;
import com.google.android.gms.internal.ads.zzhb;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class zzhc
extends zzfx {
    private final Context zza;
    @Nullable
    private zzgj zzb;
    @Nullable
    private AssetFileDescriptor zzc;
    @Nullable
    private InputStream zzd;
    private long zze;
    private boolean zzf;

    private static int zzk(String string2) throws zzhb {
        int n;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new zzhb("Resource identifier must be an integer.", null, 1004);
        }
        return n;
    }

    @Override
    public final int zza(byte[] byArray, int n, int n2) throws zzhb {
        if (n2 == 0) {
            return 0;
        }
        long l = ((zzhc)object).zze;
        if (l != 0L) {
            int n3;
            block7: {
                block8: {
                    if (l != -1L) {
                        long l2 = Math.min(l, (long)n2);
                        n2 = (int)l2;
                    }
                    try {
                        InputStream inputStream = ((zzhc)object).zzd;
                        n3 = inputStream.read(byArray, n, n2);
                        if (n3 != -1) break block7;
                        if (((zzhc)object).zze == -1L) break block8;
                        Object object = new EOFException();
                    }
                    catch (IOException iOException) {
                        throw new zzhb(null, iOException, 2000);
                    }
                    throw new zzhb("End of stream reached having not read sufficient data.", (Throwable)object, 2000);
                }
                return -1;
            }
            long l3 = ((zzhc)object).zze;
            if (l3 != -1L) {
                ((zzhc)object).zze = l3 - (long)n3;
            }
            ((zzfx)object).zzg(n3);
            return n3;
        }
        return -1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final long zzb(zzgj var1_2) throws zzhb {
        block12: {
            this.zzb = var1_2;
            this.zzi(var1_2);
            this.zzc = zzhc.zzl(this.zza, var1_2);
            var6_3 = this.zzc.getLength();
            var8_4 = new FileInputStream(this.zzc.getFileDescriptor());
            this.zzd = var8_4;
            if (var6_3 == -1L) ** GOTO lbl11
            try {
                var9_5 = var1_2.zze;
                if (var9_5 > var6_3) throw new zzhb(null, null, 2008);
lbl11:
                // 2 sources

                if ((var17_9 = (var15_8 = var8_4.skip((var11_6 = this.zzc.getStartOffset()) + (var13_7 = var1_2.zze))) - var11_6) != var13_7) {
                    throw new zzhb(null, null, 2008);
                }
            }
            catch (zzhb v0) {
                throw v0;
            }
            catch (IOException var0_1) {
                throw new zzhb(null, var0_1, 2000);
            }
            {
                if (var6_3 != -1L) break block12;
                var2_10 = (var8_4 = var8_4.getChannel()).size();
                if (var2_10 != 0L) ** GOTO lbl-1000
                this.zze = -1L;
                var2_10 = -1L;
            }
lbl23:
            // 3 sources

            while (true) {
                var9_5 = var1_2.zzf;
                if (var9_5 != -1L) {
                    var4_11 = var2_10 == -1L ? var9_5 : Math.min(var2_10, var9_5);
                    this.zze = var4_11;
                }
                this.zzf = true;
                this.zzj(var1_2);
                if (var9_5 == -1L) return this.zze;
                return var9_5;
            }
lbl-1000:
            // 1 sources

            {
                this.zze = var9_5 = var8_4.size() - var8_4.position();
                if (var9_5 < 0L) throw new zzhb(null, null, 2008);
                var2_10 = var9_5;
                ** GOTO lbl23
            }
        }
        var9_5 = var6_3 - var17_9;
        {
            this.zze = var9_5;
            if (var9_5 < 0L) {
                throw new zzgf(2008);
            }
        }
        var2_10 = var9_5;
        ** while (true)
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static AssetFileDescriptor zzl(Context object, zzgj object2) throws zzhb {
        AssetFileDescriptor assetFileDescriptor;
        block15: {
            int n;
            Object object3;
            Uri uri = ((zzgj)object3).zza.normalizeScheme();
            object3 = uri.getScheme();
            if (TextUtils.equals((CharSequence)"rawresource", (CharSequence)object3)) {
                Resources resources = object.getResources();
                object3 = uri.getPathSegments();
                if (object3.size() != 1) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("rawresource:// URI must have exactly one path element, found ");
                    stringBuilder.append(object3.size());
                    throw new zzhb(stringBuilder.toString());
                }
                n = zzhc.zzk((String)object3.get(0));
            } else {
                String string2;
                object3 = uri.getScheme();
                if (!TextUtils.equals((CharSequence)"android.resource", (CharSequence)object3)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Unsupported URI scheme (");
                    stringBuilder.append(uri.getScheme());
                    stringBuilder.append("). Only android.resource is supported.");
                    throw new zzhb(stringBuilder.toString(), null, 1004);
                }
                object3 = uri.getPath();
                if (object3 == null) {
                    throw null;
                }
                if (((String)(object3 = (String)object3)).startsWith("/")) {
                    object3 = ((String)object3).substring(1);
                }
                if ((string2 = TextUtils.isEmpty((CharSequence)uri.getHost()) ? object.getPackageName() : uri.getHost()).equals(object.getPackageName())) {
                    Resources resources = object.getResources();
                } else {
                    Resources resources = object.getPackageManager().getResourcesForApplication(string2);
                }
                if (((String)object3).matches("\\d+")) {
                    n = zzhc.zzk((String)object3);
                } else {
                    void var0_6;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(string2);
                    stringBuilder.append(":");
                    stringBuilder.append((String)object3);
                    n = var0_6.getIdentifier(stringBuilder.toString(), "raw", null);
                    if (n == 0) {
                        throw new zzhb("Resource not found.", null, 2005);
                    }
                }
            }
            try {
                void var0_2;
                assetFileDescriptor = var0_2.openRawResourceFd(n);
                if (assetFileDescriptor != null) break block15;
            }
            catch (Resources.NotFoundException notFoundException) {
                throw new zzhb(null, notFoundException, 2005);
            }
            String string3 = String.valueOf(String.valueOf(uri));
            throw new zzhb("Resource is compressed: ".concat(string3), null, 2000);
        }
        return assetFileDescriptor;
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new zzhb("Package in android.resource:// URI not found. Check http://g.co/dev/packagevisibility.", nameNotFoundException, 2005);
        }
    }

    @Deprecated
    public static Uri buildRawResourceUri(int rawResourceId) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("rawresource:///");
        stringBuilder.append(n);
        return Uri.parse((String)stringBuilder.toString());
    }

    @Override
    @Nullable
    public final Uri zzc() {
        zzgj zzgj2 = ((zzhc)((Object)zzgj2)).zzb;
        if (zzgj2 != null) {
            return zzgj2.zza;
        }
        return null;
    }

    public zzhc(Context context) {
        super(false);
        this.zza = context.getApplicationContext();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void zzd() throws zzhb {
        this.zzb = null;
        var1_1 = this.zzd;
        if (var1_1 != null) {
            var1_1.close();
        }
        this.zzd = null;
        var1_1 = this.zzc;
        if (var1_1 != null) {
            var1_1.close();
        }
        this.zzc = null;
        if (this.zzf) {
            this.zzf = false;
            this.zzh();
            return;
        }
        return;
        catch (IOException var1_2) {
            try {
                throw new zzhb(null, var1_2, 2000);
            }
            catch (Throwable var1_3) {
                block18: {
                    this.zzd = null;
                    try {
                        var2_10 = this.zzc;
                        if (var2_10 != null) {
                            var2_10.close();
                        }
                        this.zzc = null;
                        if (!this.zzf) break block18;
                        this.zzf = false;
                        this.zzh();
                    }
                    catch (IOException var1_7) {
                        try {
                            throw new zzhb(null, var1_7, 2000);
                        }
                        catch (Throwable var1_8) {
                            ** continue;
                        }
                    }
                }
                throw var1_3;
                catch (IOException var1_4) {
                    try {
                        throw new zzhb(null, var1_4, 2000);
                    }
                    catch (Throwable var1_5) lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            this.zzc = null;
                            if (this.zzf) {
                                this.zzf = false;
                                this.zzh();
                            }
                            throw var1_6;
                        }
                    }
                }
            }
        }
    }
}

