/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.nonagon.signalgeneration;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdFormat;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.internal.client.zzbd;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.ads.nonagon.signalgeneration.zzaa;
import com.google.android.gms.ads.nonagon.signalgeneration.zzbo;
import com.google.android.gms.ads.nonagon.signalgeneration.zzbp;
import com.google.android.gms.ads.nonagon.signalgeneration.zzbq;
import com.google.android.gms.ads.nonagon.signalgeneration.zzbr;
import com.google.android.gms.ads.nonagon.signalgeneration.zzbu;
import com.google.android.gms.ads.nonagon.signalgeneration.zzf;
import com.google.android.gms.ads.nonagon.signalgeneration.zzj;
import com.google.android.gms.ads.nonagon.signalgeneration.zzo;
import com.google.android.gms.ads.query.QueryInfo;
import com.google.android.gms.ads.query.QueryInfoGenerationCallback;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.internal.ads.zzavl;
import com.google.android.gms.internal.ads.zzavm;
import com.google.android.gms.internal.ads.zzbcm;
import com.google.android.gms.internal.ads.zzbcv;
import com.google.android.gms.internal.ads.zzbfa;
import com.google.android.gms.internal.ads.zzcaa;
import com.google.android.gms.internal.ads.zzdsi;
import com.google.android.gms.internal.ads.zzfct;
import com.google.android.gms.internal.ads.zzfjr;
import com.google.android.gms.internal.ads.zzgdj;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

public final class TaggingLibraryJsInterface {
    private final Context zza;
    private final WebView zzb;
    private final zzavl zzc;
    private final zzfct zzd;
    private final int zze;
    private final zzdsi zzf;
    private final boolean zzg;
    private final zzgdj zzh = zzcaa.zzf;
    private final zzfjr zzi;
    private final zzo zzj;
    private final zzf zzk;
    private final zzj zzl;

    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    @NonNull
    public String getClickSignals(@NonNull String clickString) {
        String string2;
        block3: {
            long l;
            try {
                l = zzv.zzD().currentTimeMillis();
                string2 = ((TaggingLibraryJsInterface)((Object)zzdsi2)).zzc.zzc().zzd(((TaggingLibraryJsInterface)((Object)zzdsi2)).zza, string2, (View)((TaggingLibraryJsInterface)((Object)zzdsi2)).zzb);
                boolean bl = ((TaggingLibraryJsInterface)((Object)zzdsi2)).zzg;
                if (!bl) break block3;
            }
            catch (RuntimeException runtimeException) {
                com.google.android.gms.ads.internal.util.client.zzo.zzh((String)"Exception getting click signals. ", (Throwable)runtimeException);
                string2 = "TaggingLibraryJsInterface.getClickSignals";
                zzv.zzp().zzw(runtimeException, string2);
                return "";
            }
            long l2 = zzv.zzD().currentTimeMillis() - l;
            zzdsi zzdsi2 = ((TaggingLibraryJsInterface)((Object)zzdsi2)).zzf;
            String string3 = "csg";
            Pair[] pairArray = new Pair[]{new Pair((Object)"clat", (Object)String.valueOf(l2))};
            zzaa.zzd(zzdsi2, null, string3, pairArray);
        }
        return string2;
    }

    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    @NonNull
    public String getClickSignalsWithTimeout(@NonNull String clickString, int timeoutMs) {
        String string2;
        int n;
        if (timeoutMs <= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid timeout for getting click signals. Timeout=");
            stringBuilder.append(n);
            com.google.android.gms.ads.internal.util.client.zzo.zzg((String)stringBuilder.toString());
            return "";
        }
        n = Math.min(n, ((TaggingLibraryJsInterface)object).zze);
        Object object = zzcaa.zza.zzb(new zzbq((TaggingLibraryJsInterface)object, string2));
        try {
            object = (String)object.get(n, TimeUnit.MILLISECONDS);
            return object;
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            com.google.android.gms.ads.internal.util.client.zzo.zzh((String)"Exception getting click signals with timeout. ", (Throwable)exception);
            string2 = "TaggingLibraryJsInterface.getClickSignalsWithTimeout";
            zzv.zzp().zzw(exception, string2);
            if (exception instanceof TimeoutException) {
                return "17";
            }
            return "";
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    @NonNull
    public String getQueryInfo() {
        zzv.zzr();
        String string2 = UUID.randomUUID().toString();
        Bundle bundle = new Bundle();
        bundle.putString("query_info_type", "requester_type_6");
        zzbu zzbu2 = new zzbu(this, string2);
        if (((Boolean)zzbfa.zze.zze()).booleanValue()) {
            this.zzj.zzg(this.zzb, zzbu2);
            return string2;
        }
        zzbcm zzbcm2 = zzbcv.zzjU;
        if (((Boolean)zzbd.zzc().zzb(zzbcm2)).booleanValue()) {
            this.zzh.execute(new zzbr(this, bundle, zzbu2));
            return string2;
        }
        QueryInfo.generate((Context)this.zza, (AdFormat)AdFormat.BANNER, (AdRequest)((AdRequest.Builder)new AdRequest.Builder().addNetworkExtrasBundle(AdMobAdapter.class, bundle)).build(), (QueryInfoGenerationCallback)zzbu2);
        return string2;
    }

    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    @NonNull
    public String getViewSignals() {
        String string2;
        block3: {
            long l;
            try {
                l = zzv.zzD().currentTimeMillis();
                string2 = ((TaggingLibraryJsInterface)((Object)zzdsi2)).zzc.zzc().zzh(((TaggingLibraryJsInterface)((Object)zzdsi2)).zza, (View)((TaggingLibraryJsInterface)((Object)zzdsi2)).zzb, null);
                boolean bl = ((TaggingLibraryJsInterface)((Object)zzdsi2)).zzg;
                if (!bl) break block3;
            }
            catch (RuntimeException runtimeException) {
                com.google.android.gms.ads.internal.util.client.zzo.zzh((String)"Exception getting view signals. ", (Throwable)runtimeException);
                string2 = "TaggingLibraryJsInterface.getViewSignals";
                zzv.zzp().zzw(runtimeException, string2);
                return "";
            }
            long l2 = zzv.zzD().currentTimeMillis() - l;
            zzdsi zzdsi2 = ((TaggingLibraryJsInterface)((Object)zzdsi2)).zzf;
            String string3 = "vsg";
            Pair[] pairArray = new Pair[]{new Pair((Object)"vlat", (Object)String.valueOf(l2))};
            zzaa.zzd(zzdsi2, null, string3, pairArray);
        }
        return string2;
    }

    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    @NonNull
    public String getViewSignalsWithTimeout(int timeoutMs) {
        int n;
        if (timeoutMs <= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid timeout for getting view signals. Timeout=");
            stringBuilder.append(n);
            com.google.android.gms.ads.internal.util.client.zzo.zzg((String)stringBuilder.toString());
            return "";
        }
        n = Math.min(n, ((TaggingLibraryJsInterface)object).zze);
        Object object = zzcaa.zza.zzb(new zzbo((TaggingLibraryJsInterface)object));
        try {
            object = (String)object.get(n, TimeUnit.MILLISECONDS);
            return object;
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            com.google.android.gms.ads.internal.util.client.zzo.zzh((String)"Exception getting view signals with timeout. ", (Throwable)exception);
            String string2 = "TaggingLibraryJsInterface.getViewSignalsWithTimeout";
            zzv.zzp().zzw(exception, string2);
            if (exception instanceof TimeoutException) {
                return "17";
            }
            return "";
        }
    }

    /*
     * WARNING - void declaration
     */
    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    public void recordClick(@NonNull String clickUrl) {
        void var1_1;
        zzbcm zzbcm2 = zzbcv.zzjW;
        if (!((Boolean)zzbd.zzc().zzb(zzbcm2)).booleanValue() || TextUtils.isEmpty((CharSequence)var1_1)) {
            return;
        }
        zzcaa.zza.execute(new zzbp(this, (String)var1_1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    public void reportTouchEvent(@NonNull String touchJson) {
        String string2;
        JSONObject jSONObject = new JSONObject(string2);
        int n = jSONObject.getInt("x");
        int n2 = jSONObject.getInt("y");
        int n3 = jSONObject.getInt("duration_ms");
        float f = (float)jSONObject.getDouble("force");
        int n4 = jSONObject.getInt("type");
        switch (n4) {
            default: {
                n4 = -1;
                break;
            }
            case 3: {
                n4 = 3;
                break;
            }
            case 2: {
                n4 = 2;
                break;
            }
            case 1: {
                n4 = 1;
                break;
            }
            case 0: {
                n4 = 0;
            }
        }
        try {
            MotionEvent motionEvent = MotionEvent.obtain((long)0L, (long)n3, (int)n4, (float)n, (float)n2, (float)f, (float)1.0f, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0);
            this.zzc.zzd(motionEvent);
            return;
        }
        catch (RuntimeException | JSONException throwable) {
            com.google.android.gms.ads.internal.util.client.zzo.zzh((String)"Failed to parse the touch string. ", (Throwable)throwable);
            string2 = "TaggingLibraryJsInterface.reportTouchEvent";
            zzv.zzp().zzw(throwable, string2);
            return;
        }
    }

    static /* bridge */ /* synthetic */ WebView zza(TaggingLibraryJsInterface taggingLibraryJsInterface) {
        return taggingLibraryJsInterface.zzb;
    }

    static /* bridge */ /* synthetic */ zzf zzb(TaggingLibraryJsInterface taggingLibraryJsInterface) {
        return taggingLibraryJsInterface.zzk;
    }

    static /* bridge */ /* synthetic */ zzj zzc(TaggingLibraryJsInterface taggingLibraryJsInterface) {
        return taggingLibraryJsInterface.zzl;
    }

    static /* bridge */ /* synthetic */ zzgdj zzd(TaggingLibraryJsInterface taggingLibraryJsInterface) {
        return taggingLibraryJsInterface.zzh;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static /* synthetic */ void zze(@NonNull TaggingLibraryJsInterface taggingLibraryJsInterface, @NonNull String string2) {
        string2 = Uri.parse((String)string2);
        try {
            zzfct zzfct2;
            zzbcm zzbcm2 = zzbcv.zzmm;
            Object object = zzbd.zzc().zzb(zzbcm2);
            boolean bl = (Boolean)object;
            if (bl && (zzfct2 = taggingLibraryJsInterface.zzd) != null) {
                string2 = zzfct2.zza((Uri)string2, taggingLibraryJsInterface.zza, (View)taggingLibraryJsInterface.zzb, null);
            } else {
                zzavl zzavl2 = taggingLibraryJsInterface.zzc;
                Context context = taggingLibraryJsInterface.zza;
                WebView webView = taggingLibraryJsInterface.zzb;
                string2 = zzavl2.zza((Uri)string2, context, (View)webView, null);
            }
        }
        catch (zzavm zzavm2) {
            com.google.android.gms.ads.internal.util.client.zzo.zzf((String)"Failed to append the click signal to URL: ", (Throwable)zzavm2);
            String string3 = "TaggingLibraryJsInterface.recordClick";
            zzv.zzp().zzw(zzavm2, string3);
        }
        taggingLibraryJsInterface.zzi.zzd(string2.toString(), null, null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static /* synthetic */ void zzf(@NonNull TaggingLibraryJsInterface taggingLibraryJsInterface, @NonNull Bundle bundle, @NonNull QueryInfoGenerationCallback queryInfoGenerationCallback) {
        Context context = taggingLibraryJsInterface.zza;
        CookieManager cookieManager = zzv.zzs().zza(context);
        boolean bl = cookieManager != null ? cookieManager.acceptThirdPartyCookies(taggingLibraryJsInterface.zzb) : false;
        bundle.putBoolean("accept_3p_cookie", bl);
        QueryInfo.generate((Context)context, (AdFormat)AdFormat.BANNER, (AdRequest)((AdRequest.Builder)new AdRequest.Builder().addNetworkExtrasBundle(AdMobAdapter.class, bundle)).build(), (QueryInfoGenerationCallback)queryInfoGenerationCallback);
    }

    TaggingLibraryJsInterface(WebView webView, zzavl zzavl2, zzdsi zzdsi2, zzfjr zzfjr2, zzfct zzfct2, zzo zzo2, zzf zzf2, zzj zzj2) {
        this.zzb = webView;
        this.zza = webView.getContext();
        this.zzc = zzavl2;
        this.zzf = zzdsi2;
        zzbcv.zza((Context)this.zza);
        webView = zzbcv.zzjR;
        this.zze = (Integer)zzbd.zzc().zzb((zzbcm)webView);
        webView = zzbcv.zzjS;
        this.zzg = (Boolean)zzbd.zzc().zzb((zzbcm)webView);
        this.zzi = zzfjr2;
        this.zzd = zzfct2;
        this.zzj = zzo2;
        this.zzk = zzf2;
        this.zzl = zzj2;
    }
}

