/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaFormat;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.client.zzbd;
import com.google.android.gms.ads.internal.util.client.zzo;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.util.zzs;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.internal.ads.zzbbf;
import com.google.android.gms.internal.ads.zzbcm;
import com.google.android.gms.internal.ads.zzbcv;
import com.google.android.gms.internal.ads.zzcar;
import com.google.android.gms.internal.ads.zzcas;
import com.google.android.gms.internal.ads.zzcat;
import com.google.android.gms.internal.ads.zzcau;
import com.google.android.gms.internal.ads.zzcav;
import com.google.android.gms.internal.ads.zzcaw;
import com.google.android.gms.internal.ads.zzcax;
import com.google.android.gms.internal.ads.zzcay;
import com.google.android.gms.internal.ads.zzcaz;
import com.google.android.gms.internal.ads.zzcbb;
import com.google.android.gms.internal.ads.zzcbc;
import com.google.android.gms.internal.ads.zzcbu;
import com.google.android.gms.internal.ads.zzcbv;
import com.google.android.gms.internal.ads.zzcbw;
import com.google.android.gms.internal.ads.zzcbx;
import com.google.android.gms.internal.ads.zzdsc;
import com.google.android.gms.internal.ads.zzdsd;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class zzcba
extends zzcbc
implements TextureView.SurfaceTextureListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener {
    private static final Map zzc = new HashMap();
    private final zzcbw zzd;
    private final zzcbx zze;
    private final boolean zzf;
    @Nullable
    private final zzdsd zzg;
    private int zzh = 0;
    private int zzi = 0;
    private MediaPlayer zzj;
    private Uri zzk;
    private int zzl;
    private int zzm;
    private int zzn;
    private zzcbu zzo;
    private final boolean zzp;
    private int zzq;
    private zzcbb zzr;
    private boolean zzs = false;
    private Integer zzt = null;

    @Override
    public final int zza() {
        if (this.zzH()) {
            return this.zzj.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public final int zzb() {
        if (Build.VERSION.SDK_INT >= 26 && this.zzH()) {
            return this.zzj.getMetrics().getInt("android.media.mediaplayer.dropped");
        }
        return -1;
    }

    @Override
    public final int zzc() {
        if (this.zzH()) {
            return this.zzj.getDuration();
        }
        return -1;
    }

    @Override
    public final int zzd() {
        zzcba zzcba2 = zzcba2.zzj;
        if (zzcba2 != null) {
            return zzcba2.getVideoHeight();
        }
        return 0;
    }

    @Override
    public final int zze() {
        zzcba zzcba2 = zzcba2.zzj;
        if (zzcba2 != null) {
            return zzcba2.getVideoWidth();
        }
        return 0;
    }

    @Override
    public final long zzf() {
        return 0L;
    }

    @Override
    public final long zzg() {
        if (this.zzt != null) {
            return this.zzh() * (long)this.zzn / 100L;
        }
        return -1L;
    }

    @Override
    public final long zzh() {
        if (this.zzt != null) {
            return (long)this.zzc() * (long)this.zzt.intValue();
        }
        return -1L;
    }

    static /* bridge */ /* synthetic */ zzcbb zzi(zzcba zzcba2) {
        return zzcba2.zzr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final String zzj() {
        Object object;
        if (!((zzcba)object).zzp) {
            object = "";
            return "MediaPlayer".concat((String)object);
        }
        object = " spherical";
        return "MediaPlayer".concat((String)object);
    }

    public final String toString() {
        String string2 = this.getClass().getName();
        String string3 = Integer.toHexString(this.hashCode());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append("@");
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    public static /* synthetic */ void zzk(zzcba object, int n) {
        object = ((zzcba)object).zzr;
        if (object != null) {
            object.onWindowVisibilityChanged(n);
            return;
        }
    }

    static /* bridge */ /* synthetic */ void zzl(zzcba zzcba2, boolean bl) {
        zzcba2.zzs = true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    static /* bridge */ /* synthetic */ void zzm(zzcba zzcba2, MediaPlayer object) {
        MediaPlayer.TrackInfo[] trackInfoArray = zzbcv.zzcc;
        if ((Boolean)zzbd.zzc().zzb((zzbcm)trackInfoArray) == false) return;
        if (zzcba2.zzd == null) return;
        if (object == null) {
            return;
        }
        try {
            trackInfoArray = object.getTrackInfo();
            if (trackInfoArray == null) return;
        }
        catch (RuntimeException runtimeException) {
            String string2 = "AdMediaPlayerView.reportMetadata";
            zzv.zzp().zzw(runtimeException, string2);
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        boolean bl = false;
        while (true) {
            void var1_4;
            if (var1_4 >= trackInfoArray.length) {
                if (hashMap.isEmpty()) return;
                zzcba2.zzd.zzd("onMetadataEvent", hashMap);
                return;
            }
            MediaPlayer.TrackInfo trackInfo = trackInfoArray[var1_4];
            if (trackInfo != null) {
                switch (trackInfo.getTrackType()) {
                    default: {
                        break;
                    }
                    case 2: {
                        String string3;
                        MediaFormat mediaFormat = trackInfo.getFormat();
                        if (mediaFormat == null) break;
                        if (mediaFormat.containsKey("mime")) {
                            string3 = mediaFormat.getString("mime");
                            hashMap.put("audioMime", string3);
                        }
                        if (Build.VERSION.SDK_INT < 30 || !mediaFormat.containsKey("codecs-string")) break;
                        String string4 = mediaFormat.getString("codecs-string");
                        hashMap.put("audioCodec", string4);
                        break;
                    }
                    case 1: {
                        String string3;
                        MediaFormat mediaFormat = trackInfo.getFormat();
                        if (mediaFormat == null) break;
                        if (mediaFormat.containsKey("frame-rate")) {
                            try {
                                hashMap.put("frameRate", String.valueOf(mediaFormat.getFloat("frame-rate")));
                            }
                            catch (ClassCastException classCastException) {
                                string3 = String.valueOf(mediaFormat.getInteger("frame-rate"));
                                hashMap.put("frameRate", string3);
                            }
                        }
                        if (mediaFormat.containsKey("bitrate")) {
                            zzcba2.zzt = mediaFormat.getInteger("bitrate");
                            string3 = String.valueOf(zzcba2.zzt);
                            hashMap.put("bitRate", string3);
                        }
                        if (mediaFormat.containsKey("width") && mediaFormat.containsKey("height")) {
                            int n = mediaFormat.getInteger("width");
                            int n2 = mediaFormat.getInteger("height");
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append(n);
                            stringBuilder.append("x");
                            stringBuilder.append(n2);
                            string3 = stringBuilder.toString();
                            hashMap.put("resolution", string3);
                        }
                        if (mediaFormat.containsKey("mime")) {
                            string3 = mediaFormat.getString("mime");
                            hashMap.put("videoMime", string3);
                        }
                        if (Build.VERSION.SDK_INT < 30 || !mediaFormat.containsKey("codecs-string")) break;
                        String string5 = mediaFormat.getString("codecs-string");
                        hashMap.put("videoCodec", string5);
                    }
                }
            }
            ++var1_4;
        }
    }

    static {
        zzc.put(-1004, "MEDIA_ERROR_IO");
        zzc.put(-1007, "MEDIA_ERROR_MALFORMED");
        zzc.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
        zzc.put(-110, "MEDIA_ERROR_TIMED_OUT");
        zzc.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        zzc.put(100, "MEDIA_ERROR_SERVER_DIED");
        Integer n = 1;
        zzc.put(n, "MEDIA_ERROR_UNKNOWN");
        String string2 = "MEDIA_INFO_UNKNOWN";
        zzc.put(n, string2);
        zzc.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzc.put(701, "MEDIA_INFO_BUFFERING_START");
        zzc.put(702, "MEDIA_INFO_BUFFERING_END");
        zzc.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzc.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzc.put(802, "MEDIA_INFO_METADATA_UPDATE");
        zzc.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
        zzc.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
    }

    public zzcba(Context context, zzcbw zzcbw2, boolean bl, boolean bl2, zzcbv zzcbv2, zzcbx zzcbx2, @Nullable zzdsd zzdsd2) {
        super(context);
        this.zzd = zzcbw2;
        this.zze = zzcbx2;
        this.zzp = bl;
        this.zzf = bl2;
        this.zze.zza(this);
        this.zzg = zzdsd2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzD() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzk == null || surfaceTexture == null) {
            return;
        }
        this.zzE(false);
        try {
            void var1_3;
            MediaPlayer mediaPlayer;
            zzv.zzl();
            this.zzj = mediaPlayer = new MediaPlayer();
            this.zzj.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzj.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzj.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzj.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzj.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzj.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzn = 0;
            boolean bl = this.zzp;
            if (bl) {
                zzdsd zzdsd2;
                zzbcm zzbcm2 = zzbcv.zznw;
                Object object = zzbd.zzc().zzb(zzbcm2);
                boolean bl2 = (Boolean)object;
                if (bl2 && (zzdsd2 = this.zzg) != null) {
                    zzdsc zzdsc2 = zzdsd2.zza();
                    zzdsc2.zzb("action", "svp_ampv");
                    zzdsc2.zzj();
                }
                this.zzo = new zzcbu(this.getContext());
                this.zzo.zzd(surfaceTexture, this.getWidth(), this.getHeight());
                zzcbu zzcbu2 = this.zzo;
                zzcbu2.start();
                SurfaceTexture surfaceTexture2 = zzcbu2.zzb();
                if (surfaceTexture2 != null) {
                    SurfaceTexture surfaceTexture3 = surfaceTexture2;
                } else {
                    this.zzo.zze();
                    this.zzo = null;
                }
            }
            this.zzj.setDataSource(this.getContext(), this.zzk);
            zzv.zzm();
            Surface surface = new Surface((SurfaceTexture)var1_3);
            this.zzj.setSurface(surface);
            this.zzj.setAudioStreamType(3);
            this.zzj.setScreenOnWhilePlaying(true);
            this.zzj.prepareAsync();
            this.zzF(1);
            return;
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            String string2 = String.valueOf(String.valueOf(this.zzk));
            com.google.android.gms.ads.internal.util.client.zzo.zzk((String)"Failed to initialize MediaPlayer at ".concat(string2), (Throwable)exception);
            zzcba zzcba2 = this;
            zzcba2.onError(zzcba2.zzj, 1, 0);
            return;
        }
    }

    protected final void onAttachedToWindow() {
        super.onAttachedToWindow();
        zzcba zzcba2 = this;
        zzcba2.setSurfaceTextureListener(zzcba2);
    }

    public final void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzn = n;
    }

    public final void onCompletion(MediaPlayer mediaPlayer) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView completion");
        this.zzF(5);
        this.zzi = 5;
        com.google.android.gms.ads.internal.util.zzs.zza.post((Runnable)new zzcat(this));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void onMeasure(int n, int n2) {
        block17: {
            int n3;
            int n4;
            block19: {
                block20: {
                    block21: {
                        int n5;
                        block26: {
                            block25: {
                                block24: {
                                    block22: {
                                        block23: {
                                            n4 = zzcba.getDefaultSize((int)((zzcba)((Object)zzcbu2)).zzl, (int)n);
                                            n3 = zzcba.getDefaultSize((int)((zzcba)((Object)zzcbu2)).zzm, (int)n2);
                                            if (((zzcba)((Object)zzcbu2)).zzl <= 0) break block19;
                                            if (((zzcba)((Object)zzcbu2)).zzm <= 0) break block20;
                                            if (((zzcba)((Object)zzcbu2)).zzo != null) break block21;
                                            n4 = View.MeasureSpec.getMode((int)n);
                                            n3 = View.MeasureSpec.getSize((int)n);
                                            n5 = View.MeasureSpec.getMode((int)n2);
                                            n2 = View.MeasureSpec.getSize((int)n2);
                                            if (n4 != 0x40000000) break block22;
                                            if (n5 != 0x40000000) break block23;
                                            n = ((zzcba)((Object)zzcbu2)).zzl;
                                            n4 = n * n2;
                                            n5 = ((zzcba)((Object)zzcbu2)).zzm;
                                            int n6 = n3 * n5;
                                            if (n4 < n6) {
                                                n = n4 / n5;
                                                break block17;
                                            } else if (n4 > n6) {
                                                int n7 = n6 / n;
                                                n = n3;
                                                n2 = n7;
                                                break block17;
                                            } else {
                                                n = n3;
                                            }
                                            break block17;
                                        }
                                        n = 0x40000000;
                                        break block24;
                                    }
                                    n = n4;
                                }
                                if (n != 0x40000000) break block25;
                                n = n3 * ((zzcba)((Object)zzcbu2)).zzm / ((zzcba)((Object)zzcbu2)).zzl;
                                if (n5 == Integer.MIN_VALUE) {
                                    if (n > n2) {
                                        n = n3;
                                        break block17;
                                    } else {
                                        int n8 = n;
                                        n = n3;
                                        n2 = n8;
                                    }
                                    break block17;
                                } else {
                                    int n9 = n;
                                    n = n3;
                                    n2 = n9;
                                }
                                break block17;
                            }
                            if (n5 != 0x40000000) break block26;
                            n4 = n2 * ((zzcba)((Object)zzcbu2)).zzl / ((zzcba)((Object)zzcbu2)).zzm;
                            n = n == Integer.MIN_VALUE ? (n4 > n3 ? n3 : n4) : n4;
                            break block17;
                        }
                        int n10 = ((zzcba)((Object)zzcbu2)).zzl;
                        int n11 = ((zzcba)((Object)zzcbu2)).zzm;
                        if (n5 == Integer.MIN_VALUE) {
                            if (n11 > n2) {
                                int n12 = n2;
                                n2 = n12 * n10 / n11;
                                n4 = n12;
                            } else {
                                n2 = n10;
                                n4 = n11;
                            }
                        } else {
                            n2 = n10;
                            n4 = n11;
                        }
                        if (n == Integer.MIN_VALUE) {
                            if (n2 > n3) {
                                n = n3;
                                n2 = n3 * n11 / n10;
                                break block17;
                            } else {
                                n = n2;
                                n2 = n4;
                            }
                            break block17;
                        } else {
                            n = n2;
                            n2 = n4;
                        }
                        break block17;
                    }
                    n = n4;
                    n2 = n3;
                    break block17;
                }
                n = n4;
                n2 = n3;
                break block17;
            }
            n = n4;
            n2 = n3;
        }
        zzcbu2.setMeasuredDimension(n, n2);
        zzcbu zzcbu2 = ((zzcba)((Object)zzcbu2)).zzo;
        if (zzcbu2 != null) {
            zzcbu2.zzc(n, n2);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void onPrepared(MediaPlayer mediaPlayer) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView prepared");
        this.zzF(2);
        this.zze.zzb();
        com.google.android.gms.ads.internal.util.zzs.zza.post((Runnable)new zzcas(this, mediaPlayer));
        this.zzl = mediaPlayer.getVideoWidth();
        this.zzm = mediaPlayer.getVideoHeight();
        int n = this.zzq;
        if (n != 0) {
            this.zzq(n);
        }
        if (this.zzf && this.zzH() && this.zzj.getCurrentPosition() > 0 && this.zzi != 3) {
            com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView nudging MediaPlayer");
            this.zzG(0.0f);
            this.zzj.start();
            n = this.zzj.getCurrentPosition();
            long l = zzv.zzD().currentTimeMillis();
            while (this.zzH() && this.zzj.getCurrentPosition() == n && zzv.zzD().currentTimeMillis() - l <= 250L) {
            }
            this.zzj.pause();
            this.zzn();
        }
        n = this.zzl;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdMediaPlayerView stream dimensions: ");
        stringBuilder.append(n);
        stringBuilder.append(" x ");
        stringBuilder.append(this.zzm);
        com.google.android.gms.ads.internal.util.client.zzo.zzi((String)stringBuilder.toString());
        if (this.zzi == 3) {
            this.zzp();
        }
        this.zzn();
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView surface created");
        this.zzD();
        com.google.android.gms.ads.internal.util.zzs.zza.post((Runnable)new zzcav(this));
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        zzcbu zzcbu2;
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView surface changed");
        int n3 = this.zzi;
        int n4 = this.zzl == n ? (this.zzm == n2 ? 1 : 0) : 0;
        if (this.zzj != null && n3 == 3 && n4 != 0) {
            n4 = this.zzq;
            if (n4 != 0) {
                this.zzq(n4);
            }
            this.zzp();
        }
        if ((zzcbu2 = this.zzo) != null) {
            zzcbu2.zzc(n, n2);
        }
        com.google.android.gms.ads.internal.util.zzs.zza.post((Runnable)new zzcaw(this, n, n2));
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zze.zzf(this);
        zzcbb zzcbb2 = this.zzr;
        this.zza.zza(surfaceTexture, zzcbb2);
    }

    @Override
    public final void zzn() {
        zzcba zzcba2 = this;
        zzcba2.zzG(zzcba2.zzb.zza());
    }

    public final void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdMediaPlayerView size changed: ");
        stringBuilder.append(n);
        stringBuilder.append(" x ");
        stringBuilder.append(n2);
        com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        this.zzl = mediaPlayer.getVideoWidth();
        this.zzm = n3 = mediaPlayer.getVideoHeight();
        if (this.zzl != 0 && n3 != 0) {
            this.requestLayout();
            return;
        }
    }

    protected final void onWindowVisibilityChanged(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdMediaPlayerView window visibility changed to ");
        stringBuilder.append(n);
        com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        com.google.android.gms.ads.internal.util.zzs.zza.post((Runnable)new zzcar(this, n));
        super.onWindowVisibilityChanged(n);
    }

    @Override
    public final void zzo() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView pause");
        if (this.zzH() && this.zzj.isPlaying()) {
            this.zzj.pause();
            this.zzF(4);
            com.google.android.gms.ads.internal.util.zzs.zza.post((Runnable)new zzcaz(this));
        }
        this.zzi = 4;
    }

    @Override
    public final void zzp() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView play");
        if (this.zzH()) {
            this.zzj.start();
            this.zzF(3);
            this.zza.zzb();
            com.google.android.gms.ads.internal.util.zzs.zza.post((Runnable)new zzcay(this));
        }
        this.zzi = 3;
    }

    private final void zzE(boolean bl) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView release");
        zzcbu zzcbu2 = this.zzo;
        if (zzcbu2 != null) {
            zzcbu2.zze();
            this.zzo = null;
        }
        if ((zzcbu2 = this.zzj) != null) {
            zzcbu2.reset();
            this.zzj.release();
            this.zzj = null;
            this.zzF(0);
            if (bl) {
                this.zzi = 0;
                return;
            }
        }
    }

    @Override
    public final void zzq(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdMediaPlayerView seek ");
        stringBuilder.append(n);
        com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        if (this.zzH()) {
            this.zzj.seekTo(n);
            this.zzq = 0;
            return;
        }
        this.zzq = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzF(int n) {
        if (n == 3) {
            this.zze.zzc();
            this.zzb.zzb();
        } else if (this.zzh == 3) {
            this.zze.zze();
            this.zzb.zzc();
        }
        this.zzh = n;
    }

    @Override
    public final void zzr(zzcbb zzcbb2) {
        this.zzr = zzcbb2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzG(float f) {
        zzcba zzcba2;
        zzcba2 = zzcba2.zzj;
        if (zzcba2 == null) {
            com.google.android.gms.ads.internal.util.client.zzo.zzj((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
            return;
        }
        try {
            float f2 = f;
            zzcba2.setVolume(f2, f2);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
    }

    @Override
    public final void zzs(@Nullable String string2) {
        zzbbf zzbbf2 = zzbbf.zza((Uri)(string2 = Uri.parse((String)string2)));
        if (zzbbf2 == null || zzbbf2.zza != null) {
            if (zzbbf2 != null) {
                string2 = Uri.parse((String)zzbbf2.zza);
            }
            this.zzk = string2;
            this.zzq = 0;
            this.zzD();
            this.requestLayout();
            this.invalidate();
            return;
        }
    }

    @Override
    public final void zzt() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView stop");
        MediaPlayer mediaPlayer = this.zzj;
        if (mediaPlayer != null) {
            mediaPlayer.stop();
            this.zzj.release();
            this.zzj = null;
            this.zzF(0);
            this.zzi = 0;
        }
        this.zze.zzd();
    }

    @Override
    public final void zzu(float f, float f2) {
        zzcbu zzcbu2 = ((zzcba)((Object)zzcbu2)).zzo;
        if (zzcbu2 != null) {
            zzcbu2.zzf(f, f2);
            return;
        }
    }

    static /* bridge */ /* synthetic */ boolean zzv(zzcba zzcba2) {
        return zzcba2.zzs;
    }

    private final boolean zzH() {
        int n;
        return this.zzj != null && (n = this.zzh) != -1 && n != 0 && n != 1;
    }

    public final boolean onError(MediaPlayer object, int n, int n2) {
        Map map = zzc;
        object = (String)map.get(n);
        String string2 = (String)map.get(n2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdMediaPlayerView MediaPlayer error: ");
        stringBuilder.append((String)object);
        stringBuilder.append(":");
        stringBuilder.append(string2);
        com.google.android.gms.ads.internal.util.client.zzo.zzj((String)stringBuilder.toString());
        this.zzF(-1);
        this.zzi = -1;
        com.google.android.gms.ads.internal.util.zzs.zza.post((Runnable)new zzcau(this, (String)object, string2));
        return true;
    }

    public final boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
        Map map = zzc;
        String string2 = (String)map.get(n);
        String string3 = (String)map.get(n2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdMediaPlayerView MediaPlayer info: ");
        stringBuilder.append(string2);
        stringBuilder.append(":");
        stringBuilder.append(string3);
        com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        return true;
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture object) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView surface destroyed");
        object = this.zzj;
        if (object != null && this.zzq == 0) {
            this.zzq = object.getCurrentPosition();
        }
        if ((object = this.zzo) != null) {
            ((zzcbu)object).zze();
        }
        com.google.android.gms.ads.internal.util.zzs.zza.post((Runnable)new zzcax(this));
        this.zzE(true);
        return true;
    }
}

