/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Message;
import android.view.View;
import android.view.WindowManager;
import android.webkit.ConsoleMessage;
import android.webkit.GeolocationPermissions;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.client.zzbd;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.util.client.zzo;
import com.google.android.gms.ads.internal.util.zzs;
import com.google.android.gms.ads.internal.zzb;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.internal.ads.zzbcm;
import com.google.android.gms.internal.ads.zzbcv;
import com.google.android.gms.internal.ads.zzcet;
import com.google.android.gms.internal.ads.zzceu;
import com.google.android.gms.internal.ads.zzcev;
import com.google.android.gms.internal.ads.zzcew;
import com.google.android.gms.internal.ads.zzcex;
import com.google.android.gms.internal.ads.zzcey;
import com.google.android.gms.internal.ads.zzcez;
import com.google.android.gms.internal.ads.zzcfb;

public final class zzcfa
extends WebChromeClient {
    private final zzcfb zza;

    public zzcfa(zzcfb zzcfb2) {
        this.zza = zzcfb2;
    }

    public final void onCloseWindow(WebView webView) {
        if (!(webView instanceof zzcfb)) {
            zzo.zzj((String)"Tried to close a WebView that wasn't an AdWebView.");
            return;
        }
        zzm zzm2 = ((zzcfb)webView).zzL();
        if (zzm2 == null) {
            zzo.zzj((String)"Tried to close an AdWebView not associated with an overlay.");
            return;
        }
        zzm2.zzb();
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void onExceededDatabaseQuota(String string2, String string3, long l, long l2, long l3, WebStorage.QuotaUpdater quotaUpdater) {
        long l4;
        long l5 = 0x500000L - l3;
        if (l5 <= 0L) {
            quotaUpdater.updateQuota(l);
            return;
        }
        if (l == 0L) {
            long l6 = l2 <= l5 ? (l2 <= 0x100000L ? l2 : 0L) : 0L;
            l4 = l6;
        } else if (l2 == 0L) {
            l4 = Math.min(l + Math.min(131072L, l5), 0x100000L);
        } else {
            if (l2 <= Math.min(0x100000L - l, l5)) {
                l += l2;
            }
            l4 = l;
        }
        quotaUpdater.updateQuota(l4);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void onGeolocationPermissionsShowPrompt(String string2, GeolocationPermissions.Callback callback) {
        if (callback != null) {
            boolean bl;
            zzcfb zzcfb2 = ((zzcfa)((Object)zzcfb2)).zza;
            zzv.zzr();
            if (!zzs.zzB(zzcfb2.getContext(), "android.permission.ACCESS_FINE_LOCATION")) {
                zzv.zzr();
                bl = zzs.zzB(zzcfb2.getContext(), "android.permission.ACCESS_COARSE_LOCATION");
            } else {
                bl = true;
            }
            zzbcm zzbcm2 = zzbcv.zznt;
            if (((Boolean)zzbd.zzc().zzb(zzbcm2)).booleanValue()) {
                callback.invoke(string2, false, true);
            } else {
                callback.invoke(string2, bl, true);
            }
            zzbcm zzbcm3 = zzbcv.zznu;
            if (((Boolean)zzbd.zzc().zzb(zzbcm3)).booleanValue()) {
                zzo.zze((String)"AdWebChromeClient.onGeolocationPermissionsShowPrompt()");
                return;
            }
        }
    }

    public final void onHideCustomView() {
        zzm zzm2 = ((zzcfa)((Object)zzm2)).zza.zzL();
        if (zzm2 == null) {
            zzo.zzj((String)"Could not get ad overlay when hiding custom view.");
            return;
        }
        zzm2.zzg();
    }

    public final void onShowCustomView(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.onShowCustomView(view, -1, customViewCallback);
    }

    @Deprecated
    public final void onShowCustomView(View view, int n, WebChromeClient.CustomViewCallback customViewCallback) {
        zzm zzm2 = ((zzcfa)((Object)zzm2)).zza.zzL();
        if (zzm2 == null) {
            zzo.zzj((String)"Could not get ad overlay when showing custom view.");
            customViewCallback.onCustomViewHidden();
            return;
        }
        zzm2.zzC(view, customViewCallback);
        zzm2.zzA(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        String string2 = consoleMessage.message();
        String string3 = consoleMessage.sourceId();
        int n = consoleMessage.lineNumber();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("JS: ");
        stringBuilder.append(string2);
        stringBuilder.append(" (");
        stringBuilder.append(string3);
        stringBuilder.append(":");
        stringBuilder.append(n);
        stringBuilder.append(")");
        string2 = stringBuilder.toString();
        if (string2.contains("Application Cache")) {
            return super.onConsoleMessage(consoleMessage);
        }
        switch (zzcez.zza[consoleMessage.messageLevel().ordinal()]) {
            default: {
                zzo.zzi((String)string2);
                return super.onConsoleMessage(consoleMessage);
            }
            case 5: {
                zzo.zze((String)string2);
                return super.onConsoleMessage(consoleMessage);
            }
            case 3: 
            case 4: {
                zzo.zzi((String)string2);
                return super.onConsoleMessage(consoleMessage);
            }
            case 2: {
                zzo.zzj((String)string2);
                return super.onConsoleMessage(consoleMessage);
            }
            case 1: 
        }
        zzo.zzg((String)string2);
        return super.onConsoleMessage(consoleMessage);
    }

    public final boolean onCreateWindow(WebView webView, boolean bl, boolean bl2, Message message) {
        WebView.WebViewTransport webViewTransport = (WebView.WebViewTransport)message.obj;
        WebView webView2 = new WebView(webView.getContext());
        zzcfb zzcfb2 = ((zzcfa)((Object)zzcfb2)).zza;
        if (zzcfb2.zzH() != null) {
            webView2.setWebViewClient(zzcfb2.zzH());
        }
        webViewTransport.setWebView(webView2);
        message.sendToTarget();
        return true;
    }

    public final boolean onJsAlert(WebView webView, String string2, String string3, JsResult jsResult) {
        return this.zza(zzcfa.zzb(webView), "alert", string2, string3, null, jsResult, null, false);
    }

    public final boolean onJsBeforeUnload(WebView webView, String string2, String string3, JsResult jsResult) {
        return this.zza(zzcfa.zzb(webView), "onBeforeUnload", string2, string3, null, jsResult, null, false);
    }

    public final boolean onJsConfirm(WebView webView, String string2, String string3, JsResult jsResult) {
        return this.zza(zzcfa.zzb(webView), "confirm", string2, string3, null, jsResult, null, false);
    }

    public final boolean onJsPrompt(WebView webView, String string2, String string3, String string4, JsPromptResult jsPromptResult) {
        return this.zza(zzcfa.zzb(webView), "prompt", string2, string3, string4, null, jsPromptResult, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean zza(Context context, String string2, String string3, String string4, String string5, JsResult jsResult, JsPromptResult jsPromptResult, boolean bl) {
        block12: {
            Object object;
            block11: {
                try {
                    object = ((zzcfa)((Object)object)).zza;
                    if (object == null) break block11;
                }
                catch (WindowManager.BadTokenException badTokenException) {
                    zzo.zzk((String)"Fail to display Dialog.", (Throwable)badTokenException);
                    return true;
                }
                Object object2 = object.zzN();
                if (object2 == null) break block11;
                object2 = object.zzN().zzd();
                if (object2 == null) break block11;
                object = object.zzN().zzd();
                if (object == null) break block11;
                boolean bl2 = ((zzb)object).zzc();
                if (bl2) break block11;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("window.");
                stringBuilder.append(string2);
                stringBuilder.append("('");
                stringBuilder.append(string4);
                stringBuilder.append("')");
                ((zzb)object).zzb(stringBuilder.toString());
                return false;
            }
            zzv.zzr();
            object = zzs.zzL(context);
            object.setTitle((CharSequence)string3);
            if (!bl) break block12;
            LinearLayout linearLayout = new LinearLayout(context);
            linearLayout.setOrientation(1);
            TextView textView = new TextView(context);
            textView.setText((CharSequence)string4);
            string2 = new EditText(context);
            string2.setText((CharSequence)string5);
            linearLayout.addView((View)textView);
            linearLayout.addView((View)string2);
            object.setView((View)linearLayout).setPositiveButton(17039370, (DialogInterface.OnClickListener)new zzcey(jsPromptResult, (EditText)string2)).setNegativeButton(0x1040000, (DialogInterface.OnClickListener)new zzcex(jsPromptResult)).setOnCancelListener((DialogInterface.OnCancelListener)new zzcew(jsPromptResult)).create().show();
            return true;
        }
        object.setMessage((CharSequence)string4).setPositiveButton(17039370, (DialogInterface.OnClickListener)new zzcev(jsResult)).setNegativeButton(0x1040000, (DialogInterface.OnClickListener)new zzceu(jsResult)).setOnCancelListener((DialogInterface.OnCancelListener)new zzcet(jsResult)).create().show();
        return true;
    }

    private static final Context zzb(WebView object) {
        if (!(object instanceof zzcfb)) {
            return object.getContext();
        }
        Activity activity = (object = (zzcfb)object).zzi();
        if (activity != null) {
            return activity;
        }
        return object.getContext();
    }
}

