/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.RemoteException;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.client.zzea;
import com.google.android.gms.ads.internal.util.client.zzo;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbfs;
import com.google.android.gms.internal.ads.zzbgd;
import com.google.android.gms.internal.ads.zzbmi;
import com.google.android.gms.internal.ads.zzbmm;
import com.google.android.gms.internal.ads.zzcan;
import com.google.android.gms.internal.ads.zzcqx;
import com.google.android.gms.internal.ads.zzdij;
import com.google.android.gms.internal.ads.zzdio;
import com.google.android.gms.internal.ads.zzdms;
import java.util.Collections;

public final class zzdmt
extends zzbmi
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener,
zzbfs {
    private View zza;
    private zzea zzb;
    private zzdij zzc;
    private boolean zzd;
    private boolean zze;

    @Nullable
    public final zzea zzb() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzd) {
            zzo.zzg((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        return this.zzb;
    }

    @Nullable
    public final zzbgd zzc() {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (((zzdmt)((Object)zzdij2)).zzd) {
            zzo.zzg((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        zzdij zzdij2 = ((zzdmt)((Object)zzdij2)).zzc;
        if (zzdij2 != null && zzdij2.zzc() != null) {
            return zzdij2.zzc().zza();
        }
        return null;
    }

    public zzdmt(zzdij zzdij2, zzdio zzdio2) {
        this.zza = zzdio2.zzf();
        this.zzb = zzdio2.zzj();
        this.zzc = zzdij2;
        this.zzd = false;
        this.zze = false;
        if (zzdio2.zzs() != null) {
            zzdio2.zzs().zzap(this);
            return;
        }
    }

    public final void zzd() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        this.zzh();
        zzdij zzdij2 = this.zzc;
        if (zzdij2 != null) {
            ((zzcqx)zzdij2).zzb();
        }
        this.zzc = null;
        this.zza = null;
        this.zzb = null;
        this.zzd = true;
    }

    private final void zzg() {
        View view;
        zzdij zzdij2 = this.zzc;
        if (zzdij2 != null && (view = this.zza) != null) {
            zzdij2.zzB(view, Collections.emptyMap(), Collections.emptyMap(), zzdij.zzY(this.zza));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzh() {
        View view = this.zza;
        if (view == null || !((view = view.getParent()) instanceof ViewGroup)) {
            return;
        }
        ((ViewGroup)view).removeView(this.zza);
    }

    public final void onGlobalLayout() {
        this.zzg();
    }

    public final void onScrollChanged() {
        this.zzg();
    }

    public final void zze(IObjectWrapper iObjectWrapper) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        this.zzf(iObjectWrapper, (zzbmm)new zzdms(this));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzf(IObjectWrapper iObjectWrapper, zzbmm zzbmm2) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (((zzdmt)((Object)string2)).zzd) {
            zzo.zzg((String)"Instream ad can not be shown after destroy().");
            zzdmt.zzi(zzbmm2, 2);
            return;
        }
        View view = ((zzdmt)((Object)string2)).zza;
        if (view == null || ((zzdmt)((Object)string2)).zzb == null) {
            String string2 = view == null ? "can not get video view." : "can not get video controller.";
            zzo.zzg((String)"Instream internal error: ".concat(string2));
            zzdmt.zzi(zzbmm2, 0);
            return;
        }
        if (((zzdmt)((Object)string2)).zze) {
            zzo.zzg((String)"Instream ad should not be used again.");
            zzdmt.zzi(zzbmm2, 1);
            return;
        }
        ((zzdmt)((Object)string2)).zze = true;
        super.zzh();
        ((ViewGroup)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)).addView(((zzdmt)((Object)string2)).zza, new ViewGroup.LayoutParams(-1, -1));
        zzv.zzz();
        zzcan.zza(((zzdmt)((Object)string2)).zza, (ViewTreeObserver.OnGlobalLayoutListener)string2);
        zzv.zzz();
        zzcan.zzb(((zzdmt)((Object)string2)).zza, (ViewTreeObserver.OnScrollChangedListener)string2);
        super.zzg();
        try {
            zzbmm2.zzf();
            return;
        }
        catch (RemoteException remoteException) {
            zzo.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    private static final void zzi(zzbmm zzbmm2, int n) {
        try {
            zzbmm2.zze(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzo.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }
}

