/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.RemoteException;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import com.google.android.gms.ads.impl.R;
import com.google.android.gms.ads.internal.client.zzbd;
import com.google.android.gms.ads.internal.offline.buffering.zza;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.util.client.zzo;
import com.google.android.gms.ads.internal.util.client.zzu;
import com.google.android.gms.ads.internal.util.zzbr;
import com.google.android.gms.ads.internal.util.zzs;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbcm;
import com.google.android.gms.internal.ads.zzbcv;
import com.google.android.gms.internal.ads.zzbtd;
import com.google.android.gms.internal.ads.zzdio;
import com.google.android.gms.internal.ads.zzdsc;
import com.google.android.gms.internal.ads.zzdsd;
import com.google.android.gms.internal.ads.zzebh;
import com.google.android.gms.internal.ads.zzebl;
import com.google.android.gms.internal.ads.zzebm;
import com.google.android.gms.internal.ads.zzebt;
import com.google.android.gms.internal.ads.zzebv;
import com.google.android.gms.internal.ads.zzebw;
import com.google.android.gms.internal.ads.zzebx;
import com.google.android.gms.internal.ads.zzeby;
import com.google.android.gms.internal.ads.zzebz;
import com.google.android.gms.internal.ads.zzeca;
import com.google.android.gms.internal.ads.zzecb;
import com.google.android.gms.internal.ads.zzecc;
import com.google.android.gms.internal.ads.zzecd;
import com.google.android.gms.internal.ads.zzecg;
import com.google.android.gms.internal.ads.zzfrz;
import com.google.android.gms.internal.ads.zzfyf;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.xmlpull.v1.XmlPullParser;

public final class zzece
extends zzbtd {
    @VisibleForTesting
    final Map zza = new HashMap();
    private final Context zzb;
    private final zzdsd zzc;
    private final zzu zzd;
    private final zzebt zze;
    private String zzf;
    private String zzg;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final AlertDialog zzs(Activity activity, @Nullable zzm zzm2) {
        zzv.zzr();
        zzm2 = zzs.zzL((Context)activity).setOnCancelListener((DialogInterface.OnCancelListener)new zzebw(zzm2));
        XmlResourceParser xmlResourceParser = zzece.zzt(R.layout.offline_ads_dialog);
        if (xmlResourceParser == null) {
            zzm2.setMessage(zzece.zzv(R.string.offline_dialog_text, "Thanks for your interest.\nWe will share more once you're back online."));
            return zzm2.create();
        }
        try {
            activity = activity.getLayoutInflater().inflate((XmlPullParser)xmlResourceParser, null);
        }
        catch (Resources.NotFoundException notFoundException) {
            zzm2.setMessage(zzece.zzv(R.string.offline_dialog_text, "Thanks for your interest.\nWe will share more once you're back online."));
            return zzm2.create();
        }
        zzm2.setView((View)activity);
        String string2 = ((zzece)((Object)this)).zzu();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            TextView textView = (TextView)activity.findViewById(R.id.offline_dialog_advertiser_name);
            textView.setVisibility(0);
            textView.setText((CharSequence)string2);
        }
        if ((this = (this = (zzebl)((zzece)((Object)this)).zza.get(((zzece)((Object)this)).zzf)) == null ? null : ((zzebl)this).zza()) != null) {
            ((ImageView)activity.findViewById(R.id.offline_dialog_image)).setImageDrawable((Drawable)this);
        }
        AlertDialog alertDialog = zzm2.create();
        alertDialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        return alertDialog;
    }

    @Nullable
    private static XmlResourceParser zzt(int n) {
        Resources resources = zzv.zzp().zze();
        if (resources == null) {
            return null;
        }
        try {
            XmlResourceParser xmlResourceParser = resources.getLayout(n);
            return xmlResourceParser;
        }
        catch (Resources.NotFoundException notFoundException) {
            return null;
        }
    }

    @Nullable
    private final String zzu() {
        zzebl zzebl2 = (zzebl)((zzece)((Object)zzebl2)).zza.get(((zzece)((Object)zzebl2)).zzf);
        if (zzebl2 == null) {
            return "";
        }
        return zzebl2.zzb();
    }

    private static String zzv(int n, String string2) {
        Resources resources = zzv.zzp().zze();
        if (resources == null) {
            return string2;
        }
        try {
            String string3 = resources.getString(n);
            return string3;
        }
        catch (Resources.NotFoundException notFoundException) {
            return string2;
        }
    }

    public static /* synthetic */ void zzc(zzece zzece2, zzm zzm2, DialogInterface object, int n) {
        zzece2.zze.zzc(zzece2.zzf);
        object = new HashMap();
        object.put("dialog_action", "dismiss");
        zzece zzece3 = zzece2;
        zzece3.zzw(zzece3.zzf, "rtsdc", (Map)object);
        if (zzm2 != null) {
            zzm2.zzb();
            return;
        }
    }

    public static /* synthetic */ void zzd(zzece zzece2, zzm zzm2, DialogInterface object) {
        zzece2.zze.zzc(zzece2.zzf);
        object = new HashMap();
        object.put("dialog_action", "dismiss");
        zzece zzece3 = zzece2;
        zzece3.zzw(zzece3.zzf, "rtsdc", (Map)object);
        if (zzm2 != null) {
            zzm2.zzb();
            return;
        }
    }

    public static /* synthetic */ void zzk(zzece zzece2, Activity activity, zzm zzm2, DialogInterface object, int n) {
        object = new HashMap();
        object.put("dialog_action", "confirm");
        zzece zzece3 = zzece2;
        zzece3.zzw(zzece3.zzf, "rtsdc", (Map)object);
        Activity activity2 = activity;
        activity2.startActivity(zzv.zzs().zzf(activity2));
        zzece2.zzx();
        if (zzm2 != null) {
            zzm2.zzb();
            return;
        }
    }

    public static /* synthetic */ void zzl(zzece zzece2, zzm zzm2, DialogInterface object, int n) {
        zzece2.zze.zzc(zzece2.zzf);
        object = new HashMap();
        object.put("dialog_action", "dismiss");
        zzece zzece3 = zzece2;
        zzece3.zzw(zzece3.zzf, "dialog_click", (Map)object);
        if (zzm2 != null) {
            zzm2.zzb();
            return;
        }
    }

    public static /* synthetic */ void zzm(zzece zzece2, Activity activity, zzm zzm2, DialogInterface object, int n) {
        object = new HashMap();
        object.put("dialog_action", "confirm");
        zzece zzece3 = zzece2;
        zzece3.zzw(zzece3.zzf, "dialog_click", (Map)object);
        zzece2.zzy(activity, zzm2);
    }

    public static /* synthetic */ void zzn(zzece zzece2, zzm zzm2, DialogInterface object) {
        zzece2.zze.zzc(zzece2.zzf);
        object = new HashMap();
        object.put("dialog_action", "dismiss");
        zzece zzece3 = zzece2;
        zzece3.zzw(zzece3.zzf, "dialog_click", (Map)object);
        if (zzm2 != null) {
            zzm2.zzb();
            return;
        }
    }

    @VisibleForTesting
    public zzece(Context context, zzebt zzebt2, zzu zzu2, zzdsd zzdsd2) {
        this.zzb = context;
        this.zzc = zzdsd2;
        this.zzd = zzu2;
        this.zze = zzebt2;
    }

    private final void zzw(String string2, String string3, Map map) {
        zzece.zzp(this.zzb, this.zzc, this.zze, string2, string3, map);
    }

    public static void zzo(Context context, zzdsd zzdsd2, zzebt zzebt2, String string2, String string3) {
        zzece.zzp(context, zzdsd2, zzebt2, string2, string3, new HashMap());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static void zzp(Context object, zzdsd object2, zzebt zzebt2, String string2, String object3, Map map) {
        object = true != zzv.zzp().zzA((Context)object) ? "offline" : "online";
        if (object2 != null) {
            void var5_7;
            object2 = ((zzdsd)object2).zza();
            ((zzdsc)object2).zzb("gqi", string2);
            ((zzdsc)object2).zzb("action", (String)object3);
            ((zzdsc)object2).zzb("device_connectivity", (String)object);
            object = String.valueOf(zzv.zzD().currentTimeMillis());
            ((zzdsc)object2).zzb("event_timestamp", (String)object);
            for (Map.Entry entry : var5_7.entrySet()) {
                ((zzdsc)object2).zzb((String)entry.getKey(), (String)entry.getValue());
            }
            object = ((zzdsc)object2).zze();
        } else {
            object = "";
        }
        zzebt2.zzd(new zzebv(zzv.zzD().currentTimeMillis(), string2, (String)object, 2));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zze(Intent intent) {
        String string2;
        String string3;
        block9: {
            HashMap<String, String> hashMap;
            int n;
            string3 = intent.getStringExtra("offline_notification_action");
            if (string3 != null && (string3.equals("offline_notification_clicked") || string3.equals("offline_notification_dismissed"))) {
                string2 = intent.getStringExtra("gws_query_id");
                String string4 = intent.getStringExtra("uri");
                Context context = this.zzb;
                n = zzv.zzp().zzA(context);
                hashMap = new HashMap<String, String>();
                if (string3.equals("offline_notification_clicked")) {
                    hashMap.put("offline_notification_action", "offline_notification_clicked");
                    n = 1 != n ? 2 : 1;
                    string3 = String.valueOf(Build.VERSION.SDK_INT);
                    hashMap.put("obvs", string3);
                    string3 = String.valueOf(string4.startsWith("http"));
                    hashMap.put("olaih", string3);
                    string3 = context.getPackageManager().getLaunchIntentForPackage(string4);
                    if (string3 == null) {
                        Intent intent2 = new Intent("android.intent.action.VIEW");
                        intent2.setData(Uri.parse((String)string4));
                        string3 = intent2;
                    }
                    string3.addFlags(0x10000000);
                    context.startActivity((Intent)string3);
                    hashMap.put("olaa", "olas");
                } else {
                    hashMap.put("offline_notification_action", "offline_notification_dismissed");
                    n = 2;
                }
            } else {
                return;
                catch (ActivityNotFoundException activityNotFoundException) {
                    hashMap.put("olaa", "olaf");
                }
            }
            this.zzw(string2, "offline_notification_action", hashMap);
            try {
                string3 = this.zze.getWritableDatabase();
                if (n != 1) break block9;
                this.zze.zzg((SQLiteDatabase)string3, this.zzd, string2);
                return;
            }
            catch (SQLiteException sQLiteException) {
                zzo.zzg((String)"Failed to get writable offline buffering database: ".concat(((Object)((Object)sQLiteException)).toString()));
                return;
            }
        }
        zzebt.zzi((SQLiteDatabase)string3, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzf(String[] activity, int[] nArray, IObjectWrapper object) {
        int n = 0;
        while (true) {
            if (n >= ((Activity)activity).length) {
                return;
            }
            if (activity[n].equals("android.permission.POST_NOTIFICATIONS")) break;
            ++n;
        }
        zzecg zzecg2 = (zzecg)ObjectWrapper.unwrap((IObjectWrapper)object);
        activity = zzecg2.zza();
        object = zzecg2.zzb();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (nArray[n] == 0) {
            hashMap.put("dialog_action", "confirm");
            this.zzx();
            this.zzz(activity, (zzm)object);
        } else {
            hashMap.put("dialog_action", "dismiss");
            if (object != null) {
                ((zzm)object).zzb();
            }
        }
        zzece zzece2 = this;
        zzece2.zzw(zzece2.zzf, "asnpdc", hashMap);
    }

    public final void zzg(IObjectWrapper iObjectWrapper) {
        zzece zzece2 = this;
        zzecg zzecg2 = (zzecg)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        iObjectWrapper = zzecg2.zza();
        zzm zzm2 = zzecg2.zzb();
        zzece2.zzf = zzecg2.zzc();
        zzece2.zzg = zzecg2.zzd();
        zzbcm zzbcm2 = zzbcv.zziK;
        if (!((Boolean)zzbd.zzc().zzb(zzbcm2)).booleanValue()) {
            zzece zzece3 = this;
            zzece3.zzw(zzece3.zzf, "dialog_impression", zzfyf.zzd());
            zzv.zzr();
            AlertDialog.Builder builder = zzs.zzL((Context)iObjectWrapper);
            builder.setTitle((CharSequence)zzece.zzv(R.string.offline_opt_in_title, "Open ad when you're back online.")).setMessage((CharSequence)zzece.zzv(R.string.offline_opt_in_message, "We'll send you a notification with a link to the advertiser site.")).setPositiveButton((CharSequence)zzece.zzv(R.string.offline_opt_in_confirm, "OK"), (DialogInterface.OnClickListener)new zzeca(this, (Activity)iObjectWrapper, zzm2)).setNegativeButton((CharSequence)zzece.zzv(R.string.offline_opt_in_decline, "No thanks"), (DialogInterface.OnClickListener)new zzecb(this, zzm2)).setOnCancelListener((DialogInterface.OnCancelListener)new zzecc(this, zzm2));
            builder.create().show();
            return;
        }
        this.zzy((Activity)iObjectWrapper, zzm2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzx() {
        boolean bl;
        block5: {
            zzv.zzr();
            Context context = this.zzb;
            zzbr zzbr2 = zzs.zzA(context);
            IObjectWrapper iObjectWrapper = ObjectWrapper.wrap((Object)context);
            String string2 = this.zzg;
            String string3 = this.zzf;
            Object object = this.zza;
            object = (zzebl)object.get(string3);
            object = object == null ? "" : ((zzebl)object).zzc();
            zza zza2 = new zza(string2, string3, (String)object);
            bl = zzbr2.zzg(iObjectWrapper, zza2);
            if (bl) return;
            bl = zzbr2.zzf(ObjectWrapper.wrap((Object)context), this.zzg, this.zzf);
            break block5;
            catch (RemoteException remoteException) {
                RemoteException remoteException2;
                boolean bl2;
                block6: {
                    bl2 = false;
                    break block6;
                    catch (RemoteException remoteException3) {
                        remoteException2 = remoteException3;
                        bl2 = bl;
                    }
                }
                zzo.zzh((String)"Failed to schedule offline notification poster.", (Throwable)remoteException2);
                bl = bl2;
            }
        }
        if (bl) return;
        this.zze.zzc(this.zzf);
        zzece zzece2 = this;
        zzece2.zzw(zzece2.zzf, "offline_notification_worker_not_scheduled", zzfyf.zzd());
    }

    private final void zzy(Activity activity, @Nullable zzm object) {
        zzv.zzr();
        if (!NotificationManagerCompat.from((Context)activity).areNotificationsEnabled()) {
            if (Build.VERSION.SDK_INT < 33) {
                zzv.zzr();
                AlertDialog.Builder builder = zzs.zzL((Context)activity);
                builder.setTitle((CharSequence)zzece.zzv(R.string.notifications_permission_title, "Allow app to send you notifications?")).setPositiveButton((CharSequence)zzece.zzv(R.string.notifications_permission_confirm, "Allow"), (DialogInterface.OnClickListener)new zzebx(this, activity, (zzm)object)).setNegativeButton((CharSequence)zzece.zzv(R.string.notifications_permission_decline, "Don't allow"), (DialogInterface.OnClickListener)new zzeby(this, (zzm)object)).setOnCancelListener((DialogInterface.OnCancelListener)new zzebz(this, (zzm)object));
                builder.create().show();
                zzece zzece2 = this;
                zzece2.zzw(zzece2.zzf, "rtsdi", zzfyf.zzd());
                return;
            }
            object = "android.permission.POST_NOTIFICATIONS";
            activity.requestPermissions(new String[]{object}, 12345);
            zzece zzece3 = this;
            zzece3.zzw(zzece3.zzf, "asnpdi", zzfyf.zzd());
            return;
        }
        this.zzx();
        this.zzz(activity, (zzm)object);
    }

    public final void zzh() {
        zzebm zzebm2 = new zzebm(this.zzd);
        this.zze.zze(zzebm2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzq(String string2, zzdio zzdio2) {
        String string3;
        String string4;
        block10: {
            string4 = zzdio2.zzx();
            string3 = zzdio2.zzB();
            if (TextUtils.isEmpty((CharSequence)string4)) {
                string4 = string3 != null ? string3 : "";
            }
            if ((string3 = zzdio2.zzm()) == null) {
                string3 = "";
            } else {
                try {
                    string3 = string3.zze().toString();
                }
                catch (RemoteException remoteException) {
                    string3 = "";
                }
            }
            if ((zzdio2 = zzdio2.zzn()) == null) {
                zzdio2 = null;
            } else {
                try {
                    zzdio2 = zzdio2.zzf();
                    if (zzdio2 != null) {
                        zzdio2 = (Drawable)ObjectWrapper.unwrap((IObjectWrapper)zzdio2);
                        break block10;
                    }
                    zzdio2 = null;
                }
                catch (RemoteException remoteException) {
                    zzdio2 = null;
                }
            }
        }
        zzebh zzebh2 = new zzebh(string4, string3, (Drawable)zzdio2);
        this.zza.put(string2, zzebh2);
    }

    public final void zzi(IObjectWrapper iObjectWrapper, String string2, String string3) {
        String string4 = "";
        this.zzj(iObjectWrapper, new zza(string2, string3, string4));
    }

    private final void zzz(Activity activity, @Nullable zzm zzm2) {
        activity = this.zzs(activity, zzm2);
        activity.show();
        Timer timer = new Timer();
        timer.schedule((TimerTask)new zzecd(this, (AlertDialog)activity, timer, zzm2), 3000L);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzj(IObjectWrapper object, zza object2) {
        void var1_10;
        void var1_7;
        NotificationCompat.Builder builder;
        String string2;
        HashMap<String, String> hashMap;
        Context context;
        block13: {
            context = (Context)ObjectWrapper.unwrap((IObjectWrapper)object);
            String string3 = "offline_notification_channel";
            String string4 = "AdMob Offline Notifications";
            String string5 = ((zza)hashMap).zza;
            string2 = ((zza)hashMap).zzb;
            hashMap = ((zza)hashMap).zzc;
            String string6 = this.zzu();
            zzv.zzs().zzh(context, string3, string4);
            PendingIntent pendingIntent = zzece.zzr(context, "offline_notification_clicked", string2, string5);
            string4 = zzece.zzr(context, "offline_notification_dismissed", string2, string5);
            string5 = "offline_notification_channel";
            builder = new NotificationCompat.Builder(context, string5);
            if (!TextUtils.isEmpty((CharSequence)string6)) {
                builder.setContentTitle((CharSequence)String.format(zzece.zzv(R.string.offline_notification_title_with_advertiser, "You are back online! Continue learning about %s"), string6));
            } else {
                builder.setContentTitle((CharSequence)zzece.zzv(R.string.offline_notification_title, "You are back online! Let's pick up where we left off"));
            }
            zzbcm zzbcm2 = zzbcv.zziL;
            builder.setAutoCancel(true).setDeleteIntent((PendingIntent)string4).setContentIntent(pendingIntent).setSmallIcon(context.getApplicationInfo().icon).setPriority(((Integer)zzbd.zzc().zzb(zzbcm2)).intValue());
            zzbcm zzbcm3 = zzbcv.zziN;
            if (((Boolean)zzbd.zzc().zzb(zzbcm3)).booleanValue()) {
                if (!((String)((Object)hashMap)).isEmpty()) {
                    Bitmap bitmap = BitmapFactory.decodeStream((InputStream)new URL((String)((Object)hashMap)).openConnection().getInputStream());
                } else {
                    Object var1_11 = null;
                }
            } else {
                Object var1_12 = null;
            }
            break block13;
            catch (IOException iOException) {
                Object var1_13 = null;
            }
        }
        if (var1_7 != null) {
            try {
                builder.setLargeIcon((Bitmap)var1_7).setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture((Bitmap)var1_7).bigLargeIcon((Bitmap)null));
            }
            catch (Resources.NotFoundException notFoundException) {}
        }
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        hashMap = new HashMap<String, String>();
        try {
            notificationManager.notify(string2, 54321, builder.build());
            String string7 = "offline_notification_impression";
        }
        catch (IllegalArgumentException illegalArgumentException) {
            hashMap.put("notification_not_shown_reason", illegalArgumentException.getMessage());
            String string8 = "offline_notification_failed";
        }
        this.zzw(string2, (String)var1_10, hashMap);
    }

    @VisibleForTesting
    public static final PendingIntent zzr(Context context, String string2, String string3, String string4) {
        Intent intent = new Intent();
        intent.setAction(string2);
        intent.putExtra("offline_notification_action", string2);
        intent.putExtra("gws_query_id", string3);
        intent.putExtra("uri", string4);
        if (Build.VERSION.SDK_INT >= 29 && string2.equals("offline_notification_clicked")) {
            intent.setClassName(context, "com.google.android.gms.ads.NotificationHandlerActivity");
            return zzfrz.zza(context, 0, intent, 0xC000000);
        }
        intent.setClassName(context, "com.google.android.gms.ads.AdService");
        return zzfrz.zzb(context, 0, intent, 0x44000000, 0);
    }
}

