/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzgee;
import com.google.android.gms.internal.ads.zzgej;
import com.google.android.gms.internal.ads.zzgjf;
import com.google.android.gms.internal.ads.zzgkk;
import com.google.android.gms.internal.ads.zzgkq;
import com.google.android.gms.internal.ads.zzglr;
import com.google.android.gms.internal.ads.zzgou;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class zzglf
implements zzgee {
    private final byte[] zza;
    private final byte[] zzb;

    public static zzgee zzb(zzgjf zzgjf2) throws GeneralSecurityException {
        return new zzglf(zzgjf2.zze().zzd(zzgej.zza()), zzgjf2.zzb().zzd());
    }

    private zzglf(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        if (!zzglr.zza(1)) {
            throw new GeneralSecurityException("Can not use ChaCha20Poly1305 in FIPS-mode.");
        }
        if (!zzglf.zzc()) {
            throw new GeneralSecurityException("JCE does not support algorithm: ChaCha20-Poly1305");
        }
        if (byArray.length != 32) {
            throw new InvalidKeyException("The key length in bytes must be 32.");
        }
        this.zza = byArray;
        this.zzb = byArray2;
    }

    public static boolean zzc() {
        return zzgkk.zzc() != null;
    }

    @Override
    public final byte[] zza(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        if (byArray == null) {
            throw new NullPointerException("ciphertext is null");
        }
        int n = byArray.length;
        Object object = ((zzglf)object2).zzb;
        int n2 = ((byte[])object).length;
        if (n < n2 + 40) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        if (!zzgou.zzc(object, byArray)) {
            throw new GeneralSecurityException("Decryption failed (OutputPrefix mismatch).");
        }
        object = new byte[24];
        System.arraycopy(byArray, n2, object, 0, 24);
        Object object2 = zzgkq.zzd(zzgkq.zze(((zzglf)object2).zza), zzgkq.zze(object));
        ByteBuffer byteBuffer = ByteBuffer.allocate(((Object)object2).length * 4).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.asIntBuffer().put((int[])object2);
        object2 = byteBuffer.array();
        String string2 = "ChaCha20";
        SecretKeySpec secretKeySpec = new SecretKeySpec((byte[])object2, string2);
        byte[] byArray3 = new byte[12];
        System.arraycopy(object, 16, byArray3, 4, 8);
        object2 = new IvParameterSpec(byArray3);
        object = zzgkk.zzc();
        object.init(2, (Key)secretKeySpec, (AlgorithmParameterSpec)object2);
        if (byArray2 != null && byArray2.length != 0) {
            object.updateAAD(byArray2);
        }
        return object.doFinal(byArray, n2 + 24, n - n2 + -24);
    }
}

