/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzgpt;
import com.google.android.gms.internal.ads.zzgpu;
import com.google.android.gms.internal.ads.zzgpv;
import com.google.android.gms.internal.ads.zzgpw;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import javax.annotation.Nullable;

public final class zzgps {
    @Nullable
    private Integer zza = null;
    @Nullable
    private Integer zzb = null;
    private zzgpt zzc = null;
    private zzgpu zzd = zzgpu.zzd;

    public final zzgps zza(zzgpt zzgpt2) {
        this.zzc = zzgpt2;
        return this;
    }

    public final zzgps zzb(int n) throws GeneralSecurityException {
        this.zza = n;
        return this;
    }

    public final zzgps zzc(int n) throws GeneralSecurityException {
        this.zzb = n;
        return this;
    }

    public final zzgps zzd(zzgpu zzgpu2) {
        this.zzd = zzgpu2;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final zzgpw zze() throws GeneralSecurityException {
        Object[] objectArray;
        Object[] objectArray2 = objectArray.zza;
        if (objectArray2 == null) {
            throw new GeneralSecurityException("key size is not set");
        }
        if (objectArray.zzb == null) {
            throw new GeneralSecurityException("tag size is not set");
        }
        if (objectArray.zzc == null) {
            throw new GeneralSecurityException("hash type is not set");
        }
        if (objectArray.zzd == null) {
            throw new GeneralSecurityException("variant is not set");
        }
        if (objectArray2.intValue() < 16) {
            objectArray2 = new Object[]{objectArray.zza};
            throw new InvalidAlgorithmParameterException(String.format("Invalid key size in bytes %d; must be at least 16 bytes", objectArray2));
        }
        int n = objectArray.zzb;
        zzgpt zzgpt2 = objectArray.zzc;
        if (n < 10) {
            objectArray = new Object[]{n};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; must be at least 10 bytes", objectArray));
        }
        if (zzgpt2 == zzgpt.zza) {
            if (n <= 20) return new zzgpw(objectArray.zza, objectArray.zzb, objectArray.zzd, objectArray.zzc, null);
            objectArray = new Object[]{n};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 20 bytes for SHA1", objectArray));
        }
        if (zzgpt2 == zzgpt.zzb) {
            if (n <= 28) return new zzgpw(objectArray.zza, objectArray.zzb, objectArray.zzd, objectArray.zzc, null);
            objectArray = new Object[]{n};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 28 bytes for SHA224", objectArray));
        }
        if (zzgpt2 == zzgpt.zzc) {
            if (n <= 32) return new zzgpw(objectArray.zza, objectArray.zzb, objectArray.zzd, objectArray.zzc, null);
            objectArray = new Object[]{n};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 32 bytes for SHA256", objectArray));
        }
        if (zzgpt2 == zzgpt.zzd) {
            if (n <= 48) return new zzgpw(objectArray.zza, objectArray.zzb, objectArray.zzd, objectArray.zzc, null);
            objectArray = new Object[]{n};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 48 bytes for SHA384", objectArray));
        }
        if (zzgpt2 != zzgpt.zze) {
            throw new GeneralSecurityException("unknown hash type; must be SHA256, SHA384 or SHA512");
        }
        if (n <= 64) {
            return new zzgpw(objectArray.zza, objectArray.zzb, objectArray.zzd, objectArray.zzc, null);
        }
        objectArray = new Object[]{n};
        throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 64 bytes for SHA512", objectArray));
    }

    private zzgps() {
    }

    /* synthetic */ zzgps(zzgpv zzgpv2) {
    }
}

