/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioFormat;
import android.media.AudioProfile;
import android.media.AudioTrack;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.util.Pair;
import android.util.SparseArray;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.internal.ads.zzay;
import com.google.android.gms.internal.ads.zzcj;
import com.google.android.gms.internal.ads.zze;
import com.google.android.gms.internal.ads.zzeu;
import com.google.android.gms.internal.ads.zzfxz;
import com.google.android.gms.internal.ads.zzfyc;
import com.google.android.gms.internal.ads.zzfye;
import com.google.android.gms.internal.ads.zzfyf;
import com.google.android.gms.internal.ads.zzfyg;
import com.google.android.gms.internal.ads.zzfyh;
import com.google.android.gms.internal.ads.zzgbf;
import com.google.android.gms.internal.ads.zzpd;
import com.google.android.gms.internal.ads.zzpk;
import com.google.android.gms.internal.ads.zzz;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class zzpe {
    public static final zzpe zza = new zzpe(zzfyc.zzo(zzpd.zza));
    @SuppressLint(value={"InlinedApi"})
    private static final zzfyc zzc;
    @VisibleForTesting
    static final zzfyf zzb;
    private final SparseArray zzd = new SparseArray();
    private final int zze;

    /*
     * Enabled aggressive block sorting
     */
    public final int hashCode() {
        int n;
        SparseArray sparseArray = this.zzd;
        if (Build.VERSION.SDK_INT >= 31) {
            n = sparseArray.contentHashCode();
            return this.zze + n * 31;
        } else {
            n = 17;
            for (int i = 0; i < sparseArray.size(); ++i) {
                n = (n * 31 + sparseArray.keyAt(i)) * 31 + Objects.hashCode(sparseArray.valueAt(i));
            }
        }
        return this.zze + n * 31;
    }

    @Nullable
    static Uri zza() {
        if (zzpe.zzf()) {
            return Settings.Global.getUriFor((String)"external_surround_sound_enabled");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final Pair zzb(zzz zzz2, zze zze2) {
        int n;
        int n2;
        block15: {
            block17: {
                block16: {
                    String string2;
                    block11: {
                        int n3;
                        block14: {
                            block12: {
                                block13: {
                                    block9: {
                                        block10: {
                                            string2 = zzz2.zzo;
                                            if (string2 == null) throw null;
                                            n2 = zzay.zza(string2, zzz2.zzk);
                                            if (!zzb.containsKey(n2)) {
                                                return null;
                                            }
                                            if (n2 != 18) break block9;
                                            if (zzeu.zzH(((zzpe)this).zzd, 18)) break block10;
                                            n2 = 6;
                                            break block11;
                                        }
                                        n2 = 18;
                                    }
                                    if (n2 != 8) break block12;
                                    if (!zzeu.zzH(((zzpe)this).zzd, 8)) break block13;
                                    n2 = 8;
                                    n3 = 8;
                                    break block14;
                                }
                                n2 = 7;
                                break block11;
                            }
                            n3 = n2;
                        }
                        n2 = n2 == 30 ? (!zzeu.zzH(((zzpe)this).zzd, 30) ? 7 : n3) : n3;
                    }
                    if (!zzeu.zzH((SparseArray)(this = ((zzpe)this).zzd), n2)) return null;
                    if ((this = (zzpd)this.get(n2)) == null) throw null;
                    zzpd zzpd2 = (zzpd)this;
                    n = zzz2.zzE;
                    if (n == -1 || n2 == 18) {
                        n = zzz2.zzF;
                        if (n == -1) {
                            n = 48000;
                        }
                        n = zzpd2.zza(n, zze2);
                    } else if (string2.equals("audio/vnd.dts.uhd;profile=p2") && Build.VERSION.SDK_INT < 33 ? n > 10 : !zzpd2.zzb(n)) {
                        return null;
                    }
                    if (Build.VERSION.SDK_INT > 28) break block15;
                    if (n != 7) break block16;
                    n = 8;
                    break block15;
                }
                if (n == 3) break block17;
                if (n != 4) {
                    if (n == 5) {
                        n = 6;
                    }
                    break block15;
                } else {
                    n = 6;
                }
                break block15;
            }
            n = 6;
        }
        if (Build.VERSION.SDK_INT <= 26 && "fugu".equals(Build.DEVICE) && n == 1) {
            n = 2;
        }
        if ((n = zzeu.zzi(n)) == 0) return null;
        return Pair.create((Object)n2, (Object)n);
    }

    @SuppressLint(value={"UnprotectedReceiver"})
    static zzpe zzc(Context context, zze zze2, @Nullable zzpk zzpk2) {
        Context context2 = context;
        return zzpe.zzd(context2, context2.registerReceiver(null, new IntentFilter("android.media.action.HDMI_AUDIO_PLUG")), zze2, zzpk2);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"InlinedApi"})
    static zzpe zzd(Context object, @Nullable Intent object2, zze object3, @Nullable zzpk object4) {
        boolean bl;
        zzfyg zzfyg2;
        block28: {
            int n;
            block29: {
                int n2;
                void var3_13;
                zzfyh zzfyh2;
                Object object5;
                block27: {
                    object5 = zzcj.zzc((Context)object);
                    if (object4 == null) {
                        if (Build.VERSION.SDK_INT >= 33) {
                            List list = object5.getAudioDevicesForAttributes(((zze)object3).zza().zza);
                            if (list.isEmpty()) {
                                Object var3_17 = null;
                                break block27;
                            } else {
                                zzpk zzpk2 = new zzpk((AudioDeviceInfo)list.get(0));
                            }
                        } else {
                            Object var3_19 = null;
                        }
                        break block27;
                        catch (RuntimeException runtimeException) {
                            Object var3_20 = null;
                        }
                    }
                }
                if (Build.VERSION.SDK_INT < 33 || !zzeu.zzN((Context)object) && !zzeu.zzJ((Context)object)) {
                    void var3_8;
                    if (var3_8 == null) {
                        AudioDeviceInfo[] audioDeviceInfoArray = object5.getDevices(2);
                    } else {
                        AudioDeviceInfo[] audioDeviceInfoArray = new AudioDeviceInfo[]{var3_8.zza};
                    }
                    object5 = new zzfyg();
                    ((zzfyg)object5).zzg(8, 7);
                    if (Build.VERSION.SDK_INT >= 31) {
                        ((zzfyg)object5).zzg(26, 27);
                    }
                    if (Build.VERSION.SDK_INT >= 33) {
                        ((zzfyg)object5).zzf(30);
                    }
                    zzfyh2 = ((zzfyg)object5).zzi();
                    n2 = ((void)var3_13).length;
                } else {
                    object2 = object5.getDirectProfilesForAttributes(((zze)object3).zza().zza);
                    HashMap hashMap = new HashMap();
                    hashMap.put(2, new HashSet(zzgbf.zzh(12)));
                    for (int i = 0; i < object2.size(); ++i) {
                        int n3;
                        object5 = (AudioProfile)object2.get(i);
                        if (object5.getEncapsulationType() == 1 || !zzeu.zzK(n3 = object5.getFormat()) && !zzb.containsKey(n3)) continue;
                        Object object6 = n3;
                        if (hashMap.containsKey(object6)) {
                            if ((object6 = (Set)hashMap.get(object6)) == null) {
                                throw null;
                            }
                            ((Set)object6).addAll(zzgbf.zzh(object5.getChannelMasks()));
                            continue;
                        }
                        hashMap.put((Integer)object6, new HashSet(zzgbf.zzh(object5.getChannelMasks())));
                    }
                    zzfxz zzfxz2 = new zzfxz();
                    object2 = hashMap.entrySet().iterator();
                    while (true) {
                        if (!object2.hasNext()) {
                            return new zzpe(zzfxz2.zzi());
                        }
                        Map.Entry entry = (Map.Entry)object2.next();
                        zzfxz2.zzf(new zzpd((int)((Integer)entry.getKey()), (Set)entry.getValue()));
                    }
                }
                for (n = 0; n < n2; ++n) {
                    if (!zzfyh2.contains(var3_13[n].getType())) continue;
                    return zza;
                }
                zzfyg2 = new zzfyg();
                zzfyg2.zzf(2);
                if (Build.VERSION.SDK_INT < 29) break block28;
                if (zzeu.zzN((Context)object)) break block29;
                if (!zzeu.zzJ((Context)object)) break block28;
            }
            object = new zzfxz();
            object2 = zzb.zzi().zze();
            while (true) {
                if (!object2.hasNext()) {
                    ((zzfxz)object).zzf(2);
                    zzfyg2.zzh(((zzfxz)object).zzi());
                    return new zzpe(zzpe.zze(zzgbf.zzi(zzfyg2.zzi()), 10));
                }
                n = (Integer)object2.next();
                int n4 = zzeu.zzh(n);
                if (Build.VERSION.SDK_INT < n4 || !AudioTrack.isDirectPlaybackSupported((AudioFormat)new AudioFormat.Builder().setChannelMask(12).setEncoding(n).setSampleRate(48000).build(), (AudioAttributes)((zze)object3).zza().zza)) continue;
                ((zzfxz)object).zzf(n);
            }
        }
        if (((bl = Settings.Global.getInt((ContentResolver)(object3 = object.getContentResolver()), (String)"use_external_surround_sound_flag", (int)0) == 1) || zzpe.zzf()) && Settings.Global.getInt((ContentResolver)object3, (String)"external_surround_sound_enabled", (int)0) == 1) {
            zzfyg2.zzh(zzc);
        }
        if (object2 == null) return new zzpe(zzpe.zze(zzgbf.zzi(zzfyg2.zzi()), 10));
        if (bl) return new zzpe(zzpe.zze(zzgbf.zzi(zzfyg2.zzi()), 10));
        if (object2.getIntExtra("android.media.extra.AUDIO_PLUG_STATE", 0) != 1) return new zzpe(zzpe.zze(zzgbf.zzi(zzfyg2.zzi()), 10));
        int[] nArray = object2.getIntArrayExtra("android.media.extra.ENCODINGS");
        if (nArray == null) return new zzpe(zzpe.zze(zzgbf.zzi(zzfyg2.zzi()), object2.getIntExtra("android.media.extra.MAX_CHANNEL_COUNT", 10)));
        zzfyg2.zzh(zzgbf.zzh(nArray));
        return new zzpe(zzpe.zze(zzgbf.zzi(zzfyg2.zzi()), object2.getIntExtra("android.media.extra.MAX_CHANNEL_COUNT", 10)));
    }

    private static zzfyc zze(@Nullable int[] nArray, int n) {
        zzfxz zzfxz2 = new zzfxz();
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            zzfxz2.zzf(new zzpd(n2, n));
        }
        return zzfxz2.zzi();
    }

    public final String toString() {
        String string2 = this.zzd.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AudioCapabilities[maxChannelCount=");
        stringBuilder.append(this.zze);
        stringBuilder.append(", audioProfiles=");
        stringBuilder.append(string2);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    static {
        Integer n = 5;
        Integer n2 = 6;
        zzc = zzfyc.zzq(2, n, n2);
        zzfye zzfye2 = new zzfye();
        zzfye2.zza(n, n2);
        zzfye2.zza(17, n2);
        zzfye2.zza(7, n2);
        zzfye2.zza(30, 10);
        zzfye2.zza(18, n2);
        Integer n3 = 8;
        zzfye2.zza(n2, n3);
        Integer n4 = n3;
        zzfye2.zza(n4, n4);
        zzfye2.zza(14, n3);
        zzb = zzfye2.zzc();
    }

    private zzpe(List list) {
        int n;
        for (n = 0; n < list.size(); ++n) {
            zzpd zzpd2 = (zzpd)list.get(n);
            this.zzd.put(zzpd2.zzb, (Object)zzpd2);
        }
        int n2 = 0;
        for (n = 0; n < this.zzd.size(); ++n) {
            n2 = Math.max(n2, ((zzpd)this.zzd.valueAt((int)n)).zzc);
        }
        this.zze = n2;
    }

    private static boolean zzf() {
        return Build.MANUFACTURER.equals("Amazon") || Build.MANUFACTURER.equals("Xiaomi");
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzpe)) {
            return false;
        }
        zzpe zzpe2 = (zzpe)object;
        SparseArray sparseArray = this.zzd;
        SparseArray sparseArray2 = zzpe2.zzd;
        if (Build.VERSION.SDK_INT >= 31) {
            if (!sparseArray.contentEquals(sparseArray2)) return false;
        } else {
            int n = sparseArray.size();
            if (n != sparseArray2.size()) return false;
            for (int i = 0; i < n; ++i) {
                int n2 = sparseArray.keyAt(i);
                if (!Objects.equals(sparseArray.valueAt(i), sparseArray2.get(n2))) return false;
            }
        }
        if (this.zze != zzpe2.zze) return false;
        return true;
    }
}

