/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zacd;
import com.google.android.gms.common.api.internal.zacm;
import com.google.android.gms.common.api.internal.zacp;
import com.google.android.gms.common.internal.Preconditions;
import java.lang.ref.WeakReference;
import javax.annotation.concurrent.GuardedBy;

public final class zacn<R extends Result>
extends TransformedResult<R>
implements ResultCallback<R> {
    private ResultTransform<? super R, ? extends Result> zakv = null;
    private zacn<? extends Result> zakw = null;
    private volatile ResultCallbacks<? super R> zakx = null;
    private PendingResult<R> zaky = null;
    private final Object zads = new Object();
    private Status zakz = null;
    private final WeakReference<GoogleApiClient> zadu;
    private final zacp zala;
    private boolean zalb = false;

    public zacn(WeakReference<GoogleApiClient> weakReference) {
        Preconditions.checkNotNull(weakReference, (Object)"GoogleApiClient reference must not be null");
        this.zadu = weakReference;
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zadu.get();
        this.zala = new zacp(this, googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public final <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> resultTransform) {
        Object object = this.zads;
        synchronized (object) {
            Preconditions.checkState((this.zakv == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            Preconditions.checkState((this.zakx == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zakv = resultTransform;
            zacn<R> zacn2 = new zacn<R>(this.zadu);
            this.zakw = zacn2;
            this.zabs();
            return zacn2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void andFinally(@NonNull ResultCallbacks<? super R> resultCallbacks) {
        Object object = this.zads;
        synchronized (object) {
            Preconditions.checkState((this.zakx == null ? 1 : 0) != 0, (Object)"Cannot call andFinally() twice.");
            Preconditions.checkState((this.zakv == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zakx = resultCallbacks;
            this.zabs();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onResult(R r) {
        Object object = this.zads;
        synchronized (object) {
            if (r.getStatus().isSuccess()) {
                if (this.zakv != null) {
                    zacd.zabd().submit(new zacm(this, (Result)r));
                } else if (this.zabu()) {
                    this.zakx.onSuccess(r);
                }
            } else {
                this.zad(r.getStatus());
                zacn.zab(r);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zaa(PendingResult<?> pendingResult) {
        Object object = this.zads;
        synchronized (object) {
            this.zaky = pendingResult;
            this.zabs();
            return;
        }
    }

    @GuardedBy(value="mSyncToken")
    private final void zabs() {
        if (this.zakv == null && this.zakx == null) {
            return;
        }
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zadu.get();
        if (!this.zalb && this.zakv != null && googleApiClient != null) {
            googleApiClient.zaa(this);
            this.zalb = true;
        }
        if (this.zakz != null) {
            this.zae(this.zakz);
            return;
        }
        if (this.zaky != null) {
            this.zaky.setResultCallback(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zad(Status status) {
        Object object = this.zads;
        synchronized (object) {
            this.zakz = status;
            this.zae(this.zakz);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zae(Status status) {
        Object object = this.zads;
        synchronized (object) {
            if (this.zakv != null) {
                Status status2 = this.zakv.onFailure(status);
                Preconditions.checkNotNull((Object)status2, (Object)"onFailure must not return null");
                super.zad(status2);
            } else if (this.zabu()) {
                this.zakx.onFailure(status);
            }
            return;
        }
    }

    final void zabt() {
        this.zakx = null;
    }

    @GuardedBy(value="mSyncToken")
    private final boolean zabu() {
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zadu.get();
        return this.zakx != null && googleApiClient != null;
    }

    private static void zab(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"TransformedResultImpl", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    static /* synthetic */ ResultTransform zac(zacn zacn2) {
        return zacn2.zakv;
    }

    static /* synthetic */ zacp zad(zacn zacn2) {
        return zacn2.zala;
    }

    static /* synthetic */ void zaa(zacn zacn2, Result result) {
        zacn.zab(result);
    }

    static /* synthetic */ WeakReference zae(zacn zacn2) {
        return zacn2.zadu;
    }

    static /* synthetic */ Object zaf(zacn zacn2) {
        return zacn2.zads;
    }

    static /* synthetic */ zacn zag(zacn zacn2) {
        return zacn2.zakw;
    }

    static /* synthetic */ void zaa(zacn zacn2, Status status) {
        zacn2.zad(status);
    }
}

