/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.util.Log;
import android.widget.ImageView;
import androidx.collection.LruCache;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.internal.base.zak;
import com.google.android.gms.internal.base.zal;
import com.google.android.gms.internal.base.zap;
import com.google.android.gms.internal.base.zaq;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;

public final class ImageManager {
    private static final Object zamm = new Object();
    private static HashSet<Uri> zamn = new HashSet();
    private static ImageManager zamo;
    private final Context mContext;
    private final Handler mHandler;
    private final ExecutorService zamp;
    private final zaa zamq;
    private final zak zamr;
    private final Map<com.google.android.gms.common.images.zaa, ImageReceiver> zams;
    private final Map<Uri, ImageReceiver> zamt;
    private final Map<Uri, Long> zamu;

    public static ImageManager create(Context context) {
        Context context2 = context;
        if (zamo == null) {
            zamo = new ImageManager(context2, false);
        }
        return zamo;
    }

    private ImageManager(Context context, boolean bl) {
        this.mContext = context.getApplicationContext();
        this.mHandler = new zap(Looper.getMainLooper());
        this.zamp = zal.zact().zaa(4, zaq.zasj);
        this.zamq = null;
        this.zamr = new zak();
        this.zams = new HashMap<com.google.android.gms.common.images.zaa, ImageReceiver>();
        this.zamt = new HashMap<Uri, ImageReceiver>();
        this.zamu = new HashMap<Uri, Long>();
    }

    public final void loadImage(ImageView imageView, Uri uri) {
        com.google.android.gms.common.images.zab zab2 = new com.google.android.gms.common.images.zab(imageView, uri);
        this.zaa(zab2);
    }

    public final void loadImage(ImageView imageView, int n) {
        com.google.android.gms.common.images.zab zab2 = new com.google.android.gms.common.images.zab(imageView, n);
        this.zaa(zab2);
    }

    public final void loadImage(ImageView imageView, Uri uri, int n) {
        com.google.android.gms.common.images.zab zab2 = new com.google.android.gms.common.images.zab(imageView, uri);
        new com.google.android.gms.common.images.zab(imageView, uri).zand = n;
        this.zaa(zab2);
    }

    public final void loadImage(OnImageLoadedListener onImageLoadedListener, Uri uri) {
        com.google.android.gms.common.images.zad zad2 = new com.google.android.gms.common.images.zad(onImageLoadedListener, uri);
        this.zaa(zad2);
    }

    public final void loadImage(OnImageLoadedListener onImageLoadedListener, Uri uri, int n) {
        com.google.android.gms.common.images.zad zad2 = new com.google.android.gms.common.images.zad(onImageLoadedListener, uri);
        new com.google.android.gms.common.images.zad(onImageLoadedListener, uri).zand = n;
        this.zaa(zad2);
    }

    private final void zaa(com.google.android.gms.common.images.zaa zaa2) {
        Asserts.checkMainThread((String)"ImageManager.loadImage() must be called in the main thread");
        new zad(zaa2).run();
    }

    private final Bitmap zaa(com.google.android.gms.common.images.zac zac2) {
        if (this.zamq == null) {
            return null;
        }
        return (Bitmap)this.zamq.get(zac2);
    }

    private static final class zaa
    extends LruCache<com.google.android.gms.common.images.zac, Bitmap> {
        protected final /* synthetic */ int sizeOf(Object object, Object object2) {
            com.google.android.gms.common.images.zac cfr_ignored_0 = (com.google.android.gms.common.images.zac)object;
            Bitmap bitmap = (Bitmap)object2;
            return bitmap.getHeight() * bitmap.getRowBytes();
        }

        protected final /* synthetic */ void entryRemoved(boolean bl, Object object, Object object2, Object object3) {
            Bitmap bitmap = (Bitmap)object3;
            Bitmap bitmap2 = (Bitmap)object2;
            com.google.android.gms.common.images.zac zac2 = (com.google.android.gms.common.images.zac)object;
            super.entryRemoved(bl, (Object)zac2, (Object)bitmap2, (Object)bitmap);
        }
    }

    private final class zac
    implements Runnable {
        private final Uri zamv;
        private final Bitmap mBitmap;
        private final CountDownLatch zadv;
        private boolean zamz;

        public zac(Uri uri, Bitmap bitmap, boolean bl, CountDownLatch countDownLatch) {
            this.zamv = uri;
            this.mBitmap = bitmap;
            this.zamz = bl;
            this.zadv = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            ImageReceiver imageReceiver;
            boolean bl;
            Asserts.checkMainThread((String)"OnBitmapLoadedRunnable must be executed in the main thread");
            boolean bl2 = bl = this.mBitmap != null;
            if (ImageManager.this.zamq != null) {
                if (this.zamz) {
                    ImageManager.this.zamq.evictAll();
                    System.gc();
                    this.zamz = false;
                    ImageManager.this.mHandler.post((Runnable)this);
                    return;
                }
                if (bl) {
                    ImageManager.this.zamq.put(new com.google.android.gms.common.images.zac(this.zamv), this.mBitmap);
                }
            }
            if ((imageReceiver = (ImageReceiver)((Object)ImageManager.this.zamt.remove(this.zamv))) != null) {
                boolean bl3 = bl;
                ImageReceiver imageReceiver2 = imageReceiver;
                zac zac2 = this;
                ArrayList arrayList = imageReceiver2.zamy;
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    com.google.android.gms.common.images.zaa zaa2 = (com.google.android.gms.common.images.zaa)arrayList.get(i);
                    if (bl3) {
                        zaa2.zaa(zac2.ImageManager.this.mContext, zac2.mBitmap, false);
                    } else {
                        zac2.ImageManager.this.zamu.put(zac2.zamv, SystemClock.elapsedRealtime());
                        zaa2.zaa(zac2.ImageManager.this.mContext, zac2.ImageManager.this.zamr, false);
                    }
                    if (zaa2 instanceof com.google.android.gms.common.images.zad) continue;
                    zac2.ImageManager.this.zams.remove(zaa2);
                }
            }
            this.zadv.countDown();
            Object object = zamm;
            synchronized (object) {
                zamn.remove(this.zamv);
                return;
            }
        }
    }

    private final class zab
    implements Runnable {
        private final Uri zamv;
        private final ParcelFileDescriptor zamw;

        public zab(Uri uri, ParcelFileDescriptor parcelFileDescriptor) {
            this.zamv = uri;
            this.zamw = parcelFileDescriptor;
        }

        @Override
        public final void run() {
            Asserts.checkNotMainThread((String)"LoadBitmapFromDiskRunnable can't be executed in the main thread");
            boolean bl = false;
            Bitmap bitmap = null;
            if (this.zamw != null) {
                try {
                    bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)this.zamw.getFileDescriptor());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    String string2 = String.valueOf(this.zamv);
                    Log.e((String)"ImageManager", (String)new StringBuilder(34 + String.valueOf(string2).length()).append("OOM while loading bitmap for uri: ").append(string2).toString(), (Throwable)outOfMemoryError);
                    bl = true;
                }
                try {
                    this.zamw.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ImageManager.this.mHandler.post((Runnable)new zac(this.zamv, bitmap, bl, countDownLatch));
            try {
                countDownLatch.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                String string3 = String.valueOf(this.zamv);
                Log.w((String)"ImageManager", (String)new StringBuilder(32 + String.valueOf(string3).length()).append("Latch interrupted while posting ").append(string3).toString());
                return;
            }
        }
    }

    @KeepName
    private final class ImageReceiver
    extends ResultReceiver {
        private final Uri zamv;
        private final ArrayList<com.google.android.gms.common.images.zaa> zamy;

        ImageReceiver(Uri uri) {
            super((Handler)new zap(Looper.getMainLooper()));
            this.zamv = uri;
            this.zamy = new ArrayList();
        }

        public final void zab(com.google.android.gms.common.images.zaa zaa2) {
            Asserts.checkMainThread((String)"ImageReceiver.addImageRequest() must be called in the main thread");
            this.zamy.add(zaa2);
        }

        public final void zac(com.google.android.gms.common.images.zaa zaa2) {
            Asserts.checkMainThread((String)"ImageReceiver.removeImageRequest() must be called in the main thread");
            this.zamy.remove(zaa2);
        }

        public final void zacc() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.setPackage("com.google.android.gms");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.zamv);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            ImageManager.this.mContext.sendBroadcast(intent);
        }

        public final void onReceiveResult(int n, Bundle bundle) {
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)bundle.getParcelable("com.google.android.gms.extra.fileDescriptor");
            ImageManager.this.zamp.execute(new zab(this.zamv, parcelFileDescriptor));
        }
    }

    private final class zad
    implements Runnable {
        private final com.google.android.gms.common.images.zaa zana;

        public zad(com.google.android.gms.common.images.zaa zaa2) {
            this.zana = zaa2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Asserts.checkMainThread((String)"LoadImageRunnable must be executed on the main thread");
            ImageReceiver imageReceiver = (ImageReceiver)((Object)ImageManager.this.zams.get(this.zana));
            if (imageReceiver != null) {
                ImageManager.this.zams.remove(this.zana);
                imageReceiver.zac(this.zana);
            }
            com.google.android.gms.common.images.zac zac2 = this.zana.zanb;
            if (zac2.uri == null) {
                this.zana.zaa(ImageManager.this.mContext, ImageManager.this.zamr, true);
                return;
            }
            Bitmap bitmap = ImageManager.this.zaa(zac2);
            if (bitmap != null) {
                this.zana.zaa(ImageManager.this.mContext, bitmap, true);
                return;
            }
            Long l = (Long)ImageManager.this.zamu.get(zac2.uri);
            if (l != null) {
                if (SystemClock.elapsedRealtime() - l < 3600000L) {
                    this.zana.zaa(ImageManager.this.mContext, ImageManager.this.zamr, true);
                    return;
                }
                ImageManager.this.zamu.remove(zac2.uri);
            }
            this.zana.zaa(ImageManager.this.mContext, ImageManager.this.zamr);
            imageReceiver = (ImageReceiver)((Object)ImageManager.this.zamt.get(zac2.uri));
            if (imageReceiver == null) {
                imageReceiver = new ImageReceiver(zac2.uri);
                ImageManager.this.zamt.put(zac2.uri, imageReceiver);
            }
            imageReceiver.zab(this.zana);
            if (!(this.zana instanceof com.google.android.gms.common.images.zad)) {
                ImageManager.this.zams.put(this.zana, imageReceiver);
            }
            Object object = zamm;
            synchronized (object) {
                if (!zamn.contains(zac2.uri)) {
                    zamn.add(zac2.uri);
                    imageReceiver.zacc();
                }
                return;
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, Drawable var2, boolean var3);
    }
}

