/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.base;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.internal.base.zah;
import com.google.android.gms.internal.base.zaj;

public final class zaf
extends Drawable
implements Drawable.Callback {
    private int zann = 0;
    private long zano;
    private int mFrom;
    private int zanp;
    private int zanq = 255;
    private int zanr;
    private int mAlpha = 0;
    private boolean zanf = true;
    private boolean zans;
    private zaj zant;
    private Drawable zanu;
    private Drawable zanv;
    private boolean zanw;
    private boolean zanx;
    private boolean zany;
    private int zanz;

    public zaf(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = zah.zace();
        }
        this.zanu = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.zant.zaoc |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = zah.zace();
        }
        this.zanv = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.zant.zaoc |= drawable3.getChangingConfigurations();
    }

    zaf(zaj zaj2) {
        this.zant = new zaj(zaj2);
    }

    public final void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public final void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable((Drawable)this, runnable, l);
        }
    }

    public final void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable((Drawable)this, runnable);
        }
    }

    public final int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.zant.mChangingConfigurations | this.zant.zaoc;
    }

    public final void setAlpha(int n) {
        if (this.mAlpha == this.zanq) {
            this.mAlpha = n;
        }
        this.zanq = n;
        this.invalidateSelf();
    }

    public final void setColorFilter(ColorFilter colorFilter) {
        this.zanu.setColorFilter(colorFilter);
        this.zanv.setColorFilter(colorFilter);
    }

    public final int getIntrinsicWidth() {
        return Math.max(this.zanu.getIntrinsicWidth(), this.zanv.getIntrinsicWidth());
    }

    public final int getIntrinsicHeight() {
        return Math.max(this.zanu.getIntrinsicHeight(), this.zanv.getIntrinsicHeight());
    }

    protected final void onBoundsChange(Rect rect) {
        this.zanu.setBounds(rect);
        this.zanv.setBounds(rect);
    }

    public final Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.zant.mChangingConfigurations = this.getChangingConfigurations();
            return this.zant;
        }
        return null;
    }

    public final int getOpacity() {
        if (!this.zany) {
            this.zanz = Drawable.resolveOpacity((int)this.zanu.getOpacity(), (int)this.zanv.getOpacity());
            this.zany = true;
        }
        return this.zanz;
    }

    private final boolean canConstantState() {
        if (!this.zanw) {
            this.zanx = this.zanu.getConstantState() != null && this.zanv.getConstantState() != null;
            this.zanw = true;
        }
        return this.zanx;
    }

    public final Drawable mutate() {
        if (!this.zans && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.zanu.mutate();
            this.zanv.mutate();
            this.zans = true;
        }
        return this;
    }

    public final Drawable zacd() {
        return this.zanv;
    }

    public final void startTransition(int n) {
        this.mFrom = 0;
        this.zanp = this.zanq;
        this.mAlpha = 0;
        this.zanr = 250;
        this.zann = 1;
        this.invalidateSelf();
    }

    public final void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.zann) {
            case 1: {
                this.zano = SystemClock.uptimeMillis();
                bl = false;
                this.zann = 2;
                break;
            }
            case 2: {
                float f;
                if (this.zano < 0L) break;
                float f2 = (float)(SystemClock.uptimeMillis() - this.zano) / (float)this.zanr;
                bl = f >= 1.0f;
                if (bl) {
                    this.zann = 0;
                }
                f2 = Math.min(f2, 1.0f);
                this.mAlpha = (int)(0.0f + (float)this.zanp * f2);
            }
        }
        int n = this.mAlpha;
        boolean bl2 = this.zanf;
        Drawable drawable2 = this.zanu;
        Drawable drawable3 = this.zanv;
        if (bl) {
            if (!bl2 || n == 0) {
                drawable2.draw(canvas);
            }
            if (n == this.zanq) {
                drawable3.setAlpha(this.zanq);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl2) {
            drawable2.setAlpha(this.zanq - n);
        }
        drawable2.draw(canvas);
        if (bl2) {
            drawable2.setAlpha(this.zanq);
        }
        if (n > 0) {
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.zanq);
        }
        this.invalidateSelf();
    }
}

