/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.OnDelegateCreatedListener;
import com.google.android.gms.dynamic.zaa;
import com.google.android.gms.dynamic.zab;
import com.google.android.gms.dynamic.zac;
import com.google.android.gms.dynamic.zad;
import com.google.android.gms.dynamic.zae;
import com.google.android.gms.dynamic.zaf;
import com.google.android.gms.dynamic.zag;
import com.google.android.gms.dynamic.zah;
import java.util.LinkedList;

@KeepForSdk
public abstract class DeferredLifecycleHelper<T extends LifecycleDelegate> {
    private T zaa;
    @Nullable
    private Bundle zab;
    private LinkedList<zah> zac;
    private final OnDelegateCreatedListener<T> zad;

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        void var3_3;
        void var2_2;
        void var1_1;
        FrameLayout frameLayout = new FrameLayout(var1_1.getContext());
        zad zad2 = new zad(this, frameLayout, (LayoutInflater)var1_1, (ViewGroup)var2_2, (Bundle)var3_3);
        this.zaf((Bundle)var3_3, zad2);
        if (this.zaa == null) {
            this.handleGooglePlayUnavailable(frameLayout);
        }
        return frameLayout;
    }

    @KeepForSdk
    @NonNull
    public T getDelegate() {
        return this.zaa;
    }

    @KeepForSdk
    public DeferredLifecycleHelper() {
        zaa zaa2;
        this.zad = zaa2 = new zaa(this);
    }

    @KeepForSdk
    protected abstract void createDelegate(@NonNull OnDelegateCreatedListener<T> var1);

    @KeepForSdk
    protected void handleGooglePlayUnavailable(@NonNull FrameLayout parent) {
        DeferredLifecycleHelper.showGooglePlayUnavailableMessage(parent);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void onCreate(@Nullable Bundle savedInstanceState) {
        void var1_1;
        zac zac2 = new zac(this, (Bundle)var1_1);
        this.zaf((Bundle)var1_1, zac2);
    }

    @KeepForSdk
    public void onDestroy() {
        T t = this.zaa;
        if (t != null) {
            t.onDestroy();
            return;
        }
        this.zae(1);
    }

    @KeepForSdk
    public void onDestroyView() {
        T t = this.zaa;
        if (t != null) {
            t.onDestroyView();
            return;
        }
        this.zae(2);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void onInflate(@NonNull Activity activity, @NonNull Bundle attrs, @Nullable Bundle savedInstanceState) {
        void var3_3;
        void var2_2;
        void var1_1;
        zab zab2 = new zab(this, (Activity)var1_1, (Bundle)var2_2, (Bundle)var3_3);
        this.zaf((Bundle)var3_3, zab2);
    }

    @KeepForSdk
    public void onLowMemory() {
        DeferredLifecycleHelper<T> this_ = this_.zaa;
        if (this_ != null) {
            this_.onLowMemory();
            return;
        }
    }

    @KeepForSdk
    public void onPause() {
        T t = this.zaa;
        if (t != null) {
            t.onPause();
            return;
        }
        this.zae(5);
    }

    @KeepForSdk
    public void onResume() {
        zag zag2 = new zag(this);
        this.zaf(null, zag2);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void onSaveInstanceState(@NonNull Bundle outState) {
        void var1_1;
        T t = this_.zaa;
        if (t != null) {
            t.onSaveInstanceState((Bundle)var1_1);
            return;
        }
        DeferredLifecycleHelper this_ = this_.zab;
        if (this_ != null) {
            var1_1.putAll((Bundle)this_);
            return;
        }
    }

    @KeepForSdk
    public void onStart() {
        zaf zaf2 = new zaf(this);
        this.zaf(null, zaf2);
    }

    @KeepForSdk
    public void onStop() {
        T t = this.zaa;
        if (t != null) {
            t.onStop();
            return;
        }
        this.zae(4);
    }

    @KeepForSdk
    public static void showGooglePlayUnavailableMessage(@NonNull FrameLayout parent) {
        FrameLayout frameLayout;
        GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
        Context context = frameLayout.getContext();
        int n = googleApiAvailability.isGooglePlayServicesAvailable(context);
        String string2 = com.google.android.gms.common.internal.zac.zad(context, n);
        String string3 = com.google.android.gms.common.internal.zac.zac(context, n);
        LinearLayout linearLayout = new LinearLayout(frameLayout.getContext());
        linearLayout.setOrientation(1);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        frameLayout.addView((View)linearLayout);
        layoutParams = new TextView(frameLayout.getContext());
        frameLayout = new FrameLayout.LayoutParams(-2, -2);
        layoutParams.setLayoutParams((ViewGroup.LayoutParams)frameLayout);
        layoutParams.setText((CharSequence)string2);
        linearLayout.addView((View)layoutParams);
        frameLayout = googleApiAvailability.getErrorResolutionIntent(context, n, null);
        if (frameLayout != null) {
            googleApiAvailability = new Button(context);
            googleApiAvailability.setId(16908313);
            Object object = new FrameLayout.LayoutParams(-2, -2);
            googleApiAvailability.setLayoutParams((ViewGroup.LayoutParams)object);
            googleApiAvailability.setText(string3);
            linearLayout.addView((View)googleApiAvailability);
            object = new zae(context, (Intent)frameLayout);
            googleApiAvailability.setOnClickListener((View.OnClickListener)object);
            return;
        }
    }

    static /* bridge */ /* synthetic */ LifecycleDelegate zaa(DeferredLifecycleHelper deferredLifecycleHelper) {
        return deferredLifecycleHelper.zaa;
    }

    static /* bridge */ /* synthetic */ LinkedList zab(DeferredLifecycleHelper deferredLifecycleHelper) {
        return deferredLifecycleHelper.zac;
    }

    static /* bridge */ /* synthetic */ void zac(DeferredLifecycleHelper deferredLifecycleHelper, LifecycleDelegate lifecycleDelegate) {
        deferredLifecycleHelper.zaa = lifecycleDelegate;
    }

    static /* bridge */ /* synthetic */ void zad(DeferredLifecycleHelper deferredLifecycleHelper, Bundle bundle) {
        deferredLifecycleHelper.zab = null;
    }

    private final void zae(int n) {
        while (!this.zac.isEmpty() && this.zac.getLast().zaa() >= n) {
            this.zac.removeLast();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zaf(@Nullable Bundle bundle, zah zah2) {
        T t = this.zaa;
        if (t != null) {
            zah2.zab((LifecycleDelegate)t);
            return;
        }
        if (this.zac == null) {
            LinkedList linkedList = new LinkedList();
            this.zac = linkedList;
        }
        this.zac.add(zah2);
        if (bundle != null) {
            zah2 = this.zab;
            if (zah2 == null) {
                this.zab = (Bundle)bundle.clone();
            } else {
                zah2.putAll(bundle);
            }
        }
        this.createDelegate(this.zad);
    }
}

