/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.RemoteException;
import android.os.StrictMode;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.zzj;
import com.google.android.gms.common.zzk;
import com.google.android.gms.common.zzn;
import com.google.android.gms.common.zzo;
import com.google.android.gms.common.zzv;
import com.google.android.gms.common.zzy;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.common.zzad;
import com.google.android.gms.internal.common.zzah;
import com.google.android.gms.internal.common.zzr;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nullable;

@ShowFirstParty
@KeepForSdk
public class GoogleSignatureVerifier {
    @Nullable
    private static GoogleSignatureVerifier zza;
    private final Context zzb;
    private volatile String zzc;
    @Nullable
    private static volatile Set zzd;
    @Nullable
    private static volatile Set zze;

    public GoogleSignatureVerifier(@NonNull Context context) {
        this.zzb = context.getApplicationContext();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @NonNull
    public static GoogleSignatureVerifier getInstance(@NonNull Context context) {
        Preconditions.checkNotNull(context);
        Class<GoogleSignatureVerifier> clazz = GoogleSignatureVerifier.class;
        synchronized (clazz) {
            Context context2;
            GoogleSignatureVerifier googleSignatureVerifier = zza;
            if (googleSignatureVerifier != null) return zza;
            zzo.zza(context2);
            zza = new GoogleSignatureVerifier(context2);
            return zza;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @ShowFirstParty
    @KeepForSdk
    public boolean isUidGoogleSigned(int uid) {
        var3_3 = this.zzb.getPackageManager().getPackagesForUid((int)var1_1);
        if (var3_3 == null || (var4_4 = var3_3.length) == 0) {
            this = zzy.zzc("no pkgs");
lbl4:
            // 3 sources

            while (true) {
                this.zze();
                return this.zza;
            }
        }
        var1_2 = null;
        for (var2_5 = 0; var2_5 < var4_4; ++var2_5) {
            var1_2 = super.zzb(var3_3[var2_5], false, false);
            if (!var1_2.zza) continue;
            this = var1_2;
            ** GOTO lbl4
        }
        Preconditions.checkNotNull(var1_2);
        this = var1_2;
        ** while (true)
    }

    /*
     * WARNING - void declaration
     */
    @ShowFirstParty
    @KeepForSdk
    public boolean isPackageGoogleSigned(@Nullable String callingPackage) {
        void var1_1;
        zzy zzy2 = this.zzb((String)var1_1, false, false);
        zzy2.zze();
        return zzy2.zza;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public boolean isGooglePublicSignedPackage(@NonNull PackageInfo packageInfo) {
        void var1_1;
        if (packageInfo == null) {
            return false;
        }
        if (GoogleSignatureVerifier.zza((PackageInfo)var1_1, false)) {
            return true;
        }
        if (GoogleSignatureVerifier.zza((PackageInfo)var1_1, true)) {
            if (GooglePlayServicesUtilLight.honorsDebugCertificates(this.zzb)) {
                return true;
            }
            Log.w((String)"GoogleSignatureVerifier", (String)"Test-keys aren't accepted on this build.");
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @SuppressLint(value={"PackageManagerGetSignatures"})
    private final zzy zzb(@Nullable String var1_2, boolean var2_3, boolean var3_6) {
        block12: {
            if (var1_2 == null) {
                return zzy.zzc("null pkg");
            }
            if (var1_2.equals(this.zzc)) break block12;
            var2_4 /* !! */  = StrictMode.allowThreadDiskReads();
            try {
                zzo.zzb();
                var3_6 = zzo.zzg.zzg();
            }
            catch (RemoteException | DynamiteModule.LoadingException var3_9) {
                try {
                    Log.e((String)"GoogleCertificates", (String)"Failed to get Google certificates from remote", (Throwable)var3_9);
                }
                catch (Throwable v1) {
                    StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)var2_4 /* !! */ );
                    throw v1;
                }
                StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)var2_4 /* !! */ );
                ** continue;
            }
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)var2_4 /* !! */ );
            if (var3_6) {
                v0 = new zzv(null);
                v0.zza(var1_2);
                v0.zzb(GooglePlayServicesUtilLight.honorsDebugCertificates(this.zzb));
                v0.zzc(true);
                var2_4 /* !! */  = zzo.zzc(v0.zzd());
lbl20:
                // 8 sources

                while (true) {
                    if (var2_4 /* !! */ .zza) {
                        this.zzc = var1_2;
                    }
                    return var2_4 /* !! */ ;
                }
            }
lbl24:
            // 3 sources

            while (true) {
                block13: {
                    if (Build.VERSION.SDK_INT < 28) break block13;
                    var2_5 = 0x8000040;
lbl27:
                    // 2 sources

                    while (true) {
                        block16: {
                            block17: {
                                block18: {
                                    block19: {
                                        block15: {
                                            block14: {
                                                var2_4 /* !! */  = this.zzb.getPackageManager().getPackageInfo(var1_2, var2_5);
                                                var3_7 = GooglePlayServicesUtilLight.honorsDebugCertificates(this.zzb);
                                                if (var2_4 /* !! */  != null) break block14;
                                                var2_4 /* !! */  = zzy.zzc("null pkg");
                                                ** GOTO lbl20
                                            }
                                            if (var2_4 /* !! */ .signatures != null && var2_4 /* !! */ .signatures.length == 1) break block15;
                                            var2_4 /* !! */  = zzy.zzc("single cert required");
                                            ** GOTO lbl20
                                        }
                                        var4_10 = new zzk(var2_4 /* !! */ .signatures[0].toByteArray());
                                        var5_11 = var2_4 /* !! */ .packageName;
                                        var3_8 = zzo.zzd(var5_11, var4_10, var3_7, false);
                                        if (!var3_8.zza) break block16;
                                        if (var2_4 /* !! */ .applicationInfo == null) break block17;
                                        if ((var2_4 /* !! */ .applicationInfo.flags & 2) == 0) break block18;
                                        if (!zzo.zzd((String)var5_11, (zzj)var4_10, (boolean)false, (boolean)true).zza) break block19;
                                        var2_4 /* !! */  = zzy.zzc("debuggable release cert app rejected");
                                        ** GOTO lbl20
                                    }
                                    var2_4 /* !! */  = var3_8;
                                    ** GOTO lbl20
                                }
                                var2_4 /* !! */  = var3_8;
                                ** GOTO lbl20
                            }
                            var2_4 /* !! */  = var3_8;
                            ** GOTO lbl20
                        }
                        var2_4 /* !! */  = var3_8;
                        ** continue;
                        break;
                    }
                }
                var2_5 = 64;
                ** continue;
                break;
            }
        }
        return zzy.zzb();
        catch (PackageManager.NameNotFoundException var0_1) {
            return zzy.zzd("no pkg ".concat(var1_2), var0_1);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    private static zzj zzc(PackageInfo packageInfo, zzj ... zzjArray) {
        if (packageInfo.signatures != null) {
            if (packageInfo.signatures.length != 1) {
                Log.w((String)"GoogleSignatureVerifier", (String)"Package has more than one signature.");
                return null;
            }
            zzk zzk2 = new zzk(packageInfo.signatures[0].toByteArray());
            for (int i = 0; i < zzjArray.length; ++i) {
                if (!zzjArray[i].equals(zzk2)) continue;
                return zzjArray[i];
            }
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    static final boolean zza(PackageInfo var0, boolean var1_2) {
        block23: {
            block27: {
                block21: {
                    block22: {
                        block20: {
                            block28: {
                                block26: {
                                    block25: {
                                        if (var0 /* !! */  == null) {
                                            return false;
                                        }
                                        if (!var1_2 || !"com.android.vending".equals(var2_4 = var0 /* !! */ .packageName) && !"com.google.android.gms".equals(var2_4 = var0 /* !! */ .packageName)) break block25;
                                        var1_3 = var0 /* !! */ .applicationInfo;
                                        if (var1_3 != null) break block26;
                                        var1_2 = false;
                                    }
lbl8:
                                    // 3 sources

                                    while (var1_2) {
                                        var2_4 = zzn.zzc;
lbl12:
                                        // 2 sources

                                        while (true) {
                                            var3_5 = Build.VERSION.SDK_INT;
                                            if (var3_5 < 28) {
                                                var3_6 = var0 /* !! */ .signatures;
                                                if (var3_6 != null) {
                                                    var3_7 = var0 /* !! */ .signatures.length;
                                                    var3_6 = var3_7 == 1 ? (Object)var0 /* !! */ .signatures[0].toByteArray() : null;
lbl19:
                                                    // 2 sources

                                                    while (true) {
                                                        var3_6 = var3_6 != null ? zzah.zzk(var3_6) : zzah.zzj();
                                                        break block20;
                                                        break;
                                                    }
                                                } else {
                                                    var3_6 = null;
                                                    ** continue;
                                                }
                                            }
                                            var3_5 = Build.VERSION.SDK_INT;
                                            if (var3_5 < 28) break block21;
                                            var3_5 = 1;
lbl27:
                                            // 2 sources

                                            while (true) {
                                                zzr.zza((boolean)var3_5);
                                                var3_6 = var0 /* !! */ .signingInfo;
                                                if (var3_6 == null || (var4_12 = var3_6.hasMultipleSigners()) || (var4_13 = var3_6.getSigningCertificateHistory()) == null) {
                                                    var3_6 = zzah.zzj();
                                                    break block20;
                                                }
                                                var4_13 = new zzad();
                                                var5_14 = var3_6.getSigningCertificateHistory();
                                                var6_16 = var5_14.length;
                                                for (var3_9 = 0; var3_9 < var6_16; ++var3_9) {
                                                    var4_13.zzb(var5_14[var3_9].toByteArray());
                                                }
                                                break block22;
                                                break;
                                            }
                                            break;
                                        }
                                    }
                                    break block27;
                                }
                                if ((var1_3.flags & 129) == 0) break block28;
                                var1_2 = true;
                                ** GOTO lbl8
                            }
                            var1_2 = false;
                            ** GOTO lbl8
                            catch (IllegalArgumentException v0) {
                                Log.i((String)"GoogleSignatureVerifier", (String)"package info is not set correctly");
                                if (var1_2) {
                                    var0 /* !! */  = GoogleSignatureVerifier.zzc(var0 /* !! */ , zzn.zza);
lbl54:
                                    // 2 sources

                                    while (true) {
                                        if (var0 /* !! */  == null) return false;
                                        return true;
                                    }
                                }
                                break block23;
                            }
                        }
lbl59:
                        // 2 sources

                        while (!(var4_10 = var3_6.isEmpty())) {
                            var4_11 = var3_6.zzh();
                            var5_15 = var4_11.size();
                            var3_8 = 0;
                            while (true) {
                                block24: {
                                    if (var3_8 >= var5_15) {
                                        return false;
                                    }
                                    var6_17 = (byte[])var4_11.get(var3_8);
                                    var7_18 = var2_4.zzr(0);
                                    do {
                                        var8_19 = var7_18.hasNext();
                                        var9_20 = var3_8 + 1;
                                        if (!var8_19) break block24;
                                    } while (!(var8_19 = Arrays.equals(var6_17, (byte[])var7_18.next())));
                                    return true;
                                }
                                var3_8 = var9_20;
                            }
                        }
                        ** GOTO lbl-1000
                    }
                    var3_6 = var4_13.zzd();
                    ** GOTO lbl59
                }
                var3_5 = 0;
                ** while (true)
            }
            var2_4 = zzn.zzb;
            ** while (true)
lbl-1000:
            // 1 sources

            {
                var2_4 = "Unable to obtain package certificate history.";
                throw new IllegalArgumentException((String)var2_4);
            }
        }
        var0 /* !! */  = GoogleSignatureVerifier.zzc(var0 /* !! */ , new zzj[]{zzn.zza[0]});
        ** while (true)
    }
}

