/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.ComplianceOptions;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;

@KeepForSdk
@SafeParcelable.Class(creator="ApiMetadataCreator")
public final class ApiMetadata
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<ApiMetadata> CREATOR = com.google.android.gms.common.api.zza.zza();
    private static final ApiMetadata zzb = ApiMetadata.newBuilder().build();
    @NonNull
    public static final ApiMetadata zza;
    @SafeParcelable.Field(id=1, getter="getComplianceOptions")
    @Nullable
    private final ComplianceOptions zzc;
    @SafeParcelable.Field(id=2, getter="isCallbackSupportEnabled")
    private final boolean zzd;
    private boolean zze;

    @SafeParcelable.Constructor
    ApiMetadata(@Nullable @SafeParcelable.Param(id=1) ComplianceOptions complianceOptions, @SafeParcelable.Param(id=2) boolean bl) {
        this.zzc = complianceOptions;
        this.zzd = bl;
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        if (this.zze) {
            Parcel parcel2 = parcel;
            parcel2.setDataPosition(parcel2.dataPosition() + -4);
            Parcel parcel3 = parcel;
            parcel3.setDataSize(parcel3.dataSize() + -4);
            return;
        }
        parcel.writeInt(-204102970);
        int n2 = SafeParcelWriter.beginObjectHeader(parcel);
        SafeParcelWriter.writeParcelable(parcel, 1, this.zzc, n, false);
        Parcel parcel4 = parcel;
        SafeParcelWriter.writeBoolean(parcel4, 2, this.zzd);
        SafeParcelWriter.finishObjectHeader(parcel4, n2);
    }

    public final int hashCode() {
        ComplianceOptions complianceOptions = this.zzc;
        return Objects.hashCode(complianceOptions, this.zze, this.zzd);
    }

    public final boolean equals(@Nullable Object object) {
        if (!(object instanceof ApiMetadata)) {
            return false;
        }
        object = (ApiMetadata)object;
        return Objects.equal(this.zzc, ((ApiMetadata)object).zzc) && this.zze == ((ApiMetadata)object).zze && this.zzd == ((ApiMetadata)object).zzd;
    }

    @NonNull
    public final String toString() {
        String string2 = String.valueOf(this.zzc);
        int n = String.valueOf(string2).length();
        StringBuilder stringBuilder = new StringBuilder(n + 31);
        stringBuilder.append("ApiMetadata(complianceOptions=");
        stringBuilder.append(string2);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @KeepForSdk
    @NonNull
    public static final ApiMetadata getEmptyInstance() {
        return zzb;
    }

    @KeepForSdk
    @NonNull
    public Builder toBuilder() {
        Builder builder = ApiMetadata.newBuilder();
        builder.setComplianceOptions(this.zzc);
        builder.setCallbackSupportEnabled(this.zzd);
        builder.zza(this.zze);
        return builder;
    }

    @KeepForSdk
    @NonNull
    public static Builder newBuilder() {
        return new Builder();
    }

    @KeepForSdk
    @NonNull
    public static final ApiMetadata fromComplianceOptions(@NonNull ComplianceOptions options) {
        ComplianceOptions complianceOptions;
        Builder builder = ApiMetadata.newBuilder();
        builder.setComplianceOptions(complianceOptions);
        return builder.build();
    }

    static {
        Builder builder = ApiMetadata.newBuilder();
        builder.zza(true);
        zza = builder.build();
    }

    final /* synthetic */ void zza(boolean bl) {
        this.zze = bl;
    }

    @KeepForSdk
    public static final class Builder {
        @Nullable
        private ComplianceOptions zza;
        private boolean zzb = false;
        private boolean zzc;

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setCallbackSupportEnabled(boolean callbackSupportEnabled) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setComplianceOptions(@Nullable ComplianceOptions complianceOptions) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        @KeepForSdk
        @NonNull
        public ApiMetadata build() {
            ApiMetadata apiMetadata = new ApiMetadata(this.zza, this.zzb);
            apiMetadata.zza(this.zzc);
            return apiMetadata;
        }

        final /* synthetic */ Builder zza(boolean bl) {
            this.zzc = bl;
            return this;
        }
    }
}

