/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;

@KeepForSdk
@SafeParcelable.Class(creator="ComplianceOptionsCreator")
public final class ComplianceOptions
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<ComplianceOptions> CREATOR;
    @NonNull
    public static final ComplianceOptions zza;
    @SafeParcelable.Field(id=1, getter="getCallerProductId")
    private final int zzb;
    @SafeParcelable.Field(id=2, getter="getDataOwnerProductId")
    private final int zzc;
    @SafeParcelable.Field(id=3, getter="getProcessingReason")
    private final int zzd;
    @SafeParcelable.Field(id=4, getter="isUserData", defaultValue="true")
    private final boolean zze;

    @SafeParcelable.Constructor
    ComplianceOptions(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) int n2, @SafeParcelable.Param(id=3) int n3, @SafeParcelable.Param(id=4) boolean bl) {
        this.zzb = n;
        this.zzc = n2;
        this.zzd = n3;
        this.zze = bl;
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        n = this.zzb;
        int n2 = SafeParcelWriter.beginObjectHeader(parcel);
        SafeParcelWriter.writeInt(parcel, 1, n);
        SafeParcelWriter.writeInt(parcel, 2, this.zzc);
        SafeParcelWriter.writeInt(parcel, 3, this.zzd);
        Parcel parcel2 = parcel;
        SafeParcelWriter.writeBoolean(parcel2, 4, this.zze);
        SafeParcelWriter.finishObjectHeader(parcel2, n2);
    }

    public final int hashCode() {
        return Objects.hashCode(this.zzb, this.zzc, this.zzd, this.zze);
    }

    public final boolean equals(@Nullable Object object) {
        if (!(object instanceof ComplianceOptions)) {
            return false;
        }
        object = (ComplianceOptions)object;
        return this.zzb == ((ComplianceOptions)object).zzb && this.zzc == ((ComplianceOptions)object).zzc && this.zzd == ((ComplianceOptions)object).zzd && this.zze == ((ComplianceOptions)object).zze;
    }

    @NonNull
    public final String toString() {
        int n = this.zzb;
        int n2 = this.zzc;
        int n3 = String.valueOf(n2).length();
        int n4 = this.zzd;
        int n5 = String.valueOf(n4).length();
        boolean bl = this.zze;
        int n6 = String.valueOf(bl).length();
        n3 = String.valueOf(n).length() + 55 + n3 + 19 + n5 + 13 + n6;
        StringBuilder stringBuilder = new StringBuilder(n3 + 1);
        stringBuilder.append("ComplianceOptions{callerProductId=");
        stringBuilder.append(n);
        stringBuilder.append(", dataOwnerProductId=");
        stringBuilder.append(n2);
        stringBuilder.append(", processingReason=");
        stringBuilder.append(n4);
        stringBuilder.append(", isUserData=");
        stringBuilder.append(bl);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @KeepForSdk
    @NonNull
    public static Builder newBuilder() {
        return new Builder();
    }

    @KeepForSdk
    @NonNull
    public static final Builder newBuilder(@NonNull Context context) {
        return ComplianceOptions.newBuilder();
    }

    @KeepForSdk
    @NonNull
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.setCallerProductId(this.zzb);
        builder.setDataOwnerProductId(this.zzc);
        builder.setProcessingReason(this.zzd);
        builder.setIsUserData(this.zze);
        return builder;
    }

    static {
        Builder builder = ComplianceOptions.newBuilder();
        builder.setCallerProductId(-1);
        builder.setDataOwnerProductId(-1);
        builder.setProcessingReason(0);
        builder.setIsUserData(true);
        zza = builder.build();
        CREATOR = new zzc();
    }

    @KeepForSdk
    public static final class Builder {
        private int zza = -1;
        private int zzb = -1;
        private int zzc = 0;
        private boolean zzd = true;

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setCallerProductId(int callerProductId) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setDataOwnerProductId(int dataOwnerProductId) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setProcessingReason(int processingReason) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setIsUserData(boolean isUserData) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        @KeepForSdk
        @NonNull
        public ComplianceOptions build() {
            return new ComplianceOptions(this.zza, this.zzb, this.zzc, this.zzd);
        }
    }
}

