/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.os.Binder;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.IAccountAccessor;

public class AccountAccessor
extends IAccountAccessor.Stub {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @KeepForSdk
    @Nullable
    public static Account getAccountBinderSafe(@NonNull IAccountAccessor accountAccessor) {
        IAccountAccessor iAccountAccessor;
        if (accountAccessor == null) return null;
        long l = Binder.clearCallingIdentity();
        try {
            iAccountAccessor = iAccountAccessor.zzb();
        }
        catch (RemoteException remoteException) {
            try {
                Log.w((String)"AccountAccessor", (String)"Remote account accessor probably died");
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity((long)l);
                throw throwable;
            }
        }
        Binder.restoreCallingIdentity((long)l);
        return iAccountAccessor;
        Binder.restoreCallingIdentity((long)l);
        return null;
    }

    public final boolean equals(@Nullable Object object) {
        throw null;
    }

    @Override
    @NonNull
    public final Account zzb() {
        throw null;
    }
}

