/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ConnectionTelemetryConfiguration;
import com.google.android.gms.common.internal.GetServiceRequest;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.IGmsCallbacks;
import com.google.android.gms.common.internal.IGmsServiceBroker;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.RootTelemetryConfigManager;
import com.google.android.gms.common.internal.RootTelemetryConfiguration;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzn;
import com.google.android.gms.common.internal.zzs;
import com.google.android.gms.common.wrappers.AttributionSourceWrapper;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;

@KeepForSdk
public abstract class BaseGmsClient<T extends IInterface> {
    @KeepForSdk
    public static final int CONNECT_STATE_DISCONNECTED = 1;
    @KeepForSdk
    public static final int CONNECT_STATE_CONNECTED = 4;
    @KeepForSdk
    public static final int CONNECT_STATE_DISCONNECTING = 5;
    @KeepForSdk
    @NonNull
    public static final String KEY_PENDING_INTENT = "pendingIntent";
    @KeepForSdk
    @NonNull
    public static final String DEFAULT_ACCOUNT = "<<default account>>";
    @KeepForSdk
    @NonNull
    public static final String[] GOOGLE_PLUS_REQUIRED_FEATURES;
    private static final Feature[] zze;
    private int zzf;
    private long zzg;
    private long zzh;
    private int zzi;
    private long zzj;
    @Nullable
    private volatile String zzk;
    @VisibleForTesting
    zzs zza;
    private final Context zzl;
    private final Looper zzm;
    private final GmsClientSupervisor zzn;
    private final GoogleApiAvailabilityLight zzo;
    final Handler zzb;
    private final Object zzp;
    private final Object zzq;
    @Nullable
    private IGmsServiceBroker zzr;
    @VisibleForTesting
    @NonNull
    protected ConnectionProgressReportCallbacks zzc;
    @Nullable
    private IInterface zzs;
    private final ArrayList zzt;
    @Nullable
    private zze zzu;
    private int zzv;
    @Nullable
    private final BaseConnectionCallbacks zzw;
    @Nullable
    private final BaseOnConnectionFailedListener zzx;
    private final int zzy;
    @Nullable
    private final String zzz;
    @Nullable
    private volatile String zzA;
    @Nullable
    private volatile AttributionSourceWrapper zzB;
    @Nullable
    private ConnectionResult zzC;
    private boolean zzD;
    @Nullable
    private volatile zzj zzE;
    @VisibleForTesting
    @NonNull
    protected AtomicInteger zzd;

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    protected BaseGmsClient(@NonNull Context context, @NonNull Looper looper, int gCoreServiceId, @Nullable BaseConnectionCallbacks connectedListener, @Nullable BaseOnConnectionFailedListener connectionFailedListener, @Nullable String realClientName) {
        void var6_6;
        void var3_3;
        void var2_2;
        void var5_5;
        void var4_4;
        void var1_1;
        void v0 = var1_1;
        GmsClientSupervisor gmsClientSupervisor = GmsClientSupervisor.getInstance((Context)v0);
        GoogleApiAvailabilityLight googleApiAvailabilityLight = GoogleApiAvailabilityLight.getInstance();
        Preconditions.checkNotNull(var4_4);
        BaseConnectionCallbacks baseConnectionCallbacks = (BaseConnectionCallbacks)var4_4;
        Preconditions.checkNotNull(var5_5);
        this((Context)v0, (Looper)var2_2, gmsClientSupervisor, googleApiAvailabilityLight, (int)var3_3, baseConnectionCallbacks, (BaseOnConnectionFailedListener)var5_5, (String)var6_6);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @KeepForSdk
    protected BaseGmsClient(@NonNull Context context, @NonNull Looper looper, @NonNull GmsClientSupervisor supervisor, @NonNull GoogleApiAvailabilityLight apiAvailability, int gCoreServiceId, @Nullable BaseConnectionCallbacks connectedListener, @Nullable BaseOnConnectionFailedListener connectionFailedListener, @Nullable String realClientName) {
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        this.zzk = null;
        this.zzp = new Object();
        this.zzq = new Object();
        this.zzt = new ArrayList();
        this.zzv = 1;
        this.zzC = null;
        this.zzD = false;
        this.zzE = null;
        this.zzd = new AtomicInteger(0);
        Preconditions.checkNotNull(var1_1, "Context must not be null");
        this.zzl = (Context)var1_1;
        Preconditions.checkNotNull(var2_2, "Looper must not be null");
        this.zzm = (Looper)var2_2;
        Preconditions.checkNotNull(var3_3, "Supervisor must not be null");
        this.zzn = (GmsClientSupervisor)var3_3;
        Preconditions.checkNotNull(var4_4, "API availability must not be null");
        this.zzo = (GoogleApiAvailabilityLight)var4_4;
        this.zzb = new zzb(this, (Looper)var2_2);
        this.zzy = var5_5;
        this.zzw = var6_6;
        this.zzx = var7_7;
        this.zzz = var8_8;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @KeepForSdk
    protected BaseGmsClient(@NonNull Context context, @NonNull Handler handler, @NonNull GmsClientSupervisor supervisor, @NonNull GoogleApiAvailabilityLight apiAvailability, int gCoreServiceId, @Nullable BaseConnectionCallbacks connectedListener, @Nullable BaseOnConnectionFailedListener connectionFailedListener) {
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        this.zzk = null;
        this.zzp = new Object();
        this.zzq = new Object();
        this.zzt = new ArrayList();
        this.zzv = 1;
        this.zzC = null;
        this.zzD = false;
        this.zzE = null;
        this.zzd = new AtomicInteger(0);
        Preconditions.checkNotNull(var1_1, "Context must not be null");
        this.zzl = (Context)var1_1;
        Preconditions.checkNotNull(var2_2, "Handler must not be null");
        this.zzb = (Handler)var2_2;
        this.zzm = var2_2.getLooper();
        Preconditions.checkNotNull(var3_3, "Supervisor must not be null");
        this.zzn = (GmsClientSupervisor)var3_3;
        Preconditions.checkNotNull(var4_4, "API availability must not be null");
        this.zzo = (GoogleApiAvailabilityLight)var4_4;
        this.zzy = var5_5;
        this.zzw = var6_6;
        this.zzx = var7_7;
        this.zzz = null;
    }

    @NonNull
    @KeepForSdk
    protected abstract String getStartServiceAction();

    @KeepForSdk
    @NonNull
    protected String getStartServicePackage() {
        return "com.google.android.gms";
    }

    @NonNull
    @KeepForSdk
    protected abstract String getServiceDescriptor();

    @KeepForSdk
    @Nullable
    protected Executor getBindServiceExecutor() {
        return null;
    }

    @Nullable
    @KeepForSdk
    public AttributionSourceWrapper getAttributionSourceWrapper() {
        return this.zzB;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void setAttributionTag(@NonNull String attributionTag) {
        void var1_1;
        this.zzA = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void setAttributionSourceWrapper(@NonNull AttributionSourceWrapper attributionSourceWrapper) {
        void var1_1;
        this.zzB = var1_1;
    }

    @Nullable
    @KeepForSdk
    protected String getLocalStartServiceAction() {
        return null;
    }

    @Nullable
    @KeepForSdk
    public final Feature[] getAvailableFeatures() {
        zzj this_ = ((BaseGmsClient)((Object)this_)).zzE;
        if (this_ == null) {
            return null;
        }
        return this_.zzb;
    }

    @Nullable
    @KeepForSdk
    public ConnectionTelemetryConfiguration getTelemetryConfiguration() {
        zzj this_ = ((BaseGmsClient)((Object)this_)).zzE;
        if (this_ == null) {
            return null;
        }
        return this_.zzd;
    }

    @KeepForSdk
    public boolean hasConnectionInfo() {
        return this.zzE != null;
    }

    @KeepForSdk
    public int getGCoreServiceId() {
        return this.zzy;
    }

    @Nullable
    @KeepForSdk
    protected abstract T createServiceInterface(@NonNull IBinder var1);

    @CallSuper
    @KeepForSdk
    protected void onConnectedLocked(@NonNull T t) {
        this.zzh = System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    @CallSuper
    @KeepForSdk
    protected void onConnectionSuspended(int cause) {
        void var1_1;
        this.zzf = var1_1;
        this.zzg = System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    @CallSuper
    @KeepForSdk
    protected void onConnectionFailed(@NonNull ConnectionResult result) {
        void var1_1;
        this.zzi = var1_1.getErrorCode();
        this.zzj = System.currentTimeMillis();
    }

    @KeepForSdk
    public void checkAvailabilityAndConnect() {
        int n = this.zzo.isGooglePlayServicesAvailable(this.zzl, this.getMinApkVersion());
        if (n != 0) {
            this.zzp(1, null);
            BaseGmsClient baseGmsClient = this;
            baseGmsClient.triggerNotAvailable(new LegacyClientCallbackAdapter(baseGmsClient), n, null);
            return;
        }
        BaseGmsClient baseGmsClient = this;
        baseGmsClient.connect(new LegacyClientCallbackAdapter(baseGmsClient));
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void connect(@NonNull ConnectionProgressReportCallbacks callbacks) {
        void var1_1;
        Preconditions.checkNotNull(callbacks, "Connection progress callbacks cannot be null.");
        this.zzc = (ConnectionProgressReportCallbacks)var1_1;
        this.zzp(2, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public boolean isConnected() {
        Object object = this.zzp;
        synchronized (object) {
            boolean bl = this.zzv;
            if (!bl) return false;
            return true;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public boolean isConnecting() {
        Object object = this.zzp;
        synchronized (object) {
            boolean bl = this.zzv;
            if (bl) return true;
            if (!bl) return false;
            return true;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void disconnect(@NonNull String message) {
        void var1_1;
        this.zzk = var1_1;
        this.disconnect();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public void disconnect() {
        this.zzd.incrementAndGet();
        ArrayList arrayList = this.zzt;
        synchronized (arrayList) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ((zzc)arrayList.get(i)).zzf();
            }
            arrayList.clear();
        }
        Object object = this.zzq;
        synchronized (object) {
            this.zzr = null;
            // MONITOREXIT @DISABLED, blocks:[2, 6] lbl15 : MonitorExitStatement: MONITOREXIT : var1_5
            this.zzp(1, null);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @KeepForSdk
    @Nullable
    public String getLastDisconnectMessage() {
        return this.zzk;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void triggerConnectionSuspended(int cause) {
        void var1_1;
        int n = this.zzd.get();
        Handler handler = this.zzb;
        handler.sendMessage(handler.obtainMessage(6, n, (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @KeepForSdk
    protected void triggerNotAvailable(@NonNull ConnectionProgressReportCallbacks callbacks, int errorCode, @Nullable PendingIntent resolution) {
        void var3_4;
        void var2_3;
        void var1_1;
        Preconditions.checkNotNull(callbacks, "Connection progress callbacks cannot be null.");
        this.zzc = (ConnectionProgressReportCallbacks)var1_1;
        int n = this.zzd.get();
        Handler handler = this.zzb;
        handler.sendMessage(handler.obtainMessage(3, n, (int)var2_3, (Object)var3_4));
    }

    @KeepForSdk
    @NonNull
    public final Context getContext() {
        return this.zzl;
    }

    @KeepForSdk
    @NonNull
    public final Looper getLooper() {
        return this.zzm;
    }

    @KeepForSdk
    @Nullable
    public Account getAccount() {
        return null;
    }

    @KeepForSdk
    @NonNull
    public Feature[] getApiFeatures() {
        return zze;
    }

    @KeepForSdk
    @NonNull
    protected Bundle getGetServiceRequestExtraArgs() {
        return new Bundle();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    protected void onPostInitHandler(int statusCode, @Nullable IBinder service, @Nullable Bundle resolution, int disconnectCount) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        zzf zzf2 = new zzf(this, (int)var1_1, (IBinder)var2_2, (Bundle)var3_3);
        Handler handler = this.zzb;
        handler.sendMessage(handler.obtainMessage(1, (int)var4_4, -1, (Object)zzf2));
    }

    @KeepForSdk
    protected final void checkConnected() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    @KeepForSdk
    @Nullable
    public Bundle getConnectionHint() {
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @NonNull
    public final T getService() throws DeadObjectException {
        Object object = this_.zzp;
        synchronized (object) {
            int n = this_.zzv;
            if (n == 5) {
                throw new DeadObjectException();
            }
            this_.checkConnected();
            BaseGmsClient this_ = this_.zzs;
            String string2 = "Client is connected but service is null";
            Preconditions.checkNotNull(this_, string2);
            this_ = (IInterface)this_;
            return (T)this_;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @WorkerThread
    @KeepForSdk
    public void getRemoteService(@Nullable IAccountAccessor authedAccountAccessor, @NonNull Set<Scope> scopes) {
        block15: {
            BaseGmsClient baseGmsClient;
            Object object;
            Object object2;
            Object object3;
            Bundle bundle = this.getGetServiceRequestExtraArgs();
            object3 = Build.VERSION.SDK_INT < 31 ? this.zzA : (this.zzB == null ? this.zzA : ((object3 = this.zzB.getAttributionSource()) == null ? this.zzA : (object3.getAttributionTag() == null ? this.zzA : object3.getAttributionTag())));
            GetServiceRequest getServiceRequest = new GetServiceRequest(6, this.zzy, GoogleApiAvailabilityLight.GOOGLE_PLAY_SERVICES_VERSION_CODE, null, null, GetServiceRequest.zza, new Bundle(), null, GetServiceRequest.zzb, GetServiceRequest.zzb, true, 0, false, (String)object3);
            getServiceRequest.zzf = this.zzl.getPackageName();
            getServiceRequest.zzi = bundle;
            if (object2 != null) {
                getServiceRequest.zzh = object2.toArray(new Scope[0]);
            }
            if (this.requiresSignIn()) {
                object2 = this.getAccount();
                if (object2 == null) {
                    object2 = new Account(DEFAULT_ACCOUNT, "com.google");
                }
                getServiceRequest.zzj = object2;
                if (object != null) {
                    getServiceRequest.zzg = object.asBinder();
                }
            } else if (this.requiresAccount()) {
                getServiceRequest.zzj = this.getAccount();
            }
            getServiceRequest.zzk = zze;
            getServiceRequest.zzl = this.getApiFeatures();
            if (this.usesClientTelemetry()) {
                getServiceRequest.zzo = true;
            }
            try {
                object = this.zzq;
                // MONITORENTER : object
                object2 = this.zzr;
                if (object2 == null) break block15;
                baseGmsClient = this;
            }
            catch (DeadObjectException deadObjectException) {
                Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)deadObjectException);
                this.triggerConnectionSuspended(3);
                return;
            }
            catch (SecurityException securityException) {
                throw securityException;
            }
            catch (RemoteException | RuntimeException throwable) {
                Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)throwable);
                this.onPostInitHandler(8, null, null, this.zzd.get());
                return;
            }
            object3 = new zzd(baseGmsClient, baseGmsClient.zzd.get());
            object2.getService((IGmsCallbacks)object3, getServiceRequest);
            // MONITOREXIT : object
            return;
        }
        Log.w((String)"GmsClient", (String)"mServiceBroker is null, client disconnected");
        return;
    }

    @KeepForSdk
    protected boolean enableLocalFallback() {
        return false;
    }

    @KeepForSdk
    public boolean requiresSignIn() {
        return false;
    }

    @KeepForSdk
    public void onUserSignOut(@NonNull SignOutCallbacks signOutCallbacks) {
        signOutCallbacks.onSignOutComplete();
    }

    @KeepForSdk
    public boolean requiresAccount() {
        return false;
    }

    @KeepForSdk
    public boolean requiresGooglePlayServices() {
        return true;
    }

    @KeepForSdk
    public boolean providesSignIn() {
        return false;
    }

    @KeepForSdk
    @NonNull
    public Intent getSignInIntent() {
        throw new UnsupportedOperationException("Not a sign in API");
    }

    @KeepForSdk
    @NonNull
    protected Set<Scope> getScopes() {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @KeepForSdk
    public void dump(@NonNull String prefix, @NonNull FileDescriptor object, @NonNull PrintWriter writer, @NonNull String[] stringArray) {
        StringBuilder stringBuilder;
        long l;
        void var1_3;
        void var3_6;
        object = this.zzp;
        // MONITORENTER : object
        int n = this.zzv;
        IInterface iInterface = this.zzs;
        // MONITOREXIT : object
        object = this.zzq;
        // MONITORENTER : object
        IGmsServiceBroker iGmsServiceBroker = this.zzr;
        // MONITOREXIT : object
        var3_6.append((CharSequence)var1_3).append("mConnectState=");
        {
            catch (Throwable throwable) {}
            {
                // MONITOREXIT : object
                throw throwable;
            }
        }
        switch (n) {
            default: {
                var3_6.print("UNKNOWN");
                break;
            }
            case 5: {
                var3_6.print("DISCONNECTING");
                break;
            }
            case 4: {
                var3_6.print("CONNECTED");
                break;
            }
            case 3: {
                var3_6.print("LOCAL_CONNECTING");
                break;
            }
            case 2: {
                var3_6.print("REMOTE_CONNECTING");
                break;
            }
            case 1: {
                var3_6.print("DISCONNECTED");
            }
        }
        var3_6.append(" mService=");
        if (iInterface == null) {
            var3_6.append("null");
        } else {
            var3_6.append(this.getServiceDescriptor()).append("@").append(Integer.toHexString(System.identityHashCode(iInterface.asBinder())));
        }
        var3_6.append(" mServiceBroker=");
        if (iGmsServiceBroker == null) {
            var3_6.println("null");
        } else {
            var3_6.append("IGmsServiceBroker@").println(Integer.toHexString(System.identityHashCode(iGmsServiceBroker.asBinder())));
        }
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        String string2 = " ";
        if (this.zzh > 0L) {
            PrintWriter printWriter = var3_6.append((CharSequence)var1_3).append("lastConnectedTime=");
            l = this.zzh;
            String string3 = ((DateFormat)object).format(new Date(l));
            int n2 = String.valueOf(l).length() + 1;
            int n3 = String.valueOf(string3).length();
            stringBuilder = new StringBuilder(n2 + n3);
            stringBuilder.append(l);
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.append(string2);
            stringBuilder2.append(string3);
            printWriter.println(stringBuilder.toString());
        }
        if (this.zzg > 0L) {
            var3_6.append((CharSequence)var1_3).append("lastSuspendedCause=");
            int n4 = this.zzf;
            switch (n4) {
                default: {
                    var3_6.append(String.valueOf(n4));
                    break;
                }
                case 3: {
                    var3_6.append("CAUSE_DEAD_OBJECT_EXCEPTION");
                    break;
                }
                case 2: {
                    var3_6.append("CAUSE_NETWORK_LOST");
                    break;
                }
                case 1: {
                    var3_6.append("CAUSE_SERVICE_DISCONNECTED");
                }
            }
            PrintWriter printWriter = var3_6.append(" lastSuspendedTime=");
            l = this.zzg;
            String string4 = ((DateFormat)object).format(new Date(l));
            n4 = String.valueOf(l).length() + 1;
            int n5 = String.valueOf(string4).length();
            stringBuilder = new StringBuilder(n4 + n5);
            stringBuilder.append(l);
            StringBuilder stringBuilder3 = stringBuilder;
            stringBuilder3.append(string2);
            stringBuilder3.append(string4);
            printWriter.println(stringBuilder.toString());
        }
        if (this.zzj <= 0L) return;
        var3_6.append((CharSequence)var1_3).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(this.zzi));
        PrintWriter printWriter = var3_6.append(" lastFailedTime=");
        l = this.zzj;
        String string5 = ((DateFormat)object).format(new Date(l));
        int n6 = String.valueOf(l).length() + 1;
        int n7 = String.valueOf(string5).length();
        object = new StringBuilder(n6 + n7);
        ((StringBuilder)object).append(l);
        Object object2 = object;
        ((StringBuilder)object2).append(string2);
        ((StringBuilder)object2).append(string5);
        printWriter.println(((StringBuilder)object).toString());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @KeepForSdk
    public IBinder getServiceBrokerBinder() {
        Object object = ((BaseGmsClient)((Object)this_)).zzq;
        synchronized (object) {
            IGmsServiceBroker this_ = ((BaseGmsClient)((Object)this_)).zzr;
            if (this_ != null) return this_.asBinder();
            return null;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @KeepForSdk
    @NonNull
    public String getEndpointPackageName() {
        if (!((BaseGmsClient)this).isConnected() || (this = ((BaseGmsClient)this).zza) == null) {
            throw new RuntimeException("Failed to connect when checking package");
        }
        return ((zzs)this).zzb();
    }

    @KeepForSdk
    public int getMinApkVersion() {
        return GoogleApiAvailabilityLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    }

    @KeepForSdk
    protected boolean getUseDynamicLookup() {
        return this.getMinApkVersion() >= 211700000;
    }

    @KeepForSdk
    public boolean usesClientTelemetry() {
        return false;
    }

    static {
        zze = new Feature[0];
        String string2 = "service_esmobile";
        GOOGLE_PLUS_REQUIRED_FEATURES = new String[]{string2, "service_googleme"};
    }

    @NonNull
    protected final String zza() {
        String string2 = this.zzz;
        if (string2 == null) {
            return this.zzl.getClass().getName();
        }
        return string2;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final void zzp(int var1_2, @Nullable IInterface var2_12) {
        var3_13 = var1_2 == 4;
        {
            block16: {
                var4_15 = var2_12 != null;
                var3_13 = var3_13 == var4_15;
                Preconditions.checkArgument(var3_13);
                var3_14 = this.zzp;
                // MONITORENTER : var3_14
                ** try [egrp 0[TRYBLOCK] [0 : 33->784)] { 
lbl8:
                // 1 sources

                this.zzv = var1_2;
                this.zzs = var2_12;
                switch (var1_2) {
                    case 2: 
                    case 3: {
                        var1_3 = "Calling connect() while still connected, missing disconnect() for ";
                        var2_12 = " on ";
                        var4_16 = "Internal Error, the minimum apk version of this BaseGmsClient is too low to support dynamic lookup. Start service action: ";
                        var5_18 = "unable to connect to service: ";
                        var6_20 = this.zzu;
                        if (var6_20 != null && (var7_22 = this.zza) != null) {
                            var8_23 = "GmsClient";
                            var9_24 = var7_22.zza();
                            var7_22 = var7_22.zzb();
                            var10_26 = String.valueOf(var9_24).length() + 70 + String.valueOf(var7_22).length();
                            v0 = new StringBuilder(var10_26);
                            v0.append((String)var1_3);
                            v0.append(var9_24);
                            v0.append((String)var2_12);
                            v0.append((String)var7_22);
                            Log.e((String)var8_23, (String)v0.toString());
                            var1_3 = this.zzn;
                            v1 = this.zza.zza();
                            Preconditions.checkNotNull(v1);
                            var7_22 = v1;
                            var8_23 = this.zza.zzb();
                            var1_3.zzb((String)var7_22, var8_23, 4225, var6_20, this.zza(), this.zza.zzc());
                            this.zzd.incrementAndGet();
                        }
                        v2 = this;
                        this.zzu = var6_20 = new zze(v2, v2.zzd.get());
                        var1_4 = this.zzv;
                        if (var1_4 == 3 && (var1_5 = this.getLocalStartServiceAction()) != null) {
                            var7_22 = this.getContext().getPackageName();
                            var8_23 = this.getLocalStartServiceAction();
                            var1_5 = new zzs((String)var7_22, var8_23, true, 4225, false);
                        } else {
                            var7_22 = this.getStartServicePackage();
                            var8_23 = this.getStartServiceAction();
                            var1_5 = new zzs((String)var7_22, var8_23, false, 4225, this.getUseDynamicLookup());
                        }
                        this.zza = var1_5;
                        var1_6 = this.zza.zzc();
                        if (var1_6 != 0 && (var1_6 = this.getMinApkVersion()) < 17895000) break block16;
                        var1_7 = this.zzn;
                        v3 = this.zza.zza();
                        Preconditions.checkNotNull(v3);
                        var4_16 = v3;
                        var7_22 = this.zza.zzb();
                        var8_23 = this.zza();
                        var9_25 = this.zza.zzc();
                        var10_27 = this.getBindServiceExecutor();
                        var11_28 = new zzn((String)var4_16, (String)var7_22, 4225, var9_25);
                        var4_16 = var1_7.zza(var11_28, var6_20, var8_23, var10_27);
                        var1_8 = var4_16.isSuccess();
                        if (!var1_8) {
                            v4 = this.zza.zza();
                            var1_9 = this.zza.zzb();
                            var6_21 = String.valueOf(v4).length() + 34 + String.valueOf(var1_9).length();
                            v5 = new StringBuilder(var6_21);
                            v5.append(var5_18);
                            v5.append(v4);
                            v5.append((String)var2_12);
                            v5.append(var1_9);
                            Log.w((String)"GmsClient", (String)v5.toString());
                            var1_10 = var4_16.getErrorCode();
                            var1_10 = var1_10 == -1 ? 16 : var4_16.getErrorCode();
                            var2_12 = var4_16.getResolution();
                            if (var2_12 != null) {
                                v6 = new Bundle();
                                v6.putParcelable("pendingIntent", (Parcelable)var4_16.getResolution());
                                var2_12 = v6;
                            } else {
                                var2_12 = null;
                            }
                            v7 = this;
                            v7.zzb(var1_10, (Bundle)var2_12, v7.zzd.get());
                            ** break;
                        }
                        ** GOTO lbl107
                    }
                    case 1: {
                        var1_11 = this.zzu;
                        if (var1_11 != null) {
                            var2_12 = this.zzn;
                            v8 = this.zza.zza();
                            Preconditions.checkNotNull(v8);
                            var4_17 = v8;
                            var5_19 = this.zza.zzb();
                            var2_12.zzb(var4_17, var5_19, 4225, var1_11, this.zza(), this.zza.zzc());
                            this.zzu = null;
                        }
                    }
lbl107:
                    // 6 sources

                    default: {
                        // MONITOREXIT : var3_14
                        return;
                    }
                    case 4: 
                }
                Preconditions.checkNotNull(var2_12);
                this.onConnectedLocked((IInterface)var2_12);
                return;
            }
            v9 = this.zza.zza();
            String.valueOf(v9);
            throw new IllegalStateException(var4_16.concat(String.valueOf(v9)));
        }
lbl120:
        // 1 sources

        catch (Throwable var0_1) {}
        // MONITOREXIT : var3_14
        throw var0_1;
    }

    protected final void zzb(int n, @Nullable Bundle bundle, int n2) {
        zzg zzg2 = new zzg(this, n, bundle);
        Handler handler = this.zzb;
        handler.sendMessage(handler.obtainMessage(7, n2, -1, (Object)zzg2));
    }

    /*
     * Enabled aggressive block sorting
     */
    final /* synthetic */ void zzc(zzj object) {
        ((BaseGmsClient)object2).zzE = object;
        if (!((BaseGmsClient)object2).usesClientTelemetry()) {
            return;
        }
        Object object2 = ((zzj)object).zzd;
        object = RootTelemetryConfigManager.getInstance();
        object2 = object2 == null ? null : ((ConnectionTelemetryConfiguration)object2).zza();
        ((RootTelemetryConfigManager)object).zza((RootTelemetryConfiguration)object2);
    }

    final /* synthetic */ void zzd(int n, IInterface iInterface) {
        this.zzp(n, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final /* synthetic */ boolean zze(int n, int n2, IInterface iInterface) {
        Object object = this.zzp;
        synchronized (object) {
            int n3 = this.zzv;
            if (n3 != n) {
                return false;
            }
            this.zzp(n2, iInterface);
            return true;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final /* synthetic */ void zzf(int n) {
        int n2;
        block6: {
            Object object = this.zzp;
            synchronized (object) {
                int n3 = this.zzv;
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl5 : MonitorExitStatement: MONITOREXIT : var1_3
                if (n3 == 3) {
                    this.zzD = true;
                    n2 = 5;
                    break block6;
                } else {
                    n2 = 4;
                }
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
            }
        }
        Handler handler = this.zzb;
        handler.sendMessage(handler.obtainMessage(n2, this.zzd.get(), 16));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final /* synthetic */ boolean zzg() {
        if (this.zzD) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.getServiceDescriptor())) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.getLocalStartServiceAction())) {
            return false;
        }
        try {
            Class.forName(this.getServiceDescriptor());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    final /* synthetic */ Object zzh() {
        return this.zzq;
    }

    final /* synthetic */ void zzi(IGmsServiceBroker iGmsServiceBroker) {
        this.zzr = iGmsServiceBroker;
    }

    final /* synthetic */ ArrayList zzj() {
        return this.zzt;
    }

    final /* synthetic */ BaseConnectionCallbacks zzk() {
        return this.zzw;
    }

    final /* synthetic */ BaseOnConnectionFailedListener zzl() {
        return this.zzx;
    }

    final /* synthetic */ ConnectionResult zzm() {
        return this.zzC;
    }

    final /* synthetic */ void zzn(ConnectionResult connectionResult) {
        this.zzC = connectionResult;
    }

    final /* synthetic */ boolean zzo() {
        return this.zzD;
    }

    @KeepForSdk
    public static interface BaseConnectionCallbacks {
        @KeepForSdk
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        @KeepForSdk
        public static final int CAUSE_DEAD_OBJECT_EXCEPTION = 3;

        @KeepForSdk
        public void onConnected(@Nullable Bundle var1);

        @KeepForSdk
        public void onConnectionSuspended(int var1);
    }

    @KeepForSdk
    public static interface BaseOnConnectionFailedListener {
        @KeepForSdk
        public void onConnectionFailed(@NonNull ConnectionResult var1);
    }

    protected class LegacyClientCallbackAdapter
    implements ConnectionProgressReportCallbacks {
        final /* synthetic */ BaseGmsClient zza;

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public LegacyClientCallbackAdapter(BaseGmsClient this$0) {
            void var1_1;
            Objects.requireNonNull(this$0);
            this.zza = var1_1;
        }

        @Override
        public final void onReportServiceBinding(@NonNull ConnectionResult connectionResult) {
            if (connectionResult.isSuccess()) {
                BaseGmsClient baseGmsClient = ((LegacyClientCallbackAdapter)((Object)baseGmsClient)).zza;
                baseGmsClient.getRemoteService(null, baseGmsClient.getScopes());
                return;
            }
            BaseGmsClient baseGmsClient = ((LegacyClientCallbackAdapter)((Object)baseGmsClient)).zza;
            if (baseGmsClient.zzl() != null) {
                baseGmsClient.zzl().onConnectionFailed(connectionResult);
                return;
            }
        }
    }

    @KeepForSdk
    public static interface ConnectionProgressReportCallbacks {
        @KeepForSdk
        public void onReportServiceBinding(@NonNull ConnectionResult var1);
    }

    @KeepForSdk
    public static interface SignOutCallbacks {
        @KeepForSdk
        public void onSignOutComplete();
    }
}

