/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.common;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.fido.common.zza;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

public final class Transport
extends Enum<Transport>
implements ReflectedParcelable {
    @NonNull
    public static final /* enum */ Transport BLUETOOTH_CLASSIC;
    @NonNull
    public static final /* enum */ Transport BLUETOOTH_LOW_ENERGY;
    @NonNull
    public static final /* enum */ Transport NFC;
    @NonNull
    public static final /* enum */ Transport USB;
    @NonNull
    public static final /* enum */ Transport INTERNAL;
    @NonNull
    public static final /* enum */ Transport HYBRID;
    @NonNull
    public static final Parcelable.Creator<Transport> CREATOR;
    @NonNull
    public static final /* enum */ Transport zza;
    private static final /* synthetic */ Transport[] zzb;
    private final String zzc;

    public int describeContents() {
        return 0;
    }

    @NonNull
    public static Transport fromString(@NonNull String value) throws UnsupportedTransportException {
        Transport[] transportArray = Transport.values();
        int n = transportArray.length;
        int n2 = 0;
        while (true) {
            String string;
            if (n2 < n) {
                Transport transport = transportArray[n2];
                if (string.equals(transport.zzc)) {
                    return transport;
                }
            } else {
                Object[] objectArray = new Object[]{string};
                throw new UnsupportedTransportException(String.format("Transport %s not supported", objectArray));
            }
            ++n2;
        }
    }

    @NonNull
    public static Transport valueOf(@NonNull String name) {
        String string;
        return Enum.valueOf(Transport.class, string);
    }

    @NonNull
    public String toString() {
        return this.zzc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public static List<Transport> parseTransports(@NonNull JSONArray transports) throws JSONException {
        JSONArray jSONArray;
        if (transports == null) {
            return null;
        }
        HashSet<Transport> hashSet = new HashSet<Transport>(jSONArray.length());
        int n = 0;
        while (n < jSONArray.length()) {
            String string = jSONArray.getString(n);
            if (string != null && !string.isEmpty()) {
                try {
                    hashSet.add(Transport.fromString(string));
                }
                catch (UnsupportedTransportException unsupportedTransportException) {
                    string = "Ignoring unrecognized transport ".concat(string);
                    Log.w((String)"Transport", (String)string);
                }
            }
            ++n;
        }
        return new ArrayList<Transport>(hashSet);
    }

    static {
        String string = "bt";
        BLUETOOTH_CLASSIC = new Transport(string);
        string = "ble";
        BLUETOOTH_LOW_ENERGY = new Transport(string);
        string = "nfc";
        NFC = new Transport(string);
        string = "usb";
        USB = new Transport(string);
        string = "internal";
        INTERNAL = new Transport(string);
        string = "cable";
        HYBRID = new Transport(string);
        string = "hybrid";
        zza = new Transport(string);
        zzb = new Transport[]{BLUETOOTH_CLASSIC, BLUETOOTH_LOW_ENERGY, NFC, USB, INTERNAL, HYBRID, zza};
        CREATOR = new zza();
    }

    private Transport(String string2) {
        this.zzc = string2;
    }

    public void writeToParcel(@NonNull Parcel parcel, int n) {
        parcel.writeString(this.zzc);
    }

    @NonNull
    public static Transport[] values() {
        return (Transport[])zzb.clone();
    }

    public static class UnsupportedTransportException
    extends Exception {
        /*
         * WARNING - void declaration
         */
        public UnsupportedTransportException(@NonNull String errorMessage) {
            super((String)var1_1);
            void var1_1;
        }
    }
}

