/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.fido2.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fido.fido2.api.common.Attachment;
import com.google.android.gms.fido.fido2.api.common.ResidentKeyRequirement;
import com.google.android.gms.fido.fido2.api.common.UserVerificationRequirement;
import com.google.android.gms.fido.fido2.api.common.zzbd;
import com.google.android.gms.fido.fido2.api.common.zzm;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="AuthenticatorSelectionCriteriaCreator")
public class AuthenticatorSelectionCriteria
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<AuthenticatorSelectionCriteria> CREATOR = new zzm();
    @Nullable
    @SafeParcelable.Field(id=2, getter="getAttachmentAsString", type="java.lang.String")
    private final Attachment zza;
    @Nullable
    @SafeParcelable.Field(id=3, getter="getRequireResidentKey")
    private final Boolean zzb;
    @Nullable
    @SafeParcelable.Field(id=4, getter="getRequireUserVerificationAsString", type="java.lang.String")
    private final UserVerificationRequirement zzc;
    @Nullable
    @SafeParcelable.Field(id=5, getter="getResidentKeyRequirementAsString", type="java.lang.String")
    private final ResidentKeyRequirement zzd;

    public int hashCode() {
        Attachment attachment = this.zza;
        return Objects.hashCode((Object[])new Object[]{attachment, this.zzb, this.zzc, this.getResidentKeyRequirement()});
    }

    @Nullable
    public Attachment getAttachment() {
        return this.zza;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public ResidentKeyRequirement getResidentKeyRequirement() {
        void var0_3;
        ResidentKeyRequirement residentKeyRequirement = this.zzd;
        if (residentKeyRequirement == null) {
            Boolean bl = this.zzb;
            if (bl != null && bl.booleanValue()) {
                ResidentKeyRequirement residentKeyRequirement2 = ResidentKeyRequirement.RESIDENT_KEY_REQUIRED;
                return var0_3;
            }
            ResidentKeyRequirement residentKeyRequirement3 = ResidentKeyRequirement.RESIDENT_KEY_DISCOURAGED;
            return var0_3;
        }
        ResidentKeyRequirement residentKeyRequirement4 = residentKeyRequirement;
        return var0_3;
    }

    @Nullable
    public Boolean getRequireResidentKey() {
        return this.zzb;
    }

    @Nullable
    public String getAttachmentAsString() {
        Object this_ = this_.zza;
        if (this_ == null) {
            return null;
        }
        return ((Attachment)((Object)this_)).toString();
    }

    @Nullable
    public String getResidentKeyRequirementAsString() {
        if ((this = ((AuthenticatorSelectionCriteria)((Object)this)).getResidentKeyRequirement()) == null) {
            return null;
        }
        return ((ResidentKeyRequirement)((Object)this)).toString();
    }

    @NonNull
    public final String toString() {
        String string = String.valueOf((Object)this.zza);
        String string2 = String.valueOf((Object)this.zzc);
        String string3 = String.valueOf((Object)this.zzd);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AuthenticatorSelectionCriteria{\n attachment=");
        stringBuilder.append(string);
        stringBuilder.append(", \n requireResidentKey=");
        stringBuilder.append(this.zzb);
        stringBuilder.append(", \n requireUserVerification=");
        stringBuilder.append(string2);
        stringBuilder.append(", \n residentKeyRequirement=");
        stringBuilder.append(string3);
        stringBuilder.append("\n }");
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SafeParcelable.Constructor
    AuthenticatorSelectionCriteria(@Nullable @SafeParcelable.Param(id=2) String object, @Nullable @SafeParcelable.Param(id=3) Boolean bl, @Nullable @SafeParcelable.Param(id=4) String string, @Nullable @SafeParcelable.Param(id=5) String string2) {
        if (object == null) {
            object = null;
        } else {
            object = Attachment.fromString(object);
        }
        try {
            this.zza = object;
            this.zzb = bl;
            object = string == null ? null : UserVerificationRequirement.fromString(string);
            this.zzc = object;
            object = string2 == null ? null : ResidentKeyRequirement.fromString(string2);
            this.zzd = object;
            return;
        }
        catch (Attachment.UnsupportedAttachmentException | ResidentKeyRequirement.UnsupportedResidentKeyRequirementException | zzbd exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var2_5;
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getAttachmentAsString(), (boolean)false);
        SafeParcelWriter.writeBooleanObject((Parcel)var1_1, (int)3, (Boolean)this.getRequireResidentKey(), (boolean)false);
        UserVerificationRequirement userVerificationRequirement = this.zzc;
        if (userVerificationRequirement == null) {
            Object var2_4 = null;
        } else {
            String string = userVerificationRequirement.toString();
        }
        SafeParcelWriter.writeString((Parcel)var1_1, (int)4, (String)var2_5, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)5, (String)this.getResidentKeyRequirementAsString(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n2);
    }

    public boolean equals(@Nullable Object obj) {
        AuthenticatorSelectionCriteria authenticatorSelectionCriteria;
        if (!(obj instanceof AuthenticatorSelectionCriteria)) {
            return false;
        }
        authenticatorSelectionCriteria = authenticatorSelectionCriteria;
        return Objects.equal((Object)((Object)this.zza), (Object)((Object)authenticatorSelectionCriteria.zza)) && Objects.equal((Object)this.zzb, (Object)authenticatorSelectionCriteria.zzb) && Objects.equal((Object)((Object)this.zzc), (Object)((Object)authenticatorSelectionCriteria.zzc)) && Objects.equal((Object)((Object)this.getResidentKeyRequirement()), (Object)((Object)authenticatorSelectionCriteria.getResidentKeyRequirement()));
    }

    public static class Builder {
        @Nullable
        private Attachment zza;
        @Nullable
        private Boolean zzb;
        @Nullable
        private ResidentKeyRequirement zzc;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAttachment(@Nullable Attachment attachment) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setRequireResidentKey(@Nullable Boolean requireResidentKey) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setResidentKeyRequirement(@Nullable ResidentKeyRequirement residentKeyRequirement) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public AuthenticatorSelectionCriteria build() {
            void var0_3;
            void var1_8;
            Attachment attachment = this.zza;
            if (attachment == null) {
                Object var1_7 = null;
            } else {
                String string = attachment.toString();
            }
            Boolean bl = this.zzb;
            ResidentKeyRequirement residentKeyRequirement = this.zzc;
            if (residentKeyRequirement == null) {
                Object var0_2 = null;
                return new AuthenticatorSelectionCriteria((String)var1_8, bl, null, (String)var0_3);
            } else {
                String string = residentKeyRequirement.toString();
            }
            return new AuthenticatorSelectionCriteria((String)var1_8, bl, null, (String)var0_3);
        }
    }
}

