/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.fido2.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.android.gms.fido.fido2.api.common.zzw;
import java.util.Locale;

public enum ErrorCode implements Parcelable
{
    NOT_SUPPORTED_ERR(9),
    INVALID_STATE_ERR(11),
    SECURITY_ERR(18),
    NETWORK_ERR(19),
    ABORT_ERR(20),
    TIMEOUT_ERR(23),
    ENCODING_ERR(27),
    UNKNOWN_ERR(28),
    CONSTRAINT_ERR(29),
    DATA_ERR(30),
    NOT_ALLOWED_ERR(35),
    ATTESTATION_NOT_PRIVATE_ERR(36);

    @NonNull
    public static final Parcelable.Creator<ErrorCode> CREATOR;
    private final int zzb;

    public int describeContents() {
        return 0;
    }

    public int getCode() {
        return this.zzb;
    }

    @NonNull
    public static ErrorCode toErrorCode(int code) throws UnsupportedErrorCodeException {
        ErrorCode[] errorCodeArray = ErrorCode.values();
        int n = errorCodeArray.length;
        int n2 = 0;
        while (true) {
            int n3;
            if (n2 < n) {
                ErrorCode errorCode = errorCodeArray[n2];
                if (n3 == errorCode.zzb) {
                    return errorCode;
                }
            } else {
                throw new UnsupportedErrorCodeException(n3);
            }
            ++n2;
        }
    }

    static {
        CREATOR = new zzw();
    }

    private ErrorCode(int n2) {
        this.zzb = n2;
    }

    public void writeToParcel(@NonNull Parcel parcel, int n) {
        parcel.writeInt(this.zzb);
    }

    public static class UnsupportedErrorCodeException
    extends Exception {
        /*
         * WARNING - void declaration
         */
        public UnsupportedErrorCodeException(int errorCode) {
            void var1_1;
            Object[] objectArray = new Object[]{(int)var1_1};
            super(String.format(Locale.US, "Error code %d is not supported", objectArray));
        }
    }
}

