/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.fido2.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.fido.fido2.api.common.AttestationConveyancePreference;
import com.google.android.gms.fido.fido2.api.common.AuthenticationExtensions;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorSelectionCriteria;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialDescriptor;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialParameters;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialRpEntity;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialUserEntity;
import com.google.android.gms.fido.fido2.api.common.RequestOptions;
import com.google.android.gms.fido.fido2.api.common.TokenBinding;
import com.google.android.gms.fido.fido2.api.common.zzao;
import com.google.android.gms.internal.fido.zzbh;
import com.google.android.gms.internal.fido.zzim;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="PublicKeyCredentialCreationOptionsCreator")
public class PublicKeyCredentialCreationOptions
extends RequestOptions {
    @NonNull
    public static final Parcelable.Creator<PublicKeyCredentialCreationOptions> CREATOR = new zzao();
    @NonNull
    @SafeParcelable.Field(id=2, getter="getRp")
    private final PublicKeyCredentialRpEntity zza;
    @NonNull
    @SafeParcelable.Field(id=3, getter="getUser")
    private final PublicKeyCredentialUserEntity zzb;
    @NonNull
    @SafeParcelable.Field(id=4, getter="getChallenge")
    private final byte[] zzc;
    @NonNull
    @SafeParcelable.Field(id=5, getter="getParameters")
    private final List zzd;
    @Nullable
    @SafeParcelable.Field(id=6, getter="getTimeoutSeconds")
    private final Double zze;
    @Nullable
    @SafeParcelable.Field(id=7, getter="getExcludeList")
    private final List zzf;
    @Nullable
    @SafeParcelable.Field(id=8, getter="getAuthenticatorSelection")
    private final AuthenticatorSelectionCriteria zzg;
    @Nullable
    @SafeParcelable.Field(id=9, getter="getRequestId")
    private final Integer zzh;
    @Nullable
    @SafeParcelable.Field(id=10, getter="getTokenBinding")
    private final TokenBinding zzi;
    @Nullable
    @SafeParcelable.Field(id=11, getter="getAttestationConveyancePreferenceAsString", type="java.lang.String")
    private final AttestationConveyancePreference zzj;
    @Nullable
    @SafeParcelable.Field(id=12, getter="getAuthenticationExtensions")
    private final AuthenticationExtensions zzk;
    @Nullable
    @SafeParcelable.Field(id=13, getter="getJsonString")
    private final String zzl;
    @Nullable
    @SafeParcelable.Field(id=14, getter="getResultReceiver")
    private ResultReceiver zzm;
    @Nullable
    @SafeParcelable.Field(id=15, getter="getAttestationFormats")
    private final List zzn;

    public int hashCode() {
        PublicKeyCredentialRpEntity publicKeyCredentialRpEntity = this.zza;
        return Objects.hashCode((Object[])new Object[]{publicKeyCredentialRpEntity, this.zzb, Arrays.hashCode(this.zzc), this.zzd, this.zze, this.zzf, this.zzg, this.zzh, this.zzi, this.zzj, this.zzk, this.zzl, this.zzn});
    }

    @Nullable
    public AttestationConveyancePreference getAttestationConveyancePreference() {
        return this.zzj;
    }

    @Override
    @Nullable
    public AuthenticationExtensions getAuthenticationExtensions() {
        return this.zzk;
    }

    @Nullable
    public AuthenticatorSelectionCriteria getAuthenticatorSelection() {
        return this.zzg;
    }

    @NonNull
    public static PublicKeyCredentialCreationOptions deserializeFromBytes(@NonNull byte[] serializedBytes) {
        return (PublicKeyCredentialCreationOptions)SafeParcelableSerializer.deserializeFromBytes((byte[])serializedBytes, CREATOR);
    }

    @NonNull
    public PublicKeyCredentialRpEntity getRp() {
        return this.zza;
    }

    @NonNull
    public PublicKeyCredentialUserEntity getUser() {
        return this.zzb;
    }

    @Override
    @Nullable
    public TokenBinding getTokenBinding() {
        return this.zzi;
    }

    @Override
    @Nullable
    public Double getTimeoutSeconds() {
        return this.zze;
    }

    @Override
    @Nullable
    public Integer getRequestId() {
        return this.zzh;
    }

    @Nullable
    public String getAttestationConveyancePreferenceAsString() {
        Object this_ = this_.zzj;
        if (this_ == null) {
            return null;
        }
        return ((AttestationConveyancePreference)((Object)this_)).toString();
    }

    @Nullable
    public String getJsonString() {
        return this.zzl;
    }

    @NonNull
    public final String toString() {
        String string = String.valueOf((Object)this.zza);
        String string2 = String.valueOf((Object)this.zzb);
        String string3 = Base64Utils.encodeUrlSafeNoPadding((byte[])this.zzc);
        String string4 = String.valueOf(this.zzd);
        String string5 = String.valueOf(this.zzf);
        String string6 = String.valueOf((Object)this.zzg);
        String string7 = String.valueOf((Object)this.zzi);
        String string8 = String.valueOf((Object)this.zzj);
        String string9 = String.valueOf((Object)this.zzk);
        String string10 = String.valueOf(this.zzn);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PublicKeyCredentialCreationOptions{\n rp=");
        stringBuilder.append(string);
        stringBuilder.append(", \n user=");
        stringBuilder.append(string2);
        stringBuilder.append(", \n challenge=");
        stringBuilder.append(string3);
        stringBuilder.append(", \n parameters=");
        stringBuilder.append(string4);
        stringBuilder.append(", \n timeoutSeconds=");
        stringBuilder.append(this.zze);
        stringBuilder.append(", \n excludeList=");
        stringBuilder.append(string5);
        stringBuilder.append(", \n authenticatorSelection=");
        stringBuilder.append(string6);
        stringBuilder.append(", \n requestId=");
        stringBuilder.append(this.zzh);
        stringBuilder.append(", \n tokenBinding=");
        stringBuilder.append(string7);
        stringBuilder.append(", \n attestationConveyancePreference=");
        stringBuilder.append(string8);
        stringBuilder.append(", \n authenticationExtensions=");
        stringBuilder.append(string9);
        stringBuilder.append(", \n attestationFormats=");
        stringBuilder.append(string10);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Nullable
    public List<String> getAttestationFormats() {
        return this.zzn;
    }

    @Nullable
    public List<PublicKeyCredentialDescriptor> getExcludeList() {
        return this.zzf;
    }

    @NonNull
    public List<PublicKeyCredentialParameters> getParameters() {
        return this.zzd;
    }

    /*
     * WARNING - void declaration
     */
    public PublicKeyCredentialCreationOptions(@NonNull String jsonString) {
        PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions;
        void var1_2;
        try {
            publicKeyCredentialCreationOptions = PublicKeyCredentialCreationOptions.zza(new JSONObject((String)var1_2));
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException(jSONException);
        }
        this.zza = publicKeyCredentialCreationOptions.zza;
        this.zzb = publicKeyCredentialCreationOptions.zzb;
        this.zzc = publicKeyCredentialCreationOptions.zzc;
        this.zzd = publicKeyCredentialCreationOptions.zzd;
        this.zze = publicKeyCredentialCreationOptions.zze;
        this.zzf = publicKeyCredentialCreationOptions.zzf;
        this.zzg = publicKeyCredentialCreationOptions.zzg;
        this.zzh = publicKeyCredentialCreationOptions.zzh;
        this.zzi = publicKeyCredentialCreationOptions.zzi;
        this.zzj = publicKeyCredentialCreationOptions.zzj;
        this.zzk = publicKeyCredentialCreationOptions.zzk;
        this.zzn = publicKeyCredentialCreationOptions.zzn;
        this.zzl = var1_2;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SafeParcelable.Constructor
    PublicKeyCredentialCreationOptions(@NonNull @SafeParcelable.Param(id=2) PublicKeyCredentialRpEntity abstractSafeParcelable, @NonNull @SafeParcelable.Param(id=3) PublicKeyCredentialUserEntity publicKeyCredentialUserEntity, @NonNull @SafeParcelable.Param(id=4) byte[] byArray, @NonNull @SafeParcelable.Param(id=5) List list, @Nullable @SafeParcelable.Param(id=6) Double d, @Nullable @SafeParcelable.Param(id=7) List list2, @Nullable @SafeParcelable.Param(id=8) AuthenticatorSelectionCriteria authenticatorSelectionCriteria, @Nullable @SafeParcelable.Param(id=9) Integer n, @Nullable @SafeParcelable.Param(id=10) TokenBinding tokenBinding, @Nullable @SafeParcelable.Param(id=11) String string, @Nullable @SafeParcelable.Param(id=12) AuthenticationExtensions authenticationExtensions, @Nullable @SafeParcelable.Param(id=13) String string2, @Nullable @SafeParcelable.Param(id=14) ResultReceiver resultReceiver, @Nullable @SafeParcelable.Param(id=15) List list3) {
        block6: {
            this.zzm = resultReceiver;
            if (string2 != null) {
                abstractSafeParcelable = PublicKeyCredentialCreationOptions.zza(new JSONObject(string2));
                this.zza = abstractSafeParcelable.zza;
                this.zzb = abstractSafeParcelable.zzb;
                this.zzc = abstractSafeParcelable.zzc;
                this.zzd = abstractSafeParcelable.zzd;
                this.zze = abstractSafeParcelable.zze;
                this.zzf = abstractSafeParcelable.zzf;
                this.zzg = abstractSafeParcelable.zzg;
                this.zzh = abstractSafeParcelable.zzh;
                this.zzi = abstractSafeParcelable.zzi;
                this.zzj = abstractSafeParcelable.zzj;
                this.zzk = abstractSafeParcelable.zzk;
                this.zzn = abstractSafeParcelable.zzn;
                this.zzl = string2;
                return;
            }
            this.zza = (PublicKeyCredentialRpEntity)((Object)Preconditions.checkNotNull((Object)abstractSafeParcelable));
            this.zzb = (PublicKeyCredentialUserEntity)((Object)Preconditions.checkNotNull((Object)((Object)publicKeyCredentialUserEntity)));
            this.zzc = (byte[])Preconditions.checkNotNull((Object)byArray);
            this.zzd = (List)Preconditions.checkNotNull((Object)list);
            this.zze = d;
            this.zzf = list2;
            this.zzg = authenticatorSelectionCriteria;
            this.zzh = n;
            this.zzi = tokenBinding;
            if (string != null) {
                try {
                    this.zzj = AttestationConveyancePreference.fromString(string);
                }
                catch (AttestationConveyancePreference.UnsupportedAttestationConveyancePreferenceException unsupportedAttestationConveyancePreferenceException) {
                    throw new IllegalArgumentException(unsupportedAttestationConveyancePreferenceException);
                }
            }
            break block6;
            catch (JSONException jSONException) {
                throw new IllegalArgumentException(jSONException);
            }
        }
        this.zzj = null;
        this.zzk = authenticationExtensions;
        this.zzl = null;
        this.zzn = list3;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)2, (Parcelable)this.getRp(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)3, (Parcelable)this.getUser(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeByteArray((Parcel)var1_1, (int)4, (byte[])this.getChallenge(), (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)5, this.getParameters(), (boolean)false);
        SafeParcelWriter.writeDoubleObject((Parcel)var1_1, (int)6, (Double)this.getTimeoutSeconds(), (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)7, this.getExcludeList(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)8, (Parcelable)this.getAuthenticatorSelection(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeIntegerObject((Parcel)var1_1, (int)9, (Integer)this.getRequestId(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)10, (Parcelable)this.getTokenBinding(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)11, (String)this.getAttestationConveyancePreferenceAsString(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)12, (Parcelable)this.getAuthenticationExtensions(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)13, (String)this.getJsonString(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)14, (Parcelable)this.zzm, (int)var2_2, (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeStringList((Parcel)v1, (int)15, this.getAttestationFormats(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@NonNull Object obj) {
        List list;
        PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions;
        if (!(obj instanceof PublicKeyCredentialCreationOptions)) {
            return false;
        }
        publicKeyCredentialCreationOptions = publicKeyCredentialCreationOptions;
        if (!Objects.equal((Object)((Object)this.zza), (Object)((Object)publicKeyCredentialCreationOptions.zza))) return false;
        if (!Objects.equal((Object)((Object)this.zzb), (Object)((Object)publicKeyCredentialCreationOptions.zzb))) return false;
        if (!Arrays.equals(this.zzc, publicKeyCredentialCreationOptions.zzc)) return false;
        if (!Objects.equal((Object)this.zze, (Object)publicKeyCredentialCreationOptions.zze)) return false;
        if (!this.zzd.containsAll(publicKeyCredentialCreationOptions.zzd)) return false;
        if (!publicKeyCredentialCreationOptions.zzd.containsAll(this.zzd)) return false;
        List list2 = this.zzf;
        if (list2 != null || publicKeyCredentialCreationOptions.zzf != null) {
            if (list2 == null) return false;
            list = publicKeyCredentialCreationOptions.zzf;
            if (list == null) return false;
            if (!list2.containsAll(list)) return false;
            if (!publicKeyCredentialCreationOptions.zzf.containsAll(this.zzf)) return false;
        }
        if (!Objects.equal((Object)((Object)this.zzg), (Object)((Object)publicKeyCredentialCreationOptions.zzg))) return false;
        if (!Objects.equal((Object)this.zzh, (Object)publicKeyCredentialCreationOptions.zzh)) return false;
        if (!Objects.equal((Object)((Object)this.zzi), (Object)((Object)publicKeyCredentialCreationOptions.zzi))) return false;
        if (!Objects.equal((Object)((Object)this.zzj), (Object)((Object)publicKeyCredentialCreationOptions.zzj))) return false;
        if (!Objects.equal((Object)((Object)this.zzk), (Object)((Object)publicKeyCredentialCreationOptions.zzk))) return false;
        if (!Objects.equal((Object)this.zzl, (Object)publicKeyCredentialCreationOptions.zzl)) return false;
        list2 = this.zzn;
        if (list2 == null) {
            if (publicKeyCredentialCreationOptions.zzn == null) return true;
        }
        if (list2 == null) return false;
        list = publicKeyCredentialCreationOptions.zzn;
        if (list == null) return false;
        if (!list2.containsAll(list)) return false;
        if (publicKeyCredentialCreationOptions.zzn.containsAll(this.zzn)) return true;
        return false;
    }

    @Override
    @NonNull
    public byte[] getChallenge() {
        return this.zzc;
    }

    @Override
    @NonNull
    public byte[] serializeToBytes() {
        if (zzim.zzd()) {
            Builder builder = new Builder();
            builder.setRp(this.zza);
            builder.setUser(this.zzb);
            builder.setChallenge(this.zzc);
            builder.setParameters(this.zzd);
            builder.setTimeoutSeconds(this.zze);
            builder.setExcludeList(this.zzf);
            builder.setAuthenticatorSelection(this.zzg);
            builder.setRequestId(this.zzh);
            builder.setTokenBinding(this.zzi);
            builder.setAttestationConveyancePreference(this.zzj);
            builder.setAuthenticationExtensions(this.zzk);
            builder.setAttestationFormats(this.zzn);
            return SafeParcelableSerializer.serializeToBytes((SafeParcelable)builder.build());
        }
        return SafeParcelableSerializer.serializeToBytes((SafeParcelable)this);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public static PublicKeyCredentialCreationOptions zza(@NonNull JSONObject jSONObject) throws JSONException {
        Object object;
        Builder builder;
        block24: {
            void var1_8;
            void var1_5;
            builder = new Builder();
            JSONObject jSONObject2 = jSONObject.getJSONObject("rp");
            object = jSONObject2.getString("id");
            String string = jSONObject2.getString("name");
            if (jSONObject2.has("icon")) {
                String string2 = jSONObject2.optString("icon");
            } else {
                Object var1_18 = null;
            }
            builder.setRp(new PublicKeyCredentialRpEntity((String)object, string, (String)var1_5));
            JSONObject jSONObject3 = jSONObject.getJSONObject("user");
            object = Base64Utils.decodeUrlSafeNoPadding((String)jSONObject3.getString("id"));
            String string3 = jSONObject3.getString("name");
            String string4 = jSONObject3.optString("displayName");
            if (jSONObject3.has("icon")) {
                String string5 = jSONObject3.optString("icon");
            } else {
                Object var1_17 = null;
            }
            builder.setUser(new PublicKeyCredentialUserEntity((byte[])object, string3, (String)var1_8, string4));
            builder.setChallenge(Base64Utils.decodeUrlSafeNoPadding((String)jSONObject.getString("challenge")));
            JSONArray jSONArray = jSONObject.getJSONArray("pubKeyCredParams");
            ArrayList<PublicKeyCredentialParameters> arrayList = new ArrayList<PublicKeyCredentialParameters>();
            boolean bl = false;
            while (true) {
                void var1_10;
                if (var1_10 < jSONArray.length()) {
                    object = jSONArray.getJSONObject((int)var1_10);
                    PublicKeyCredentialParameters publicKeyCredentialParameters = new PublicKeyCredentialParameters(object.getString("type"), object.getInt("alg"));
                    object = zzbh.zzd((Object)publicKeyCredentialParameters);
                }
                builder.setParameters(arrayList);
                if (jSONObject.has("timeout")) {
                    builder.setTimeoutSeconds(jSONObject.getDouble("timeout") / 1000.0);
                }
                if (jSONObject.has("excludeCredentials")) {
                    void var1_12;
                    object = jSONObject.getJSONArray("excludeCredentials");
                    ArrayList<PublicKeyCredentialDescriptor> arrayList2 = new ArrayList<PublicKeyCredentialDescriptor>();
                    boolean bl2 = false;
                    while (var1_12 < object.length()) {
                        arrayList2.add(PublicKeyCredentialDescriptor.zza(object.getJSONObject((int)var1_12)));
                        ++var1_12;
                    }
                    builder.setExcludeList(arrayList2);
                }
                if (jSONObject.has("authenticatorSelection")) {
                    void var4_34;
                    void var3_27;
                    void var1_14;
                    JSONObject jSONObject4 = jSONObject.getJSONObject("authenticatorSelection");
                    if (jSONObject4.has("authenticatorAttachment")) {
                        String string6 = jSONObject4.optString("authenticatorAttachment");
                    } else {
                        Object var1_16 = null;
                    }
                    object = jSONObject4.has("residentKey") ? jSONObject4.optString("residentKey") : null;
                    if (jSONObject4.has("requireResidentKey")) {
                        Boolean bl3 = jSONObject4.optBoolean("requireResidentKey");
                    } else {
                        Object var3_29 = null;
                    }
                    if (jSONObject4.has("userVerification")) {
                        String string7 = jSONObject4.optString("userVerification");
                    } else {
                        Object var4_36 = null;
                    }
                    builder.setAuthenticatorSelection(new AuthenticatorSelectionCriteria((String)var1_14, (Boolean)var3_27, (String)var4_34, (String)object));
                }
                if (jSONObject.has("extensions")) {
                    builder.setAuthenticationExtensions(AuthenticationExtensions.zza(jSONObject.getJSONObject("extensions")));
                }
                if (!jSONObject.has("attestation")) break block24;
                builder.setAttestationConveyancePreference(AttestationConveyancePreference.fromString(jSONObject.getString("attestation")));
                catch (IllegalArgumentException illegalArgumentException) {
                    object = zzbh.zzc();
                }
                if (((zzbh)object).zzb()) {
                    arrayList.add((PublicKeyCredentialParameters)((Object)((zzbh)object).zza()));
                }
                ++var1_10;
            }
            catch (AttestationConveyancePreference.UnsupportedAttestationConveyancePreferenceException unsupportedAttestationConveyancePreferenceException) {
                Log.w((String)"PKCCreationOptions", (String)"Invalid AttestationConveyancePreference", (Throwable)unsupportedAttestationConveyancePreferenceException);
                builder.setAttestationConveyancePreference(AttestationConveyancePreference.NONE);
            }
        }
        if (jSONObject.has("attestationFormats")) {
            JSONArray jSONArray = jSONObject.getJSONArray("attestationFormats");
            object = new ArrayList();
            for (int i = 0; i < jSONArray.length(); ++i) {
                object.add(jSONArray.getString(i));
            }
            builder.setAttestationFormats((List<String>)object);
        }
        return builder.build();
    }

    public static final class Builder {
        private PublicKeyCredentialRpEntity zza;
        private PublicKeyCredentialUserEntity zzb;
        private byte[] zzc;
        private List zzd;
        private Double zze;
        private List zzf;
        private AuthenticatorSelectionCriteria zzg;
        private Integer zzh;
        private TokenBinding zzi;
        private AttestationConveyancePreference zzj;
        private AuthenticationExtensions zzk;
        private List zzl;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAttestationConveyancePreference(@Nullable AttestationConveyancePreference attestationConveyancePreference) {
            void var1_1;
            this.zzj = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAttestationFormats(@Nullable List<String> attestationFormats) {
            void var1_1;
            this.zzl = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAuthenticationExtensions(@Nullable AuthenticationExtensions authenticationExtensions) {
            void var1_1;
            this.zzk = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAuthenticatorSelection(@Nullable AuthenticatorSelectionCriteria authenticatorSelection) {
            void var1_1;
            this.zzg = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setChallenge(@NonNull byte[] challenge) {
            void var1_1;
            this.zzc = (byte[])Preconditions.checkNotNull((Object)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setExcludeList(@Nullable List<PublicKeyCredentialDescriptor> excludeList) {
            void var1_1;
            this.zzf = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setParameters(@NonNull List<PublicKeyCredentialParameters> parameters) {
            void var1_1;
            this.zzd = (List)Preconditions.checkNotNull((Object)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setRequestId(@Nullable Integer requestId) {
            void var1_1;
            this.zzh = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setRp(@NonNull PublicKeyCredentialRpEntity rp) {
            void var1_1;
            this.zza = (PublicKeyCredentialRpEntity)((Object)Preconditions.checkNotNull((Object)var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTimeoutSeconds(@Nullable Double timeoutSeconds) {
            void var1_1;
            this.zze = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTokenBinding(@Nullable TokenBinding tokenBinding) {
            void var1_1;
            this.zzi = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setUser(@NonNull PublicKeyCredentialUserEntity user) {
            void var1_1;
            this.zzb = (PublicKeyCredentialUserEntity)((Object)Preconditions.checkNotNull((Object)var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public PublicKeyCredentialCreationOptions build() {
            void var1_13;
            PublicKeyCredentialRpEntity publicKeyCredentialRpEntity = this.zza;
            PublicKeyCredentialUserEntity publicKeyCredentialUserEntity = this.zzb;
            byte[] byArray = this.zzc;
            List list = this.zzd;
            Double d = this.zze;
            List list2 = this.zzf;
            AuthenticatorSelectionCriteria authenticatorSelectionCriteria = this.zzg;
            Integer n = this.zzh;
            TokenBinding tokenBinding = this.zzi;
            AttestationConveyancePreference attestationConveyancePreference = this.zzj;
            if (attestationConveyancePreference == null) {
                Object var1_12 = null;
                return new PublicKeyCredentialCreationOptions(publicKeyCredentialRpEntity, publicKeyCredentialUserEntity, byArray, list, d, list2, authenticatorSelectionCriteria, n, tokenBinding, (String)var1_13, this.zzk, null, null, this.zzl);
            }
            String string = attestationConveyancePreference.toString();
            return new PublicKeyCredentialCreationOptions(publicKeyCredentialRpEntity, publicKeyCredentialUserEntity, byArray, list, d, list2, authenticatorSelectionCriteria, n, tokenBinding, (String)var1_13, this.zzk, null, null, this.zzl);
        }
    }
}

