/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fido.u2f.api.common.zza;
import com.google.android.gms.fido.u2f.api.common.zzb;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="ChannelIdValueCreator")
public class ChannelIdValue
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<ChannelIdValue> CREATOR = new zzb();
    @NonNull
    public static final ChannelIdValue ABSENT = new ChannelIdValue();
    @NonNull
    public static final ChannelIdValue UNAVAILABLE = new ChannelIdValue("unavailable");
    @NonNull
    public static final ChannelIdValue UNUSED = new ChannelIdValue("unused");
    @SafeParcelable.Field(id=2, getter="getTypeAsInt", type="int")
    private final ChannelIdValueType zza;
    @SafeParcelable.Field(id=3, getter="getStringValue")
    private final String zzb;
    @SafeParcelable.Field(id=4, getter="getObjectValueAsString")
    private final String zzc;

    public int getTypeAsInt() {
        return this.zza.zzb;
    }

    public int hashCode() {
        int n = this.zza.hashCode() + 31;
        switch (this.zza.ordinal()) {
            default: {
                return n;
            }
            case 2: {
                return n * 31 + this.zzc.hashCode();
            }
            case 1: 
        }
        return n * 31 + this.zzb.hashCode();
    }

    @NonNull
    public ChannelIdValueType getType() {
        return this.zza;
    }

    @NonNull
    public static ChannelIdValueType toChannelIdValueType(int type) throws UnsupportedChannelIdValueTypeException {
        ChannelIdValueType[] channelIdValueTypeArray = ChannelIdValueType.values();
        int n = channelIdValueTypeArray.length;
        int n2 = 0;
        while (true) {
            int n3;
            if (n2 < n) {
                ChannelIdValueType channelIdValueType = channelIdValueTypeArray[n2];
                if (n3 == channelIdValueType.zzb) {
                    return channelIdValueType;
                }
            } else {
                throw new UnsupportedChannelIdValueTypeException(n3);
            }
            ++n2;
        }
    }

    @NonNull
    public String getObjectValueAsString() {
        return this.zzc;
    }

    @NonNull
    public String getStringValue() {
        return this.zzb;
    }

    @NonNull
    public JSONObject getObjectValue() {
        JSONObject jSONObject;
        if (this.zzc == null) {
            return null;
        }
        try {
            jSONObject = new JSONObject(this.zzc);
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        return jSONObject;
    }

    private ChannelIdValue() {
        this.zza = ChannelIdValueType.ABSENT;
        this.zzc = null;
        this.zzb = null;
    }

    private ChannelIdValue(String string) {
        this.zzb = (String)Preconditions.checkNotNull((Object)string);
        this.zza = ChannelIdValueType.STRING;
        this.zzc = null;
    }

    /*
     * WARNING - void declaration
     */
    public ChannelIdValue(@NonNull JSONObject value) {
        void var1_1;
        this.zzc = (String)Preconditions.checkNotNull((Object)var1_1.toString());
        this.zza = ChannelIdValueType.OBJECT;
        this.zzb = null;
    }

    @SafeParcelable.Constructor
    ChannelIdValue(@SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) String string2) {
        try {
            this.zza = ChannelIdValue.toChannelIdValueType(n);
        }
        catch (UnsupportedChannelIdValueTypeException unsupportedChannelIdValueTypeException) {
            throw new IllegalArgumentException(unsupportedChannelIdValueTypeException);
        }
        this.zzb = string;
        this.zzc = string2;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.getTypeAsInt());
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.getStringValue(), (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeString((Parcel)v1, (int)4, (String)this.getObjectValueAsString(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    public boolean equals(@NonNull Object other) {
        ChannelIdValue channelIdValue;
        if (this == channelIdValue) {
            return true;
        }
        if (!(channelIdValue instanceof ChannelIdValue)) {
            return false;
        }
        channelIdValue = channelIdValue;
        if (!this.zza.equals((Object)channelIdValue.zza)) {
            return false;
        }
        switch (this.zza.ordinal()) {
            default: {
                return false;
            }
            case 2: {
                return this.zzc.equals(channelIdValue.zzc);
            }
            case 1: {
                return this.zzb.equals(channelIdValue.zzb);
            }
            case 0: 
        }
        return true;
    }

    public static enum ChannelIdValueType implements Parcelable
    {
        ABSENT(0),
        STRING(1),
        OBJECT(2);

        @NonNull
        public static final Parcelable.Creator<ChannelIdValueType> CREATOR;
        private final int zzb;

        public int describeContents() {
            return 0;
        }

        static {
            CREATOR = new zza();
        }

        private ChannelIdValueType(int n2) {
            this.zzb = n2;
        }

        public void writeToParcel(@NonNull Parcel parcel, int n) {
            parcel.writeInt(this.zzb);
        }
    }

    public static class UnsupportedChannelIdValueTypeException
    extends Exception {
        /*
         * WARNING - void declaration
         */
        public UnsupportedChannelIdValueTypeException(int type) {
            void var1_1;
            Object[] objectArray = new Object[]{(int)var1_1};
            super(String.format("ChannelIdValueType %s not supported", objectArray));
        }
    }
}

