/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.MainThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzfd;
import com.google.android.gms.measurement.internal.zzfe;
import com.google.android.gms.measurement.internal.zzfg;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzp;

public final class zzfb {
    private final zzfg zza;

    public zzfb(zzfg zzfg2) {
        Preconditions.checkNotNull((Object)zzfg2);
        this.zza = zzfg2;
    }

    public static boolean zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ActivityInfo activityInfo = packageManager.getReceiverInfo(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver"), 0);
            if (activityInfo != null && activityInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @MainThread
    public final void zza(Context context, Intent intent) {
        zzfl zzfl2 = zzfl.zza(context, null);
        zzeh zzeh2 = zzfl2.zzr();
        if (intent == null) {
            zzeh2.zzi().zza("Receiver called with null intent");
            return;
        }
        zzp zzp2 = zzfl2.zzu();
        boolean bl = false;
        String string = intent.getAction();
        if (bl) {
            zzeh2.zzx().zza("Device receiver got", string);
        } else {
            zzeh2.zzx().zza("Local receiver got", string);
        }
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            Intent intent2 = new Intent().setClassName(context, bl ? "com.google.android.gms.measurement.PackageMeasurementService" : "com.google.android.gms.measurement.AppMeasurementService");
            intent2.setAction("com.google.android.gms.measurement.UPLOAD");
            zzeh2.zzx().zza("Starting wakeful intent.");
            this.zza.doStartService(context, intent2);
            return;
        }
        if (!bl && "com.android.vending.INSTALL_REFERRER".equals(string)) {
            try {
                zzfl2.zzq().zza(new zzfe(this, zzfl2, zzeh2));
            }
            catch (Exception exception) {
                zzeh2.zzi().zza("Install Referrer Reporter encountered a problem", exception);
            }
            BroadcastReceiver.PendingResult pendingResult = this.zza.doGoAsync();
            String string2 = intent.getStringExtra("referrer");
            if (string2 == null) {
                zzeh2.zzx().zza("Install referrer extras are null");
                if (pendingResult != null) {
                    pendingResult.finish();
                }
                return;
            }
            zzeh2.zzv().zza("Install referrer extras are", string2);
            if (!string2.contains("?")) {
                String string3 = String.valueOf(string2);
                string2 = string3.length() != 0 ? "?".concat(string3) : new String("?");
            }
            Uri uri = Uri.parse((String)string2);
            Bundle bundle = zzfl2.zzi().zza(uri);
            if (bundle == null) {
                zzeh2.zzx().zza("No campaign defined in install referrer broadcast");
                if (pendingResult != null) {
                    pendingResult.finish();
                    return;
                }
            } else {
                long l = intent.getLongExtra("referrer_timestamp_seconds", 0L) * 1000L;
                if (l == 0L) {
                    zzeh2.zzi().zza("Install referrer is missing timestamp");
                }
                zzfl2.zzq().zza(new zzfd(this, zzfl2, l, bundle, context, zzeh2, pendingResult));
            }
        }
    }
}

