/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzfc;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzjf;
import com.google.android.gms.internal.measurement.zznm;
import com.google.android.gms.internal.measurement.zzns;
import com.google.android.gms.internal.measurement.zznx;
import com.google.android.gms.internal.measurement.zzok;
import com.google.android.gms.internal.measurement.zzop;
import com.google.android.gms.internal.measurement.zzoq;
import com.google.android.gms.internal.measurement.zzov;
import com.google.android.gms.internal.measurement.zzph;
import com.google.android.gms.internal.measurement.zzpt;
import com.google.android.gms.internal.measurement.zzqa;
import com.google.android.gms.internal.measurement.zzqf;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzav;
import com.google.android.gms.measurement.internal.zzax;
import com.google.android.gms.measurement.internal.zzaz;
import com.google.android.gms.measurement.internal.zzba;
import com.google.android.gms.measurement.internal.zzbe;
import com.google.android.gms.measurement.internal.zzbg;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zzif;
import com.google.android.gms.measurement.internal.zzig;
import com.google.android.gms.measurement.internal.zzkg;
import com.google.android.gms.measurement.internal.zzki;
import com.google.android.gms.measurement.internal.zzlp;
import com.google.android.gms.measurement.internal.zzmf;
import com.google.android.gms.measurement.internal.zzmh;
import com.google.android.gms.measurement.internal.zzmj;
import com.google.android.gms.measurement.internal.zzmn;
import com.google.android.gms.measurement.internal.zzmo;
import com.google.android.gms.measurement.internal.zzmq;
import com.google.android.gms.measurement.internal.zzmr;
import com.google.android.gms.measurement.internal.zzms;
import com.google.android.gms.measurement.internal.zzmt;
import com.google.android.gms.measurement.internal.zzmu;
import com.google.android.gms.measurement.internal.zzmw;
import com.google.android.gms.measurement.internal.zzmx;
import com.google.android.gms.measurement.internal.zzmy;
import com.google.android.gms.measurement.internal.zzmz;
import com.google.android.gms.measurement.internal.zzna;
import com.google.android.gms.measurement.internal.zznb;
import com.google.android.gms.measurement.internal.zznd;
import com.google.android.gms.measurement.internal.zznf;
import com.google.android.gms.measurement.internal.zzng;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzu;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class zzmp
implements zzid {
    private static volatile @Nullable zzmp zza;
    private zzgn zzb;
    private zzfw zzc;
    private zzal zzd;
    private zzfz zze;
    private zzmj zzf;
    private zzu zzg;
    private final zzmz zzh;
    private zzkg zzi;
    private zzlp zzj;
    private final zzmn zzk;
    private @MonotonicNonNull zzgk zzl;
    private final zzhd zzm;
    private boolean zzn = false;
    private boolean zzo;
    @VisibleForTesting
    private long zzp;
    private @Nullable List<Runnable> zzq;
    private final Set<String> zzr = new HashSet<String>();
    private int zzs;
    private int zzt;
    private boolean zzu;
    private boolean zzv;
    private boolean zzw;
    private @Nullable FileLock zzx;
    private @Nullable FileChannel zzy;
    private @Nullable List<Long> zzz;
    private @Nullable List<Long> zzaa;
    private long zzab;
    private final Map<String, zzif> zzac;
    private final Map<String, zzav> zzad;
    private final Map<String, zzb> zzae;
    private @Nullable zzki zzaf;
    private @Nullable String zzag;
    private final zznf zzah = new zzmw(this);

    @VisibleForTesting
    @WorkerThread
    private final int zza(@Nullable FileChannel fileChannel) {
        this.zzl().zzt();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj().zzg().zza("Bad channel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzj().zzu().zza("Unexpected data length. Bytes read", (Object)n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to read from channel", (Object)iOException);
        }
        return n;
    }

    private final long zzx() {
        long l = this.zzb().currentTimeMillis();
        zzlp zzlp2 = this.zzj;
        zzlp2.zzak();
        zzlp2.zzt();
        long l2 = zzlp2.zze.zza();
        if (l2 == 0L) {
            l2 = 1L + (long)zzlp2.zzq().zzv().nextInt(86400000);
            zzlp2.zze.zza(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    public final Context zza() {
        return this.zzm.zza();
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    final @Nullable Bundle zza(String var1_1) {
        block5: {
            this.zzl().zzt();
            this.zzs();
            if (!zzns.zza()) break block5;
            if (this.zzi().zzb(var1_1) == null) {
                return null;
            }
            var2_2 = new Bundle();
            var3_3 = this.zzb(var1_1);
            var2_2.putAll(var3_3.zzb());
            var4_4 = this.zza(var1_1, this.zzd(var1_1), var3_3, new zzah());
            var2_2.putAll(var4_4.zzb());
            if (this.zzp().zzc(var1_1)) ** GOTO lbl-1000
            var6_5 = this.zzf().zze(var1_1, "_npa");
            if (var6_5 != null) {
                var5_6 = var6_5.zze.equals(1L) != false;
            } else {
                if (this.zzb.zzb(var1_1, zzif.zza.zzd)) {
                    v0 = false;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = true;
                }
                var5_6 = v0;
            }
            var2_2.putString("ad_personalization", var5_6 == true ? "denied" : "granted");
            return var2_2;
        }
        return null;
    }

    public final Clock zzb(@UnknownInitialization zzmp this) {
        return ((zzhd)Preconditions.checkNotNull((Object)this.zzm)).zzb();
    }

    @WorkerThread
    final zzg zza(zzo zzo2) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotNull((Object)zzo2);
        Preconditions.checkNotEmpty((String)zzo2.zza);
        if (!zzo2.zzu.isEmpty()) {
            this.zzae.put(zzo2.zza, new zzb(this, zzo2.zzu, null));
        }
        zzg zzg2 = this.zzf().zzd(zzo2.zza);
        zzif zzif2 = this.zzb(zzo2.zza).zza(zzif.zza((String)zzo2.zzt));
        String string = zzif2.zzg() ? this.zzj.zza(zzo2.zza, zzo2.zzn) : "";
        if (zzg2 == null) {
            zzg2 = new zzg(this.zzm, zzo2.zza);
            if (zzif2.zzh()) {
                zzg2.zzb(this.zza(zzif2));
            }
            if (zzif2.zzg()) {
                zzg2.zzh(string);
            }
        } else if (zzif2.zzg() && string != null && !string.equals(zzg2.zzae())) {
            zzg2.zzh(string);
            if (zzo2.zzn && !"00000000-0000-0000-0000-000000000000".equals(this.zzj.zza((String)zzo2.zza, (zzif)zzif2).first)) {
                zzg2.zzb(this.zza(zzif2));
                if (this.zzf().zze(zzo2.zza, "_id") != null && this.zzf().zze(zzo2.zza, "_lair") == null) {
                    long l = this.zzb().currentTimeMillis();
                    zznd zznd2 = new zznd(zzo2.zza, "auto", "_lair", l, (Object)1L);
                    this.zzf().zza(zznd2);
                }
            }
        } else if (TextUtils.isEmpty((CharSequence)zzg2.zzy()) && zzif2.zzh()) {
            zzg2.zzb(this.zza(zzif2));
        }
        zzg2.zzf(zzo2.zzb);
        zzg2.zza(zzo2.zzp);
        if (!TextUtils.isEmpty((CharSequence)zzo2.zzk)) {
            zzg2.zze(zzo2.zzk);
        }
        if (zzo2.zze != 0L) {
            zzg2.zzm(zzo2.zze);
        }
        if (!TextUtils.isEmpty((CharSequence)zzo2.zzc)) {
            zzg2.zzd(zzo2.zzc);
        }
        zzg2.zza(zzo2.zzj);
        if (zzo2.zzd != null) {
            zzg2.zzc(zzo2.zzd);
        }
        zzg2.zzj(zzo2.zzf);
        zzg2.zzb(zzo2.zzh);
        if (!TextUtils.isEmpty((CharSequence)zzo2.zzg)) {
            zzg2.zzg(zzo2.zzg);
        }
        zzg2.zza(zzo2.zzn);
        zzg2.zza(zzo2.zzq);
        zzg2.zzk(zzo2.zzr);
        if (zzpt.zza() && (this.zze().zza(zzbg.zzbp) || this.zze().zze(zzo2.zza, zzbg.zzbr))) {
            zzg2.zzi(zzo2.zzv);
        }
        if (zznx.zza() && this.zze().zza(zzbg.zzbo)) {
            zzg2.zza(zzo2.zzs);
        } else if (zznx.zza() && this.zze().zza(zzbg.zzbn)) {
            zzg2.zza((List<String>)null);
        }
        if (zzqa.zza() && this.zze().zza(zzbg.zzbs)) {
            zzg2.zzc(zzo2.zzw);
            if (this.zze().zza(zzbg.zzbt)) {
                zzg2.zzj(zzo2.zzac);
            }
        }
        if (zzph.zza() && this.zze().zza(zzbg.zzce)) {
            zzg2.zza(zzo2.zzaa);
        }
        zzg2.zzr(zzo2.zzx);
        if (zzg2.zzam()) {
            this.zzf().zza(zzg2);
        }
        return zzg2;
    }

    @WorkerThread
    private final @Nullable zzo zzc(String string) {
        zzg zzg2 = this.zzf().zzd(string);
        if (zzg2 == null || TextUtils.isEmpty((CharSequence)zzg2.zzaa())) {
            this.zzj().zzc().zza("No app data available; dropping", (Object)string);
            return null;
        }
        Boolean bl = this.zza(zzg2);
        if (bl != null && !bl.booleanValue()) {
            this.zzj().zzg().zza("App version does not match; dropping. appId", zzfp.zza((String)string));
            return null;
        }
        zzif zzif2 = this.zzb(string);
        String string2 = "";
        int n = 100;
        if (zzns.zza() && this.zze().zza(zzbg.zzcm)) {
            string2 = this.zzd(string).zzf();
            n = zzif2.zza();
        }
        return new zzo(string, zzg2.zzac(), zzg2.zzaa(), zzg2.zzc(), zzg2.zzz(), zzg2.zzo(), zzg2.zzl(), null, zzg2.zzal(), false, zzg2.zzab(), zzg2.zzb(), 0L, 0, zzg2.zzak(), false, zzg2.zzv(), zzg2.zzu(), zzg2.zzm(), zzg2.zzah(), null, zzif2.zze(), "", null, zzg2.zzan(), zzg2.zzt(), n, string2, zzg2.zza(), zzg2.zzd(), zzg2.zzag());
    }

    public final zzu zzc() {
        return (zzu)zzmp.zza(this.zzg);
    }

    public final zzab zzd() {
        return this.zzm.zzd();
    }

    public final zzag zze(@UnknownInitialization zzmp this) {
        return ((zzhd)Preconditions.checkNotNull((Object)this.zzm)).zzf();
    }

    public final zzal zzf(@UnknownInitialization zzmp this) {
        return (zzal)zzmp.zza(this.zzd);
    }

    @VisibleForTesting
    @WorkerThread
    private final zzav zza(String string, zzav zzav2, zzif zzif2, zzah zzah2) {
        if (zzns.zza()) {
            int n;
            if (this.zzi().zzb(string) == null) {
                int n2;
                if (zzav2.zzc() == Boolean.FALSE) {
                    n2 = zzav2.zza();
                    zzah2.zza(zzif.zza.zzc, n2);
                } else {
                    n2 = 90;
                    zzah2.zza(zzif.zza.zzc, zzak.zzi);
                }
                return new zzav(Boolean.valueOf(false), n2, Boolean.valueOf(true), "-");
            }
            Boolean bl = zzav2.zzc();
            if (bl != null) {
                n = zzav2.zza();
                zzah2.zza(zzif.zza.zzc, n);
            } else {
                n = 90;
                if (this.zzb.zza(string, zzif.zza.zzc) == zzif.zza.zza && zzif2.zzc() != null) {
                    bl = zzif2.zzc();
                    zzah2.zza(zzif.zza.zzc, zzak.zzc);
                }
                if (bl == null) {
                    bl = this.zzb.zzb(string, zzif.zza.zzc);
                    zzah2.zza(zzif.zza.zzc, zzak.zzb);
                }
            }
            Preconditions.checkNotNull((Object)bl);
            boolean bl2 = this.zzb.zzn(string);
            SortedSet<String> sortedSet = this.zzi().zzh(string);
            if (!bl.booleanValue() || sortedSet.isEmpty()) {
                return new zzav(Boolean.valueOf(false), n, Boolean.valueOf(bl2), "-");
            }
            return new zzav(Boolean.valueOf(true), n, Boolean.valueOf(bl2), bl2 ? TextUtils.join((CharSequence)"", sortedSet) : "");
        }
        return zzav.zza;
    }

    @WorkerThread
    private final zzav zzd(String string) {
        this.zzl().zzt();
        this.zzs();
        if (zzns.zza()) {
            zzav zzav2 = this.zzad.get(string);
            if (zzav2 == null) {
                zzav2 = this.zzf().zzf(string);
                this.zzad.put(string, zzav2);
            }
            return zzav2;
        }
        return zzav.zza;
    }

    public final zzfo zzg() {
        return this.zzm.zzk();
    }

    public final zzfp zzj(@UnknownInitialization zzmp this) {
        return ((zzhd)Preconditions.checkNotNull((Object)this.zzm)).zzj();
    }

    public final zzfw zzh() {
        return (zzfw)zzmp.zza(this.zzc);
    }

    private final zzfz zzy() {
        if (this.zze == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zze;
    }

    public final zzgn zzi() {
        return (zzgn)zzmp.zza(this.zzb);
    }

    public final zzgw zzl(@UnknownInitialization zzmp this) {
        return ((zzhd)Preconditions.checkNotNull((Object)this.zzm)).zzl();
    }

    static /* bridge */ /* synthetic */ zzhd zza(zzmp zzmp2) {
        return zzmp2.zzm;
    }

    final zzhd zzk() {
        return this.zzm;
    }

    @WorkerThread
    final zzif zzb(String string) {
        this.zzl().zzt();
        this.zzs();
        zzif zzif2 = this.zzac.get(string);
        if (zzif2 == null) {
            zzif2 = this.zzf().zzg(string);
            if (zzif2 == null) {
                zzif2 = zzif.zza;
            }
            this.zza(string, zzif2);
        }
        return zzif2;
    }

    public final zzkg zzm() {
        return (zzkg)zzmp.zza(this.zzi);
    }

    public final zzlp zzn() {
        return this.zzj;
    }

    private final zzmj zzz() {
        return (zzmj)zzmp.zza(this.zzf);
    }

    private static zzmo zza(@Nullable zzmo zzmo2) {
        if (zzmo2 == null) {
            throw new IllegalStateException("Upload Component not created");
        }
        if (!zzmo2.zzam()) {
            String string = String.valueOf(((Object)((Object)zzmo2)).getClass());
            throw new IllegalStateException("Component not initialized: " + string);
        }
        return zzmo2;
    }

    public final zzmn zzo() {
        return this.zzk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzmp zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zza != null) return zza;
        Class<zzmp> clazz = zzmp.class;
        synchronized (zzmp.class) {
            if (zza != null) return zza;
            zzna zzna2 = (zzna)Preconditions.checkNotNull((Object)new zzna(context));
            zza = new zzmp(zzna2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zza;
        }
    }

    public final zzmz zzp() {
        return (zzmz)zzmp.zza(this.zzh);
    }

    public final zzng zzq(@UnknownInitialization zzmp this) {
        return ((zzhd)Preconditions.checkNotNull((Object)this.zzm)).zzt();
    }

    @WorkerThread
    private final @Nullable Boolean zza(zzg zzg2) {
        try {
            if (zzg2.zzc() != Integer.MIN_VALUE) {
                int n = Wrappers.packageManager((Context)this.zzm.zza()).getPackageInfo((String)zzg2.zzx(), (int)0).versionCode;
                if (zzg2.zzc() == (long)n) {
                    return true;
                }
            } else {
                String string = Wrappers.packageManager((Context)this.zzm.zza()).getPackageInfo((String)zzg2.zzx(), (int)0).versionName;
                String string2 = zzg2.zzaa();
                if (string2 != null && string2.equals(string)) {
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return false;
    }

    @WorkerThread
    private final @Nullable String zza(zzif zzif2) {
        if (zzif2.zzh()) {
            zzmp zzmp2 = this;
            byte[] byArray = new byte[16];
            zzmp2.zzq().zzv().nextBytes(byArray);
            return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
        }
        return null;
    }

    final @Nullable String zzb(zzo zzo2) {
        Future future = this.zzl().zza((Callable)new zzmt(this, zzo2));
        try {
            return (String)future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzj().zzg().zza("Failed to get app instance id. appId", zzfp.zza((String)zzo2.zza), (Object)exception);
            return null;
        }
    }

    static /* synthetic */ void zza(zzmp zzmp2, zzna zzna2) {
        zzmp zzmp3 = zzmp2;
        zzmp3.zzl().zzt();
        zzmp zzmp4 = zzmp3;
        zzmp3.zzl = new zzgk(zzmp4);
        zzmp4 = zzmp3;
        zzal zzal2 = new zzal(zzmp4);
        zzal2.zzal();
        zzmp3.zzd = zzal2;
        zzmp3.zze().zza((zzai)Preconditions.checkNotNull((Object)((Object)zzmp3.zzb)));
        zzmp4 = zzmp3;
        zzlp zzlp2 = new zzlp(zzmp4);
        zzlp2.zzal();
        zzmp3.zzj = zzlp2;
        zzmp4 = zzmp3;
        zzu zzu2 = new zzu(zzmp4);
        zzu2.zzal();
        zzmp3.zzg = zzu2;
        zzmp4 = zzmp3;
        zzkg zzkg2 = new zzkg(zzmp4);
        zzkg2.zzal();
        zzmp3.zzi = zzkg2;
        zzmp4 = zzmp3;
        zzmj zzmj2 = new zzmj(zzmp4);
        zzmj2.zzal();
        zzmp3.zzf = zzmj2;
        zzmp4 = zzmp3;
        zzmp3.zze = new zzfz(zzmp4);
        if (zzmp3.zzs != zzmp3.zzt) {
            zzmp3.zzj().zzg().zza("Not all upload components initialized", (Object)zzmp3.zzs, (Object)zzmp3.zzt);
        }
        zzmp3.zzn = true;
    }

    private zzmp(zzna zzna2) {
        this(zzna2, null);
    }

    private zzmp(zzna zzna2, @Nullable zzhd zzhd2) {
        Preconditions.checkNotNull((Object)zzna2);
        this.zzm = zzhd2 = zzhd.zza((Context)zzna2.zza, null, null);
        this.zzab = -1L;
        zzmp zzmp2 = this;
        this.zzk = new zzmn(zzmp2);
        zzmp2 = this;
        zzmz zzmz2 = new zzmz(zzmp2);
        zzmz2.zzal();
        this.zzh = zzmz2;
        zzmp2 = this;
        zzfw zzfw2 = new zzfw(zzmp2);
        zzfw2.zzal();
        this.zzc = zzfw2;
        zzmp2 = this;
        zzgn zzgn2 = new zzgn(zzmp2);
        zzgn2.zzal();
        this.zzb = zzgn2;
        this.zzac = new HashMap<String, zzif>();
        this.zzad = new HashMap<String, zzav>();
        this.zzae = new HashMap<String, zzb>();
        this.zzl().zzb((Runnable)new zzms(this, zzna2));
    }

    @WorkerThread
    final void zza(Runnable runnable) {
        this.zzl().zzt();
        if (this.zzq == null) {
            this.zzq = new ArrayList<Runnable>();
        }
        this.zzq.add(runnable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @WorkerThread
    final void zzr() {
        int n;
        this.zzl().zzt();
        this.zzs();
        if (this.zzo) return;
        this.zzo = true;
        if (!this.zzad()) return;
        int n2 = this.zza(this.zzy);
        int n3 = n = this.zzm.zzh().zzab();
        int n4 = n2;
        zzmp zzmp2 = this;
        zzmp2.zzl().zzt();
        if (n4 > n3) {
            zzmp2.zzj().zzg().zza("Panic: can't downgrade version. Previous, current version", (Object)n4, (Object)n3);
            return;
        }
        if (n4 >= n3) return;
        if (!zzmp2.zza(n3, zzmp2.zzy)) {
            zzmp2.zzj().zzg().zza("Storage version upgrade failed. Previous, current version", (Object)n4, (Object)n3);
            return;
        }
        zzmp2.zzj().zzp().zza("Storage version upgraded. Previous, current version", (Object)n4, (Object)n3);
    }

    final void zzs() {
        if (!this.zzn) {
            throw new IllegalStateException("UploadController is not initialized");
        }
    }

    @WorkerThread
    private final void zzaa() {
        this.zzl().zzt();
        if (this.zzu || this.zzv || this.zzw) {
            this.zzj().zzp().zza("Not stopping services. fetch, network, upload", (Object)this.zzu, (Object)this.zzv, (Object)this.zzw);
            return;
        }
        this.zzj().zzp().zza("Stopping uploading service(s)");
        if (this.zzq == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzq.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        ((List)Preconditions.checkNotNull(this.zzq)).clear();
    }

    final void zza(String string, zzfi.zzj.zza zza2) {
        int n;
        Set<String> set = this.zzi().zzg(string);
        if (set != null) {
            zza2.zzd(set);
        }
        if (this.zzi().zzq(string)) {
            zza2.zzi();
        }
        if (this.zzi().zzt(string)) {
            if (this.zze().zze(string, zzbg.zzbu)) {
                int n2;
                String string2 = zza2.zzy();
                if (!TextUtils.isEmpty((CharSequence)string2) && (n2 = string2.indexOf(".")) != -1) {
                    string2 = string2.substring(0, n2);
                    zza2.zzo(string2);
                }
            } else {
                zza2.zzn();
            }
        }
        if (this.zzi().zzu(string) && (n = zzmz.zza(zza2, "_id")) != -1) {
            zza2.zzc(n);
        }
        if (this.zzi().zzs(string)) {
            zza2.zzj();
        }
        if (this.zzi().zzp(string)) {
            zza2.zzg();
            zzb zzb2 = this.zzae.get(string);
            if (zzb2 == null || zzb2.zzb + this.zze().zzc(string, zzbg.zzau) < this.zzb().elapsedRealtime()) {
                zzb2 = new zzb(this, null);
                this.zzae.put(string, zzb2);
            }
            zza2.zzk(zzb2.zza);
        }
        if (this.zzi().zzr(string)) {
            zza2.zzr();
        }
    }

    @WorkerThread
    private final void zzb(zzg zzg2) {
        this.zzl().zzt();
        if (TextUtils.isEmpty((CharSequence)zzg2.zzac()) && TextUtils.isEmpty((CharSequence)zzg2.zzv())) {
            this.zza((String)Preconditions.checkNotNull((Object)zzg2.zzx()), 204, null, null, null);
            return;
        }
        Object object = zzg2;
        Object object2 = new Uri.Builder();
        String string = ((zzg)object).zzac();
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = ((zzg)object).zzv();
        }
        Object object3 = string;
        object2.scheme((String)zzbg.zze.zza(null)).encodedAuthority((String)zzbg.zzf.zza(null)).path("config/app/" + (String)object3).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", "84002").appendQueryParameter("runtime_version", "0");
        String string2 = object2.build().toString();
        try {
            String string3 = (String)Preconditions.checkNotNull((Object)zzg2.zzx());
            URL uRL = new URL(string2);
            this.zzj().zzp().zza("Fetching remote configuration", (Object)string3);
            zzfc.zzd zzd2 = this.zzi().zzc(string3);
            ArrayMap arrayMap = null;
            String string4 = this.zzi().zze(string3);
            if (zzd2 != null) {
                String string5;
                if (!TextUtils.isEmpty((CharSequence)string4)) {
                    arrayMap = new ArrayMap();
                    arrayMap.put("If-Modified-Since", string4);
                }
                if (!TextUtils.isEmpty((CharSequence)(string5 = this.zzi().zzd(string3)))) {
                    if (arrayMap == null) {
                        arrayMap = new ArrayMap();
                    }
                    arrayMap.put("If-None-Match", string5);
                }
            }
            this.zzu = true;
            object3 = new zzmu(this);
            string = arrayMap;
            object2 = uRL;
            object = string3;
            zzfw zzfw2 = this.zzh();
            zzfw2.zzt();
            zzfw2.zzak();
            Preconditions.checkNotNull((Object)object2);
            Preconditions.checkNotNull((Object)object3);
            zzfw2.zzl().zza((Runnable)new zzga(zzfw2, (String)object, (URL)object2, null, (Map)((Object)string), (zzfv)object3));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzj().zzg().zza("Failed to parse config URL. Not fetching. appId", zzfp.zza((String)zzg2.zzx()), (Object)string2);
            return;
        }
    }

    @WorkerThread
    final void zza(zzg zzg2, zzfi.zzj.zza zza2) {
        Object object;
        Object object2;
        this.zzl().zzt();
        this.zzs();
        zzah zzah2 = com.google.android.gms.measurement.internal.zzah.zza(zza2.zzv());
        Object object3 = zzah2;
        zzfi.zzj.zza zza3 = zza2;
        Object object4 = zzg2.zzx();
        Object object5 = this;
        ((zzmp)object5).zzl().zzt();
        ((zzmp)object5).zzs();
        if (zzns.zza()) {
            object2 = ((zzmp)object5).zzb((String)object4);
            if (zzns.zza() && ((zzmp)object5).zze().zza(zzbg.zzco)) {
                zza3.zzg(object2.zzf());
            }
            if (object2.zzc() != null) {
                ((zzah)object3).zza(zzif.zza.zza, object2.zza());
            } else {
                ((zzah)object3).zza(zzif.zza.zza, zzak.zzi);
            }
            if (object2.zzd() != null) {
                ((zzah)object3).zza(zzif.zza.zzb, object2.zza());
            } else {
                ((zzah)object3).zza(zzif.zza.zzb, zzak.zzi);
            }
        }
        object3 = zzah2;
        zza3 = zza2;
        object4 = zzg2.zzx();
        object5 = this;
        ((zzmp)object5).zzl().zzt();
        ((zzmp)object5).zzs();
        if (zzns.zza()) {
            object2 = ((zzmp)object5).zza((String)object4, ((zzmp)object5).zzd((String)object4), ((zzmp)object5).zzb((String)object4), (zzah)object3);
            zza3.zzb((Boolean)Preconditions.checkNotNull((Object)object2.zzd()));
            if (!TextUtils.isEmpty((CharSequence)object2.zze())) {
                zza3.zzh(object2.zze());
            }
        }
        object3 = zzah2;
        zza3 = zza2;
        object4 = zzg2;
        object5 = this;
        ((zzmp)object5).zzl().zzt();
        ((zzmp)object5).zzs();
        if (zzns.zza()) {
            object2 = null;
            Object object6 = zza3.zzab().iterator();
            while (object6.hasNext()) {
                object = object6.next();
                if (!"_npa".equals(object.zzg())) continue;
                object2 = object;
                break;
            }
            if (object2 != null) {
                if (((zzah)object3).zza(zzif.zza.zzd) == zzak.zza) {
                    if (zzqf.zza() && ((zzmp)object5).zze().zza(zzbg.zzcx) && (object6 = ((zzmp)object5).zzf().zze(((zzg)object4).zzx(), "_npa")) != null) {
                        if ("tcf".equals(((zznd)object6).zzb)) {
                            ((zzah)object3).zza(zzif.zza.zzd, zzak.zzh);
                        } else if ("app".equals(((zznd)object6).zzb)) {
                            ((zzah)object3).zza(zzif.zza.zzd, zzak.zzf);
                        } else {
                            ((zzah)object3).zza(zzif.zza.zzd, zzak.zzd);
                        }
                    } else {
                        object6 = ((zzg)object4).zzu();
                        if (object6 == null || object6 == Boolean.TRUE && ((zzfi.zzn)((Object)object2)).zzc() != 1L || object6 == Boolean.FALSE && ((zzfi.zzn)((Object)object2)).zzc() != 0L) {
                            ((zzah)object3).zza(zzif.zza.zzd, zzak.zzf);
                        } else {
                            ((zzah)object3).zza(zzif.zza.zzd, zzak.zzd);
                        }
                    }
                }
            } else if (zzns.zza() && ((zzmp)object5).zze().zza(zzbg.zzcp)) {
                int n;
                if (((zzmp)object5).zzb.zzb(((zzg)object4).zzx()) == null) {
                    n = 1;
                    ((zzah)object3).zza(zzif.zza.zzd, zzak.zzi);
                } else {
                    n = ((zzmp)object5).zzb.zzb(((zzg)object4).zzx(), zzif.zza.zzd) ? 0 : 1;
                    ((zzah)object3).zza(zzif.zza.zzd, zzak.zzb);
                }
                zza3.zza((zzfi.zzn)((zzjf)zzfi.zzn.zze().zza("_npa").zzb(((zzmp)object5).zzb().currentTimeMillis()).zza(n).zzah()));
            }
        }
        zza2.zzf(zzah2.toString());
        if (zzqf.zza() && this.zze().zza(zzbg.zzcx)) {
            boolean bl = this.zzb.zzn(zzg2.zzx());
            object5 = zza2;
            object3 = ((zzfi.zzj.zza)((Object)object5)).zzaa();
            for (int i = 0; i < object3.size(); ++i) {
                if (!"_tcf".equals(((zzfi.zze)((Object)object3.get(i))).zzg())) continue;
                zzfi.zze.zza zza4 = (zzfi.zze.zza)((zzfi.zze)((Object)object3.get(i))).zzby();
                object = zza4.zzf();
                for (int j = 0; j < object.size(); ++j) {
                    if (!"_tcfd".equals(((zzfi.zzg)((Object)object.get(j))).zzg())) continue;
                    String string = zzmf.zza((String)((zzfi.zzg)((Object)object.get(j))).zzh(), (boolean)bl);
                    zza4.zza(j, zzfi.zzg.zze().zza("_tcfd").zzb(string));
                    break;
                }
                ((zzfi.zzj.zza)((Object)object5)).zza(i, zza4);
                return;
            }
        }
    }

    @VisibleForTesting
    private static void zza(zzfi.zze.zza zza2, int n, String string) {
        List<zzfi.zzg> list = zza2.zzf();
        for (int i = 0; i < list.size(); ++i) {
            if (!"_err".equals(list.get(i).zzg())) continue;
            return;
        }
        zzfi.zzg zzg2 = (zzfi.zzg)((zzjf)zzfi.zzg.zze().zza("_err").zza(n).zzah());
        zzfi.zzg zzg3 = (zzfi.zzg)((zzjf)zzfi.zzg.zze().zza("_ev").zzb(string).zzah());
        zza2.zza(zzg2).zza(zzg3);
    }

    @WorkerThread
    final void zza(zzbe zzbe2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzo2);
        Preconditions.checkNotEmpty((String)zzo2.zza);
        this.zzl().zzt();
        this.zzs();
        String string = zzo2.zza;
        long l = zzbe2.zzd;
        zzft zzft2 = zzft.zza((zzbe)zzbe2);
        String string2 = string;
        zzid zzid2 = this;
        zzid2.zzl().zzt();
        zzng.zza(zzid2.zzaf == null || zzid2.zzag == null || !zzid2.zzag.equals(string2) ? null : zzid2.zzaf, (Bundle)zzft2.zzb, (boolean)false);
        zzbe2 = zzft2.zza();
        this.zzp();
        if (!zzmz.zza(zzbe2, zzo2)) {
            return;
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        if (zzo2.zzs != null) {
            if (zzo2.zzs.contains(zzbe2.zza)) {
                Bundle bundle = zzbe2.zzb.zzb();
                bundle.putLong("ga_safelisted", 1L);
                zzbe2 = new zzbe(zzbe2.zza, new zzaz(bundle), zzbe2.zzc, zzbe2.zzd);
            } else {
                this.zzj().zzc().zza("Dropping non-safelisted event. appId, event name, origin", (Object)string, (Object)zzbe2.zza, (Object)zzbe2.zzc);
                return;
            }
        }
        this.zzf().zzp();
        try {
            zzae zzae2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string3;
            List list3;
            long l2 = l;
            string2 = string;
            zzid2 = this.zzf();
            Preconditions.checkNotEmpty((String)string2);
            zzid2.zzt();
            zzid2.zzak();
            if (l2 < 0L) {
                zzid2.zzj().zzu().zza("Invalid time querying timed out conditional properties", zzfp.zza((String)string2), (Object)l2);
                list3 = Collections.emptyList();
            } else {
                string3 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string2, String.valueOf(l2)};
                list3 = zzid2.zza(string3, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzj().zzp().zza("User property timed out", (Object)((zzae)object22).zza, (Object)this.zzm.zzk().zzc(((zzae)object22).zzc.zza), ((zzae)object22).zzc.zza());
                if (((zzae)object22).zzg != null) {
                    this.zzc(new zzbe(((zzae)object22).zzg, l), zzo2);
                }
                this.zzf().zza(string, ((zzae)object22).zzc.zza);
            }
            l2 = l;
            string2 = string;
            zzid2 = this.zzf();
            Preconditions.checkNotEmpty((String)string2);
            zzid2.zzt();
            zzid2.zzak();
            if (l2 < 0L) {
                zzid2.zzj().zzu().zza("Invalid time querying expired conditional properties", zzfp.zza((String)string2), (Object)l2);
                list2 = Collections.emptyList();
            } else {
                string3 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string2, String.valueOf(l2)};
                list2 = zzid2.zza(string3, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzae)object4.next();
                if (object == null) continue;
                this.zzj().zzp().zza("User property expired", (Object)((zzae)object).zza, (Object)this.zzm.zzk().zzc(((zzae)object).zzc.zza), ((zzae)object).zzc.zza());
                this.zzf().zzh(string, ((zzae)object).zzc.zza);
                if (((zzae)object).zzk != null) {
                    object22.add(((zzae)object).zzk);
                }
                this.zzf().zza(string, ((zzae)object).zzc.zza);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzbe)e;
                this.zzc(new zzbe((zzbe)object, l), zzo2);
            }
            long l3 = l;
            String string4 = zzbe2.zza;
            string2 = string;
            zzid2 = this.zzf();
            Preconditions.checkNotEmpty((String)string2);
            Preconditions.checkNotEmpty((String)string4);
            zzid2.zzt();
            zzid2.zzak();
            if (l3 < 0L) {
                zzid2.zzj().zzu().zza("Invalid time querying triggered conditional properties", zzfp.zza((String)string2), (Object)zzid2.zzi().zza(string4), (Object)l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string2, string4, String.valueOf(l3)};
                list = zzid2.zza((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzae2 = (zzae)iterator.next();
                if (zzae2 == null) continue;
                zznb zznb2 = zzae2.zzc;
                zznd zznd2 = new zznd((String)Preconditions.checkNotNull((Object)zzae2.zza), zzae2.zzb, zznb2.zza, l, Preconditions.checkNotNull((Object)zznb2.zza()));
                if (this.zzf().zza(zznd2)) {
                    this.zzj().zzp().zza("User property triggered", (Object)zzae2.zza, (Object)this.zzm.zzk().zzc(zznd2.zzc), zznd2.zze);
                } else {
                    this.zzj().zzg().zza("Too many active user properties, ignoring", zzfp.zza((String)zzae2.zza), (Object)this.zzm.zzk().zzc(zznd2.zzc), zznd2.zze);
                }
                if (zzae2.zzi != null) {
                    object.add(zzae2.zzi);
                }
                zzae2.zzc = new zznb(zznd2);
                zzae2.zze = true;
                this.zzf().zza(zzae2);
            }
            this.zzc(zzbe2, zzo2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzae2 = (zzbe)e;
                this.zzc(new zzbe((zzbe)zzae2, l), zzo2);
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @WorkerThread
    final void zza(zzbe zzbe2, String string) {
        zzg zzg2 = this.zzf().zzd(string);
        if (zzg2 == null || TextUtils.isEmpty((CharSequence)zzg2.zzaa())) {
            this.zzj().zzc().zza("No app data available; dropping event", (Object)string);
            return;
        }
        Boolean bl = this.zza(zzg2);
        if (bl == null) {
            if (!"_ui".equals(zzbe2.zza)) {
                this.zzj().zzu().zza("Could not find package. appId", zzfp.zza((String)string));
            }
        } else if (!bl.booleanValue()) {
            this.zzj().zzg().zza("App version does not match; dropping event. appId", zzfp.zza((String)string));
            return;
        }
        zzif zzif2 = this.zzb(string);
        String string2 = "";
        int n = 100;
        if (zzns.zza() && this.zze().zza(zzbg.zzcm)) {
            string2 = this.zzd(string).zzf();
            n = zzif2.zza();
        }
        zzo zzo2 = new zzo(string, zzg2.zzac(), zzg2.zzaa(), zzg2.zzc(), zzg2.zzz(), zzg2.zzo(), zzg2.zzl(), null, zzg2.zzal(), false, zzg2.zzab(), zzg2.zzb(), 0L, 0, zzg2.zzak(), false, zzg2.zzv(), zzg2.zzu(), zzg2.zzm(), zzg2.zzah(), null, zzif2.zze(), "", null, zzg2.zzan(), zzg2.zzt(), n, string2, zzg2.zza(), zzg2.zzd(), zzg2.zzag());
        this.zzb(zzbe2, zzo2);
    }

    @WorkerThread
    private final void zzb(zzbe zzbe2, zzo zzo2) {
        zznb zznb2;
        String string;
        Preconditions.checkNotEmpty((String)zzo2.zza);
        zzft zzft2 = zzft.zza((zzbe)zzbe2);
        this.zzq().zza(zzft2.zzb, this.zzf().zzc(zzo2.zza));
        this.zzq().zza(zzft2, this.zze().zzb(zzo2.zza));
        zzbe2 = zzft2.zza();
        zzo zzo3 = zzo2;
        zzbe zzbe3 = zzbe2;
        zzmp zzmp2 = this;
        if ("_cmp".equals(zzbe3.zza) && "referrer API v2".equals(zzbe3.zzb.zzd("_cis")) && !TextUtils.isEmpty((CharSequence)(string = zzbe3.zzb.zzd("gclid")))) {
            zznb2 = new zznb("_lgclid", zzbe3.zzd, (Object)string, "auto");
            zzmp2.zza(zznb2, zzo3);
        }
        if (zzok.zza() && zzok.zzc()) {
            zzo3 = zzo2;
            zzbe3 = zzbe2;
            zzmp2 = this;
            if ("_cmp".equals(zzbe3.zza) && "referrer API v2".equals(zzbe3.zzb.zzd("_cis")) && !TextUtils.isEmpty((CharSequence)(string = zzbe3.zzb.zzd("gbraid")))) {
                zznb2 = new zznb("_gbraid", zzbe3.zzd, (Object)string, "auto");
                zzmp2.zza(zznb2, zzo3);
            }
        }
        this.zza(zzbe2, zzo2);
    }

    @VisibleForTesting
    private final void zza(zzfi.zzj.zza zza2, long l, boolean bl) {
        zznd zznd2;
        String string = "_lte";
        if (bl) {
            string = "_se";
        }
        zznd2 = (zznd2 = this.zzf().zze(zza2.zzt(), string)) == null || zznd2.zze == null ? new zznd(zza2.zzt(), "auto", string, this.zzb().currentTimeMillis(), (Object)l) : new zznd(zza2.zzt(), "auto", string, this.zzb().currentTimeMillis(), (Object)((Long)zznd2.zze + l));
        zzfi.zzn zzn2 = (zzfi.zzn)((zzjf)zzfi.zzn.zze().zza(string).zzb(this.zzb().currentTimeMillis()).zza((Long)zznd2.zze).zzah());
        boolean bl2 = false;
        int n = zzmz.zza(zza2, string);
        if (n >= 0) {
            zza2.zza(n, zzn2);
            bl2 = true;
        }
        if (!bl2) {
            zza2.zza(zzn2);
        }
        if (l > 0L) {
            this.zzf().zza(zznd2);
            String string2 = "lifetime";
            if (bl) {
                string2 = "session-scoped";
            }
            this.zzj().zzp().zza("Updated engagement user property. scope, value", (Object)string2, zznd2.zze);
        }
    }

    final void zzt() {
        ++this.zzt;
    }

    @VisibleForTesting
    @WorkerThread
    final void zza(String string, int n, @Nullable Throwable throwable, byte @Nullable [] byArray, @Nullable Map<String, List<String>> map) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotEmpty((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzj().zzp().zza("onConfigFetched. Response size", (Object)byArray.length);
            this.zzf().zzp();
            try {
                boolean bl;
                zzg zzg2 = this.zzf().zzd(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzg2 == null) {
                    this.zzj().zzu().zza("App does not exist in onConfigFetched. appId", zzfp.zza((String)string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = list != null && !list.isEmpty() ? list.get(0) : null;
                    List<String> list2 = map != null ? map.get("ETag") : null;
                    String string4 = string2 = list2 != null && !list2.isEmpty() ? list2.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzi().zzc(string) == null && !this.zzi().zza(string, null, null, null) : !this.zzi().zza(string, byArray, string3, string2)) {
                        return;
                    }
                    zzg2.zzc(this.zzb().currentTimeMillis());
                    this.zzf().zza(zzg2);
                    if (n == 404) {
                        this.zzj().zzv().zza("Config not found. Using empty config. appId", (Object)string);
                    } else {
                        this.zzj().zzp().zza("Successfully fetched config. Got network response. code, size", (Object)n, (Object)byArray.length);
                    }
                    if (this.zzh().zzu() && this.zzac()) {
                        this.zzw();
                    } else {
                        this.zzab();
                    }
                } else {
                    zzg2.zzl(this.zzb().currentTimeMillis());
                    this.zzf().zza(zzg2);
                    this.zzj().zzp().zza("Fetching config failed. code, error", (Object)n, (Object)throwable);
                    this.zzi().zzi(string);
                    this.zzj.zzd.zza(this.zzb().currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzj.zzb.zza(this.zzb().currentTimeMillis());
                    }
                    this.zzab();
                }
                this.zzf().zzw();
            }
            finally {
                this.zzf().zzu();
            }
            return;
        }
        finally {
            this.zzu = false;
            this.zzaa();
        }
    }

    final void zza(boolean bl) {
        this.zzab();
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(boolean bl, int n, @Nullable Throwable throwable, byte @Nullable [] byArray, String string) {
        this.zzl().zzt();
        this.zzs();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List list = (List)Preconditions.checkNotNull(this.zzz);
            this.zzz = null;
            if (zznm.zza() && this.zze().zza(zzbg.zzcr) && !bl || (n == 200 || n == 204) && throwable == null) {
                try {
                    if (!zznm.zza() || !this.zze().zza(zzbg.zzcr) || bl) {
                        this.zzj.zzc.zza(this.zzb().currentTimeMillis());
                    }
                    this.zzj.zzd.zza(0L);
                    this.zzab();
                    if (!zznm.zza() || !this.zze().zza(zzbg.zzcr) || bl) {
                        this.zzj().zzp().zza("Successful upload. Got network response. code, size", (Object)n, (Object)byArray.length);
                    } else if (zznm.zza() && this.zze().zza(zzbg.zzcr)) {
                        this.zzj().zzp().zza("Purged empty bundles");
                    }
                    this.zzf().zzp();
                    try {
                        for (Long l : list) {
                            try {
                                long l2 = l;
                                zzal zzal2 = this.zzf();
                                zzal2.zzt();
                                zzal2.zzak();
                                SQLiteDatabase sQLiteDatabase = zzal2.e_();
                                String[] stringArray = new String[]{String.valueOf(l2)};
                                try {
                                    if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                    throw new SQLiteException("Deleted fewer rows from queue than expected");
                                }
                                catch (SQLiteException sQLiteException) {
                                    zzal2.zzj().zzg().zza("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                    throw sQLiteException;
                                }
                            }
                            catch (SQLiteException sQLiteException) {
                                if (this.zzaa != null && this.zzaa.contains(l)) continue;
                                throw sQLiteException;
                            }
                        }
                        this.zzf().zzw();
                    }
                    finally {
                        this.zzf().zzu();
                    }
                    this.zzaa = null;
                    if (this.zzh().zzu() && this.zzac()) {
                        this.zzw();
                    } else {
                        this.zzab = -1L;
                        this.zzab();
                    }
                    this.zzp = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzj().zzg().zza("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzp = this.zzb().elapsedRealtime();
                    this.zzj().zzp().zza("Disable upload, time", (Object)this.zzp);
                }
            } else {
                this.zzj().zzp().zza("Network upload failed. Will retry later. code, error", (Object)n, (Object)throwable);
                this.zzj.zzd.zza(this.zzb().currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzj.zzb.zza(this.zzb().currentTimeMillis());
                }
                this.zzf().zza(list);
                this.zzab();
            }
            return;
        }
        finally {
            this.zzv = false;
            this.zzaa();
        }
    }

    @WorkerThread
    final void zzc(zzo zzo2) {
        this.zzl().zzt();
        this.zzs();
        Preconditions.checkNotNull((Object)zzo2);
        Preconditions.checkNotEmpty((String)zzo2.zza);
        if (!zzmp.zze(zzo2)) {
            return;
        }
        zzg zzg2 = this.zzf().zzd(zzo2.zza);
        if (zzg2 != null && TextUtils.isEmpty((CharSequence)zzg2.zzac()) && !TextUtils.isEmpty((CharSequence)zzo2.zzb)) {
            zzg2.zzc(0L);
            this.zzf().zza(zzg2);
            this.zzi().zzj(zzo2.zza);
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        long l = zzo2.zzl;
        if (l == 0L) {
            l = this.zzb().currentTimeMillis();
        }
        this.zzm.zzg().zzm();
        int n = zzo2.zzm;
        if (n != 0 && n != 1) {
            this.zzj().zzu().zza("Incorrect app type, assuming installed app. appId, appType", zzfp.zza((String)zzo2.zza), (Object)n);
            n = 0;
        }
        this.zzf().zzp();
        try {
            Object object;
            Bundle bundle;
            String string;
            Object object2;
            SQLiteDatabase sQLiteDatabase;
            zzal zzal2;
            String string2;
            zznb zznb2;
            zznd zznd2 = this.zzf().zze(zzo2.zza, "_npa");
            if (zznd2 == null || "auto".equals(zznd2.zzb)) {
                if (zzo2.zzq != null) {
                    zznb2 = new zznb("_npa", l, (Object)(zzo2.zzq != false ? 1L : 0L), "auto");
                    if (zznd2 == null || !zznd2.zze.equals(zznb2.zzc)) {
                        this.zza(zznb2, zzo2);
                    }
                } else if (zznd2 != null) {
                    this.zza("_npa", zzo2);
                }
            }
            long l2 = l;
            zzo zzo3 = zzo2;
            zzmp zzmp2 = this;
            Object object3 = zzmp2.zzf().zzd((String)Preconditions.checkNotNull((Object)zzo3.zza));
            if (object3 != null) {
                zzmp2.zzq();
                if (zzng.zza((String)zzo3.zzb, (String)((zzg)object3).zzac(), (String)zzo3.zzp, (String)((zzg)object3).zzv())) {
                    zzmp2.zzj().zzu().zza("New GMP App Id passed in. Removing cached database data. appId", zzfp.zza((String)((zzg)object3).zzx()));
                    string2 = ((zzg)object3).zzx();
                    zzal2 = zzmp2.zzf();
                    zzal2.zzak();
                    zzal2.zzt();
                    Preconditions.checkNotEmpty((String)string2);
                    try {
                        sQLiteDatabase = zzal2.e_();
                        object2 = new String[]{string2};
                        int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", object2) + sQLiteDatabase.delete("user_attributes", "app_id=?", object2) + sQLiteDatabase.delete("conditional_properties", "app_id=?", object2) + sQLiteDatabase.delete("apps", "app_id=?", object2) + sQLiteDatabase.delete("raw_events", "app_id=?", object2) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", object2) + sQLiteDatabase.delete("event_filters", "app_id=?", object2) + sQLiteDatabase.delete("property_filters", "app_id=?", object2) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", object2) + sQLiteDatabase.delete("consent_settings", "app_id=?", object2) + sQLiteDatabase.delete("default_event_params", "app_id=?", object2) + sQLiteDatabase.delete("trigger_uris", "app_id=?", object2);
                        if (n2 > 0) {
                            zzal2.zzj().zzp().zza("Deleted application data. app, records", (Object)string2, (Object)n2);
                        }
                    }
                    catch (SQLiteException sQLiteException) {
                        zzal2.zzj().zzg().zza("Error deleting application data. appId, error", zzfp.zza((String)string2), (Object)sQLiteException);
                    }
                    object3 = null;
                }
            }
            if (object3 != null) {
                boolean bl = ((zzg)object3).zzc() != Integer.MIN_VALUE && ((zzg)object3).zzc() != zzo3.zzj;
                string = ((zzg)object3).zzaa();
                if (bl | (((zzg)object3).zzc() == Integer.MIN_VALUE && string != null && !string.equals(zzo3.zzc))) {
                    bundle = new Bundle();
                    bundle.putString("_pv", string);
                    object = new zzbe("_au", new zzaz(bundle), "auto", l2);
                    zzmp2.zza((zzbe)object, zzo3);
                }
            }
            this.zza(zzo2);
            zznb2 = null;
            if (n == 0) {
                zznb2 = this.zzf().zzd(zzo2.zza, "_f");
            } else if (n == 1) {
                zznb2 = this.zzf().zzd(zzo2.zza, "_v");
            }
            if (zznb2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    zznb zznb3 = new zznb("_fot", l, (Object)l3, "auto");
                    this.zza(zznb3, zzo2);
                    zzo3 = zzo2;
                    zzmp2 = this;
                    zzmp2.zzl().zzt();
                    String string3 = zzo3.zza;
                    zzgk zzgk2 = (zzgk)Preconditions.checkNotNull((Object)zzmp2.zzl);
                    if (string3 == null || string3.isEmpty()) {
                        zzgk2.zza.zzj().zzw().zza("Install Referrer Reporter was called with invalid app package name");
                    } else {
                        zzgk2.zza.zzl().zzt();
                        if (!zzgk2.zza()) {
                            zzgk2.zza.zzj().zzn().zza("Install Referrer Reporter is not available");
                        } else {
                            zzgj zzgj2 = new zzgj(zzgk2, string3);
                            object3 = zzgk2;
                            ((zzgk)object3).zza.zzl().zzt();
                            string = new Intent("com.google.android.finsky.BIND_GET_INSTALL_REFERRER_SERVICE");
                            string.setComponent(new ComponentName("com.android.vending", "com.google.android.finsky.externalreferrer.GetInstallReferrerService"));
                            bundle = ((zzgk)object3).zza.zza().getPackageManager();
                            if (bundle == null) {
                                ((zzgk)object3).zza.zzj().zzw().zza("Failed to obtain Package Manager to verify binding conditions for Install Referrer");
                            } else {
                                object = bundle.queryIntentServices((Intent)string, 0);
                                if (object != null && !object.isEmpty()) {
                                    zzal2 = (ResolveInfo)object.get(0);
                                    if (((ResolveInfo)zzal2).serviceInfo != null) {
                                        string2 = ((ResolveInfo)zzal2).serviceInfo.packageName;
                                        if (((ResolveInfo)zzal2).serviceInfo.name != null && "com.android.vending".equals(string2) && ((zzgk)object3).zza()) {
                                            Intent intent = new Intent((Intent)string);
                                            try {
                                                boolean bl = ConnectionTracker.getInstance().bindService(((zzgk)object3).zza.zza(), intent, (ServiceConnection)zzgj2, 1);
                                                ((zzgk)object3).zza.zzj().zzp().zza("Install Referrer Service is", (Object)(bl ? "available" : "not available"));
                                            }
                                            catch (RuntimeException runtimeException) {
                                                ((zzgk)object3).zza.zzj().zzg().zza("Exception occurred while binding to Install Referrer Service", (Object)runtimeException.getMessage());
                                            }
                                        } else {
                                            ((zzgk)object3).zza.zzj().zzu().zza("Play Store version 8.3.73 or higher required for Install Referrer");
                                        }
                                    }
                                } else {
                                    ((zzgk)object3).zza.zzj().zzn().zza("Play Service for fetching Install Referrer is unavailable on device");
                                }
                            }
                        }
                    }
                    long l4 = l;
                    zzo3 = zzo2;
                    zzmp2 = this;
                    zzmp2.zzl().zzt();
                    zzmp2.zzs();
                    object3 = new Bundle();
                    object3.putLong("_c", 1L);
                    object3.putLong("_r", 1L);
                    object3.putLong("_uwa", 0L);
                    object3.putLong("_pfo", 0L);
                    object3.putLong("_sys", 0L);
                    object3.putLong("_sysu", 0L);
                    object3.putLong("_et", 1L);
                    if (zzo3.zzo) {
                        object3.putLong("_dac", 1L);
                    }
                    String string4 = (String)Preconditions.checkNotNull((Object)zzo3.zza);
                    object2 = string4;
                    zzal zzal3 = zzmp2.zzf();
                    Preconditions.checkNotEmpty((String)object2);
                    zzal3.zzt();
                    zzal3.zzak();
                    long l5 = zzal3.zzb((String)object2, "first_open_count");
                    if (zzmp2.zzm.zza().getPackageManager() == null) {
                        zzmp2.zzj().zzg().zza("PackageManager is null, first open report might be inaccurate. appId", zzfp.zza((String)string4));
                    } else {
                        zzal2 = null;
                        try {
                            zzal2 = Wrappers.packageManager((Context)zzmp2.zzm.zza()).getPackageInfo(string4, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzmp2.zzj().zzg().zza("Package info is null, first open report might be inaccurate. appId", zzfp.zza((String)string4), (Object)nameNotFoundException);
                        }
                        if (zzal2 != null && ((PackageInfo)zzal2).firstInstallTime != 0L) {
                            boolean bl = false;
                            if (((PackageInfo)zzal2).firstInstallTime != ((PackageInfo)zzal2).lastUpdateTime) {
                                if (zzmp2.zze().zza(zzbg.zzbk)) {
                                    if (l5 == 0L) {
                                        object3.putLong("_uwa", 1L);
                                    }
                                } else {
                                    object3.putLong("_uwa", 1L);
                                }
                            } else {
                                bl = true;
                            }
                            sQLiteDatabase = new zznb("_fi", l4, (Object)(bl ? 1L : 0L), "auto");
                            zzmp2.zza((zznb)sQLiteDatabase, zzo3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = Wrappers.packageManager((Context)zzmp2.zzm.zza()).getApplicationInfo(string4, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzmp2.zzj().zzg().zza("Application info is null, first open report might be inaccurate. appId", zzfp.zza((String)string4), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                object3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                object3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    if (l5 >= 0L) {
                        object3.putLong("_pfo", l5);
                    }
                    zzal2 = new zzbe("_f", new zzaz((Bundle)object3), "auto", l4);
                    zzmp2.zzb((zzbe)zzal2, zzo3);
                } else if (n == 1) {
                    zznb zznb4 = new zznb("_fvt", l, (Object)l3, "auto");
                    this.zza(zznb4, zzo2);
                    l2 = l;
                    zzo3 = zzo2;
                    zzmp2 = this;
                    zzmp2.zzl().zzt();
                    zzmp2.zzs();
                    object3 = new Bundle();
                    object3.putLong("_c", 1L);
                    object3.putLong("_r", 1L);
                    object3.putLong("_et", 1L);
                    if (zzo3.zzo) {
                        object3.putLong("_dac", 1L);
                    }
                    zzbe zzbe2 = new zzbe("_v", new zzaz((Bundle)object3), "auto", l2);
                    zzmp2.zzb(zzbe2, zzo3);
                }
            } else if (zzo2.zzi) {
                l2 = l;
                zzo3 = zzo2;
                zzmp2 = this;
                object3 = new Bundle();
                zzbe zzbe3 = new zzbe("_cd", new zzaz((Bundle)object3), "auto", l2);
                zzmp2.zzb(zzbe3, zzo3);
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    final void zzu() {
        ++this.zzs;
    }

    @WorkerThread
    final void zza(zzae zzae2) {
        zzo zzo2 = this.zzc((String)Preconditions.checkNotNull((Object)zzae2.zza));
        if (zzo2 != null) {
            this.zza(zzae2, zzo2);
        }
    }

    @WorkerThread
    final void zza(zzae zzae2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzae2);
        Preconditions.checkNotEmpty((String)zzae2.zza);
        Preconditions.checkNotNull((Object)zzae2.zzc);
        Preconditions.checkNotEmpty((String)zzae2.zzc.zza);
        this.zzl().zzt();
        this.zzs();
        if (!zzmp.zze(zzo2)) {
            return;
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        this.zzf().zzp();
        try {
            this.zza(zzo2);
            String string = (String)Preconditions.checkNotNull((Object)zzae2.zza);
            zzae zzae3 = this.zzf().zzc(string, zzae2.zzc.zza);
            if (zzae3 != null) {
                this.zzj().zzc().zza("Removing conditional user property", (Object)zzae2.zza, (Object)this.zzm.zzk().zzc(zzae2.zzc.zza));
                this.zzf().zza(string, zzae2.zzc.zza);
                if (zzae3.zze) {
                    this.zzf().zzh(string, zzae2.zzc.zza);
                }
                if (zzae2.zzk != null) {
                    Bundle bundle = null;
                    if (zzae2.zzk.zzb != null) {
                        bundle = zzae2.zzk.zzb.zzb();
                    }
                    zzbe zzbe2 = this.zzq().zza(string, ((zzbe)Preconditions.checkNotNull((Object)zzae2.zzk)).zza, bundle, zzae3.zzb, zzae2.zzk.zzd, true, true);
                    this.zzc((zzbe)Preconditions.checkNotNull((Object)zzbe2), zzo2);
                }
            } else {
                this.zzj().zzu().zza("Conditional user property doesn't exist", zzfp.zza((String)zzae2.zza), (Object)this.zzm.zzk().zzc(zzae2.zzc.zza));
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @VisibleForTesting
    private static void zza(zzfi.zze.zza zza2, @NonNull String string) {
        List<zzfi.zzg> list = zza2.zzf();
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equals(list.get(i).zzg())) continue;
            zza2.zza(i);
            return;
        }
    }

    @WorkerThread
    final void zza(String string, zzo zzo2) {
        this.zzl().zzt();
        this.zzs();
        if (!zzmp.zze(zzo2)) {
            return;
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        if ("_npa".equals(string) && zzo2.zzq != null) {
            this.zzj().zzc().zza("Falling back to manifest metadata value for ad personalization");
            zznb zznb2 = new zznb("_npa", this.zzb().currentTimeMillis(), (Object)(zzo2.zzq != false ? 1L : 0L), "auto");
            this.zza(zznb2, zzo2);
            return;
        }
        this.zzj().zzc().zza("Removing user property", (Object)this.zzm.zzk().zzc(string));
        this.zzf().zzp();
        try {
            this.zza(zzo2);
            if ("_id".equals(string)) {
                this.zzf().zzh((String)Preconditions.checkNotNull((Object)zzo2.zza), "_lair");
            }
            this.zzf().zzh((String)Preconditions.checkNotNull((Object)zzo2.zza), string);
            this.zzf().zzw();
            this.zzj().zzc().zza("User property removed", (Object)this.zzm.zzk().zzc(string));
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @VisibleForTesting(otherwise=4)
    @WorkerThread
    final void zzd(zzo zzo2) {
        if (this.zzz != null) {
            this.zzaa = new ArrayList<Long>();
            this.zzaa.addAll(this.zzz);
        }
        String string = (String)Preconditions.checkNotNull((Object)zzo2.zza);
        zzal zzal2 = this.zzf();
        Preconditions.checkNotEmpty((String)string);
        zzal2.zzt();
        zzal2.zzak();
        try {
            SQLiteDatabase sQLiteDatabase = zzal2.e_();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray) + sQLiteDatabase.delete("main_event_params", "app_id=?", stringArray) + sQLiteDatabase.delete("default_event_params", "app_id=?", stringArray) + sQLiteDatabase.delete("trigger_uris", "app_id=?", stringArray);
            if (n > 0) {
                zzal2.zzj().zzp().zza("Reset analytics data. app, records", (Object)string, (Object)n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzal2.zzj().zzg().zza("Error resetting analytics data. appId, error", zzfp.zza((String)string), (Object)sQLiteException);
        }
        if (zzo2.zzh) {
            this.zzc(zzo2);
        }
    }

    @WorkerThread
    public final void zza(String string, @Nullable zzki zzki2) {
        this.zzl().zzt();
        if (this.zzag == null || this.zzag.equals(string) || zzki2 != null) {
            this.zzag = string;
            this.zzaf = zzki2;
        }
    }

    @VisibleForTesting
    private final void zza(List<Long> list) {
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0);
        if (this.zzz != null) {
            this.zzj().zzg().zza("Set uploading progress before finishing the previous upload");
            return;
        }
        this.zzz = new ArrayList<Long>(list);
    }

    @WorkerThread
    protected final void zzv() {
        this.zzl().zzt();
        this.zzf().zzv();
        if (this.zzj.zzc.zza() == 0L) {
            this.zzj.zzc.zza(this.zzb().currentTimeMillis());
        }
        this.zzab();
    }

    @WorkerThread
    final void zzb(zzae zzae2) {
        zzo zzo2 = this.zzc((String)Preconditions.checkNotNull((Object)zzae2.zza));
        if (zzo2 != null) {
            this.zzb(zzae2, zzo2);
        }
    }

    @WorkerThread
    final void zzb(zzae zzae2, zzo zzo2) {
        Preconditions.checkNotNull((Object)zzae2);
        Preconditions.checkNotEmpty((String)zzae2.zza);
        Preconditions.checkNotNull((Object)zzae2.zzb);
        Preconditions.checkNotNull((Object)zzae2.zzc);
        Preconditions.checkNotEmpty((String)zzae2.zzc.zza);
        this.zzl().zzt();
        this.zzs();
        if (!zzmp.zze(zzo2)) {
            return;
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        zzae zzae3 = new zzae(zzae2);
        new zzae(zzae2).zze = false;
        this.zzf().zzp();
        try {
            boolean bl = false;
            zzae zzae4 = this.zzf().zzc((String)Preconditions.checkNotNull((Object)zzae3.zza), zzae3.zzc.zza);
            if (zzae4 != null && !zzae4.zzb.equals(zzae3.zzb)) {
                this.zzj().zzu().zza("Updating a conditional user property with different origin. name, origin, origin (from DB)", (Object)this.zzm.zzk().zzc(zzae3.zzc.zza), (Object)zzae3.zzb, (Object)zzae4.zzb);
            }
            if (zzae4 != null && zzae4.zze) {
                zzae3.zzb = zzae4.zzb;
                zzae3.zzd = zzae4.zzd;
                zzae3.zzh = zzae4.zzh;
                zzae3.zzf = zzae4.zzf;
                zzae3.zzi = zzae4.zzi;
                zzae3.zze = zzae4.zze;
                zzae3.zzc = new zznb(zzae3.zzc.zza, zzae4.zzc.zzb, zzae3.zzc.zza(), zzae4.zzc.zze);
            } else if (TextUtils.isEmpty((CharSequence)zzae3.zzf)) {
                zzae3.zzc = new zznb(zzae3.zzc.zza, zzae3.zzd, zzae3.zzc.zza(), zzae3.zzc.zze);
                zzae3.zze = true;
                bl = true;
            }
            if (zzae3.zze) {
                zznb zznb2 = zzae3.zzc;
                zznd zznd2 = new zznd((String)Preconditions.checkNotNull((Object)zzae3.zza), zzae3.zzb, zznb2.zza, zznb2.zzb, Preconditions.checkNotNull((Object)zznb2.zza()));
                if (this.zzf().zza(zznd2)) {
                    this.zzj().zzc().zza("User property updated immediately", (Object)zzae3.zza, (Object)this.zzm.zzk().zzc(zznd2.zzc), zznd2.zze);
                } else {
                    this.zzj().zzg().zza("(2)Too many active user properties, ignoring", zzfp.zza((String)zzae3.zza), (Object)this.zzm.zzk().zzc(zznd2.zzc), zznd2.zze);
                }
                if (bl && zzae3.zzi != null) {
                    zzbe zzbe2 = new zzbe(zzae3.zzi, zzae3.zzd);
                    this.zzc(zzbe2, zzo2);
                }
            }
            if (this.zzf().zza(zzae3)) {
                this.zzj().zzc().zza("Conditional property added", (Object)zzae3.zza, (Object)this.zzm.zzk().zzc(zzae3.zzc.zza), zzae3.zzc.zza());
            } else {
                this.zzj().zzg().zza("Too many conditional properties, ignoring", zzfp.zza((String)zzae3.zza), (Object)this.zzm.zzk().zzc(zzae3.zzc.zza), zzae3.zzc.zza());
            }
            this.zzf().zzw();
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @WorkerThread
    final void zza(String string, zzif zzif2) {
        this.zzl().zzt();
        this.zzs();
        this.zzac.put(string, zzif2);
        this.zzf().zza(string, zzif2);
    }

    @WorkerThread
    final void zza(String string, zzav zzav2) {
        this.zzl().zzt();
        this.zzs();
        if (zzns.zza()) {
            this.zzad.put(string, zzav2);
            this.zzf().zza(string, zzav2);
        }
    }

    @WorkerThread
    private final void zzab() {
        long l;
        long l2;
        long l3;
        block19: {
            long l4;
            this.zzl().zzt();
            this.zzs();
            if (this.zzp > 0L) {
                l3 = this.zzb().elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzp);
                if (l2 > 0L) {
                    this.zzj().zzp().zza("Upload has been suspended. Will update scheduling later in approximately ms", (Object)l2);
                    this.zzy().zzb();
                    this.zzz().zzu();
                    return;
                }
                this.zzp = 0L;
            }
            if (!this.zzm.zzaf() || !this.zzac()) {
                this.zzj().zzp().zza("Nothing to upload or uploading impossible");
                this.zzy().zzb();
                this.zzz().zzu();
                return;
            }
            zzmp zzmp2 = this;
            long l5 = zzmp2.zzb().currentTimeMillis();
            zzmp2.zze();
            long l6 = Math.max(0L, (Long)zzbg.zzaa.zza(null));
            boolean bl = zzmp2.zzf().zzz() || zzmp2.zzf().zzy();
            if (bl) {
                String string = zzmp2.zze().zzn();
                if (!TextUtils.isEmpty((CharSequence)string) && !".none.".equals(string)) {
                    zzmp2.zze();
                    l4 = Math.max(0L, (Long)zzbg.zzv.zza(null));
                } else {
                    zzmp2.zze();
                    l4 = Math.max(0L, (Long)zzbg.zzu.zza(null));
                }
            } else {
                zzmp2.zze();
                l4 = Math.max(0L, (Long)zzbg.zzt.zza(null));
            }
            long l7 = zzmp2.zzj.zzc.zza();
            long l8 = zzmp2.zzj.zzd.zza();
            long l9 = zzmp2.zzf().c_();
            long l10 = zzmp2.zzf().d_();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l5 - Math.abs(l11 - l5);
                l7 = l5 - Math.abs(l7 - l5);
                l8 = l5 - Math.abs(l8 - l5);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l6;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l4;
                }
                if (!zzmp2.zzp().zza(l12, l4)) {
                    l13 = l12 + l4;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    int n = 0;
                    while (true) {
                        zzmp2.zze();
                        if (n >= Math.min(20, Math.max(0, (Integer)zzbg.zzac.zza(null)))) break;
                        long l15 = 1L << n;
                        zzmp2.zze();
                        if ((l14 += Math.max(0L, (Long)zzbg.zzab.zza(null)) * l15) > l8) {
                            l = l14;
                            break block19;
                        }
                        ++n;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzj().zzp().zza("Next upload time is 0");
            this.zzy().zzb();
            this.zzz().zzu();
            return;
        }
        if (!this.zzh().zzu()) {
            this.zzj().zzp().zza("No network");
            this.zzy().zza();
            this.zzz().zzu();
            return;
        }
        l2 = this.zzj.zzb.zza();
        this.zze();
        long l16 = Math.max(0L, (Long)zzbg.zzr.zza(null));
        if (!this.zzp().zza(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzy().zzb();
        long l17 = l3 - this.zzb().currentTimeMillis();
        if (l17 <= 0L) {
            this.zze();
            l17 = Math.max(0L, (Long)zzbg.zzw.zza(null));
            this.zzj.zzc.zza(this.zzb().currentTimeMillis());
        }
        this.zzj().zzp().zza("Upload scheduled in approximately ms", (Object)l17);
        this.zzz().zza(l17);
    }

    @WorkerThread
    private final void zza(String string, boolean bl) {
        zzg zzg2 = this.zzf().zzd(string);
        if (zzg2 != null) {
            zzg2.zzd(bl);
            if (zzg2.zzam()) {
                this.zzf().zza(zzg2);
            }
        }
    }

    @WorkerThread
    final void zza(zznb zznb2, zzo zzo2) {
        this.zzl().zzt();
        this.zzs();
        if (!zzmp.zze(zzo2)) {
            return;
        }
        if (!zzo2.zzh) {
            this.zza(zzo2);
            return;
        }
        int n = this.zzq().zzb(zznb2.zza);
        if (n != 0) {
            this.zzq();
            String string = zznb2.zza;
            this.zze();
            String string2 = zzng.zza((String)string, (int)24, (boolean)true);
            int n2 = zznb2.zza != null ? zznb2.zza.length() : 0;
            this.zzq();
            zzng.zza((zznf)this.zzah, (String)zzo2.zza, (int)n, (String)"_ev", (String)string2, (int)n2);
            return;
        }
        n = this.zzq().zza(zznb2.zza, zznb2.zza());
        if (n != 0) {
            this.zzq();
            String string = zznb2.zza;
            this.zze();
            String string3 = zzng.zza((String)string, (int)24, (boolean)true);
            Object object = zznb2.zza();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzq();
            zzng.zza((zznf)this.zzah, (String)zzo2.zza, (int)n, (String)"_ev", (String)string3, (int)n3);
            return;
        }
        Object object = this.zzq().zzc(zznb2.zza, zznb2.zza());
        if (object == null) {
            return;
        }
        if ("_sid".equals(zznb2.zza)) {
            zzba zzba2;
            zzo zzo3 = zzo2;
            String string = zznb2.zze;
            long l = zznb2.zzb;
            zzmp zzmp2 = this;
            String string4 = (String)Preconditions.checkNotNull((Object)zzo3.zza);
            long l2 = 0L;
            zznd zznd2 = zzmp2.zzf().zze(string4, "_sno");
            if (zznd2 != null && zznd2.zze instanceof Long) {
                l2 = (Long)zznd2.zze;
            } else {
                if (zznd2 != null) {
                    zzmp2.zzj().zzu().zza("Retrieved last session number from database does not contain a valid (long) value", zznd2.zze);
                }
                if ((zzba2 = zzmp2.zzf().zzd(string4, "_s")) != null) {
                    l2 = zzba2.zzc;
                    zzmp2.zzj().zzp().zza("Backfill the session number. Last used session number", (Object)l2);
                }
            }
            zzba2 = new zznb("_sno", l, (Object)(++l2), string);
            zzmp2.zza((zznb)zzba2, zzo3);
        }
        zznd zznd3 = new zznd((String)Preconditions.checkNotNull((Object)zzo2.zza), (String)Preconditions.checkNotNull((Object)zznb2.zze), zznb2.zza, zznb2.zzb, object);
        this.zzj().zzp().zza("Setting user property", (Object)this.zzm.zzk().zzc(zznd3.zzc), object);
        this.zzf().zzp();
        try {
            zznd zznd4;
            if ("_id".equals(zznd3.zzc) && (zznd4 = this.zzf().zze(zzo2.zza, "_id")) != null && !zznd3.zze.equals(zznd4.zze)) {
                this.zzf().zzh(zzo2.zza, "_lair");
            }
            this.zza(zzo2);
            boolean bl = this.zzf().zza(zznd3);
            if ("_sid".equals(zznb2.zza)) {
                long l = this.zzp().zza(zzo2.zzv);
                zzg zzg2 = this.zzf().zzd(zzo2.zza);
                if (zzg2 != null) {
                    zzg2.zzq(l);
                    if (zzg2.zzam()) {
                        this.zzf().zza(zzg2);
                    }
                }
            }
            this.zzf().zzw();
            if (!bl) {
                this.zzj().zzg().zza("Too many unique user properties are set. Ignoring user property", (Object)this.zzm.zzk().zzc(zznd3.zzc), zznd3.zze);
                this.zzq();
                zzng.zza((zznf)this.zzah, (String)zzo2.zza, (int)9, null, null, (int)0);
            }
            return;
        }
        finally {
            this.zzf().zzu();
        }
    }

    @WorkerThread
    final void zzw() {
        this.zzl().zzt();
        this.zzs();
        this.zzw = true;
        try {
            String string;
            long l;
            long l2;
            Boolean bl = this.zzm.zzr().zzab();
            if (bl == null) {
                this.zzj().zzu().zza("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzj().zzg().zza("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzp > 0L) {
                this.zzab();
                return;
            }
            zzid zzid2 = this;
            zzid2.zzl().zzt();
            if (zzid2.zzz != null) {
                this.zzj().zzp().zza("Uploading requested multiple times");
                return;
            }
            if (!this.zzh().zzu()) {
                this.zzj().zzp().zza("Network not connected, ignoring upload request");
                this.zzab();
                return;
            }
            long l3 = this.zzb().currentTimeMillis();
            int n = this.zze().zzb(null, zzbg.zzas);
            this.zze();
            long l4 = l3 - com.google.android.gms.measurement.internal.zzag.zzh();
            for (int i = 0; i < n && this.zza(null, l2 = l4); ++i) {
            }
            if (zzph.zza()) {
                zzid2 = this;
                zzid2.zzl().zzt();
                for (String object7 : zzid2.zzr) {
                    if (!zzph.zza() || !zzid2.zze().zze(object7, zzbg.zzce)) continue;
                    zzid2.zzj().zzc().zza("Notifying app that trigger URIs are available. App ID", (Object)object7);
                    Intent intent = new Intent();
                    intent.setAction("com.google.android.gms.measurement.TRIGGERS_AVAILABLE");
                    intent.setPackage(object7);
                    zzid2.zzm.zza().sendBroadcast(intent);
                }
                zzid2.zzr.clear();
            }
            if ((l = this.zzj.zzc.zza()) != 0L) {
                this.zzj().zzc().zza("Uploading events. Elapsed time since last upload attempt (ms)", (Object)Math.abs(l3 - l));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzf().f_()))) {
                if (this.zzab == -1L) {
                    this.zzab = this.zzf().b_();
                }
                int n2 = this.zze().zzb(string, zzbg.zzg);
                Object object = string;
                zzid2 = this.zze();
                int n3 = Math.max(0, zzid2.zzb((String)object, zzbg.zzh));
                List<Pair<zzfi.zzj, Long>> list = this.zzf().zza(string, n2, n3);
                if (!list.isEmpty()) {
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    Object object6;
                    if (this.zzb(string).zzg()) {
                        object6 = null;
                        Iterator<Pair<zzfi.zzj, Long>> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            zzfi.zzj zzj2 = (zzfi.zzj)((Object)iterator.next().first);
                            if (zzj2.zzal().isEmpty()) continue;
                            object6 = zzj2.zzal();
                            break;
                        }
                        if (object6 != null) {
                            for (int i = 0; i < list.size(); ++i) {
                                object5 = (zzfi.zzj)((Object)list.get((int)i).first);
                                if (((zzfi.zzj)((Object)object5)).zzal().isEmpty() || ((zzfi.zzj)((Object)object5)).zzal().equals(object6)) continue;
                                list = list.subList(0, i);
                                break;
                            }
                        }
                    }
                    object6 = zzfi.zzi.zzb();
                    int n4 = list.size();
                    object5 = new ArrayList(list.size());
                    boolean bl2 = this.zze().zzi(string) && this.zzb(string).zzg();
                    boolean bl3 = this.zzb(string).zzg();
                    boolean bl4 = this.zzb(string).zzh();
                    boolean bl5 = zzpt.zza() && this.zze().zze(string, zzbg.zzbr);
                    for (int i = 0; i < n4; ++i) {
                        object4 = (zzfi.zzj.zza)((zzfi.zzj)((Object)list.get((int)i).first)).zzby();
                        object5.add((Long)list.get((int)i).second);
                        this.zze();
                        ((zzfi.zzj.zza)((Object)object4)).zzl(84002L).zzk(l3).zzd(false);
                        if (!bl2) {
                            ((zzfi.zzj.zza)((Object)object4)).zzj();
                        }
                        if (!bl3) {
                            ((zzfi.zzj.zza)((Object)object4)).zzq();
                            ((zzfi.zzj.zza)((Object)object4)).zzm();
                        }
                        if (!bl4) {
                            ((zzfi.zzj.zza)((Object)object4)).zzg();
                        }
                        this.zza(string, (zzfi.zzj.zza)((Object)object4));
                        if (!bl5) {
                            ((zzfi.zzj.zza)((Object)object4)).zzr();
                        }
                        if (zznm.zza() && this.zze().zza(zzbg.zzcr)) {
                            object = object4;
                            zzid2 = this;
                            String string2 = ((zzfi.zzj.zza)((Object)object)).zzz();
                            boolean bl6 = false;
                            if (TextUtils.isEmpty((CharSequence)string2) || string2.equals("00000000-0000-0000-0000-000000000000")) {
                                object3 = new ArrayList<zzfi.zze>(((zzfi.zzj.zza)((Object)object)).zzaa());
                                boolean bl7 = false;
                                Iterator iterator = object3.iterator();
                                while (iterator.hasNext()) {
                                    zzfi.zze zze2 = (zzfi.zze)((Object)iterator.next());
                                    if ("_fx".equals(zze2.zzg())) {
                                        bl6 = true;
                                        iterator.remove();
                                        bl7 = true;
                                        continue;
                                    }
                                    if (!"_f".equals(zze2.zzg())) continue;
                                    bl6 = true;
                                }
                                if (bl7) {
                                    ((zzfi.zzj.zza)((Object)object)).zzk();
                                    ((zzfi.zzj.zza)((Object)object)).zzb((Iterable<? extends zzfi.zze>)object3);
                                }
                                if (bl6) {
                                    super.zza(((zzfi.zzj.zza)((Object)object)).zzt(), true);
                                }
                            }
                            if (((zzfi.zzj.zza)((Object)object4)).zzc() == 0) continue;
                        }
                        if (this.zze().zze(string, zzbg.zzbe)) {
                            object2 = ((zzfi.zzj)((zzjf)object4.zzah())).zzbv();
                            ((zzfi.zzj.zza)((Object)object4)).zza(this.zzp().zza((byte[])object2));
                        }
                        ((zzfi.zzi.zza)((Object)object6)).zza((zzfi.zzj.zza)((Object)object4));
                    }
                    if (zznm.zza() && this.zze().zza(zzbg.zzcr) && ((zzfi.zzi.zza)((Object)object6)).zza() == 0) {
                        this.zza((List<Long>)object5);
                        this.zza(false, 204, null, null, string);
                        return;
                    }
                    String string3 = null;
                    if (this.zzj().zza(2)) {
                        string3 = this.zzp().zza((zzfi.zzi)((zzjf)object6.zzah()));
                    }
                    this.zzp();
                    object4 = ((zzfi.zzi)((zzjf)object6.zzah())).zzbv();
                    object2 = this.zzk.zzb(string);
                    try {
                        this.zza((List<Long>)object5);
                        this.zzj.zzd.zza(l3);
                        String string4 = "?";
                        if (n4 > 0) {
                            string4 = ((zzfi.zzi.zza)((Object)object6)).zza(0).zzx();
                        }
                        this.zzj().zzp().zza("Uploading data. app, uncompressed size, data", (Object)string4, (Object)((Object)object4).length, (Object)string3);
                        this.zzv = true;
                        zzmr zzmr2 = new zzmr(this, string);
                        object3 = ((zzmq)object2).zzb();
                        Object object7 = object4;
                        URL uRL = new URL(((zzmq)object2).zza());
                        object = string;
                        zzid2 = this.zzh();
                        zzid2.zzt();
                        zzid2.zzak();
                        Preconditions.checkNotNull((Object)uRL);
                        Preconditions.checkNotNull((Object)object7);
                        Preconditions.checkNotNull((Object)zzmr2);
                        zzid2.zzl().zza((Runnable)new zzga((zzfw)zzid2, (String)object, uRL, (byte[])object7, (Map)object3, zzmr2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzj().zzg().zza("Failed to parse upload URL. Not uploading. appId", zzfp.zza((String)string), (Object)((zzmq)object2).zza());
                    }
                }
            } else {
                zzg zzg2;
                this.zzab = -1L;
                zzal zzal2 = this.zzf();
                this.zze();
                String string5 = zzal2.zza(l3 - com.google.android.gms.measurement.internal.zzag.zzh());
                if (!TextUtils.isEmpty((CharSequence)string5) && (zzg2 = this.zzf().zzd(string5)) != null) {
                    this.zzb(zzg2);
                }
            }
            return;
        }
        finally {
            this.zzw = false;
            this.zzaa();
        }
    }

    @VisibleForTesting
    private final void zza(String string, zzfi.zzg.zza zza2, Bundle bundle, @Nullable String string2) {
        List list = CollectionUtils.listOf((Object[])new String[]{"_o", "_sn", "_sc", "_si"});
        long l = zzng.zzg((String)zza2.zzf()) || zzng.zzg((String)string) ? (long)this.zze().zzb(string2, true) : (long)this.zze().zza(string2, true);
        long l2 = zza2.zzg().codePointCount(0, zza2.zzg().length());
        this.zzq();
        String string3 = zza2.zzf();
        this.zze();
        String string4 = zzng.zza((String)string3, (int)40, (boolean)true);
        if (l2 > l && !list.contains(zza2.zzf())) {
            if ("_ev".equals(zza2.zzf())) {
                this.zzq();
                String string5 = zzng.zza((String)zza2.zzg(), (int)this.zze().zzb(string2, true), (boolean)true);
                bundle.putString("_ev", string5);
                return;
            }
            this.zzj().zzv().zza("Param value is too long; discarded. Name, value length", (Object)string4, (Object)l2);
            if (bundle.getLong("_err") == 0L) {
                bundle.putLong("_err", 4L);
                if (bundle.getString("_ev") == null) {
                    bundle.putString("_ev", string4);
                    bundle.putLong("_el", l2);
                }
            }
            bundle.remove(zza2.zzf());
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @WorkerThread
    private final void zzc(zzbe var1_1, zzo var2_2) {
        Preconditions.checkNotNull((Object)var2_2);
        Preconditions.checkNotEmpty((String)var2_2.zza);
        var3_3 = System.nanoTime();
        this.zzl().zzt();
        this.zzs();
        var5_4 = var2_2.zza;
        this.zzp();
        if (!zzmz.zza(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzh) {
            this.zza(var2_2);
            return;
        }
        if (this.zzi().zzd(var5_4, var1_1.zza)) {
            this.zzj().zzu().zza("Dropping blocked event. appId", zzfp.zza((String)var5_4), (Object)this.zzm.zzk().zza(var1_1.zza));
            var6_5 = this.zzi().zzm(var5_4) != false || this.zzi().zzo(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.zza)) {
                this.zzq();
                zzng.zza((zznf)this.zzah, (String)var5_4, (int)11, (String)"_ev", (String)var1_1.zza, (int)0);
            }
            if (var6_5 && (var7_7 = this.zzf().zzd(var5_4)) != null) {
                var8_9 = Math.max(var7_7.zzn(), var7_7.zze());
                v0 = Math.abs(this.zzb().currentTimeMillis() - var8_9);
                this.zze();
                if (v0 > (Long)zzbg.zzz.zza(null)) {
                    this.zzj().zzc().zza("Fetching config for blocked app");
                    this.zzb(var7_7);
                }
            }
            return;
        }
        var6_6 = zzft.zza((zzbe)var1_1);
        this.zzq().zza(var6_6, this.zze().zzb(var5_4));
        var7_8 = zzov.zza() != false && this.zze().zza(zzbg.zzcc) != false ? this.zze().zza(var5_4, zzbg.zzaq, 10, 35) : 0;
        for (String var10_12 : new TreeSet<E>(var6_6.zzb.keySet())) {
            if (!"items".equals(var10_12)) continue;
            this.zzq().zza(var6_6.zzb.getParcelableArray(var10_12), var7_8, zzov.zza() != false && this.zze().zza(zzbg.zzcc) != false);
        }
        var1_1 = var6_6.zza();
        if (this.zzj().zza(2)) {
            this.zzj().zzp().zza("Logging event", (Object)this.zzm.zzk().zza(var1_1));
        }
        if (zzop.zza()) {
            this.zze().zza(zzbg.zzbz);
        }
        this.zzf().zzp();
        try {
            block69: {
                block70: {
                    block72: {
                        block76: {
                            block75: {
                                block73: {
                                    block74: {
                                        this.zza(var2_2);
                                        var9_11 = "ecommerce_purchase".equals(var1_1.zza) != false || "purchase".equals(var1_1.zza) != false || "refund".equals(var1_1.zza) != false;
                                        if (!("_iap".equals(var1_1.zza) != false || var9_11 != false)) break block72;
                                        var28_13 = var9_11;
                                        var27_15 = var1_1;
                                        var26_18 = var5_4;
                                        var25_19 = this;
                                        var29_20 = var27_15.zzb.zzd("currency");
                                        if (!var28_13) break block73;
                                        var32_21 = var27_15.zzb.zza("value") * 1000000.0;
                                        if (var32_21 == 0.0) {
                                            var32_21 = (double)var27_15.zzb.zzb("value").longValue() * 1000000.0;
                                        }
                                        if (!(var32_21 <= 9.223372036854776E18) || !(var32_21 >= -9.223372036854776E18)) break block74;
                                        var30_25 = Math.round(var32_21);
                                        if ("refund".equals(var27_15.zza)) {
                                            var30_25 = -var30_25;
                                        }
                                        break block75;
                                    }
                                    var25_19.zzj().zzu().zza("Data lost. Currency value is too big. appId", zzfp.zza((String)var26_18), (Object)var32_21);
                                    v1 = false;
                                    break block76;
                                }
                                var30_25 = var27_15.zzb.zzb("value");
                            }
                            if (!TextUtils.isEmpty((CharSequence)var29_20) && (var29_20 = var29_20.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                                var36_27 = var29_20;
                                var32_22 = "_ltv_" + var36_27;
                                var33_29 = var25_19.zzf().zze(var26_18, var32_22);
                                if (var33_29 == null || !(var33_29.zze instanceof Long)) {
                                    var43_30 = var25_19.zze().zzb(var26_18, zzbg.zzae) - 1;
                                    var42_31 = var26_18;
                                    var41_32 = var25_19.zzf();
                                    Preconditions.checkNotEmpty((String)var42_31);
                                    var41_32.zzt();
                                    var41_32.zzak();
                                    try {
                                        var41_32.e_().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{var42_31, var42_31, String.valueOf(var43_30)});
                                    }
                                    catch (SQLiteException var44_33) {
                                        var41_32.zzj().zzg().zza("Error pruning currencies. appId", zzfp.zza((String)var42_31), (Object)var44_33);
                                    }
                                    var33_29 = new zznd(var26_18, var27_15.zzc, var32_22, var25_19.zzb().currentTimeMillis(), (Object)var30_25);
                                } else {
                                    var34_34 = (Long)var33_29.zze;
                                    var33_29 = new zznd(var26_18, var27_15.zzc, var32_22, var25_19.zzb().currentTimeMillis(), (Object)(var34_34 + var30_25));
                                }
                                if (!var25_19.zzf().zza((zznd)var33_29)) {
                                    var25_19.zzj().zzg().zza("Too many unique user properties are set. Ignoring user property. appId", zzfp.zza((String)var26_18), (Object)var25_19.zzm.zzk().zzc(var33_29.zzc), var33_29.zze);
                                    var25_19.zzq();
                                    zzng.zza((zznf)var25_19.zzah, (String)var26_18, (int)9, null, null, (int)0);
                                }
                            }
                            v1 = true;
                        }
                        if (!v1) {
                            this.zzf().zzw();
                            return;
                        }
                    }
                    var11_38 = zzng.zzh((String)var1_1.zza);
                    var12_39 = "_err".equals(var1_1.zza);
                    this.zzq();
                    var13_40 = 1L + zzng.zza((zzaz)var1_1.zzb);
                    var15_41 = this.zzf().zza(this.zzx(), var5_4, var13_40, true, var11_38, false, var12_39, false);
                    v2 = var15_41.zzb;
                    this.zze();
                    var16_42 = v2 - (long)((Integer)zzbg.zzk.zza(null)).intValue();
                    if (var16_42 > 0L) {
                        if (var16_42 % 1000L == 1L) {
                            this.zzj().zzg().zza("Data loss. Too many events logged. appId, count", zzfp.zza((String)var5_4), (Object)var15_41.zzb);
                        }
                        this.zzf().zzw();
                        return;
                    }
                    if (var11_38) {
                        v3 = var15_41.zza;
                        this.zze();
                        var16_42 = v3 - (long)((Integer)zzbg.zzm.zza(null)).intValue();
                        if (var16_42 > 0L) {
                            if (var16_42 % 1000L == 1L) {
                                this.zzj().zzg().zza("Data loss. Too many public events logged. appId, count", zzfp.zza((String)var5_4), (Object)var15_41.zza);
                            }
                            this.zzq();
                            zzng.zza((zznf)this.zzah, (String)var5_4, (int)16, (String)"_ev", (String)var1_1.zza, (int)0);
                            this.zzf().zzw();
                            return;
                        }
                    }
                    if (var12_39) {
                        var27_16 = this.zze().zzb(var2_2.zza, zzbg.zzl);
                        var16_42 = var15_41.zzd - (long)Math.max(0, var27_16 = Math.min(1000000, var27_16));
                        if (var16_42 > 0L) {
                            if (var16_42 == 1L) {
                                this.zzj().zzg().zza("Too many error events logged. appId, count", zzfp.zza((String)var5_4), (Object)var15_41.zzd);
                            }
                            this.zzf().zzw();
                            return;
                        }
                    }
                    var18_43 = var1_1.zzb.zzb();
                    this.zzq().zza(var18_43, "_o", (Object)var1_1.zzc);
                    if (this.zzq().zzf(var5_4)) {
                        this.zzq().zza(var18_43, "_dbg", (Object)1L);
                        this.zzq().zza(var18_43, "_r", (Object)1L);
                    }
                    if ("_s".equals(var1_1.zza) && (var19_44 = this.zzf().zze(var2_2.zza, "_sno")) != null && var19_44.zze instanceof Long) {
                        this.zzq().zza(var18_43, "_sno", var19_44.zze);
                    }
                    if ((var19_45 = this.zzf().zza(var5_4)) > 0L) {
                        this.zzj().zzu().zza("Data lost. Too many events stored on disk, deleted. appId", zzfp.zza((String)var5_4), (Object)var19_45);
                    }
                    var21_46 = new zzax(this.zzm, var1_1.zzc, var5_4, var1_1.zza, var1_1.zzd, 0L, var18_43);
                    var22_47 = this.zzf().zzd(var5_4, var21_46.zzb);
                    if (var22_47 == null) {
                        if (this.zzf().zzb(var5_4) >= (long)this.zze().zza(var5_4) && var11_38) {
                            this.zzj().zzg().zza("Too many event names used, ignoring event. appId, name, supported count", zzfp.zza((String)var5_4), (Object)this.zzm.zzk().zza(var21_46.zzb), (Object)this.zze().zza(var5_4));
                            this.zzq();
                            zzng.zza((zznf)this.zzah, (String)var5_4, (int)8, null, null, (int)0);
                            return;
                        }
                        var23_48 = new zzba(var5_4, var21_46.zzb, 0L, 0L, var21_46.zzc, 0L, null, null, null, null);
                    } else {
                        var21_46 = var21_46.zza(this.zzm, var22_47.zzf);
                        var23_48 = var22_47.zza(var21_46.zzc);
                    }
                    this.zzf().zza(var23_48);
                    var27_17 = var2_2;
                    var26_18 = var21_46;
                    var25_19 = this;
                    var25_19.zzl().zzt();
                    var25_19.zzs();
                    Preconditions.checkNotNull((Object)var26_18);
                    Preconditions.checkNotNull((Object)var27_17);
                    Preconditions.checkNotEmpty((String)var26_18.zza);
                    Preconditions.checkArgument((boolean)var26_18.zza.equals(var27_17.zza));
                    var28_14 = zzfi.zzj.zzu().zzg(1).zzp("android");
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zza)) {
                        var28_14.zzb(var27_17.zza);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzd)) {
                        var28_14.zzd(var27_17.zzd);
                    }
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzc)) {
                        var28_14.zze(var27_17.zzc);
                    }
                    if (zzpt.zza() && !TextUtils.isEmpty((CharSequence)var27_17.zzv) && (var25_19.zze().zza(zzbg.zzbp) || var25_19.zze().zze(var27_17.zza, zzbg.zzbr))) {
                        var28_14.zzr(var27_17.zzv);
                    }
                    if (var27_17.zzj != -2147483648L) {
                        var28_14.zze((int)var27_17.zzj);
                    }
                    var28_14.zzf(var27_17.zze);
                    if (!TextUtils.isEmpty((CharSequence)var27_17.zzb)) {
                        var28_14.zzm(var27_17.zzb);
                    }
                    var29_20 = var25_19.zzb((String)Preconditions.checkNotNull((Object)var27_17.zza)).zza(zzif.zza((String)var27_17.zzt));
                    var28_14.zzg(var29_20.zze());
                    if (var28_14.zzx().isEmpty() && !TextUtils.isEmpty((CharSequence)var27_17.zzp)) {
                        var28_14.zza(var27_17.zzp);
                    }
                    if (zzph.zza() && var25_19.zze().zze(var27_17.zza, zzbg.zzce)) {
                        var25_19.zzq();
                        if (zzng.zzd((String)var27_17.zza)) {
                            var28_14.zzd(var27_17.zzaa);
                            var30_25 = var27_17.zzab;
                            if (!var29_20.zzg() && var30_25 != 0L) {
                                var30_25 = var30_25 & -2L | 32L;
                            }
                            var28_14.zza(var30_25 == 1L);
                            if (var30_25 != 0L) {
                                var37_49 = var30_25;
                                var40_51 /* !! */  = zzfi.zzb.zza();
                                var40_51 /* !! */ .zzc((var37_49 & 1L) != 0L);
                                var40_51 /* !! */ .zze((var37_49 & 2L) != 0L);
                                var40_51 /* !! */ .zzf((var37_49 & 4L) != 0L);
                                var40_51 /* !! */ .zzg((var37_49 & 8L) != 0L);
                                var40_51 /* !! */ .zzb((var37_49 & 16L) != 0L);
                                var40_51 /* !! */ .zza((var37_49 & 32L) != 0L);
                                var40_51 /* !! */ .zzd((var37_49 & 64L) != 0L);
                                var28_14.zza((zzfi.zzb)((zzjf)var40_51 /* !! */ .zzah()));
                            }
                        }
                    }
                    if (var27_17.zzf != 0L) {
                        var28_14.zzc(var27_17.zzf);
                    }
                    var28_14.zzd(var27_17.zzr);
                    var30_26 = var25_19.zzp().zzu();
                    if (var30_26 != null) {
                        var28_14.zzc(var30_26);
                    }
                    if ((var31_52 = var25_19.zzb((String)Preconditions.checkNotNull((Object)var27_17.zza)).zza(zzif.zza((String)var27_17.zzt))).zzg() && var27_17.zzn && (var32_23 = var25_19.zzj.zza(var27_17.zza, var31_52)) != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var32_23.first)) && var27_17.zzn) {
                        var28_14.zzq((String)var32_23.first);
                        if (var32_23.second != null) {
                            var28_14.zzc((Boolean)var32_23.second);
                        }
                        if (zznm.zza() && var25_19.zze().zza(zzbg.zzcr) && !var26_18.zzb.equals("_fx") && !((String)var32_23.first).equals("00000000-0000-0000-0000-000000000000") && (var33_29 = var25_19.zzf().zzd(var27_17.zza)) != null && var33_29.zzao()) {
                            var25_19.zza(var27_17.zza, false);
                            var34_35 = new Bundle();
                            var34_35.putLong("_r", 1L);
                            var25_19.zzah.zza(var27_17.zza, "_fx", var34_35);
                        }
                    }
                    var25_19.zzm.zzg().zzac();
                    v4 = var28_14.zzi(Build.MODEL);
                    var25_19.zzm.zzg().zzac();
                    v4.zzo(Build.VERSION.RELEASE).zzi((int)var25_19.zzm.zzg().zzg()).zzs(var25_19.zzm.zzg().zzh());
                    var28_14.zzj(var27_17.zzx);
                    if (var25_19.zzm.zzac()) {
                        var28_14.zzt();
                        if (!TextUtils.isEmpty(null)) {
                            var28_14.zzj(null);
                        }
                    }
                    if ((var32_24 = var25_19.zzf().zzd(var27_17.zza)) == null) {
                        var32_24 = new zzg(var25_19.zzm, var27_17.zza);
                        var32_24.zzb(var25_19.zza(var31_52));
                        var32_24.zze(var27_17.zzk);
                        var32_24.zzf(var27_17.zzb);
                        if (var31_52.zzg()) {
                            var32_24.zzh(var25_19.zzj.zza(var27_17.zza, var27_17.zzn));
                        }
                        var32_24.zzo(0L);
                        var32_24.zzp(0L);
                        var32_24.zzn(0L);
                        var32_24.zzd(var27_17.zzc);
                        var32_24.zza(var27_17.zzj);
                        var32_24.zzc(var27_17.zzd);
                        var32_24.zzm(var27_17.zze);
                        var32_24.zzj(var27_17.zzf);
                        var32_24.zzb(var27_17.zzh);
                        var32_24.zzk(var27_17.zzr);
                        var25_19.zzf().zza(var32_24);
                    }
                    if (var31_52.zzh() && !TextUtils.isEmpty((CharSequence)var32_24.zzy())) {
                        var28_14.zzc((String)Preconditions.checkNotNull((Object)var32_24.zzy()));
                    }
                    if (!TextUtils.isEmpty((CharSequence)var32_24.zzab())) {
                        var28_14.zzl((String)Preconditions.checkNotNull((Object)var32_24.zzab()));
                    }
                    var33_29 = var25_19.zzf().zzi(var27_17.zza);
                    for (var34_36 = 0; var34_36 < var33_29.size(); ++var34_36) {
                        var35_53 = zzfi.zzn.zze().zza(((zznd)var33_29.get((int)var34_36)).zzc).zzb(((zznd)var33_29.get((int)var34_36)).zzd);
                        var25_19.zzp().zza(var35_53, ((zznd)var33_29.get((int)var34_36)).zze);
                        var28_14.zza(var35_53);
                        if (!"_sid".equals(((zznd)var33_29.get((int)var34_36)).zzc) || var32_24.zzs() == 0L || var25_19.zzp().zza(var27_17.zzv) == var32_24.zzs()) continue;
                        var28_14.zzr();
                    }
                    try {
                        var34_37 = var25_19.zzf().zza((zzfi.zzj)((zzjf)var28_14.zzah()));
                    }
                    catch (IOException var36_28) {
                        var25_19.zzj().zzg().zza("Data loss. Failed to insert raw event metadata. appId", zzfp.zza((String)var28_14.zzt()), (Object)var36_28);
                        break block69;
                    }
                    v5 = var25_19.zzf();
                    var38_54 = var26_18;
                    var37_50 = var25_19;
                    if (var38_54.zze == null) ** GOTO lbl-1000
                    for (zzfi.zzb.zza var40_51 : var38_54.zze) {
                        if (!"_r".equals((Object)var40_51 /* !! */ )) continue;
                        v6 = true;
                        break block70;
                    }
                    var39_56 = var37_50.zzi().zzc(var38_54.zza, var38_54.zzb);
                    var40_51 /* !! */  = var37_50.zzf().zza(var37_50.zzx(), var38_54.zza, false, false, false, false, false);
                    if (var39_56 && var40_51 /* !! */ .zze < (long)var37_50.zze().zzc(var38_54.zza)) {
                        v6 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = false;
                    }
                }
                if (v5.zza((zzax)var26_18, var34_37, v6)) {
                    var25_19.zzp = 0L;
                }
            }
            this.zzf().zzw();
        }
        finally {
            this.zzf().zzu();
        }
        this.zzab();
        this.zzj().zzp().zza("Background event processing time, ms", (Object)((System.nanoTime() - var3_3 + 500000L) / 1000000L));
    }

    private static boolean zze(zzo zzo2) {
        return !TextUtils.isEmpty((CharSequence)zzo2.zzb) || !TextUtils.isEmpty((CharSequence)zzo2.zzp);
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private final boolean zza(@Nullable String string, long l) {
        this.zzf().zzp();
        try {
            block160: {
                zzfi.zzg zzg2;
                boolean bl;
                int n;
                String[] stringArray;
                String string222;
                String string3;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                zza zza2;
                block158: {
                    zza2 = new zza(null);
                    object6 = zza2;
                    long l2 = this.zzab;
                    long l3 = l;
                    object5 = null;
                    object4 = this.zzf();
                    Preconditions.checkNotNull((Object)object6);
                    object4.zzt();
                    ((zzmo)((Object)object4)).zzak();
                    try (Cursor cursor = null;){
                        String string2;
                        zzfi.zzj object8;
                        object3 = ((zzal)((Object)object4)).e_();
                        if (TextUtils.isEmpty(null)) {
                            object2 = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            string3 = l2 != -1L ? "rowid <= ? and " : "";
                            cursor = object3.rawQuery("select app_id, metadata_fingerprint from raw_events where " + string3 + "app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;", (String[])object2);
                            if (!cursor.moveToFirst()) break block158;
                            object5 = cursor.getString(0);
                            string222 = cursor.getString(1);
                            cursor.close();
                        } else {
                            object2 = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            string3 = l2 != -1L ? " and rowid <= ?" : "";
                            cursor = object3.rawQuery("select metadata_fingerprint from raw_events where app_id = ?" + string3 + " order by rowid limit 1;", (String[])object2);
                            if (!cursor.moveToFirst()) break block158;
                            string222 = cursor.getString(0);
                            cursor.close();
                        }
                        cursor = object3.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{object5, string222}, null, null, "rowid", "2");
                        if (!cursor.moveToFirst()) {
                            object4.zzj().zzg().zza("Raw event metadata record is missing. appId", zzfp.zza((String)object5));
                            break block158;
                        }
                        object2 = cursor.getBlob(0);
                        try {
                            object8 = (zzfi.zzj)((zzjf)zzmz.zza(zzfi.zzj.zzu(), (byte[])object2).zzah());
                        }
                        catch (IOException iOException) {
                            object4.zzj().zzg().zza("Data loss. Failed to merge raw event metadata. appId", zzfp.zza((String)object5), (Object)iOException);
                            if (cursor != null) {
                                cursor.close();
                            }
                            break block158;
                        }
                        if (cursor.moveToNext()) {
                            object4.zzj().zzu().zza("Get multiple raw event metadata records, expected one. appId", zzfp.zza((String)object5));
                        }
                        cursor.close();
                        object6.zza(object8);
                        if (l2 != -1L) {
                            string2 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            stringArray = new String[]{object5, string222, String.valueOf(l2)};
                        } else {
                            string2 = "app_id = ? and metadata_fingerprint = ?";
                            stringArray = new String[]{object5, string222};
                        }
                        cursor = object3.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string2, stringArray, null, null, "rowid", null);
                        if (!cursor.moveToFirst()) {
                            object4.zzj().zzu().zza("Raw event data disappeared while in transaction. appId", zzfp.zza((String)object5));
                            break block158;
                        }
                        do {
                            zzfi.zze.zza zza3;
                            long l4 = cursor.getLong(0);
                            object2 = cursor.getBlob(3);
                            try {
                                zza3 = zzmz.zza(zzfi.zze.zze(), (byte[])object2);
                            }
                            catch (IOException iOException) {
                                object4.zzj().zzg().zza("Data loss. Failed to merge raw event. appId", zzfp.zza((String)object5), (Object)iOException);
                                continue;
                            }
                            zza3.zza(cursor.getString(1)).zzb(cursor.getLong(2));
                            if (!object6.zza(l4, (zzfi.zze)((zzjf)zza3.zzah()))) break;
                        } while (cursor.moveToNext());
                    }
                }
                object4 = zza2;
                if (((zza)object4).zzc == null || ((zza)object4).zzc.isEmpty()) break block160;
                boolean bl2 = false;
                zzfi.zzj.zza zza4 = ((zzfi.zzj.zza)zza2.zza.zzby()).zzk();
                int n2 = 0;
                long l5 = 0L;
                zzfi.zze.zza zza5 = null;
                int n3 = -1;
                zzfi.zze.zza zza6 = null;
                int n4 = -1;
                for (n = 0; n < zza2.zzc.size(); ++n) {
                    int n5;
                    int n6;
                    zzfi.zze.zza string6;
                    block162: {
                        boolean bl3;
                        block161: {
                            boolean bl4;
                            bl3 = bl2;
                            string6 = (zzfi.zze.zza)zza2.zzc.get(n).zzby();
                            if (this.zzi().zzd(zza2.zza.zzx(), string6.zze())) {
                                this.zzj().zzu().zza("Dropping blocked raw event. appId", zzfp.zza((String)zza2.zza.zzx()), (Object)this.zzm.zzk().zza(string6.zze()));
                                if (this.zzi().zzm(zza2.zza.zzx()) || this.zzi().zzo(zza2.zza.zzx()) || "_err".equals(string6.zze())) continue;
                                this.zzq();
                                zzng.zza((zznf)this.zzah, (String)zza2.zza.zzx(), (int)11, (String)"_ev", (String)string6.zze(), (int)0);
                                continue;
                            }
                            if (string6.zze().equals(zzig.zza((String)"_ai"))) {
                                string6.zza("_ai");
                                this.zzj().zzp().zza("Renaming ad_impression to _ai");
                                if (this.zzj().zza(5)) {
                                    for (n6 = 0; n6 < string6.zza(); ++n6) {
                                        if (!"ad_platform".equals(string6.zzb(n6).zzg()) || string6.zzb(n6).zzh().isEmpty() || !"admob".equalsIgnoreCase(string6.zzb(n6).zzh())) continue;
                                        this.zzj().zzv().zza("AdMob ad impression logged from app. Potentially duplicative.");
                                    }
                                }
                            }
                            if ((n6 = this.zzi().zzc(zza2.zza.zzx(), string6.zze())) != 0) break block161;
                            this.zzp();
                            object4 = string6.zze();
                            Preconditions.checkNotEmpty((String)object4);
                            switch (object4) {
                                case "_ui": {
                                    bl4 = true;
                                    break;
                                }
                                default: {
                                    bl4 = false;
                                }
                            }
                            if (!bl4) break block162;
                        }
                        bl = false;
                        n5 = 0;
                        for (int i = 0; i < string6.zza(); ++i) {
                            if ("_c".equals(string6.zzb(i).zzg())) {
                                zzg2 = (zzfi.zzg)((zzjf)((zzfi.zzg.zza)string6.zzb(i).zzby()).zza(1L).zzah());
                                bl = true;
                                string6.zza(i, zzg2);
                                continue;
                            }
                            if (!"_r".equals(string6.zzb(i).zzg())) continue;
                            zzg2 = (zzfi.zzg)((zzjf)((zzfi.zzg.zza)string6.zzb(i).zzby()).zza(1L).zzah());
                            n5 = 1;
                            string6.zza(i, zzg2);
                        }
                        if (!bl && n6 != 0) {
                            this.zzj().zzp().zza("Marking event as conversion", (Object)this.zzm.zzk().zza(string6.zze()));
                            string6.zza(zzfi.zzg.zze().zza("_c").zza(1L));
                        }
                        if (n5 == 0) {
                            this.zzj().zzp().zza("Marking event as real-time", (Object)this.zzm.zzk().zza(string6.zze()));
                            string6.zza(zzfi.zzg.zze().zza("_r").zza(1L));
                        }
                        bl2 = true;
                        if (this.zzf().zza((long)this.zzx(), (String)zza2.zza.zzx(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zze > (long)this.zze().zzc(zza2.zza.zzx())) {
                            zzmp.zza(string6, "_r");
                            bl2 = bl3;
                        }
                        if (zzng.zzh((String)string6.zze()) && n6 != 0 && this.zzf().zza((long)this.zzx(), (String)zza2.zza.zzx(), (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zzc > (long)this.zze().zzb(zza2.zza.zzx(), zzbg.zzn)) {
                            this.zzj().zzu().zza("Too many conversions. Not logging as conversion. appId", zzfp.zza((String)zza2.zza.zzx()));
                            boolean bl5 = false;
                            zzfi.zzg.zza zza7 = null;
                            int n7 = -1;
                            for (int i = 0; i < string6.zza(); ++i) {
                                zzfi.zzg zzg3 = string6.zzb(i);
                                if ("_c".equals(zzg3.zzg())) {
                                    zza7 = (zzfi.zzg.zza)zzg3.zzby();
                                    n7 = i;
                                    continue;
                                }
                                if (!"_err".equals(zzg3.zzg())) continue;
                                bl5 = true;
                            }
                            if (bl5 && zza7 != null) {
                                string6.zza(n7);
                            } else if (zza7 != null) {
                                zzfi.zzg zzg4 = (zzfi.zzg)((zzjf)((zzfi.zzg.zza)((zzjf.zzb)zza7.clone())).zza("_err").zza(10L).zzah());
                                string6.zza(n7, zzg4);
                            } else {
                                this.zzj().zzg().zza("Did not find conversion parameter. appId", zzfp.zza((String)zza2.zza.zzx()));
                            }
                        }
                    }
                    if (n6 != 0) {
                        int n8;
                        object5 = string6;
                        object4 = this;
                        Object object7 = new ArrayList<zzfi.zzg>(((zzfi.zze.zza)((Object)object5)).zzf());
                        int n9 = -1;
                        int n10 = -1;
                        for (n8 = 0; n8 < object7.size(); ++n8) {
                            if ("value".equals(((zzfi.zzg)((Object)object7.get(n8))).zzg())) {
                                n9 = n8;
                                continue;
                            }
                            if (!"currency".equals(((zzfi.zzg)((Object)object7.get(n8))).zzg())) continue;
                            n10 = n8;
                        }
                        if (n9 != -1) {
                            if (!((zzfi.zzg)((Object)object7.get(n9))).zzl() && !((zzfi.zzg)((Object)object7.get(n9))).zzj()) {
                                ((zzmp)object4).zzj().zzv().zza("Value must be specified with a numeric type.");
                                ((zzfi.zze.zza)((Object)object5)).zza(n9);
                                zzmp.zza((zzfi.zze.zza)((Object)object5), "_c");
                                zzmp.zza((zzfi.zze.zza)((Object)object5), 18, "value");
                            } else {
                                n8 = 0;
                                if (n10 == -1) {
                                    n8 = 1;
                                } else {
                                    object6 = ((zzfi.zzg)((Object)object7.get(n10))).zzh();
                                    if (object6.length() != 3) {
                                        n8 = 1;
                                    } else {
                                        int n11;
                                        for (int i = 0; i < object6.length(); i += Character.charCount(n11)) {
                                            n11 = object6.codePointAt(i);
                                            if (Character.isLetter(n11)) continue;
                                            n8 = 1;
                                            break;
                                        }
                                    }
                                }
                                if (n8 != 0) {
                                    ((zzmp)object4).zzj().zzv().zza("Value parameter discarded. You must also supply a 3-letter ISO_4217 currency code in the currency parameter.");
                                    ((zzfi.zze.zza)((Object)object5)).zza(n9);
                                    zzmp.zza((zzfi.zze.zza)((Object)object5), "_c");
                                    zzmp.zza((zzfi.zze.zza)((Object)object5), 19, "currency");
                                }
                            }
                        }
                    }
                    if ("_e".equals(string6.zze())) {
                        this.zzp();
                        if (zzmz.zza((zzfi.zze)((zzjf)string6.zzah()), "_fr") == null) {
                            if (zza6 != null && Math.abs(zza6.zzc() - string6.zzc()) <= 1000L) {
                                zzfi.zze.zza zza8 = (zzfi.zze.zza)((zzjf.zzb)zza6.clone());
                                if (this.zza(string6, zza8)) {
                                    zza5 = null;
                                    zza6 = null;
                                    zza4.zza(n4, zza8);
                                } else {
                                    zza5 = string6;
                                    n3 = n2;
                                }
                            } else {
                                zza5 = string6;
                                n3 = n2;
                            }
                        }
                    } else if ("_vs".equals(string6.zze())) {
                        this.zzp();
                        if (zzmz.zza((zzfi.zze)((zzjf)string6.zzah()), "_et") == null) {
                            if (zza5 != null && Math.abs(zza5.zzc() - string6.zzc()) <= 1000L) {
                                zzfi.zze.zza zza9 = (zzfi.zze.zza)((zzjf.zzb)zza5.clone());
                                if (this.zza(zza9, string6)) {
                                    zza5 = null;
                                    zza6 = null;
                                    zza4.zza(n3, zza9);
                                } else {
                                    zza6 = string6;
                                    n4 = n2;
                                }
                            } else {
                                zza6 = string6;
                                n4 = n2;
                            }
                        }
                    }
                    if (zzoq.zza() && this.zze().zza(zzbg.zzcu) && string6.zza() != 0) {
                        zzfi.zze.zza zzkt4;
                        this.zzp();
                        Bundle bundle = zzmz.zza(string6.zzf());
                        for (n5 = 0; n5 < string6.zza(); ++n5) {
                            zzfi.zzg zzg5 = string6.zzb(n5);
                            if (zzg5.zzg().equals("items") && !zzg5.zzi().isEmpty()) {
                                Bundle bundle2 = bundle;
                                String string4 = zza2.zza.zzx();
                                zzkt4 = string6;
                                object5 = zzg5;
                                object4 = this;
                                List<zzfi.zzg> list = ((zzfi.zzg)((Object)object5)).zzi();
                                object6 = new Bundle[list.size()];
                                for (int i = 0; i < list.size(); ++i) {
                                    zzfi.zzg zzg6 = list.get(i);
                                    ((zzmp)object4).zzp();
                                    string222 = zzmz.zza(zzg6.zzi());
                                    for (zzfi.zzg zzg7 : zzg6.zzi()) {
                                        super.zza(zzkt4.zze(), (zzfi.zzg.zza)zzg7.zzby(), (Bundle)string222, string4);
                                    }
                                    object6[i] = string222;
                                }
                                bundle2.putParcelableArray("items", (Parcelable[])object6);
                                continue;
                            }
                            if (zzg5.zzg().equals("items")) continue;
                            this.zza(string6.zze(), (zzfi.zzg.zza)zzg5.zzby(), bundle, zza2.zza.zzx());
                        }
                        zzkt4 = string6;
                        object5 = bundle;
                        object4 = this;
                        zzkt4.zzd();
                        object6 = object5;
                        zzmz zzmz2 = ((zzmp)object4).zzp();
                        ArrayList<zzfi.zzg> arrayList = new ArrayList<zzfi.zzg>();
                        for (String string222 : object6.keySet()) {
                            object2 = zzfi.zzg.zze().zza(string222);
                            Object object = object6.get(string222);
                            if (object == null) continue;
                            zzmz2.zza((zzfi.zzg.zza)((Object)object2), object);
                            arrayList.add((zzfi.zzg)((zzjf)object2.zzah()));
                        }
                        ArrayList<zzfi.zzg> arrayList2 = arrayList;
                        int n10 = arrayList2.size();
                        for (int i = 0; i < n10; ++i) {
                            Object e = arrayList2.get(i);
                            zzfi.zzg zzg7 = (zzfi.zzg)((Object)e);
                            zzkt4.zza(zzg7);
                        }
                    }
                    zza2.zzc.set(n, (zzfi.zze)((zzjf)string6.zzah()));
                    ++n2;
                    zza4.zza(string6);
                }
                for (n = 0; n < n2; ++n) {
                    Long l6;
                    zzfi.zze zze2 = zza4.zza(n);
                    if ("_e".equals(zze2.zzg())) {
                        this.zzp();
                        if (zzmz.zza(zze2, "_fr") != null) {
                            zza4.zzb(n);
                            --n2;
                            --n;
                            continue;
                        }
                    }
                    this.zzp();
                    zzfi.zzg zzg8 = zzmz.zza(zze2, "_et");
                    if (zzg8 == null || (l6 = zzg8.zzl() ? Long.valueOf(zzg8.zzd()) : null) == null || l6 <= 0L) continue;
                    l5 += l6.longValue();
                }
                this.zza(zza4, l5, false);
                n = 0;
                for (zzfi.zze zze3 : zza4.zzaa()) {
                    if (!"_s".equals(zze3.zzg())) continue;
                    n = 1;
                    break;
                }
                if (n != 0) {
                    this.zzf().zzh(zza4.zzt(), "_se");
                }
                if (zzmz.zza(zza4, "_sid") >= 0) {
                    this.zza(zza4, l5, true);
                } else {
                    int n11 = zzmz.zza(zza4, "_se");
                    if (n11 >= 0) {
                        zza4.zzc(n11);
                        this.zzj().zzg().zza("Session engagement user property is in the bundle without session ID. appId", zzfp.zza((String)zza2.zza.zzx()));
                    }
                }
                this.zzp().zza(zza4);
                if (zzns.zza() && this.zze().zza(zzbg.zzcm)) {
                    zzfi.zzj.zza zza9 = zza4;
                    object5 = zza2.zza.zzx();
                    object4 = this;
                    ((zzmp)object4).zzl().zzt();
                    ((zzmp)object4).zzs();
                    if (zzns.zza()) {
                        zzg zzg9 = ((zzmp)object4).zzf().zzd((String)object5);
                        if (zzg9 == null) {
                            ((zzmp)object4).zzj().zzg().zza("Cannot fix consent fields without appInfo. appId", zzfp.zza((String)object5));
                        } else {
                            ((zzmp)object4).zza(zzg9, zza9);
                        }
                    }
                }
                object4 = zza4;
                ((zzfi.zzj.zza)((Object)object4)).zzi(Long.MAX_VALUE).zze(Long.MIN_VALUE);
                for (int i = 0; i < ((zzfi.zzj.zza)((Object)object4)).zzc(); ++i) {
                    zzfi.zze zze4 = ((zzfi.zzj.zza)((Object)object4)).zza(i);
                    if (zze4.zzd() < ((zzfi.zzj.zza)((Object)object4)).zzf()) {
                        ((zzfi.zzj.zza)((Object)object4)).zzi(zze4.zzd());
                    }
                    if (zze4.zzd() <= ((zzfi.zzj.zza)((Object)object4)).zze()) continue;
                    ((zzfi.zzj.zza)((Object)object4)).zze(zze4.zzd());
                }
                zza4.zzs();
                if (zzph.zza() && this.zze().zze(zza2.zza.zzx(), zzbg.zzce)) {
                    this.zzq();
                    if (zzng.zzd((String)zza2.zza.zzx()) && this.zzb(zza2.zza.zzx()).zzg() && zza2.zza.zzar()) {
                        void var16_71;
                        boolean bl6 = false;
                        while (var16_71 < zza2.zzc.size()) {
                            zzfi.zze.zza zza10 = (zzfi.zze.zza)zza2.zzc.get((int)var16_71).zzby();
                            bl = false;
                            for (zzfi.zzg zzg10 : zza10.zzf()) {
                                if (!"_c".equals(zzg10.zzg())) continue;
                                bl = true;
                                break;
                            }
                            if (bl) {
                                if (zza2.zza.zza() >= this.zze().zzb(zza2.zza.zzx(), zzbg.zzav)) {
                                    zzfi.zzg zzg10;
                                    Object object = null;
                                    if (this.zze().zze(zza2.zza.zzx(), zzbg.zzcg)) {
                                        object = this.zzq().zzp();
                                        zzg10 = (zzfi.zzg)((zzjf)zzfi.zzg.zze().zza("_tu").zzb((String)object).zzah());
                                        zza10.zza(zzg10);
                                    }
                                    zzg10 = (zzfi.zzg)((zzjf)zzfi.zzg.zze().zza("_tr").zza(1L).zzah());
                                    zza10.zza(zzg10);
                                    zzg2 = this.zze().zze(zza2.zza.zzx(), zzbg.zzci) ? this.zzp().zza(zza2.zza.zzx(), zza4, zza10, (String)object) : this.zzp().zza(zza2.zza.zzx(), zza2.zza, zza10, (String)object);
                                    if (zzg2 != null) {
                                        this.zzj().zzp().zza("Generated trigger URI. appId, uri", (Object)zza2.zza.zzx(), (Object)((zzmh)zzg2).zza);
                                        this.zzf().zza(zza2.zza.zzx(), (zzmh)zzg2);
                                        this.zzr.add(zza2.zza.zzx());
                                    }
                                }
                                zza4.zza((int)var16_71, (zzfi.zze)((zzjf)zza10.zzah()));
                            }
                            ++var16_71;
                        }
                    }
                }
                zza4.zzh().zza(this.zzc().zza(zza4.zzt(), zza4.zzaa(), zza4.zzab(), zza4.zzf(), zza4.zze()));
                if (this.zze().zzj(zza2.zza.zzx())) {
                    zza zza11 = zza2;
                    object5 = zza4;
                    object4 = this;
                    HashMap<Object, String> hashMap = new HashMap<Object, String>();
                    ArrayList<zzfi.zze> arrayList = new ArrayList<zzfi.zze>();
                    SecureRandom secureRandom = ((zzmp)object4).zzq().zzv();
                    for (int i = 0; i < ((zzfi.zzj.zza)((Object)object5)).zzc(); ++i) {
                        boolean bl7;
                        int n12;
                        long l7;
                        long l8;
                        zzfi.zze.zza zza12;
                        block159: {
                            zza12 = (zzfi.zze.zza)((zzfi.zzj.zza)((Object)object5)).zza(i).zzby();
                            if (zza12.zze().equals("_ep")) {
                                ((zzmp)object4).zzp();
                                object3 = (String)zzmz.zzb((zzfi.zze)((zzjf)zza12.zzah()), "_en");
                                string222 = (zzba)hashMap.get(object3);
                                if (string222 == null && (string222 = ((zzmp)object4).zzf().zzd(zza11.zza.zzx(), (String)Preconditions.checkNotNull((Object)object3))) != null) {
                                    hashMap.put(object3, string222);
                                }
                                if (string222 != null && ((zzba)string222).zzi == null) {
                                    if (((zzba)string222).zzj != null && ((zzba)string222).zzj > 1L) {
                                        ((zzmp)object4).zzp();
                                        zzmz.zza(zza12, "_sr", ((zzba)string222).zzj);
                                    }
                                    if (((zzba)string222).zzk != null && ((zzba)string222).zzk.booleanValue()) {
                                        ((zzmp)object4).zzp();
                                        zzmz.zza(zza12, "_efs", 1L);
                                    }
                                    arrayList.add((zzfi.zze)((zzjf)zza12.zzah()));
                                }
                                ((zzfi.zzj.zza)((Object)object5)).zza(i, zza12);
                                continue;
                            }
                            l8 = ((zzmp)object4).zzi().zza(zza11.zza.zzx());
                            ((zzmp)object4).zzq();
                            l7 = zzng.zza((long)zza12.zzc(), (long)l8);
                            n12 = 1;
                            Long l9 = 1L;
                            string3 = "_dbg";
                            zzfi.zze zze5 = (zzfi.zze)((zzjf)zza12.zzah());
                            if (TextUtils.isEmpty((CharSequence)string3) || l9 == null) {
                                bl7 = false;
                            } else {
                                for (zzfi.zzg zzg11 : zze5.zzh()) {
                                    if (!string3.equals(zzg11.zzg())) continue;
                                    bl7 = l9 instanceof Long && ((Object)l9).equals(zzg11.zzd()) || l9 instanceof String && ((Object)l9).equals(zzg11.zzh()) || l9 instanceof Double && ((Object)l9).equals(zzg11.zza());
                                    break block159;
                                }
                                bl7 = false;
                            }
                        }
                        if (!bl7) {
                            n12 = ((zzmp)object4).zzi().zzb(zza11.zza.zzx(), zza12.zze());
                        }
                        if (n12 <= 0) {
                            ((zzmp)object4).zzj().zzu().zza("Sample rate must be positive. event, rate", (Object)zza12.zze(), (Object)n12);
                            arrayList.add((zzfi.zze)((zzjf)zza12.zzah()));
                            ((zzfi.zzj.zza)((Object)object5)).zza(i, zza12);
                            continue;
                        }
                        stringArray = (String[])hashMap.get(zza12.zze());
                        if (stringArray == null && (stringArray = ((zzmp)object4).zzf().zzd(zza11.zza.zzx(), zza12.zze())) == null) {
                            ((zzmp)object4).zzj().zzu().zza("Event being bundled has no eventAggregate. appId, eventName", (Object)zza11.zza.zzx(), (Object)zza12.zze());
                            stringArray = new zzba(zza11.zza.zzx(), zza12.zze(), 1L, 1L, 1L, zza12.zzc(), 0L, null, null, null, null);
                        }
                        ((zzmp)object4).zzp();
                        Long l10 = (Long)zzmz.zzb((zzfi.zze)((zzjf)zza12.zzah()), "_eid");
                        Boolean bl8 = l10 != null;
                        if (n12 == 1) {
                            arrayList.add((zzfi.zze)((zzjf)zza12.zzah()));
                            if (bl8.booleanValue() && (stringArray.zzi != null || stringArray.zzj != null || stringArray.zzk != null)) {
                                stringArray = stringArray.zza(null, null, null);
                                hashMap.put(zza12.zze(), (String)stringArray);
                            }
                            ((zzfi.zzj.zza)((Object)object5)).zza(i, zza12);
                            continue;
                        }
                        if (secureRandom.nextInt(n12) == 0) {
                            ((zzmp)object4).zzp();
                            zzmz.zza(zza12, "_sr", n12);
                            arrayList.add((zzfi.zze)((zzjf)zza12.zzah()));
                            if (bl8.booleanValue()) {
                                stringArray = stringArray.zza(null, Long.valueOf(n12), null);
                            }
                            hashMap.put(zza12.zze(), (String)stringArray.zza(zza12.zzc(), l7));
                        } else {
                            long l11;
                            if (stringArray.zzh != null) {
                                l11 = stringArray.zzh;
                            } else {
                                ((zzmp)object4).zzq();
                                l11 = zzng.zza((long)zza12.zzb(), (long)l8);
                            }
                            if (l11 != l7) {
                                ((zzmp)object4).zzp();
                                zzmz.zza(zza12, "_efs", 1L);
                                ((zzmp)object4).zzp();
                                zzmz.zza(zza12, "_sr", n12);
                                arrayList.add((zzfi.zze)((zzjf)zza12.zzah()));
                                if (bl8.booleanValue()) {
                                    stringArray = stringArray.zza(null, Long.valueOf(n12), Boolean.valueOf(true));
                                }
                                hashMap.put(zza12.zze(), (String)stringArray.zza(zza12.zzc(), l7));
                            } else if (bl8.booleanValue()) {
                                hashMap.put(zza12.zze(), (String)stringArray.zza(l10, null, null));
                            }
                        }
                        ((zzfi.zzj.zza)((Object)object5)).zza(i, zza12);
                    }
                    if (arrayList.size() < ((zzfi.zzj.zza)((Object)object5)).zzc()) {
                        ((zzfi.zzj.zza)((Object)object5)).zzk().zzb(arrayList);
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        ((zzmp)object4).zzf().zza((zzba)entry.getValue());
                    }
                }
                String string5 = zza2.zza.zzx();
                zzg zzg12 = this.zzf().zzd(string5);
                if (zzg12 == null) {
                    this.zzj().zzg().zza("Bundling raw events w/o app info. appId", zzfp.zza((String)zza2.zza.zzx()));
                } else if (zza4.zzc() > 0) {
                    long l12 = zzg12.zzp();
                    if (l12 != 0L) {
                        zza4.zzg(l12);
                    } else {
                        zza4.zzo();
                    }
                    long l13 = zzg12.zzr();
                    if (l13 == 0L) {
                        l13 = l12;
                    }
                    if (l13 != 0L) {
                        zza4.zzh(l13);
                    } else {
                        zza4.zzp();
                    }
                    zzg12.zzaj();
                    zza4.zzf((int)zzg12.zzq());
                    zzg12.zzp(zza4.zzf());
                    zzg12.zzn(zza4.zze());
                    String string6 = zzg12.zzw();
                    if (string6 != null) {
                        zza4.zzn(string6);
                    } else {
                        zza4.zzl();
                    }
                    this.zzf().zza(zzg12);
                }
                if (zza4.zzc() > 0) {
                    zzfc.zzd zzd2 = this.zzi().zzc(zza2.zza.zzx());
                    if (zzd2 == null || !zzd2.zzs()) {
                        if (zza2.zza.zzah().isEmpty()) {
                            zza4.zzb(-1L);
                        } else {
                            this.zzj().zzu().zza("Did not find measurement config or missing version info. appId", zzfp.zza((String)zza2.zza.zzx()));
                        }
                    } else {
                        zza4.zzb(zzd2.zzc());
                    }
                    this.zzf().zza((zzfi.zzj)((zzjf)zza4.zzah()), bl2);
                }
                object5 = zza2.zzb;
                object4 = this.zzf();
                Preconditions.checkNotNull((Object)object5);
                object4.zzt();
                ((zzmo)((Object)object4)).zzak();
                StringBuilder stringBuilder = new StringBuilder("rowid in (");
                for (int i = 0; i < object5.size(); ++i) {
                    if (i != 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append((Long)object5.get(i));
                }
                stringBuilder.append(")");
                int n15 = ((zzal)((Object)object4)).e_().delete("raw_events", stringBuilder.toString(), null);
                if (n15 != object5.size()) {
                    object4.zzj().zzg().zza("Deleted fewer rows from raw events table than expected", (Object)n15, (Object)object5.size());
                }
                object5 = string5;
                object4 = this.zzf();
                stringBuilder = ((zzal)((Object)object4)).e_();
                try {
                    stringBuilder.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", new String[]{object5, object5});
                }
                catch (SQLiteException sQLiteException) {
                    object4.zzj().zzg().zza("Failed to remove unused event metadata. appId", zzfp.zza((String)object5), (Object)sQLiteException);
                }
                this.zzf().zzw();
                return true;
            }
            this.zzf().zzw();
            return false;
        }
        finally {
            this.zzf().zzu();
        }
    }

    private final boolean zzac() {
        this.zzl().zzt();
        this.zzs();
        return this.zzf().zzx() || !TextUtils.isEmpty((CharSequence)this.zzf().f_());
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zzad() {
        this.zzl().zzt();
        if (this.zzx != null && this.zzx.isValid()) {
            this.zzj().zzp().zza("Storage concurrent access okay");
            return true;
        }
        String string = "google_app_measurement.db";
        File file = this.zzm.zza().getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzy = new RandomAccessFile(file2, "rw").getChannel();
            this.zzx = this.zzy.tryLock();
            if (this.zzx != null) {
                this.zzj().zzp().zza("Storage concurrent access okay");
                return true;
            }
            this.zzj().zzg().zza("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzj().zzg().zza("Failed to acquire storage lock", (Object)fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to access storage lock file", (Object)iOException);
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            this.zzj().zzu().zza("Storage lock already acquired", (Object)overlappingFileLockException);
        }
        return false;
    }

    private final boolean zza(zzfi.zze.zza zza2, zzfi.zze.zza zza3) {
        Preconditions.checkArgument((boolean)"_e".equals(zza2.zze()));
        this.zzp();
        zzfi.zzg zzg2 = zzmz.zza((zzfi.zze)((zzjf)zza2.zzah()), "_sc");
        String string = zzg2 == null ? null : zzg2.zzh();
        this.zzp();
        zzfi.zzg zzg3 = zzmz.zza((zzfi.zze)((zzjf)zza3.zzah()), "_pc");
        String string2 = zzg3 == null ? null : zzg3.zzh();
        if (string2 != null && string2.equals(string)) {
            zzfi.zze.zza zza4 = zza3;
            zzfi.zze.zza zza5 = zza2;
            zzmp zzmp2 = this;
            Preconditions.checkArgument((boolean)"_e".equals(zza5.zze()));
            zzmp2.zzp();
            zzfi.zzg zzg4 = zzmz.zza((zzfi.zze)((zzjf)zza5.zzah()), "_et");
            if (zzg4 != null && zzg4.zzl() && zzg4.zzd() > 0L) {
                long l = zzg4.zzd();
                zzmp2.zzp();
                zzg4 = zzmz.zza((zzfi.zze)((zzjf)zza4.zzah()), "_et");
                if (zzg4 != null && zzg4.zzd() > 0L) {
                    l += zzg4.zzd();
                }
                zzmp2.zzp();
                zzmz.zza(zza4, "_et", l);
                zzmp2.zzp();
                zzmz.zza(zza5, "_fr", 1L);
            }
            return true;
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zza(int n, @Nullable FileChannel fileChannel) {
        this.zzl().zzt();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzj().zzg().zza("Bad channel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzj().zzg().zza("Error writing to channel. Bytes written", (Object)fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzj().zzg().zza("Failed to write to channel", (Object)iOException);
            return false;
        }
    }

    private final class zzb {
        final String zza;
        long zzb;

        private zzb(zzmp zzmp2) {
            this(zzmp2, zzmp2.zzq().zzp());
        }

        /* synthetic */ zzb(zzmp zzmp2, zzmy zzmy2) {
            this(zzmp2);
        }

        private zzb(zzmp zzmp2, String string) {
            this.zza = string;
            this.zzb = zzmp2.zzb().elapsedRealtime();
        }

        /* synthetic */ zzb(zzmp zzmp2, String string, zzmy zzmy2) {
            this(zzmp2, string);
        }
    }

    private final class zza
    implements zzap {
        zzfi.zzj zza;
        List<Long> zzb;
        List<zzfi.zze> zzc;
        private long zzd;

        private static long zza(zzfi.zze zze2) {
            return zze2.zzd() / 1000L / 60L / 60L;
        }

        private zza() {
        }

        /* synthetic */ zza(zzmx zzmx2) {
            this();
        }

        @Override
        public final void zza(zzfi.zzj zzj2) {
            Preconditions.checkNotNull((Object)((Object)zzj2));
            this.zza = zzj2;
        }

        @Override
        public final boolean zza(long l, zzfi.zze zze2) {
            Preconditions.checkNotNull((Object)((Object)zze2));
            if (this.zzc == null) {
                this.zzc = new ArrayList<zzfi.zze>();
            }
            if (this.zzb == null) {
                this.zzb = new ArrayList<Long>();
            }
            if (!this.zzc.isEmpty() && com.google.android.gms.measurement.internal.zzmp$zza.zza(this.zzc.get(0)) != com.google.android.gms.measurement.internal.zzmp$zza.zza(zze2)) {
                return false;
            }
            long l2 = this.zzd + (long)zze2.zzbw();
            zzmp.this.zze();
            if (l2 >= (long)Math.max(0, (Integer)zzbg.zzi.zza(null))) {
                return false;
            }
            this.zzd = l2;
            this.zzc.add(zze2);
            this.zzb.add(l);
            int n = this.zzc.size();
            zzmp.this.zze();
            return n < Math.max(1, (Integer)zzbg.zzj.zza(null));
        }
    }
}

