/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face;

import android.content.Context;
import android.graphics.PointF;
import android.os.RemoteException;
import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.GmsLogger;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.vision.zzbw;
import com.google.android.gms.internal.vision.zzcb;
import com.google.android.gms.internal.vision.zzcc;
import com.google.android.gms.internal.vision.zzci;
import com.google.android.gms.internal.vision.zzck;
import com.google.android.gms.internal.vision.zzcp;
import com.google.android.gms.internal.vision.zzct;
import com.google.android.gms.internal.vision.zzfl;
import com.google.android.gms.internal.vision.zzhp;
import com.google.android.gms.internal.vision.zzid;
import com.google.android.gms.internal.vision.zzls;
import com.google.android.gms.internal.vision.zzma;
import com.google.android.gms.internal.vision.zzu;
import com.google.android.gms.vision.clearcut.DynamiteClearcutLogger;
import com.google.android.gms.vision.face.FaceDetectorV2Jni;
import com.google.android.gms.vision.face.internal.client.FaceParcel;
import com.google.android.gms.vision.face.internal.client.LandmarkParcel;
import com.google.android.gms.vision.face.internal.client.zza;
import com.google.android.gms.vision.face.internal.client.zzf;
import com.google.android.gms.vision.face.internal.client.zzg;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

final class NativeFaceDetectorV2Impl
extends zzg {
    private static final GmsLogger zzcy = new GmsLogger("NativeFaceDetectorV2Imp", "");
    private final long zzcz;
    private final DynamiteClearcutLogger zzda;
    private final zzci.zzd zzdb;
    private final FaceDetectorV2Jni zzdc;

    NativeFaceDetectorV2Impl(Context context, Context context2, DynamiteClearcutLogger dynamiteClearcutLogger, zzf zzf2, FaceDetectorV2Jni faceDetectorV2Jni) {
        zzf zzf3 = zzf2;
        zzci.zzg zzg2 = (zzci.zzg)((zzid)zzci.zzg.zzbz().zzk("models").zzgw());
        zzci.zzd.zza zza2 = zzci.zzd.zzbt().zza(zzci.zze.zzbv().zzh(zzg2).zzi(zzg2).zzj(zzg2)).zza(zzci.zza.zzbh().zzc(zzg2).zzd(zzg2)).zza(zzci.zzf.zzbx().zzk(zzg2).zzl(zzg2).zzm(zzg2).zzn(zzg2)).zzd(zzf3.zzcv).zze(zzf3.trackingEnabled).zze(zzf3.proportionalMinFaceSize).zzf(true);
        switch (zzf3.mode) {
            case 1: {
                zza2.zzb(zzct.zzls);
                break;
            }
            case 0: {
                zza2.zzb(zzct.zzlr);
                break;
            }
            case 2: {
                zza2.zzb(zzct.zzlt);
            }
        }
        switch (zzf3.landmarkType) {
            case 1: {
                zza2.zzb(zzcp.zzli);
                break;
            }
            case 0: {
                zza2.zzb(zzcp.zzlh);
                break;
            }
            case 2: {
                zza2.zzb(zzcp.zzlj);
            }
        }
        switch (zzf3.zzcw) {
            case 1: {
                zza2.zzb(zzck.zzjm);
                break;
            }
            case 0: {
                zza2.zzb(zzck.zzjl);
            }
        }
        this.zzdb = (zzci.zzd)((zzid)zza2.zzgw());
        this.zzcz = faceDetectorV2Jni.zza(this.zzdb, context2.getAssets());
        this.zzda = dynamiteClearcutLogger;
        this.zzdc = faceDetectorV2Jni;
    }

    public final void zzo() throws RemoteException {
        this.zzdc.zza(this.zzcz);
    }

    private static zzcc zze(int n) {
        switch (n) {
            case 0: {
                return zzcc.zzic;
            }
            case 1: {
                return zzcc.zzif;
            }
            case 2: {
                return zzcc.zzie;
            }
            case 3: {
                return zzcc.zzid;
            }
        }
        throw new IllegalArgumentException("Unsupported rotation degree.");
    }

    public final FaceParcel[] zzc(IObjectWrapper iObjectWrapper, zzu zzu2) throws RemoteException {
        long l = SystemClock.elapsedRealtime();
        try {
            Object[] objectArray;
            zzci.zzc zzc2;
            ByteBuffer byteBuffer = (ByteBuffer)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
            zzcb.zza zza2 = zzcb.zzam().zzj(zzu2.width).zzk(zzu2.height).zzb(NativeFaceDetectorV2Impl.zze(zzu2.rotation)).zzb(zzbw.zzhk);
            if (zzu2.zzaz > 0L) {
                zza2.zzc(zzu2.zzaz * 1000L);
            }
            zzcb zzcb2 = (zzcb)((zzid)zza2.zzgw());
            if (byteBuffer.isDirect()) {
                zzc2 = this.zzdc.zza(this.zzcz, byteBuffer, zzcb2);
            } else if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 0) {
                zzc2 = this.zzdc.zza(this.zzcz, byteBuffer.array(), zzcb2);
            } else {
                objectArray = new byte[byteBuffer.remaining()];
                byteBuffer.get((byte[])objectArray);
                zzc2 = this.zzdc.zza(this.zzcz, (byte[])objectArray, zzcb2);
            }
            objectArray = NativeFaceDetectorV2Impl.zza(zzc2, this.zzdb.zzbs(), this.zzdb.zzbr());
            NativeFaceDetectorV2Impl.zza(this.zzda, zzu2, (FaceParcel[])objectArray, null, SystemClock.elapsedRealtime() - l);
            return objectArray;
        }
        catch (Exception exception) {
            zzcy.e("NativeFaceDetectorV2Imp", "Native face detection v2 failed", (Throwable)exception);
            return new FaceParcel[0];
        }
    }

    public final FaceParcel[] zza(IObjectWrapper iObjectWrapper, IObjectWrapper iObjectWrapper2, IObjectWrapper iObjectWrapper3, int n, int n2, int n3, int n4, int n5, int n6, zzu zzu2) {
        long l = SystemClock.elapsedRealtime();
        try {
            Object[] objectArray;
            zzci.zzc zzc2;
            ByteBuffer byteBuffer = (ByteBuffer)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
            ByteBuffer byteBuffer2 = (ByteBuffer)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper2);
            ByteBuffer byteBuffer3 = (ByteBuffer)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper3);
            zzcb.zza zza2 = zzcb.zzam().zzj(zzu2.width).zzk(zzu2.height).zzb(NativeFaceDetectorV2Impl.zze(zzu2.rotation));
            if (zzu2.zzaz > 0L) {
                zza2.zzc(zzu2.zzaz * 1000L);
            }
            zzcb zzcb2 = (zzcb)((zzid)zza2.zzgw());
            if (byteBuffer.isDirect()) {
                zzc2 = this.zzdc.zza(this.zzcz, byteBuffer, byteBuffer2, byteBuffer3, n, n2, n3, n4, n5, n6, zzcb2);
            } else if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 0) {
                objectArray = byteBuffer2 != null && byteBuffer2.hasArray() && byteBuffer2.arrayOffset() == 0 ? byteBuffer2.array() : null;
                byte[] byArray = byteBuffer3 != null && byteBuffer3.hasArray() && byteBuffer3.arrayOffset() == 0 ? byteBuffer3.array() : null;
                zzc2 = this.zzdc.zza(this.zzcz, byteBuffer.array(), (byte[])objectArray, byArray, n, n2, n3, n4, n5, n6, zzcb2);
            } else {
                objectArray = new byte[byteBuffer.remaining()];
                byteBuffer.get((byte[])objectArray);
                byte[] byArray = new byte[byteBuffer2.remaining()];
                byteBuffer.get((byte[])objectArray);
                byte[] byArray2 = new byte[byteBuffer3.remaining()];
                byteBuffer.get((byte[])objectArray);
                zzc2 = this.zzdc.zza(this.zzcz, (byte[])objectArray, byArray, byArray2, n, n2, n3, n4, n5, n6, zzcb2);
            }
            objectArray = NativeFaceDetectorV2Impl.zza(zzc2, this.zzdb.zzbs(), this.zzdb.zzbr());
            NativeFaceDetectorV2Impl.zza(this.zzda, zzu2, (FaceParcel[])objectArray, null, SystemClock.elapsedRealtime() - l);
            return objectArray;
        }
        catch (Exception exception) {
            zzcy.e("NativeFaceDetectorV2Imp", "Native face detection v2 failed", (Throwable)exception);
            return new FaceParcel[0];
        }
    }

    public final boolean zzd(int n) throws RemoteException {
        return true;
    }

    private static FaceParcel[] zza(zzci.zzc zzc2, zzck zzck2, zzcp zzcp2) {
        zzma zzma2 = zzc2.zzbp();
        FaceParcel[] faceParcelArray = new FaceParcel[zzma2.zzkg()];
        for (int i = 0; i < zzma2.zzkg(); ++i) {
            zza[] zzaArray;
            LandmarkParcel[] object32;
            LandmarkParcel[] landmarkParcelArray;
            Object object;
            zzid zzid2;
            int n;
            zza[] zzaArray2;
            List list;
            float f;
            zzls zzls2 = zzma2.zzcj(i);
            zzls.zzb zzb2 = zzls2.zzjm();
            float f2 = zzb2.zzjx() + (zzb2.zzjz() - zzb2.zzjx()) / 2.0f;
            float f3 = zzb2.zzjy() + (zzb2.zzka() - zzb2.zzjy()) / 2.0f;
            float f4 = zzb2.zzjz() - zzb2.zzjx();
            float f5 = zzb2.zzka() - zzb2.zzjy();
            float f6 = -1.0f;
            float f7 = -1.0f;
            float f8 = -1.0f;
            if (zzck2 == zzck.zzjm) {
                for (zzls.zza zza2 : zzls2.zzjs()) {
                    if (zza2.getName().equals("joy")) {
                        f8 = zza2.getConfidence();
                        continue;
                    }
                    if (zza2.getName().equals("left_eye_closed")) {
                        f6 = 1.0f - zza2.getConfidence();
                        continue;
                    }
                    if (!zza2.getName().equals("right_eye_closed")) continue;
                    f7 = 1.0f - zza2.getConfidence();
                }
            }
            float f9 = f = zzls2.zzjo() ? zzls2.getConfidence() : -1.0f;
            if (zzcp2 == zzcp.zzli) {
                list = zzls2.zzjn();
                zzaArray2 = new ArrayList();
                for (n = 0; n < list.size(); ++n) {
                    int n2;
                    int n3;
                    zzid2 = (zzls.zze)((Object)list.get(n));
                    zzls.zze.zza zza3 = zzid2.zzke();
                    switch (zza3) {
                        case zzagn: {
                            n3 = 4;
                            break;
                        }
                        case zzago: {
                            n3 = 10;
                            break;
                        }
                        case zzagu: {
                            n3 = 6;
                            break;
                        }
                        case zzagw: {
                            n3 = 0;
                            break;
                        }
                        case zzagx: {
                            n3 = 5;
                            break;
                        }
                        case zzagy: {
                            n3 = 11;
                            break;
                        }
                        case zzahn: {
                            n3 = 3;
                            break;
                        }
                        case zzaho: {
                            n3 = 9;
                            break;
                        }
                        case zzahv: {
                            n3 = 1;
                            break;
                        }
                        case zzahw: {
                            n3 = 7;
                            break;
                        }
                        case zzahx: {
                            n3 = 2;
                            break;
                        }
                        case zzahy: {
                            n3 = 8;
                            break;
                        }
                        default: {
                            object = String.valueOf((Object)zza3);
                            zzcy.d("NativeFaceDetectorV2Imp", new StringBuilder(23 + String.valueOf(object).length()).append("Unknown landmark type: ").append((String)object).toString());
                            n3 = n2 = -1;
                        }
                    }
                    if (n3 < 0) continue;
                    zzaArray2.add(new LandmarkParcel(-1, zzid2.getX(), zzid2.getY(), n2));
                }
                landmarkParcelArray = zzaArray2.toArray(new LandmarkParcel[0]);
            } else {
                landmarkParcelArray = object32 = new LandmarkParcel[]{};
            }
            if (zzcp2 == zzcp.zzlj) {
                list = (List)zzls2.zzc((zzhp)zzci.zzjg);
                zzaArray2 = new zza[list.size()];
                for (n = 0; n < list.size(); ++n) {
                    int n4;
                    zzid2 = (zzci.zzb)((Object)list.get(n));
                    PointF[] pointFArray = new PointF[zzid2.zzbl()];
                    for (int j = 0; j < zzid2.zzbl(); ++j) {
                        object = zzid2.zzbk().get(j);
                        pointFArray[j] = new PointF(((zzci.zzb.zzb)((Object)object)).getX(), ((zzci.zzb.zzb)((Object)object)).getY());
                    }
                    zzci.zzb.zzc zzc3 = zzid2.zzbj();
                    switch (zzc3) {
                        case zzjw: {
                            n4 = 1;
                            break;
                        }
                        case zzjx: {
                            n4 = 2;
                            break;
                        }
                        case zzjy: {
                            n4 = 3;
                            break;
                        }
                        case zzjz: {
                            n4 = 4;
                            break;
                        }
                        case zzka: {
                            n4 = 5;
                            break;
                        }
                        case zzkb: {
                            n4 = 6;
                            break;
                        }
                        case zzkc: {
                            n4 = 7;
                            break;
                        }
                        case zzkd: {
                            n4 = 8;
                            break;
                        }
                        case zzke: {
                            n4 = 9;
                            break;
                        }
                        case zzkf: {
                            n4 = 10;
                            break;
                        }
                        case zzkg: {
                            n4 = 11;
                            break;
                        }
                        case zzkh: {
                            n4 = 12;
                            break;
                        }
                        case zzki: {
                            n4 = 13;
                            break;
                        }
                        case zzkj: {
                            n4 = 14;
                            break;
                        }
                        case zzkk: {
                            n4 = 15;
                            break;
                        }
                        default: {
                            int n5 = zzc3.zzak();
                            zzcy.e("NativeFaceDetectorV2Imp", new StringBuilder(33).append("Unknown contour type: ").append(n5).toString());
                            n4 = -1;
                        }
                    }
                    zzaArray2[n] = new zza(pointFArray, n4);
                }
                zzaArray = zzaArray2;
            } else {
                zzaArray = new zza[]{};
            }
            zza[] zzaArray3 = zzaArray;
            faceParcelArray[i] = new FaceParcel(3, (int)zzls2.zzjt(), f2, f3, f4, f5, zzls2.zzjq(), -zzls2.zzjp(), zzls2.zzjr(), object32, f6, f7, f8, zzaArray3, f);
        }
        return faceParcelArray;
    }

    private static void zza(DynamiteClearcutLogger dynamiteClearcutLogger, zzu zzu2, FaceParcel[] faceParcelArray, @Nullable String string, long l) {
        if (zzu2.id > 2 && faceParcelArray.length == 0) {
            return;
        }
        long l2 = l;
        FaceParcel[] faceParcelArray2 = faceParcelArray;
        zzu zzu3 = zzu2;
        ArrayList<zzfl.zzn> arrayList = new ArrayList<zzfl.zzn>();
        FaceParcel[] faceParcelArray3 = faceParcelArray2;
        int n = faceParcelArray2.length;
        for (int i = 0; i < n; ++i) {
            FaceParcel faceParcel = faceParcelArray3[i];
            zzfl.zzm zzm2 = (zzfl.zzm)((zzid)zzfl.zzm.zzdy().zzaf((int)(faceParcel.centerX - faceParcel.width / 2.0f)).zzag((int)(faceParcel.centerY - faceParcel.height / 2.0f)).zzgw());
            zzfl.zzm zzm3 = (zzfl.zzm)((zzid)zzfl.zzm.zzdy().zzaf((int)(faceParcel.centerX + faceParcel.width / 2.0f)).zzag((int)(faceParcel.centerY - faceParcel.height / 2.0f)).zzgw());
            zzfl.zzm zzm4 = (zzfl.zzm)((zzid)zzfl.zzm.zzdy().zzaf((int)(faceParcel.centerX + faceParcel.width / 2.0f)).zzag((int)(faceParcel.centerY + faceParcel.height / 2.0f)).zzgw());
            zzfl.zzm zzm5 = (zzfl.zzm)((zzid)zzfl.zzm.zzdy().zzaf((int)(faceParcel.centerX - faceParcel.width / 2.0f)).zzag((int)(faceParcel.centerY + faceParcel.height / 2.0f)).zzgw());
            zzfl.zzh zzh2 = (zzfl.zzh)((zzid)zzfl.zzh.zzdo().zzj(faceParcel.zzdh).zzk(faceParcel.zzdi).zzl(faceParcel.zzdj).zzg(faceParcel.zzcm).zzh(faceParcel.zzcn).zzi(faceParcel.zzco).zzgw());
            arrayList.add((zzfl.zzn)((zzid)zzfl.zzn.zzea().zza(zzfl.zzd.zzdh().zzb(zzm2).zzb(zzm3).zzb(zzm4).zzb(zzm5)).zzah(faceParcel.id).zzb(zzh2).zzgw()));
        }
        zzu zzu4 = zzu3;
        ArrayList<zzfl.zzn> arrayList2 = arrayList;
        String string2 = "face";
        int n2 = faceParcelArray2.length;
        long l3 = l2;
        zzfl.zzi.zza zza2 = zzfl.zzi.zzdr();
        ArrayList<zzfl.zzn> arrayList3 = arrayList2;
        String string3 = string2;
        int n3 = n2;
        long l4 = l3;
        zzfl.zzf.zza zza3 = zzfl.zzf.zzdk().zzq(string3).zzd(l4).zze((long)n3);
        zza3.zzc(arrayList3);
        ArrayList<zzfl.zzf> arrayList4 = new ArrayList<zzfl.zzf>();
        arrayList4.add((zzfl.zzf)((zzid)zza3.zzgw()));
        zzu zzu5 = zzu4;
        zzfl.zzi zzi2 = (zzfl.zzi)((zzid)zza2.zze(arrayList4).zza((zzfl.zzj)((zzid)zzfl.zzj.zzdt().zzi((long)zzu5.height).zzh((long)zzu5.width).zzj((long)zzu5.id).zzk(zzu5.zzaz).zzgw())).zzgw());
        zzfl.zzo zzo2 = (zzfl.zzo)((zzid)zzfl.zzo.zzec().zzb(zzi2).zzgw());
        dynamiteClearcutLogger.zza(3, zzo2);
    }
}

