/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face;

import android.content.Context;
import android.graphics.PointF;
import android.os.RemoteException;
import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.GmsLogger;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.vision.zzbw;
import com.google.android.gms.internal.vision.zzcb;
import com.google.android.gms.internal.vision.zzcc;
import com.google.android.gms.internal.vision.zzci;
import com.google.android.gms.internal.vision.zzck;
import com.google.android.gms.internal.vision.zzcp;
import com.google.android.gms.internal.vision.zzct;
import com.google.android.gms.internal.vision.zzfi;
import com.google.android.gms.internal.vision.zzim;
import com.google.android.gms.internal.vision.zzjb;
import com.google.android.gms.internal.vision.zzmt;
import com.google.android.gms.internal.vision.zznb;
import com.google.android.gms.internal.vision.zzs;
import com.google.android.gms.vision.clearcut.DynamiteClearcutLogger;
import com.google.android.gms.vision.clearcut.LogUtils;
import com.google.android.gms.vision.face.FaceDetectorV2Jni;
import com.google.android.gms.vision.face.internal.client.FaceParcel;
import com.google.android.gms.vision.face.internal.client.LandmarkParcel;
import com.google.android.gms.vision.face.internal.client.zza;
import com.google.android.gms.vision.face.internal.client.zzf;
import com.google.android.gms.vision.face.internal.client.zzg;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

final class NativeFaceDetectorV2Impl
extends zzg {
    private static final GmsLogger zza = new GmsLogger("NativeFaceDetectorV2Imp", "");
    private final long zzb;
    private final DynamiteClearcutLogger zzc;
    private final zzci.zzd zzd;
    private final FaceDetectorV2Jni zze;

    NativeFaceDetectorV2Impl(Context context, Context context2, DynamiteClearcutLogger dynamiteClearcutLogger, zzf zzf2, FaceDetectorV2Jni faceDetectorV2Jni) {
        zzf zzf3 = zzf2;
        zzci.zzg zzg2 = (zzci.zzg)((zzjb)zzci.zzg.zza().zza("models").zzf());
        zzci.zzd.zza zza2 = zzci.zzd.zzc().zza(zzci.zze.zza().zza(zzg2).zzb(zzg2).zzc(zzg2)).zza(zzci.zza.zza().zza(zzg2).zzb(zzg2)).zza(zzci.zzf.zza().zza(zzg2).zzb(zzg2).zzc(zzg2).zzd(zzg2)).zza(zzf3.zzd).zzb(zzf3.zze).zza(zzf3.zzf).zzc(true);
        switch (zzf3.zza) {
            case 1: {
                zza2.zza(zzct.zzb);
                break;
            }
            case 0: {
                zza2.zza(zzct.zza);
                break;
            }
            case 2: {
                zza2.zza(zzct.zzc);
            }
        }
        switch (zzf3.zzb) {
            case 1: {
                zza2.zza(zzcp.zzb);
                break;
            }
            case 0: {
                zza2.zza(zzcp.zza);
                break;
            }
            case 2: {
                zza2.zza(zzcp.zzc);
            }
        }
        switch (zzf3.zzc) {
            case 1: {
                zza2.zza(zzck.zzb);
                break;
            }
            case 0: {
                zza2.zza(zzck.zza);
            }
        }
        this.zzd = (zzci.zzd)((zzjb)zza2.zzf());
        this.zzb = faceDetectorV2Jni.zza(this.zzd, context2.getAssets());
        this.zzc = dynamiteClearcutLogger;
        this.zze = faceDetectorV2Jni;
    }

    public final void zza() throws RemoteException {
        this.zze.zza(this.zzb);
    }

    private static zzcc zzb(int n) {
        switch (n) {
            case 0: {
                return zzcc.zza;
            }
            case 1: {
                return zzcc.zzd;
            }
            case 2: {
                return zzcc.zzc;
            }
            case 3: {
                return zzcc.zzb;
            }
        }
        throw new IllegalArgumentException("Unsupported rotation degree.");
    }

    public final FaceParcel[] zza(IObjectWrapper iObjectWrapper, zzs zzs2) throws RemoteException {
        long l = SystemClock.elapsedRealtime();
        try {
            Object[] objectArray;
            zzci.zzc zzc2;
            ByteBuffer byteBuffer = (ByteBuffer)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
            zzcb.zza zza2 = zzcb.zza().zza(zzs2.zza).zzb(zzs2.zzb).zza(NativeFaceDetectorV2Impl.zzb(zzs2.zze)).zza(zzbw.zza);
            if (zzs2.zzd > 0L) {
                zza2.zza(zzs2.zzd * 1000L);
            }
            zzcb zzcb2 = (zzcb)((zzjb)zza2.zzf());
            if (byteBuffer.isDirect()) {
                zzc2 = this.zze.zza(this.zzb, byteBuffer, zzcb2);
            } else if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 0) {
                zzc2 = this.zze.zza(this.zzb, byteBuffer.array(), zzcb2);
            } else {
                objectArray = new byte[byteBuffer.remaining()];
                byteBuffer.get((byte[])objectArray);
                zzc2 = this.zze.zza(this.zzb, (byte[])objectArray, zzcb2);
            }
            objectArray = NativeFaceDetectorV2Impl.zza(zzc2, this.zzd.zzb(), this.zzd.zza());
            NativeFaceDetectorV2Impl.zza(this.zzc, zzs2, (FaceParcel[])objectArray, null, SystemClock.elapsedRealtime() - l);
            return objectArray;
        }
        catch (Exception exception) {
            zza.e("NativeFaceDetectorV2Imp", "Native face detection v2 failed", (Throwable)exception);
            return new FaceParcel[0];
        }
    }

    public final FaceParcel[] zza(IObjectWrapper iObjectWrapper, IObjectWrapper iObjectWrapper2, IObjectWrapper iObjectWrapper3, int n, int n2, int n3, int n4, int n5, int n6, zzs zzs2) {
        long l = SystemClock.elapsedRealtime();
        try {
            Object[] objectArray;
            zzci.zzc zzc2;
            ByteBuffer byteBuffer = (ByteBuffer)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
            ByteBuffer byteBuffer2 = (ByteBuffer)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper2);
            ByteBuffer byteBuffer3 = (ByteBuffer)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper3);
            zzcb.zza zza2 = zzcb.zza().zza(zzs2.zza).zzb(zzs2.zzb).zza(NativeFaceDetectorV2Impl.zzb(zzs2.zze));
            if (zzs2.zzd > 0L) {
                zza2.zza(zzs2.zzd * 1000L);
            }
            zzcb zzcb2 = (zzcb)((zzjb)zza2.zzf());
            if (byteBuffer.isDirect()) {
                zzc2 = this.zze.zza(this.zzb, byteBuffer, byteBuffer2, byteBuffer3, n, n2, n3, n4, n5, n6, zzcb2);
            } else if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 0) {
                objectArray = byteBuffer2 != null && byteBuffer2.hasArray() && byteBuffer2.arrayOffset() == 0 ? byteBuffer2.array() : null;
                byte[] byArray = byteBuffer3 != null && byteBuffer3.hasArray() && byteBuffer3.arrayOffset() == 0 ? byteBuffer3.array() : null;
                zzc2 = this.zze.zza(this.zzb, byteBuffer.array(), (byte[])objectArray, byArray, n, n2, n3, n4, n5, n6, zzcb2);
            } else {
                objectArray = new byte[byteBuffer.remaining()];
                byteBuffer.get((byte[])objectArray);
                byte[] byArray = new byte[byteBuffer2.remaining()];
                byteBuffer.get((byte[])objectArray);
                byte[] byArray2 = new byte[byteBuffer3.remaining()];
                byteBuffer.get((byte[])objectArray);
                zzc2 = this.zze.zza(this.zzb, (byte[])objectArray, byArray, byArray2, n, n2, n3, n4, n5, n6, zzcb2);
            }
            objectArray = NativeFaceDetectorV2Impl.zza(zzc2, this.zzd.zzb(), this.zzd.zza());
            NativeFaceDetectorV2Impl.zza(this.zzc, zzs2, (FaceParcel[])objectArray, null, SystemClock.elapsedRealtime() - l);
            return objectArray;
        }
        catch (Exception exception) {
            zza.e("NativeFaceDetectorV2Imp", "Native face detection v2 failed", (Throwable)exception);
            return new FaceParcel[0];
        }
    }

    public final boolean zza(int n) throws RemoteException {
        return true;
    }

    private static FaceParcel[] zza(zzci.zzc zzc2, zzck zzck2, zzcp zzcp2) {
        zznb zznb2 = zzc2.zza();
        FaceParcel[] faceParcelArray = new FaceParcel[zznb2.zzb()];
        for (int i = 0; i < zznb2.zzb(); ++i) {
            zza[] zzaArray;
            LandmarkParcel[] object32;
            LandmarkParcel[] landmarkParcelArray;
            Object object;
            zzjb zzjb2;
            int n;
            zza[] zzaArray2;
            List list;
            float f;
            zzmt zzmt2 = zznb2.zza(i);
            zzmt.zzb zzb2 = zzmt2.zzb();
            float f2 = zzb2.zza() + (zzb2.zzc() - zzb2.zza()) / 2.0f;
            float f3 = zzb2.zzb() + (zzb2.zzd() - zzb2.zzb()) / 2.0f;
            float f4 = zzb2.zzc() - zzb2.zza();
            float f5 = zzb2.zzd() - zzb2.zzb();
            float f6 = -1.0f;
            float f7 = -1.0f;
            float f8 = -1.0f;
            if (zzck2 == zzck.zzb) {
                for (zzmt.zza zza2 : zzmt2.zzu()) {
                    if (zza2.zza().equals("joy")) {
                        f8 = zza2.zzb();
                        continue;
                    }
                    if (zza2.zza().equals("left_eye_closed")) {
                        f6 = 1.0f - zza2.zzb();
                        continue;
                    }
                    if (!zza2.zza().equals("right_eye_closed")) continue;
                    f7 = 1.0f - zza2.zzb();
                }
            }
            float f9 = f = zzmt2.zzd() ? zzmt2.zze() : -1.0f;
            if (zzcp2 == zzcp.zzb) {
                list = zzmt2.zzc();
                zzaArray2 = new ArrayList();
                for (n = 0; n < list.size(); ++n) {
                    int n2;
                    int n3;
                    zzjb2 = (zzmt.zze)((Object)list.get(n));
                    zzmt.zze.zzb zzb3 = zzjb2.zzc();
                    switch (zzb3) {
                        case zza: {
                            n3 = 4;
                            break;
                        }
                        case zzb: {
                            n3 = 10;
                            break;
                        }
                        case zzc: {
                            n3 = 6;
                            break;
                        }
                        case zzd: {
                            n3 = 0;
                            break;
                        }
                        case zze: {
                            n3 = 5;
                            break;
                        }
                        case zzf: {
                            n3 = 11;
                            break;
                        }
                        case zzg: {
                            n3 = 3;
                            break;
                        }
                        case zzh: {
                            n3 = 9;
                            break;
                        }
                        case zzi: {
                            n3 = 1;
                            break;
                        }
                        case zzj: {
                            n3 = 7;
                            break;
                        }
                        case zzk: {
                            n3 = 2;
                            break;
                        }
                        case zzl: {
                            n3 = 8;
                            break;
                        }
                        default: {
                            object = String.valueOf((Object)zzb3);
                            zza.d("NativeFaceDetectorV2Imp", new StringBuilder(23 + String.valueOf(object).length()).append("Unknown landmark type: ").append((String)object).toString());
                            n3 = n2 = -1;
                        }
                    }
                    if (n3 < 0) continue;
                    zzaArray2.add(new LandmarkParcel(-1, zzjb2.zza(), zzjb2.zzb(), n2));
                }
                landmarkParcelArray = zzaArray2.toArray(new LandmarkParcel[0]);
            } else {
                landmarkParcelArray = object32 = new LandmarkParcel[]{};
            }
            if (zzcp2 == zzcp.zzc) {
                list = (List)zzmt2.zzb((zzim)zzci.zza);
                zzaArray2 = new zza[list.size()];
                for (n = 0; n < list.size(); ++n) {
                    int n4;
                    zzjb2 = (zzci.zzb)((Object)list.get(n));
                    PointF[] pointFArray = new PointF[zzjb2.zzc()];
                    for (int j = 0; j < zzjb2.zzc(); ++j) {
                        object = zzjb2.zzb().get(j);
                        pointFArray[j] = new PointF(((zzci.zzb.zzb)((Object)object)).zza(), ((zzci.zzb.zzb)((Object)object)).zzb());
                    }
                    zzci.zzb.zzc zzc3 = zzjb2.zza();
                    switch (zzc3) {
                        case zzb: {
                            n4 = 1;
                            break;
                        }
                        case zzc: {
                            n4 = 2;
                            break;
                        }
                        case zzd: {
                            n4 = 3;
                            break;
                        }
                        case zze: {
                            n4 = 4;
                            break;
                        }
                        case zzf: {
                            n4 = 5;
                            break;
                        }
                        case zzg: {
                            n4 = 6;
                            break;
                        }
                        case zzh: {
                            n4 = 7;
                            break;
                        }
                        case zzi: {
                            n4 = 8;
                            break;
                        }
                        case zzj: {
                            n4 = 9;
                            break;
                        }
                        case zzk: {
                            n4 = 10;
                            break;
                        }
                        case zzl: {
                            n4 = 11;
                            break;
                        }
                        case zzm: {
                            n4 = 12;
                            break;
                        }
                        case zzn: {
                            n4 = 13;
                            break;
                        }
                        case zzo: {
                            n4 = 14;
                            break;
                        }
                        case zzp: {
                            n4 = 15;
                            break;
                        }
                        default: {
                            int n5 = zzc3.zza();
                            zza.e("NativeFaceDetectorV2Imp", new StringBuilder(33).append("Unknown contour type: ").append(n5).toString());
                            n4 = -1;
                        }
                    }
                    zzaArray2[n] = new zza(pointFArray, n4);
                }
                zzaArray = zzaArray2;
            } else {
                zzaArray = new zza[]{};
            }
            zza[] zzaArray3 = zzaArray;
            faceParcelArray[i] = new FaceParcel(3, (int)zzmt2.zzv(), f2, f3, f4, f5, zzmt2.zzs(), -zzmt2.zzf(), zzmt2.zzt(), object32, f6, f7, f8, zzaArray3, f);
        }
        return faceParcelArray;
    }

    private static void zza(DynamiteClearcutLogger dynamiteClearcutLogger, zzs zzs2, FaceParcel[] faceParcelArray, @Nullable String string, long l) {
        if (zzs2.zzc > 2 && faceParcelArray.length == 0) {
            return;
        }
        long l2 = l;
        FaceParcel[] faceParcelArray2 = faceParcelArray;
        zzs zzs3 = zzs2;
        ArrayList<zzfi.zzn> arrayList = new ArrayList<zzfi.zzn>();
        FaceParcel[] faceParcelArray3 = faceParcelArray2;
        int n = faceParcelArray2.length;
        for (int i = 0; i < n; ++i) {
            FaceParcel faceParcel = faceParcelArray3[i];
            zzfi.zzm zzm2 = (zzfi.zzm)((zzjb)zzfi.zzm.zza().zza((int)(faceParcel.zzb - faceParcel.zzd / 2.0f)).zzb((int)(faceParcel.zzc - faceParcel.zze / 2.0f)).zzf());
            zzfi.zzm zzm3 = (zzfi.zzm)((zzjb)zzfi.zzm.zza().zza((int)(faceParcel.zzb + faceParcel.zzd / 2.0f)).zzb((int)(faceParcel.zzc - faceParcel.zze / 2.0f)).zzf());
            zzfi.zzm zzm4 = (zzfi.zzm)((zzjb)zzfi.zzm.zza().zza((int)(faceParcel.zzb + faceParcel.zzd / 2.0f)).zzb((int)(faceParcel.zzc + faceParcel.zze / 2.0f)).zzf());
            zzfi.zzm zzm5 = (zzfi.zzm)((zzjb)zzfi.zzm.zza().zza((int)(faceParcel.zzb - faceParcel.zzd / 2.0f)).zzb((int)(faceParcel.zzc + faceParcel.zze / 2.0f)).zzf());
            zzfi.zzh zzh2 = (zzfi.zzh)((zzjb)zzfi.zzh.zza().zzd(faceParcel.zzf).zze(faceParcel.zzg).zzf(faceParcel.zzh).zza(faceParcel.zzj).zzb(faceParcel.zzk).zzc(faceParcel.zzl).zzf());
            arrayList.add((zzfi.zzn)((zzjb)zzfi.zzn.zza().zza(zzfi.zzd.zza().zza(zzm2).zza(zzm3).zza(zzm4).zza(zzm5)).zza(faceParcel.zza).zza(zzh2).zzf()));
        }
        zzfi.zzo zzo2 = LogUtils.zza((long)l2, (int)faceParcelArray2.length, null, (String)"face", arrayList, (zzs)zzs3);
        dynamiteClearcutLogger.zza(3, zzo2);
    }
}

