/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.label;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.SparseArray;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.internal.vision.zzp;
import com.google.android.gms.internal.vision.zzq;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.label.ImageLabel;
import com.google.android.gms.vision.label.internal.client.ImageLabelerOptions;
import com.google.android.gms.vision.label.internal.client.LabelOptions;
import com.google.android.gms.vision.label.internal.client.zzi;
import com.google.android.gms.vision.label.zza;
import java.util.Locale;

@KeepForSdk
@ShowFirstParty
public class ImageLabeler
extends Detector<ImageLabel> {
    private final zzi zzdm;
    private static final LabelOptions zzdn = new LabelOptions(-1);

    private ImageLabeler(zzi zzi2) {
        this.zzdm = zzi2;
    }

    @KeepForSdk
    public SparseArray<ImageLabel> detect(Frame frame) {
        return this.detect(frame, zzdn);
    }

    @KeepForSdk
    public SparseArray<ImageLabel> detect(Frame frame, LabelOptions labelOptions) {
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        Bitmap bitmap = frame.getBitmap();
        zzp zzp2 = zzp.zzc((Frame)frame);
        bitmap = zzq.zzb((Bitmap)bitmap, (zzp)zzp2);
        ImageLabel[] imageLabelArray = this.zzdm.zza(bitmap, labelOptions);
        SparseArray sparseArray = new SparseArray(imageLabelArray.length);
        for (int i = 0; i < imageLabelArray.length; ++i) {
            sparseArray.append(i, (Object)imageLabelArray[i]);
        }
        return sparseArray;
    }

    @KeepForSdk
    public boolean isOperational() {
        return this.zzdm.isOperational();
    }

    @KeepForSdk
    public void release() {
        super.release();
        this.zzdm.zzo();
    }

    /* synthetic */ ImageLabeler(zzi zzi2, zza zza2) {
        this(zzi2);
    }

    @KeepForSdk
    @ShowFirstParty
    public static class Builder {
        private Context zze;
        private ImageLabelerOptions zzdq;

        @KeepForSdk
        public Builder(Context context) {
            this.zze = context;
            this.zzdq = new ImageLabelerOptions(ImageLabelerOptions.zza(Locale.getDefault().getLanguage()), -1, 0.5f, 1);
        }

        @KeepForSdk
        public Builder setScoreThreshold(float f) {
            if (f < 0.0f || f > 1.0f) {
                throw new IllegalArgumentException("scoreThreshold should be between [0, 1]");
            }
            this.zzdq.zzdv = f;
            return this;
        }

        @KeepForSdk
        public ImageLabeler build() {
            zzi zzi2 = new zzi(this.zze, this.zzdq);
            return new ImageLabeler(zzi2, null);
        }
    }
}

