/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.identity.intents.model.UserAddress;
import com.google.android.gms.wallet.InstrumentInfo;
import com.google.android.gms.wallet.LoyaltyWalletObject;
import com.google.android.gms.wallet.OfferWalletObject;
import com.google.android.gms.wallet.zza;
import com.google.android.gms.wallet.zzv;
import java.util.Objects;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="MaskedWalletCreator")
public final class MaskedWallet
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @NonNull
    public static final Parcelable.Creator<MaskedWallet> CREATOR = new zzv();
    @SafeParcelable.Field(id=2)
    String zza;
    @SafeParcelable.Field(id=3)
    String zzb;
    @SafeParcelable.Field(id=4)
    String[] zzc;
    @SafeParcelable.Field(id=5)
    String zzd;
    @SafeParcelable.Field(id=6)
    zza zze;
    @SafeParcelable.Field(id=7)
    zza zzf;
    @SafeParcelable.Field(id=8)
    LoyaltyWalletObject[] zzg;
    @SafeParcelable.Field(id=9)
    OfferWalletObject[] zzh;
    @SafeParcelable.Field(id=10)
    UserAddress zzi;
    @SafeParcelable.Field(id=11)
    UserAddress zzj;
    @SafeParcelable.Field(id=12)
    InstrumentInfo[] zzk;

    @NonNull
    public static Builder newBuilderFrom(@NonNull MaskedWallet maskedWallet) {
        MaskedWallet maskedWallet2;
        Preconditions.checkNotNull((Object)((Object)maskedWallet));
        Builder builder = new MaskedWallet().new Builder(null);
        builder.setGoogleTransactionId(maskedWallet2.getGoogleTransactionId());
        builder.setMerchantTransactionId(maskedWallet2.getMerchantTransactionId());
        builder.setPaymentDescriptions(maskedWallet2.getPaymentDescriptions());
        builder.setInstrumentInfos(maskedWallet2.getInstrumentInfos());
        builder.setEmail(maskedWallet2.getEmail());
        MaskedWallet maskedWallet3 = builder.MaskedWallet.this;
        maskedWallet3.zzg = maskedWallet2.zzg;
        maskedWallet3.zzh = maskedWallet2.zzh;
        builder.setBuyerBillingAddress(maskedWallet2.getBuyerBillingAddress());
        builder.setBuyerShippingAddress(maskedWallet2.getBuyerShippingAddress());
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.zza, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.zzb, (boolean)false);
        SafeParcelWriter.writeStringArray((Parcel)var1_1, (int)4, (String[])this.zzc, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)5, (String)this.zzd, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)6, (Parcelable)this.zze, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)7, (Parcelable)this.zzf, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeTypedArray((Parcel)var1_1, (int)8, (Parcelable[])this.zzg, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeTypedArray((Parcel)var1_1, (int)9, (Parcelable[])this.zzh, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)10, (Parcelable)this.zzi, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)11, (Parcelable)this.zzj, (int)var2_2, (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeTypedArray((Parcel)v1, (int)12, (Parcelable[])this.zzk, (int)var2_2, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }

    private MaskedWallet() {
    }

    @NonNull
    public String getGoogleTransactionId() {
        return this.zza;
    }

    @NonNull
    public String getMerchantTransactionId() {
        return this.zzb;
    }

    @NonNull
    public String[] getPaymentDescriptions() {
        return this.zzc;
    }

    @NonNull
    public InstrumentInfo[] getInstrumentInfos() {
        return this.zzk;
    }

    @NonNull
    public String getEmail() {
        return this.zzd;
    }

    @NonNull
    public UserAddress getBuyerBillingAddress() {
        return this.zzi;
    }

    @NonNull
    public UserAddress getBuyerShippingAddress() {
        return this.zzj;
    }

    @SafeParcelable.Constructor
    MaskedWallet(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) String[] stringArray, @SafeParcelable.Param(id=5) String string3, @SafeParcelable.Param(id=6) zza zza2, @SafeParcelable.Param(id=7) zza zza3, @SafeParcelable.Param(id=8) LoyaltyWalletObject[] loyaltyWalletObjectArray, @SafeParcelable.Param(id=9) OfferWalletObject[] offerWalletObjectArray, @SafeParcelable.Param(id=10) UserAddress userAddress, @SafeParcelable.Param(id=11) UserAddress userAddress2, @SafeParcelable.Param(id=12) InstrumentInfo[] instrumentInfoArray) {
        this.zza = string;
        this.zzb = string2;
        this.zzc = stringArray;
        this.zzd = string3;
        this.zze = zza2;
        this.zzf = zza3;
        this.zzg = loyaltyWalletObjectArray;
        this.zzh = offerWalletObjectArray;
        this.zzi = userAddress;
        this.zzj = userAddress2;
        this.zzk = instrumentInfoArray;
    }

    public final class Builder {
        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setGoogleTransactionId(@NonNull String googleTransactionId) {
            void var1_1;
            MaskedWallet.this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setMerchantTransactionId(@NonNull String merchantTransactionId) {
            void var1_1;
            MaskedWallet.this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPaymentDescriptions(@NonNull String[] paymentDescriptions) {
            void var1_1;
            MaskedWallet.this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setInstrumentInfos(@NonNull InstrumentInfo[] instrumentInfos) {
            void var1_1;
            MaskedWallet.this.zzk = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setEmail(@NonNull String email) {
            void var1_1;
            MaskedWallet.this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setBuyerBillingAddress(@NonNull UserAddress buyerBillingAddress) {
            void var1_1;
            MaskedWallet.this.zzi = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setBuyerShippingAddress(@NonNull UserAddress buyerShippingAddress) {
            void var1_1;
            MaskedWallet.this.zzj = var1_1;
            return this;
        }

        @NonNull
        public MaskedWallet build() {
            return MaskedWallet.this;
        }

        /* synthetic */ Builder(byte[] byArray) {
            Objects.requireNonNull(MaskedWallet.this);
        }
    }
}

