/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.Cart;
import com.google.android.gms.wallet.CountrySpecification;
import com.google.android.gms.wallet.PaymentMethodTokenizationParameters;
import com.google.android.gms.wallet.zzw;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="MaskedWalletRequestCreator")
public final class MaskedWalletRequest
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @NonNull
    public static final Parcelable.Creator<MaskedWalletRequest> CREATOR = new zzw();
    @SafeParcelable.Field(id=2)
    String zza;
    @SafeParcelable.Field(id=3)
    boolean zzb;
    @SafeParcelable.Field(id=4)
    boolean zzc;
    @SafeParcelable.Field(id=5)
    boolean zzd;
    @SafeParcelable.Field(id=6)
    String zze;
    @SafeParcelable.Field(id=7)
    String zzf;
    @SafeParcelable.Field(id=8)
    String zzg;
    @SafeParcelable.Field(id=9)
    Cart zzh;
    @SafeParcelable.Field(id=10)
    boolean zzi;
    @SafeParcelable.Field(id=11)
    boolean zzj;
    @SafeParcelable.Field(id=12)
    CountrySpecification[] zzk;
    @SafeParcelable.Field(id=13, defaultValue="true")
    boolean zzl;
    @SafeParcelable.Field(id=14, defaultValue="true")
    boolean zzm;
    @SafeParcelable.Field(id=15)
    ArrayList zzn;
    @SafeParcelable.Field(id=16)
    PaymentMethodTokenizationParameters zzo;
    @SafeParcelable.Field(id=17)
    ArrayList zzp;
    @SafeParcelable.Field(id=18)
    String zzq;

    @NonNull
    public static Builder newBuilder() {
        return new MaskedWalletRequest().new Builder(null);
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.zza, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)3, (boolean)this.zzb);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)4, (boolean)this.zzc);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)5, (boolean)this.zzd);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)6, (String)this.zze, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)7, (String)this.zzf, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)8, (String)this.zzg, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)9, (Parcelable)this.zzh, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)10, (boolean)this.zzi);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)11, (boolean)this.zzj);
        SafeParcelWriter.writeTypedArray((Parcel)var1_1, (int)12, (Parcelable[])this.zzk, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)13, (boolean)this.zzl);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)14, (boolean)this.zzm);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)15, (List)this.zzn, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)16, (Parcelable)this.zzo, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeIntegerList((Parcel)var1_1, (int)17, (List)this.zzp, (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeString((Parcel)v1, (int)18, (String)this.zzq, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }

    @SafeParcelable.Constructor
    MaskedWalletRequest(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) boolean bl, @SafeParcelable.Param(id=4) boolean bl2, @SafeParcelable.Param(id=5) boolean bl3, @SafeParcelable.Param(id=6) String string2, @SafeParcelable.Param(id=7) String string3, @SafeParcelable.Param(id=8) String string4, @SafeParcelable.Param(id=9) Cart cart, @SafeParcelable.Param(id=10) boolean bl4, @SafeParcelable.Param(id=11) boolean bl5, @SafeParcelable.Param(id=12) CountrySpecification[] countrySpecificationArray, @SafeParcelable.Param(id=13) boolean bl6, @SafeParcelable.Param(id=14) boolean bl7, @SafeParcelable.Param(id=15) ArrayList arrayList, @SafeParcelable.Param(id=16) PaymentMethodTokenizationParameters paymentMethodTokenizationParameters, @SafeParcelable.Param(id=17) ArrayList arrayList2, @SafeParcelable.Param(id=18) String string5) {
        this.zza = string;
        this.zzb = bl;
        this.zzc = bl2;
        this.zzd = bl3;
        this.zze = string2;
        this.zzf = string3;
        this.zzg = string4;
        this.zzh = cart;
        this.zzi = bl4;
        this.zzj = bl5;
        this.zzk = countrySpecificationArray;
        this.zzl = bl6;
        this.zzm = bl7;
        this.zzn = arrayList;
        this.zzo = paymentMethodTokenizationParameters;
        this.zzp = arrayList2;
        this.zzq = string5;
    }

    MaskedWalletRequest() {
        this.zzl = true;
        this.zzm = true;
    }

    @NonNull
    public String getMerchantTransactionId() {
        return this.zza;
    }

    public boolean isPhoneNumberRequired() {
        return this.zzb;
    }

    public boolean isShippingAddressRequired() {
        return this.zzc;
    }

    @Deprecated
    public boolean useMinimalBillingAddress() {
        return this.zzd;
    }

    @NonNull
    public String getEstimatedTotalPrice() {
        return this.zze;
    }

    @NonNull
    public String getCurrencyCode() {
        return this.zzf;
    }

    @NonNull
    public String getMerchantName() {
        return this.zzg;
    }

    @NonNull
    public Cart getCart() {
        return this.zzh;
    }

    @Deprecated
    public boolean isBillingAgreement() {
        return this.zzj;
    }

    @NonNull
    public CountrySpecification[] getAllowedShippingCountrySpecifications() {
        return this.zzk;
    }

    public boolean allowPrepaidCard() {
        return this.zzl;
    }

    public boolean allowDebitCard() {
        return this.zzm;
    }

    @NonNull
    public ArrayList<com.google.android.gms.identity.intents.model.CountrySpecification> getAllowedCountrySpecificationsForShipping() {
        return this.zzn;
    }

    @NonNull
    public PaymentMethodTokenizationParameters getPaymentMethodTokenizationParameters() {
        return this.zzo;
    }

    @NonNull
    public ArrayList<Integer> getAllowedCardNetworks() {
        return this.zzp;
    }

    @NonNull
    public String getCountryCode() {
        return this.zzq;
    }

    public final class Builder {
        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setMerchantTransactionId(@NonNull String merchantTransactionId) {
            void var1_1;
            MaskedWalletRequest.this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPhoneNumberRequired(boolean phoneNumberRequired) {
            void var1_1;
            MaskedWalletRequest.this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setShippingAddressRequired(boolean shippingAddressRequired) {
            void var1_1;
            MaskedWalletRequest.this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @NonNull
        public Builder setUseMinimalBillingAddress(boolean useMinimalBillingAddress) {
            void var1_1;
            MaskedWalletRequest.this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setEstimatedTotalPrice(@NonNull String estimatedTotalPrice) {
            void var1_1;
            MaskedWalletRequest.this.zze = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCurrencyCode(@NonNull String currencyCode) {
            void var1_1;
            MaskedWalletRequest.this.zzf = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setMerchantName(@NonNull String merchantName) {
            void var1_1;
            MaskedWalletRequest.this.zzg = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCart(@NonNull Cart cart) {
            void var1_1;
            MaskedWalletRequest.this.zzh = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @NonNull
        public Builder setIsBillingAgreement(boolean isBillingAgreement) {
            void var1_1;
            MaskedWalletRequest.this.zzj = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAllowPrepaidCard(boolean allowPrepaidCard) {
            void var1_1;
            MaskedWalletRequest.this.zzl = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAllowDebitCard(boolean allowDebitCard) {
            void var1_1;
            MaskedWalletRequest.this.zzm = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addAllowedCountrySpecificationForShipping(@NonNull com.google.android.gms.identity.intents.model.CountrySpecification countrySpecification) {
            void var1_1;
            MaskedWalletRequest maskedWalletRequest = MaskedWalletRequest.this;
            if (maskedWalletRequest.zzn == null) {
                maskedWalletRequest.zzn = new ArrayList();
            }
            maskedWalletRequest.zzn.add(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addAllowedCountrySpecificationsForShipping(@NonNull Collection<com.google.android.gms.identity.intents.model.CountrySpecification> countrySpecifications) {
            if (countrySpecifications != null) {
                void var1_1;
                MaskedWalletRequest maskedWalletRequest = MaskedWalletRequest.this;
                if (maskedWalletRequest.zzn == null) {
                    maskedWalletRequest.zzn = new ArrayList();
                }
                maskedWalletRequest.zzn.addAll(var1_1);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPaymentMethodTokenizationParameters(@NonNull PaymentMethodTokenizationParameters paymentMethodTokenizationParameters) {
            void var1_1;
            MaskedWalletRequest.this.zzo = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addAllowedCardNetwork(int allowedCardNetwork) {
            void var1_1;
            MaskedWalletRequest maskedWalletRequest = MaskedWalletRequest.this;
            if (maskedWalletRequest.zzp == null) {
                maskedWalletRequest.zzp = new ArrayList();
            }
            maskedWalletRequest.zzp.add((int)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addAllowedCardNetworks(@NonNull Collection<Integer> allowedCardNetworks) {
            if (allowedCardNetworks != null) {
                void var1_1;
                MaskedWalletRequest maskedWalletRequest = MaskedWalletRequest.this;
                if (maskedWalletRequest.zzp == null) {
                    maskedWalletRequest.zzp = new ArrayList();
                }
                maskedWalletRequest.zzp.addAll(var1_1);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCountryCode(@NonNull String countryCode) {
            void var1_1;
            MaskedWalletRequest.this.zzq = var1_1;
            return this;
        }

        @NonNull
        public MaskedWalletRequest build() {
            return MaskedWalletRequest.this;
        }

        /* synthetic */ Builder(byte[] byArray) {
            Objects.requireNonNull(MaskedWalletRequest.this);
        }
    }
}

