/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.zzao;
import java.util.Objects;

@SafeParcelable.Class(creator="TransactionInfoCreator")
public final class TransactionInfo
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<TransactionInfo> CREATOR = new zzao();
    @SafeParcelable.Field(id=1)
    int zza;
    @SafeParcelable.Field(id=2)
    String zzb;
    @SafeParcelable.Field(id=3)
    String zzc;

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)1, (int)this.zza);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.zzb, (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeString((Parcel)v1, (int)3, (String)this.zzc, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    @SafeParcelable.Constructor
    public TransactionInfo(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) @NonNull String string, @SafeParcelable.Param(id=3) @NonNull String string2) {
        this.zza = n;
        this.zzb = string;
        this.zzc = string2;
    }

    private TransactionInfo() {
    }

    @NonNull
    public static Builder newBuilder() {
        return new TransactionInfo().new Builder(null);
    }

    public int getTotalPriceStatus() {
        return this.zza;
    }

    @Nullable
    public String getTotalPrice() {
        return this.zzb;
    }

    @NonNull
    public String getCurrencyCode() {
        return this.zzc;
    }

    public final class Builder {
        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTotalPriceStatus(int totalPriceStatus) {
            void var1_1;
            TransactionInfo.this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTotalPrice(@NonNull String totalPrice) {
            void var1_1;
            TransactionInfo.this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCurrencyCode(@NonNull String currencyCode) {
            void var1_1;
            TransactionInfo.this.zzc = var1_1;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NonNull
        public TransactionInfo build() {
            TransactionInfo transactionInfo = TransactionInfo.this;
            Preconditions.checkNotEmpty((String)transactionInfo.zzc, (Object)"currencyCode must be set!");
            int n = transactionInfo.zza;
            if (n != 1) {
                if (n != 2) {
                    if (n != 3) {
                        throw new IllegalArgumentException("totalPriceStatus must be set to one of WalletConstants.TotalPriceStatus!");
                    }
                } else {
                    Preconditions.checkNotEmpty((String)transactionInfo.zzb, (Object)"An estimated total price must be set if totalPriceStatus is set to WalletConstants.TOTAL_PRICE_STATUS_ESTIMATED!");
                }
            }
            if (transactionInfo.zza == 3) {
                Preconditions.checkNotEmpty((String)transactionInfo.zzb, (Object)"An final total price must be set if totalPriceStatus is set to WalletConstants.TOTAL_PRICE_STATUS_FINAL!");
            }
            return transactionInfo;
        }

        /* synthetic */ Builder(byte[] byArray) {
            Objects.requireNonNull(TransactionInfo.this);
        }
    }
}

