/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.Cart;
import com.google.android.gms.wallet.zzas;
import java.util.Objects;

@ShowFirstParty
@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="WebPaymentDataRequestCreator")
public final class WebPaymentDataRequest
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @NonNull
    public static final Parcelable.Creator<WebPaymentDataRequest> CREATOR = new zzas();
    @SafeParcelable.Field(id=2)
    Cart zza;
    @SafeParcelable.Field(id=3)
    String zzb;
    @SafeParcelable.Field(id=4)
    String zzc;
    @SafeParcelable.Field(id=6)
    @Nullable
    byte[] zzd;
    @SafeParcelable.Field(id=7)
    boolean zze;
    @SafeParcelable.Field(id=5)
    @Nullable
    Bundle zzf;

    @SafeParcelable.Constructor
    WebPaymentDataRequest(@SafeParcelable.Param(id=2) Cart cart, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) String string2, @SafeParcelable.Param(id=6) byte[] byArray, @SafeParcelable.Param(id=7) boolean bl, @SafeParcelable.Param(id=5) @Nullable Bundle bundle) {
        this.zza = cart;
        this.zzb = string;
        this.zzc = string2;
        this.zzd = byArray;
        this.zze = bl;
        this.zzf = bundle;
    }

    private WebPaymentDataRequest() {
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeParcelable((Parcel)parcel, (int)2, (Parcelable)this.zza, (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)3, (String)this.zzb, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)4, (String)this.zzc, (boolean)false);
        SafeParcelWriter.writeBundle((Parcel)parcel, (int)5, (Bundle)this.zzf, (boolean)false);
        SafeParcelWriter.writeByteArray((Parcel)parcel, (int)6, (byte[])this.zzd, (boolean)false);
        Parcel parcel2 = parcel;
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)7, (boolean)this.zze);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @NonNull
    public Cart getCart() {
        return this.zza;
    }

    @NonNull
    public String getMerchantOrigin() {
        return this.zzb;
    }

    @NonNull
    public String getWalletParameters() {
        return this.zzc;
    }

    @Nullable
    public byte[] getEncryptedParameters() {
        Object this_ = this_.zzd;
        if (this_ != null && ((WebPaymentDataRequest)this_).length > 0) {
            return this_;
        }
        return null;
    }

    @Nullable
    public Boolean getUseChromiumPaymentDetailsUpdate() {
        return this.zze;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public WebPaymentDataRequest withSavedState(@Nullable Bundle savedState) {
        void var1_1;
        this.zzf = var1_1;
        return this;
    }

    @Nullable
    public Bundle getSavedState() {
        return this.zzf;
    }

    @NonNull
    public static Builder newBuilder() {
        Builder builder = new WebPaymentDataRequest().new Builder(null);
        builder.setUseChromiumPaymentDetailsUpdate(false);
        return builder;
    }

    public final class Builder {
        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCart(@NonNull Cart cart) {
            void var1_1;
            WebPaymentDataRequest.this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setMerchantOrigin(@NonNull String merchantOrigin) {
            void var1_1;
            WebPaymentDataRequest.this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setWalletParameters(@NonNull String walletParameters) {
            void var1_1;
            WebPaymentDataRequest.this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setEncryptedParameters(@NonNull byte[] encryptedParameters) {
            void var1_1;
            WebPaymentDataRequest.this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setUseChromiumPaymentDetailsUpdate(boolean useChromiumPaymentDetailsUpdate) {
            void var1_1;
            WebPaymentDataRequest.this.zze = var1_1;
            return this;
        }

        @NonNull
        public WebPaymentDataRequest build() {
            return WebPaymentDataRequest.this;
        }

        /* synthetic */ Builder(byte[] byArray) {
            Objects.requireNonNull(WebPaymentDataRequest.this);
        }
    }
}

