/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.button;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.wallet.R;
import com.google.android.gms.wallet.button.ButtonOptions;
import com.google.android.gms.wallet.button.zzd;
import com.google.android.gms.wallet.button.zze;
import com.google.android.gms.wallet.button.zzf;
import com.google.android.gms.wallet.button.zzg;

public final class PayButton
extends FrameLayout
implements View.OnClickListener {
    @Nullable
    private View.OnClickListener zza;
    private ButtonOptions.Builder zzb;
    @Nullable
    private View zzc;

    /*
     * WARNING - void declaration
     */
    public PayButton(@NonNull Context context) {
        this((Context)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PayButton(@NonNull Context context, @Nullable AttributeSet attrs) {
        this((Context)var1_1, (AttributeSet)var2_2, 0);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PayButton(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super((Context)typedArray, (AttributeSet)var2_2, (int)var3_4);
        void var3_4;
        void var2_2;
        TypedArray typedArray;
        ButtonOptions.Builder builder = this.zzb = ButtonOptions.newBuilder();
        typedArray = typedArray.obtainStyledAttributes((AttributeSet)var2_2, R.styleable.PayButtonAttributes);
        int n = typedArray.getInt(R.styleable.PayButtonAttributes_buttonTheme, 1);
        int n2 = (int)TypedValue.applyDimension((int)1, (float)100.0f, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
        ButtonOptions buttonOptions = builder.ButtonOptions.this;
        buttonOptions.zzb = n;
        buttonOptions.zzc = typedArray.getDimensionPixelSize(R.styleable.PayButtonAttributes_cornerRadius, n2);
        if (typedArray.hasValue(R.styleable.PayButtonAttributes_cornerRadius)) {
            builder.ButtonOptions.this.zze = true;
        }
        typedArray.recycle();
        builder.setButtonType(1);
        if (this.isInEditMode()) {
            PayButton payButton = this;
            payButton.zza(payButton.zzb.build());
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void initialize(@NonNull ButtonOptions options) {
        View view;
        Object object = this.zzb;
        if (view.getButtonType() != 0) {
            ((ButtonOptions.Builder)object).ButtonOptions.this.zza = view.getButtonType();
        }
        if (view.getButtonTheme() != 0) {
            ((ButtonOptions.Builder)object).ButtonOptions.this.zzb = view.getButtonTheme();
        }
        if (view.zze) {
            ((ButtonOptions.Builder)object).setCornerRadius(view.getCornerRadius());
        }
        if (view.getAllowedPaymentMethods() != null) {
            ((ButtonOptions.Builder)object).ButtonOptions.this.zzd = view.getAllowedPaymentMethods();
        }
        if (this.isInEditMode()) {
            PayButton payButton = this;
            payButton.zza(payButton.zzb.build());
            return;
        }
        this.removeAllViews();
        object = this.zzb.build();
        if (((ButtonOptions)((Object)object)).zza == 9 && GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(this.getContext(), 241500000) != 0) {
            this.removeAllViews();
            int n = ((ButtonOptions)((Object)object)).getButtonTheme() == 2 ? R.style.PayButtonGenericLightTheme : R.style.PayButtonGenericDarkTheme;
            ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper(this.getContext(), n);
            zzf zzf2 = new zzf((Context)contextThemeWrapper, null);
            ((LinearLayout)LayoutInflater.from((Context)zzf2.getContext()).inflate(R.layout.pay_button_pix_static, (ViewGroup)zzf2, true).findViewById(R.id.pay_button_view)).setBackground(zzg.zza(zzf2.getContext(), ((ButtonOptions)((Object)object)).getCornerRadius()));
            zzf zzf3 = zzf2;
            zzf3.setContentDescription(zzf3.getContext().getString(R.string.direct_pix_payment));
            this.zzc = zzf2;
            PayButton payButton = this;
            payButton.addView(payButton.zzc);
            this.zzc.setOnClickListener((View.OnClickListener)this);
            Log.e((String)"PayButton", (String)"Failed to create latest PIX buttonView: Google Play Services version is outdated.");
            return;
        }
        if (GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(this.getContext(), 232100000) != 0) {
            this.zza((ButtonOptions)((Object)object));
            Log.e((String)"PayButton", (String)"Failed to create latest buttonView: Google Play Services version is outdated.");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)((ButtonOptions)((Object)object)).getAllowedPaymentMethods())) {
            Log.e((String)"PayButton", (String)"Failed to create buttonView: allowedPaymentMethods cannot be empty.");
            return;
        }
        this.zzc = zzd.zza((Context)Preconditions.checkNotNull((Object)this.getContext()), (ButtonOptions)((Object)object));
        view = this.zzc;
        if (view == null) {
            Log.e((String)"PayButton", (String)"Failed to create buttonView");
            return;
        }
        this.addView(view);
        this.zzc.setOnClickListener((View.OnClickListener)this);
    }

    /*
     * WARNING - void declaration
     */
    public void setOnClickListener(@Nullable View.OnClickListener listener) {
        void var1_1;
        this.zza = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void onClick(@NonNull View view) {
        void var1_1;
        View.OnClickListener onClickListener = this.zza;
        if (onClickListener != null && var1_1 == this.zzc) {
            onClickListener.onClick((View)this);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zza(ButtonOptions buttonOptions) {
        this.removeAllViews();
        int n = buttonOptions.getButtonTheme() == 2 ? R.style.PayButtonGenericLightTheme : R.style.PayButtonGenericDarkTheme;
        ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper(this.getContext(), n);
        zze zze2 = new zze((Context)contextThemeWrapper, null);
        ((LinearLayout)LayoutInflater.from((Context)zze2.getContext()).inflate(R.layout.paybutton_generic, (ViewGroup)zze2, true).findViewById(R.id.pay_button_view)).setBackground(zzg.zza(zze2.getContext(), buttonOptions.getCornerRadius()));
        zze zze3 = zze2;
        zze3.setContentDescription(zze3.getContext().getString(R.string.gpay_logo_description));
        this.zzc = zze2;
        PayButton payButton = this;
        payButton.addView(payButton.zzc);
        this.zzc.setOnClickListener((View.OnClickListener)this);
    }
}

