/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.firstparty.saveinstrument;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.firstparty.saveinstrument.zza;
import java.util.Objects;

@ShowFirstParty
@SafeParcelable.Class(creator="CardCreator")
public class Card
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<Card> CREATOR = new zza();
    @SafeParcelable.Field(id=1)
    String zza;
    @SafeParcelable.Field(id=2)
    String zzb;
    @SafeParcelable.Field(id=3)
    int zzc;
    @SafeParcelable.Field(id=4)
    int zzd;

    @NonNull
    public static Builder newBuilder() {
        return new Card().new Builder(null);
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)1, (String)this.zza, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.zzb, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)3, (int)this.zzc);
        void v1 = var1_1;
        SafeParcelWriter.writeInt((Parcel)v1, (int)4, (int)this.zzd);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    /*
     * WARNING - void declaration
     */
    @SafeParcelable.Constructor
    public Card(@SafeParcelable.Param(id=1) @NonNull String pan, @SafeParcelable.Param(id=2) @NonNull String cvc, @SafeParcelable.Param(id=3) int expMonth, @SafeParcelable.Param(id=4) int expYear) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza = var1_1;
        this.zzb = var2_2;
        this.zzc = var3_3;
        this.zzd = var4_4;
    }

    private Card() {
    }

    @NonNull
    public String getPan() {
        return this.zza.replaceAll("[\\s\\-]", "");
    }

    @NonNull
    public String getCvc() {
        String this_ = ((Card)((Object)this_)).zzb;
        if (this_ != null) {
            return this_.replaceAll("[\\s\\-]", "");
        }
        return "";
    }

    public int getExpirationDateMonth() {
        return this.zzc;
    }

    public int getExpirationDateYear() {
        return this.zzd;
    }

    public final class Builder {
        @NonNull
        public Card build() {
            Card card = Card.this;
            Preconditions.checkArgument((boolean)(TextUtils.isEmpty((CharSequence)card.zza) ^ true), (Object)"PAN is required.");
            return card;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPan(@NonNull String pan) {
            void var1_1;
            Preconditions.checkArgument((boolean)(TextUtils.isEmpty((CharSequence)pan) ^ true), (Object)"Empty PAN not allowed.");
            String string2 = "[\\s\\-]";
            String string3 = "";
            Card.this.zza = var1_1.replaceAll(string2, string3);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCvc(@NonNull String cvc) {
            if (!TextUtils.isEmpty((CharSequence)cvc)) {
                void var1_1;
                Card.this.zzb = var1_1.replaceAll("[\\s\\-]", "");
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setExpirationDateMonth(int month) {
            void var1_1;
            Card.this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setExpirationDateYear(int year) {
            void var1_1;
            Card.this.zzd = var1_1;
            return this;
        }

        /* synthetic */ Builder(byte[] byArray) {
            Objects.requireNonNull(Card.this);
        }
    }
}

