/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.internal;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.BooleanResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClient;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.wallet.AutoResolvableVoidResult;
import com.google.android.gms.wallet.CreateWalletObjectsRequest;
import com.google.android.gms.wallet.FullWalletRequest;
import com.google.android.gms.wallet.IsReadyToPayRequest;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.PaymentCardRecognitionIntentRequest;
import com.google.android.gms.wallet.PaymentCardRecognitionIntentResponse;
import com.google.android.gms.wallet.PaymentData;
import com.google.android.gms.wallet.PaymentDataRequest;
import com.google.android.gms.wallet.PaymentMetadata;
import com.google.android.gms.wallet.PaymentMetadataRequest;
import com.google.android.gms.wallet.WebPaymentDataRequest;
import com.google.android.gms.wallet.firstparty.ExecuteBuyFlowRequest;
import com.google.android.gms.wallet.firstparty.GetBuyFlowInitializationTokenRequest;
import com.google.android.gms.wallet.firstparty.GetBuyFlowInitializationTokenResponse;
import com.google.android.gms.wallet.firstparty.GetClientTokenRequest;
import com.google.android.gms.wallet.firstparty.GetClientTokenResponse;
import com.google.android.gms.wallet.firstparty.InitializeBuyFlowRequest;
import com.google.android.gms.wallet.firstparty.SetUpBiometricAuthenticationKeysRequest;
import com.google.android.gms.wallet.firstparty.SetUpBiometricAuthenticationKeysResponse;
import com.google.android.gms.wallet.firstparty.WarmUpUiProcessRequest;
import com.google.android.gms.wallet.firstparty.WarmUpUiProcessResponse;
import com.google.android.gms.wallet.firstparty.setupwizard.GetSetupWizardIntentRequest;
import com.google.android.gms.wallet.internal.IOwService;
import com.google.android.gms.wallet.internal.zza;
import com.google.android.gms.wallet.internal.zzc;
import com.google.android.gms.wallet.internal.zzd;
import com.google.android.gms.wallet.internal.zze;
import com.google.android.gms.wallet.internal.zzf;
import com.google.android.gms.wallet.internal.zzg;
import com.google.android.gms.wallet.internal.zzh;
import com.google.android.gms.wallet.internal.zzi;
import com.google.android.gms.wallet.internal.zzj;
import com.google.android.gms.wallet.internal.zzl;
import com.google.android.gms.wallet.internal.zzm;
import com.google.android.gms.wallet.internal.zzn;
import com.google.android.gms.wallet.internal.zzo;
import com.google.android.gms.wallet.internal.zzp;
import com.google.android.gms.wallet.internal.zzs;
import com.google.android.gms.wallet.zzk;
import com.google.android.gms.wallet.zzq;
import com.google.android.gms.wallet.zzr;

public class WalletClientImpl
extends GmsClient<IOwService> {
    @NonNull
    public static final String SERVICE_ACTION = "com.google.android.gms.wallet.service.BIND";
    private final Context zze;
    private final int zzf;
    @Nullable
    private final String zzg;
    private final int zzh;
    private final boolean zzi;
    private final String zzj;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public WalletClientImpl(@NonNull Context context, @NonNull Looper looper, @NonNull ClientSettings commonSettings, @NonNull GoogleApiClient.ConnectionCallbacks connectedListener, @NonNull GoogleApiClient.OnConnectionFailedListener connectionFailedListener, int environment, int theme, boolean usingAndroidPayBrand, @NonNull String walletClientId) {
        super((Context)var1_1, (Looper)var2_6, 4, (ClientSettings)var3_7, (GoogleApiClient.ConnectionCallbacks)var4_8, (GoogleApiClient.OnConnectionFailedListener)var5_9);
        void var9_13;
        void var8_12;
        void var7_11;
        void var1_4;
        void var6_10;
        void var5_9;
        void var4_8;
        void var3_7;
        void var2_6;
        void var1_1;
        this.zze = var1_1;
        this.zzf = var6_10;
        Account account = var3_7.getAccount();
        if (account != null) {
            String string2 = account.name;
        } else {
            Object var1_5 = null;
        }
        this.zzg = var1_4;
        this.zzh = var7_11;
        this.zzi = var8_12;
        this.zzj = var9_13;
    }

    public boolean requiresAccount() {
        return true;
    }

    @NonNull
    protected String getStartServiceAction() {
        return SERVICE_ACTION;
    }

    @NonNull
    protected String getServiceDescriptor() {
        return "com.google.android.gms.wallet.internal.IOwService";
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    protected IOwService createServiceInterface(@NonNull IBinder binder) {
        void var1_6;
        void var0_2;
        if (binder == null) {
            return var0_2;
        }
        IInterface iInterface = var1_6.queryLocalInterface("com.google.android.gms.wallet.internal.IOwService");
        if (iInterface instanceof IOwService) {
            IOwService iOwService = (IOwService)iInterface;
            return var0_2;
        }
        zza zza2 = new zza((IBinder)var1_6);
        return var0_2;
    }

    /*
     * WARNING - void declaration
     */
    public void checkForPreAuthorization(int requestCode) {
        void var1_2;
        Context context = this.zze;
        Bundle bundle = this.zzp();
        zzc zzc2 = new zzc((Activity)context, (int)var1_2);
        try {
            ((IOwService)this.getService()).checkForPreAuthorization(bundle, zzc2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during checkForPreAuthorization", (Throwable)remoteException);
            ((zzd)zzc2).onPreAuthorizationDetermined(8, false, Bundle.EMPTY);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void checkForPreAuthorization(@NonNull TaskCompletionSource<Boolean> completionSource) throws RemoteException {
        void var1_2;
        zze zze2 = new zze((TaskCompletionSource)var1_2);
        try {
            ((IOwService)this.getService()).checkForPreAuthorization(this.zzp(), zze2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during checkForPreAuthorization", (Throwable)remoteException);
            ((zzd)zze2).onPreAuthorizationDetermined(8, false, Bundle.EMPTY);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void changeMaskedWallet(@NonNull String googleTransactionId, @NonNull String merchantTransactionId, int requestCode) {
        void var3_3;
        void var2_2;
        void var1_1;
        WalletClientImpl walletClientImpl = this;
        walletClientImpl.changeMaskedWallet((Activity)walletClientImpl.zze, (String)var1_1, (String)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void changeMaskedWallet(@NonNull Activity activity, @NonNull String googleTransactionId, @Nullable String merchantTransactionId, int requestCode) {
        void var4_5;
        void var1_2;
        Bundle bundle = this.zzp();
        zzc zzc2 = new zzc((Activity)var1_2, (int)var4_5);
        try {
            void var3_4;
            void var2_3;
            ((IOwService)this.getService()).changeMaskedWallet((String)var2_3, (String)var3_4, bundle, zzc2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException changing masked wallet", (Throwable)remoteException);
            ((zzd)zzc2).onMaskedWalletLoaded(8, null, Bundle.EMPTY);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void loadMaskedWallet(@NonNull MaskedWalletRequest request, int requestCode) {
        void var2_2;
        void var1_1;
        WalletClientImpl walletClientImpl = this;
        walletClientImpl.loadMaskedWallet((Activity)walletClientImpl.zze, (MaskedWalletRequest)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void loadMaskedWallet(@NonNull Activity activity, @NonNull MaskedWalletRequest request, int requestCode) {
        void var3_4;
        void var1_2;
        Bundle bundle = this.zzp();
        zzc zzc2 = new zzc((Activity)var1_2, (int)var3_4);
        try {
            void var2_3;
            ((IOwService)this.getService()).getMaskedWalletForPreauthorizedBuyer((MaskedWalletRequest)var2_3, bundle, zzc2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting masked wallet", (Throwable)remoteException);
            ((zzd)zzc2).onMaskedWalletLoaded(8, null, Bundle.EMPTY);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void loadFullWallet(@NonNull FullWalletRequest request, int requestCode) {
        void var2_2;
        void var1_1;
        WalletClientImpl walletClientImpl = this;
        walletClientImpl.loadFullWallet((Activity)walletClientImpl.zze, (FullWalletRequest)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void loadFullWallet(@NonNull Activity activity, @NonNull FullWalletRequest request, int requestCode) {
        void var3_4;
        Bundle bundle;
        zzc zzc2 = new zzc((Activity)bundle, (int)var3_4);
        bundle = this.zzp();
        try {
            void var2_3;
            ((IOwService)this.getService()).getFullWallet((FullWalletRequest)var2_3, bundle, zzc2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting full wallet", (Throwable)remoteException);
            ((zzd)zzc2).onFullWalletLoaded(8, null, Bundle.EMPTY);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void createWalletObjects(@NonNull CreateWalletObjectsRequest request, int requestCode) {
        void var2_3;
        Context context = this.zze;
        zzc zzc2 = new zzc((Activity)context, (int)var2_3);
        Bundle bundle = this.zzp();
        try {
            void var1_2;
            ((IOwService)this.getService()).createWalletObjects((CreateWalletObjectsRequest)var1_2, bundle, zzc2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException creating wallet objects", (Throwable)remoteException);
            ((zzd)zzc2).onWalletObjectsCreated(8, Bundle.EMPTY);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void createWalletObjects(@NonNull CreateWalletObjectsRequest request, @NonNull TaskCompletionSource<AutoResolvableVoidResult> taskCompletionSource) {
        void var2_3;
        Bundle bundle = this.zzp();
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_AUTO_RESOLVABLE_RESULT", true);
        zzf zzf2 = new zzf((TaskCompletionSource)var2_3);
        try {
            void var1_2;
            ((IOwService)this.getService()).createWalletObjects((CreateWalletObjectsRequest)var1_2, bundle, zzf2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException creating wallet objects", (Throwable)remoteException);
            ((zzd)zzf2).onWalletObjectsCreated(8, Bundle.EMPTY);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void isReadyToPay(@NonNull IsReadyToPayRequest request, @NonNull BaseImplementation.ResultHolder<BooleanResult> resultHolder) {
        Bundle bundle;
        zzn zzn2 = new zzn((BaseImplementation.ResultHolder)bundle);
        bundle = this.zzp();
        try {
            void var1_2;
            ((IOwService)this.getService()).isReadyToPay((IsReadyToPayRequest)var1_2, bundle, zzn2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during isReadyToPay", (Throwable)remoteException);
            ((zzd)zzn2).onIsReadyToPayDetermined(Status.RESULT_INTERNAL_ERROR, false, Bundle.EMPTY);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void isReadyToPay(@NonNull IsReadyToPayRequest request, @NonNull TaskCompletionSource<Boolean> completionSource) throws RemoteException {
        void var2_3;
        zze zze2 = new zze((TaskCompletionSource)var2_3);
        try {
            void var1_2;
            ((IOwService)this.getService()).isReadyToPay((IsReadyToPayRequest)var1_2, this.zzp(), zze2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during isReadyToPay", (Throwable)remoteException);
            ((zzd)zze2).onIsReadyToPayDetermined(Status.RESULT_INTERNAL_ERROR, false, Bundle.EMPTY);
            return;
        }
    }

    public void newIsReadyToPay(@NonNull IsReadyToPayRequest request, @NonNull TaskCompletionSource<zzr> completionSource) throws RemoteException {
        byte[] byArray;
        Bundle bundle;
        com.google.android.gms.wallet.internal.zzq zzq2 = new com.google.android.gms.wallet.internal.zzq((TaskCompletionSource)bundle);
        bundle = this.zzp();
        bundle.putBoolean("com.google.android.gms.wallet.EXPECT_IS_READY_TO_PAY_RESPONSE_OBJECT", true);
        try {
            ((IOwService)this.getService()).isReadyToPay((IsReadyToPayRequest)byArray, bundle, zzq2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during isReadyToPay", (Throwable)remoteException);
            zzq zzq3 = zzr.zza();
            zzq3.zza(false);
            Bundle bundle2 = new Bundle();
            byArray = SafeParcelableSerializer.serializeToBytes((SafeParcelable)zzq3.zzb());
            bundle2.putByteArray("com.google.android.gms.wallet.IsReadyToPayResponse", byArray);
            ((zzd)zzq2).onIsReadyToPayDetermined(Status.RESULT_INTERNAL_ERROR, false, bundle2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void getPaymentMetadata(@NonNull PaymentMetadataRequest request, @NonNull TaskCompletionSource<PaymentMetadata> completionSource) throws RemoteException {
        Bundle bundle;
        com.google.android.gms.wallet.internal.zzk zzk2 = new com.google.android.gms.wallet.internal.zzk((TaskCompletionSource)bundle);
        bundle = this.zzp();
        int n = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(this.getContext(), 252400000);
        if (n != 0) {
            Log.e((String)"WalletClientImpl", (String)"Google Play Services version < Y2025W24");
            ((zzd)zzk2).onPaymentMetadataLoaded(new Status(new ConnectionResult(n), "Minimum required version of Google Play Services is unavailable."), null, Bundle.EMPTY);
            return;
        }
        try {
            void var1_2;
            ((IOwService)this.getService()).getPaymentMetadata((PaymentMetadataRequest)var1_2, bundle, zzk2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting payment data", (Throwable)remoteException);
            ((zzd)zzk2).onPaymentMetadataLoaded(Status.RESULT_INTERNAL_ERROR, null, Bundle.EMPTY);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void getBuyFlowInitializationToken(@NonNull GetBuyFlowInitializationTokenRequest request, @NonNull BaseImplementation.ResultHolder resultHolder) {
        Bundle bundle;
        zzh zzh2 = new zzh((BaseImplementation.ResultHolder)bundle);
        bundle = this.zzp();
        try {
            void var1_3;
            ((IOwService)this.getService()).getBuyFlowInitializationToken((GetBuyFlowInitializationTokenRequest)var1_3, bundle, zzh2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting buyflow initialization token", (Throwable)remoteException);
            GetBuyFlowInitializationTokenResponse getBuyFlowInitializationTokenResponse = new GetBuyFlowInitializationTokenResponse(new byte[0]);
            ((zzd)zzh2).onBuyFlowInitializationTokenReceived(Status.RESULT_INTERNAL_ERROR, getBuyFlowInitializationTokenResponse, Bundle.EMPTY);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void initializeBuyFlow(@NonNull InitializeBuyFlowRequest request, @NonNull BaseImplementation.ResultHolder<Status> resultHolder) {
        Bundle bundle;
        zzm zzm2 = new zzm((BaseImplementation.ResultHolder)bundle);
        bundle = this.zzp();
        try {
            void var1_2;
            ((IOwService)this.getService()).initializeBuyFlow((InitializeBuyFlowRequest)var1_2, bundle, zzm2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException initializing buyflow", (Throwable)remoteException);
            ((zzd)zzm2).onInitializeBuyFlowStatusReceived(Status.RESULT_INTERNAL_ERROR, Bundle.EMPTY);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void executeBuyFlow(@NonNull ExecuteBuyFlowRequest request, @NonNull BaseImplementation.ResultHolder resultHolder) {
        Bundle bundle;
        zzg zzg2 = new zzg((BaseImplementation.ResultHolder)bundle);
        bundle = this.zzp();
        try {
            void var1_2;
            ((IOwService)this.getService()).executeBuyFlow((ExecuteBuyFlowRequest)var1_2, bundle, zzg2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException executing buyflow", (Throwable)remoteException);
            ((zzd)zzg2).onExecuteBuyFlowStatusReceived(Status.RESULT_INTERNAL_ERROR, Bundle.EMPTY);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void getClientToken(@NonNull GetClientTokenRequest request, @NonNull BaseImplementation.ResultHolder resultHolder) {
        Bundle bundle;
        zzi zzi2 = new zzi((BaseImplementation.ResultHolder)bundle);
        bundle = this.zzp();
        try {
            void var1_2;
            ((IOwService)this.getService()).getClientToken((GetClientTokenRequest)var1_2, bundle, zzi2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting client token", (Throwable)remoteException);
            ((zzd)zzi2).onClientTokenReceived(Status.RESULT_INTERNAL_ERROR, new GetClientTokenResponse(new byte[0]), Bundle.EMPTY);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void loadWebPaymentData(@NonNull WebPaymentDataRequest request, @NonNull BaseImplementation.ResultHolder resultHolder) {
        void var2_3;
        Bundle bundle = this.zzp();
        zzp zzp2 = new zzp((BaseImplementation.ResultHolder)var2_3);
        try {
            void var1_2;
            ((IOwService)this.getService()).loadWebPaymentData((WebPaymentDataRequest)var1_2, bundle, zzp2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting web payment data", (Throwable)remoteException);
            ((zzd)zzp2).onWebPaymentDataLoaded(Status.RESULT_INTERNAL_ERROR, null, Bundle.EMPTY);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void loadPaymentData(@NonNull PaymentDataRequest request, @NonNull TaskCompletionSource<PaymentData> completionSource) {
        void var2_3;
        Bundle bundle = this.zzp();
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_AUTO_RESOLVABLE_RESULT", true);
        zzo zzo2 = new zzo((TaskCompletionSource)var2_3);
        try {
            void var1_2;
            ((IOwService)this.getService()).loadPaymentData((PaymentDataRequest)var1_2, bundle, zzo2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting payment data", (Throwable)remoteException);
            ((zzd)zzo2).onPaymentDataLoaded(Status.RESULT_INTERNAL_ERROR, null, Bundle.EMPTY);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setUpBiometricAuthenticationKeys(@NonNull TaskCompletionSource<SetUpBiometricAuthenticationKeysResponse> completionSource) {
        void var1_2;
        Bundle bundle = this.zzp();
        com.google.android.gms.wallet.internal.zzr zzr2 = new com.google.android.gms.wallet.internal.zzr((TaskCompletionSource)var1_2);
        try {
            ((IOwService)this.getService()).setUpBiometricAuthenticationKeys(new SetUpBiometricAuthenticationKeysRequest(), bundle, zzr2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during setUpBiometricAuthenticationKeys", (Throwable)remoteException);
            ((zzd)zzr2).onBiometricAuthenticationKeysSetUp(Status.RESULT_INTERNAL_ERROR, null, Bundle.EMPTY);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void warmUpUiProcess(@NonNull TaskCompletionSource<WarmUpUiProcessResponse> completionSource) {
        void var1_2;
        Bundle bundle = this.zzp();
        zzs zzs2 = new zzs((TaskCompletionSource)var1_2);
        try {
            ((IOwService)this.getService()).warmUpUiProcess(new WarmUpUiProcessRequest(), bundle, zzs2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during warmUpUiProcess", (Throwable)remoteException);
            ((zzd)zzs2).onWarmUpUiProcessResponseReceived(Status.RESULT_INTERNAL_ERROR, null, Bundle.EMPTY);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void getSetupWizardIntent(@NonNull GetSetupWizardIntentRequest request, @NonNull TaskCompletionSource<AutoResolvableVoidResult> completionSource) {
        void var2_3;
        Bundle bundle = this.zzp();
        zzl zzl2 = new zzl((TaskCompletionSource)var2_3);
        try {
            void var1_2;
            ((IOwService)this.getService()).getSetupWizardIntent((GetSetupWizardIntentRequest)var1_2, bundle, zzl2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during getSetupWizardIntent", (Throwable)remoteException);
            ((zzd)zzl2).onSetupWizardIntentReceived(8, Bundle.EMPTY);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void getPaymentCardRecognitionIntent(@NonNull PaymentCardRecognitionIntentRequest request, @NonNull TaskCompletionSource<PaymentCardRecognitionIntentResponse> completionSource) {
        void var2_3;
        Bundle bundle = this.zzp();
        zzj zzj2 = new zzj((TaskCompletionSource)var2_3);
        try {
            void var1_2;
            ((IOwService)this.getService()).getPaymentCardRecognitionIntent((PaymentCardRecognitionIntentRequest)var1_2, bundle, zzj2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during getPaymentCardRecognitionIntent", (Throwable)remoteException);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static Bundle buildParameters(int environment, @NonNull String packageName, @Nullable String accountName, int theme, boolean usingAndroidPayBrand, @NonNull String walletClientId) {
        void var5_6;
        void var3_4;
        void var2_3;
        Account account;
        void var4_5;
        int n;
        Bundle bundle = new Bundle();
        bundle.putInt("com.google.android.gms.wallet.EXTRA_ENVIRONMENT", n);
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_ANDROID_PAY_BRAND", (boolean)var4_5);
        bundle.putString("androidPackageName", (String)account);
        if (!TextUtils.isEmpty((CharSequence)var2_3)) {
            String string2 = "com.google";
            account = new Account((String)var2_3, string2);
            bundle.putParcelable("com.google.android.gms.wallet.EXTRA_BUYER_ACCOUNT", (Parcelable)account);
        }
        bundle.putInt("com.google.android.gms.wallet.EXTRA_THEME", (int)var3_4);
        bundle.putString("com.google.android.gms.wallet.EXTRA_WALLET_CLIENT_ID", (String)var5_6);
        return bundle;
    }

    public int getMinApkVersion() {
        return 12600000;
    }

    @NonNull
    public Feature[] getApiFeatures() {
        return zzk.zzi;
    }

    public boolean usesClientTelemetry() {
        return true;
    }

    private final Bundle zzp() {
        Context context = this.zze;
        return WalletClientImpl.buildParameters(this.zzf, context.getPackageName(), this.zzg, this.zzh, this.zzi, this.zzj);
    }
}

