/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.internal;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.wallet.FullWallet;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.internal.zzd;
import java.lang.ref.WeakReference;

final class zzc
extends zzd {
    private final WeakReference zza;
    private final int zzb;

    public zzc(Activity activity, int n) {
        this.zza = new WeakReference<Activity>(activity);
        this.zzb = n;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void onMaskedWalletLoaded(int n, @Nullable MaskedWallet maskedWallet, Bundle object) {
        Activity activity = (Activity)this.zza.get();
        if (activity == null) {
            Log.d((String)"WalletClientImpl", (String)"Ignoring onMaskedWalletLoaded, Activity has gone");
            return;
        }
        ConnectionResult connectionResult = new ConnectionResult(n, (PendingIntent)(object = object != null ? (PendingIntent)object.getParcelable("com.google.android.gms.wallet.EXTRA_PENDING_INTENT") : null));
        if (connectionResult.hasResolution()) {
            connectionResult.startResolutionForResult(activity, this.zzb);
            return;
        }
        object = new Intent();
        if (connectionResult.isSuccess()) {
            object.putExtra("com.google.android.gms.wallet.EXTRA_MASKED_WALLET", (Parcelable)maskedWallet);
            n = -1;
        } else {
            int n2 = n == 408 ? 0 : 1;
            object.putExtra("com.google.android.gms.wallet.EXTRA_ERROR_CODE", n);
            n = n2;
        }
        if ((this = activity.createPendingResult(this.zzb, (Intent)object, 0x40000000)) == null) {
            Log.w((String)"WalletClientImpl", (String)"Null pending result returned for onMaskedWalletLoaded");
            return;
        }
        try {
            this.send(n);
            return;
        }
        catch (PendingIntent.CanceledException canceledException) {
            Log.w((String)"WalletClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
            return;
        }
        catch (IntentSender.SendIntentException sendIntentException) {
            Log.w((String)"WalletClientImpl", (String)"Exception starting pending intent", (Throwable)sendIntentException);
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void onFullWalletLoaded(int n, @Nullable FullWallet fullWallet, Bundle object) {
        Activity activity = (Activity)this.zza.get();
        if (activity == null) {
            Log.d((String)"WalletClientImpl", (String)"Ignoring onFullWalletLoaded, Activity has gone");
            return;
        }
        ConnectionResult connectionResult = new ConnectionResult(n, (PendingIntent)(object = object != null ? (PendingIntent)object.getParcelable("com.google.android.gms.wallet.EXTRA_PENDING_INTENT") : null));
        if (connectionResult.hasResolution()) {
            connectionResult.startResolutionForResult(activity, this.zzb);
            return;
        }
        object = new Intent();
        if (connectionResult.isSuccess()) {
            object.putExtra("com.google.android.gms.wallet.EXTRA_FULL_WALLET", (Parcelable)fullWallet);
            n = -1;
        } else {
            int n2 = n == 408 ? 0 : 1;
            object.putExtra("com.google.android.gms.wallet.EXTRA_ERROR_CODE", n);
            n = n2;
        }
        if ((this = activity.createPendingResult(this.zzb, (Intent)object, 0x40000000)) == null) {
            Log.w((String)"WalletClientImpl", (String)"Null pending result returned for onFullWalletLoaded");
            return;
        }
        try {
            this.send(n);
            return;
        }
        catch (PendingIntent.CanceledException canceledException) {
            Log.w((String)"WalletClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
            return;
        }
        catch (IntentSender.SendIntentException sendIntentException) {
            Log.w((String)"WalletClientImpl", (String)"Exception starting pending intent", (Throwable)sendIntentException);
            return;
        }
    }

    @Override
    public final void onPreAuthorizationDetermined(int n, boolean bl, Bundle bundle) {
        Activity activity = (Activity)zzc2.zza.get();
        if (activity == null) {
            Log.d((String)"WalletClientImpl", (String)"Ignoring onPreAuthorizationDetermined, Activity has gone");
            return;
        }
        bundle = new Intent();
        bundle.putExtra("com.google.android.gm.wallet.EXTRA_IS_USER_PREAUTHORIZED", bl);
        zzc zzc2 = activity.createPendingResult(zzc2.zzb, (Intent)bundle, 0x40000000);
        if (zzc2 == null) {
            Log.w((String)"WalletClientImpl", (String)"Null pending result returned for onPreAuthorizationDetermined");
            return;
        }
        try {
            zzc2.send(-1);
            return;
        }
        catch (PendingIntent.CanceledException canceledException) {
            Log.w((String)"WalletClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
            return;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public final void onWalletObjectsCreated(int n, Bundle bundle) {
        Preconditions.checkNotNull((Object)bundle, (Object)"Bundle should not be null");
        Activity activity = (Activity)zzc2.zza.get();
        if (activity == null) {
            Log.d((String)"WalletClientImpl", (String)"Ignoring onWalletObjectsCreated, Activity has gone");
            return;
        }
        ConnectionResult connectionResult = new ConnectionResult(n, (PendingIntent)(bundle = (PendingIntent)bundle.getParcelable("com.google.android.gms.wallet.EXTRA_PENDING_INTENT")));
        if (connectionResult.hasResolution()) {
            connectionResult.startResolutionForResult(activity, zzc2.zzb);
            return;
        }
        String string2 = connectionResult.toString();
        string2 = "Create Wallet Objects confirmation UI will not be shown connection result: ".concat(string2);
        Log.e((String)"WalletClientImpl", (String)string2);
        string2 = new Intent();
        string2.putExtra("com.google.android.gms.wallet.EXTRA_ERROR_CODE", 413);
        zzc zzc2 = activity.createPendingResult(zzc2.zzb, (Intent)string2, 0x40000000);
        if (zzc2 == null) {
            Log.w((String)"WalletClientImpl", (String)"Null pending result returned for onWalletObjectsCreated");
            return;
        }
        try {
            zzc2.send(1);
            return;
        }
        catch (PendingIntent.CanceledException canceledException) {
            Log.w((String)"WalletClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
            return;
        }
        catch (IntentSender.SendIntentException sendIntentException) {
            Log.w((String)"WalletClientImpl", (String)"Exception starting pending intent", (Throwable)sendIntentException);
            return;
        }
    }
}

