/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.shared;

import android.accounts.Account;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.firstparty.WalletCustomTheme;
import com.google.android.gms.wallet.shared.zza;
import java.util.Objects;
import org.checkerframework.dataflow.qual.Pure;

@SafeParcelable.Reserved(value={1})
@ShowFirstParty
@SafeParcelable.Class(creator="ApplicationParametersCreator")
public final class ApplicationParameters
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<ApplicationParameters> CREATOR = new zza();
    @SafeParcelable.Field(id=2, defaultValueUnchecked="com.google.android.gms.wallet.WalletConstants.ENVIRONMENT_PRODUCTION")
    int zza;
    @SafeParcelable.Field(id=3)
    Account zzb;
    @SafeParcelable.Field(id=4)
    Bundle zzc;
    @SafeParcelable.Field(id=5)
    boolean zzd;
    @SafeParcelable.Field(id=6, defaultValueUnchecked="com.google.android.gms.wallet.WalletConstants.THEME_LIGHT")
    int zze;
    @SafeParcelable.Field(id=7)
    @Nullable
    WalletCustomTheme zzf;
    @SafeParcelable.Field(id=8)
    int zzg;
    @SafeParcelable.Field(id=9)
    double zzh;
    @SafeParcelable.Field(id=10)
    double zzi;
    @SafeParcelable.Field(id=11)
    int zzj;
    @SafeParcelable.Field(id=12)
    int zzk;

    @SafeParcelable.Constructor
    ApplicationParameters(@SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) Account account, @SafeParcelable.Param(id=4) Bundle bundle, @SafeParcelable.Param(id=5) boolean bl, @SafeParcelable.Param(id=6) int n2, @SafeParcelable.Param(id=7) @Nullable WalletCustomTheme walletCustomTheme, @SafeParcelable.Param(id=8) int n3, @SafeParcelable.Param(id=9) double d, @SafeParcelable.Param(id=10) double d2, @SafeParcelable.Param(id=11) int n4, @SafeParcelable.Param(id=12) int n5) {
        this.zza = n;
        this.zzb = account;
        this.zzc = bundle;
        this.zzd = bl;
        this.zze = n2;
        this.zzf = walletCustomTheme;
        this.zzg = n3;
        this.zzh = d;
        this.zzi = d2;
        this.zzj = n4;
        this.zzk = n5;
    }

    ApplicationParameters() {
        this.zzd = false;
        this.zza = 1;
        this.zze = 1;
        this.zzg = 0;
        this.zzj = 0;
        this.zzk = -1;
    }

    @NonNull
    public static Builder newBuilder() {
        return new ApplicationParameters().new Builder(null);
    }

    @NonNull
    public static Builder newBuilderFrom(@NonNull ApplicationParameters appParams) {
        ApplicationParameters applicationParameters;
        Builder builder = ApplicationParameters.newBuilder();
        builder.setEnvironment(applicationParameters.getEnvironment());
        builder.setBuyerAccount(applicationParameters.getBuyerAccount());
        builder.setArgs(applicationParameters.getArgs());
        builder.setAccountSelectionAllowed(applicationParameters.isAccountSelectionAllowed());
        builder.setTheme(applicationParameters.getTheme());
        builder.setCustomTheme(applicationParameters.getWalletCustomTheme());
        builder.setButtonStyle(applicationParameters.getButtonStyle());
        builder.setPopoverInitialHeightFraction(applicationParameters.getPopoverInitialHeightFraction());
        builder.setPopoverAutoDismissThresholdFraction(applicationParameters.getPopoverAutoDismissThresholdFraction());
        builder.setPopoverLoadingStyle(applicationParameters.getPopoverLoadingStyle());
        builder.setLoadingUiStyle(applicationParameters.getLoadingUiStyle());
        return builder;
    }

    public int getEnvironment() {
        return this.zza;
    }

    @Pure
    @NonNull
    public Account getBuyerAccount() {
        return this.zzb;
    }

    public boolean isAccountSelectionAllowed() {
        return this.zzd;
    }

    public int getTheme() {
        return this.zze;
    }

    @Pure
    @Nullable
    public WalletCustomTheme getWalletCustomTheme() {
        return this.zzf;
    }

    public int getButtonStyle() {
        return this.zzg;
    }

    @Pure
    @NonNull
    public Bundle getArgs() {
        return this.zzc;
    }

    public double getPopoverInitialHeightFraction() {
        return this.zzh;
    }

    public double getPopoverAutoDismissThresholdFraction() {
        return this.zzi;
    }

    public int getPopoverLoadingStyle() {
        return this.zzj;
    }

    public int getLoadingUiStyle() {
        return this.zzk;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.zza);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)3, (Parcelable)this.zzb, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeBundle((Parcel)var1_1, (int)4, (Bundle)this.zzc, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)5, (boolean)this.zzd);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)6, (int)this.zze);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)7, (Parcelable)this.zzf, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)8, (int)this.zzg);
        SafeParcelWriter.writeDouble((Parcel)var1_1, (int)9, (double)this.zzh);
        SafeParcelWriter.writeDouble((Parcel)var1_1, (int)10, (double)this.zzi);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)11, (int)this.zzj);
        void v1 = var1_1;
        SafeParcelWriter.writeInt((Parcel)v1, (int)12, (int)this.zzk);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }

    public final class Builder {
        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setEnvironment(int environment) {
            void var1_1;
            ApplicationParameters.this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setBuyerAccount(@NonNull Account buyerAccount) {
            void var1_1;
            ApplicationParameters.this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAccountSelectionAllowed(boolean allowAccountSelection) {
            void var1_1;
            ApplicationParameters.this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTheme(int theme) {
            void var1_1;
            ApplicationParameters.this.zze = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setButtonStyle(int style2) {
            void var1_1;
            ApplicationParameters.this.zzg = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setArgs(@NonNull Bundle args) {
            void var1_1;
            ApplicationParameters.this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCustomTheme(@Nullable WalletCustomTheme theme) {
            void var1_1;
            ApplicationParameters.this.zzf = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPopoverInitialHeightFraction(double popoverInitialHeightFraction) {
            void var1_1;
            ApplicationParameters.this.zzh = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPopoverAutoDismissThresholdFraction(double popoverAutoDismissThresholdFraction) {
            void var1_1;
            ApplicationParameters.this.zzi = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPopoverLoadingStyle(int popoverLoadingStyle) {
            void var1_1;
            ApplicationParameters.this.zzj = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setLoadingUiStyle(int loadingUiStyle) {
            void var1_1;
            ApplicationParameters.this.zzk = var1_1;
            return this;
        }

        @NonNull
        public ApplicationParameters build() {
            return ApplicationParameters.this;
        }

        /* synthetic */ Builder(byte[] byArray) {
            Objects.requireNonNull(ApplicationParameters.this);
        }
    }
}

