/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.shared;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.shared.ApplicationParameters;
import com.google.android.gms.wallet.shared.zzb;
import java.util.Objects;
import java.util.UUID;
import org.checkerframework.dataflow.qual.Pure;

@SafeParcelable.Reserved(value={1})
@ShowFirstParty
@SafeParcelable.Class(creator="BuyFlowConfigCreator")
public final class BuyFlowConfig
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @NonNull
    public static final Parcelable.Creator<BuyFlowConfig> CREATOR = new zzb();
    @SafeParcelable.Field(id=2, getter="getTransactionId")
    String zza;
    @SafeParcelable.Field(id=3, getter="getApplicationParams")
    ApplicationParameters zzb;
    @SafeParcelable.Field(id=4, getter="getCallingPackage")
    String zzc;
    @SafeParcelable.Field(id=5, getter="getFlowName")
    String zzd;
    @SafeParcelable.Field(id=6, getter="getCallingAppIdentifier")
    String zze;
    @SafeParcelable.Field(id=7, getter="getSessionResumptionId")
    String zzf;
    @SafeParcelable.Field(id=8, getter="getSessionResumptionType")
    int zzg;

    @NonNull
    public static Builder newBuilder() {
        return new BuyFlowConfig().new Builder(null);
    }

    @NonNull
    public static Builder newBuilderFrom(@NonNull BuyFlowConfig config) {
        BuyFlowConfig buyFlowConfig;
        Builder builder = BuyFlowConfig.newBuilder();
        builder.setApplicationParameters(buyFlowConfig.getApplicationParams());
        builder.setCallingAppIdentifier(buyFlowConfig.getCallingAppIdentifier());
        builder.setCallingPackage(buyFlowConfig.getCallingPackage());
        builder.setFlowName(buyFlowConfig.getFlowName());
        builder.setTransactionId(buyFlowConfig.getTransactionId());
        builder.setSessionResumptionId(buyFlowConfig.getSessionResumptionId());
        builder.setSessionResumptionType(buyFlowConfig.getSessionResumptionType());
        return builder;
    }

    @SafeParcelable.Constructor
    BuyFlowConfig(@SafeParcelable.Param(id=2) String string2, @SafeParcelable.Param(id=3) ApplicationParameters applicationParameters, @SafeParcelable.Param(id=4) String string3, @SafeParcelable.Param(id=5) String string4, @SafeParcelable.Param(id=6) String string5, @SafeParcelable.Param(id=7) String string6, @SafeParcelable.Param(id=8) int n) {
        this.zza = string2;
        this.zzb = applicationParameters;
        this.zzc = string3;
        this.zzd = string4;
        this.zze = string5;
        this.zzf = string6;
        this.zzg = n;
    }

    BuyFlowConfig() {
    }

    @Pure
    @NonNull
    public String getTransactionId() {
        return this.zza;
    }

    @Pure
    @NonNull
    public String getCallingPackage() {
        return this.zzc;
    }

    @Pure
    @NonNull
    public ApplicationParameters getApplicationParams() {
        return this.zzb;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Pure
    @NonNull
    public String getCallingAppIdentifier() {
        void var0_2;
        if (TextUtils.isEmpty((CharSequence)this.zze)) {
            String string2 = this.zzc;
            return var0_2;
        }
        String string3 = this.zze;
        return var0_2;
    }

    @Pure
    @NonNull
    public String getFlowName() {
        return this.zzd;
    }

    @Pure
    @NonNull
    public String getSessionResumptionId() {
        return this.zzf;
    }

    @Pure
    public int getSessionResumptionType() {
        return this.zzg;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getTransactionId(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)3, (Parcelable)this.getApplicationParams(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)4, (String)this.getCallingPackage(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)5, (String)this.getFlowName(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)6, (String)this.getCallingAppIdentifier(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)7, (String)this.getSessionResumptionId(), (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeInt((Parcel)v1, (int)8, (int)this.getSessionResumptionType());
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }

    public final class Builder {
        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTransactionId(@NonNull String transactionId) {
            void var1_1;
            BuyFlowConfig.this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setSessionResumptionId(@NonNull String sessionResumptionId) {
            void var1_1;
            BuyFlowConfig.this.zzf = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setSessionResumptionType(int sessionResumptionType) {
            void var1_1;
            BuyFlowConfig.this.zzg = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setApplicationParameters(@NonNull ApplicationParameters applicationParameters) {
            void var1_1;
            BuyFlowConfig.this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCallingPackage(@NonNull String callingPackage) {
            void var1_1;
            BuyFlowConfig.this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setFlowName(@NonNull String flowName) {
            void var1_1;
            BuyFlowConfig.this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCallingAppIdentifier(@NonNull String callingAppIdentifier) {
            void var1_1;
            BuyFlowConfig.this.zze = var1_1;
            return this;
        }

        @NonNull
        public BuyFlowConfig build() {
            Object this_ = this_.BuyFlowConfig.this;
            if (((BuyFlowConfig)((Object)this_)).zza == null) {
                ((BuyFlowConfig)((Object)this_)).zza = UUID.randomUUID().toString();
            }
            return this_;
        }

        /* synthetic */ Builder(byte[] byArray) {
            Objects.requireNonNull(BuyFlowConfig.this);
        }
    }
}

